/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli;

import X10Gimli.Command.FuncCommand;
import X10Gimli.Debug;
import X10Gimli.Token;
import X10Gimli.Value.ValueDay;
import X10Gimli.Value.ValueIdent;
import X10Gimli.Value.ValueMonth;
import X10Gimli.X10.X10Data;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;

public class Scanner {
    private boolean bReady = false;
    private Token token;
    private char currentChar;
    private Reader inStream;
    private int lineCount = 0;
    private int charCount = 0;

    public void initFile(String f) {
        try {
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Initializing X10GIMLI scanner to read \"").append(f).append("\"...\""))));
            File inFile = new File(f);
            this.inStream = new FileReader(inFile);
            this.lineCount = 1;
            this.charCount = 1;
            this.bReady = true;
            this.nextChar();
        }
        catch (Exception e) {
            Debug.error(String.valueOf(String.valueOf(new StringBuffer("Exception initializing scanner to read input file '").append(f).append("'."))));
        }
    }

    public void initString(String s) {
        this.inStream = new StringReader(s);
        this.lineCount = 1;
        this.charCount = 1;
        this.bReady = true;
        this.nextChar();
    }

    public Token nextToken() {
        if (this.bReady) {
            this.doScan();
        } else {
            this.token = new Token();
            this.token.typePrimary = 16;
        }
        return this.token;
    }

    private void nextChar() {
        int inByte = 0;
        try {
            inByte = this.inStream.read();
        }
        catch (Exception e) {
            Debug.printCallStack("Exception scanning next character.", e);
        }
        if (inByte == -1) {
            try {
                this.inStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.currentChar = '\u0000';
        } else {
            this.currentChar = (char)inByte;
        }
        if (this.currentChar == '\n') {
            ++this.lineCount;
            this.charCount = 0;
        } else {
            ++this.charCount;
        }
    }

    private char getChar() {
        return this.currentChar;
    }

    private void doScan() {
        int iState = 0;
        int iNewState = 0;
        boolean bContinue = true;
        String sScanned = "";
        if (this.getChar() != '\u0000') {
            while (bContinue) {
                char cIn;
                char cReal = cIn = this.getChar();
                if (cIn >= 'A' && cIn <= 'Z') {
                    cIn = (char)(cIn - 65 + 97);
                }
                iState = iNewState;
                iNewState = 200;
                if (iState == 0) {
                    sScanned = "";
                }
                switch (iState) {
                    case 0: {
                        if (cIn == '\"') {
                            iNewState = 10;
                        }
                        if (cIn == ';') {
                            iNewState = 90;
                        }
                        if (cIn == ',') {
                            iNewState = 91;
                        }
                        if (cIn == '(') {
                            iNewState = 92;
                        }
                        if (cIn == ')') {
                            iNewState = 93;
                        }
                        if (cIn == '[') {
                            iNewState = 94;
                        }
                        if (cIn == ']') {
                            iNewState = 95;
                        }
                        if (cIn == '{') {
                            iNewState = 96;
                        }
                        if (cIn == '}') {
                            iNewState = 97;
                        }
                        if (cIn == '.') {
                            iNewState = 98;
                        }
                        if (cIn == ':') {
                            iNewState = 99;
                        }
                        if (cIn == '-') {
                            iNewState = 80;
                        }
                        if (cIn == '+') {
                            iNewState = 81;
                        }
                        if (cIn == '/') {
                            iNewState = 82;
                        }
                        if (cIn == '*') {
                            iNewState = 83;
                        }
                        if (cIn == '=') {
                            iNewState = 84;
                        }
                        if (cIn == '>') {
                            iNewState = 71;
                        }
                        if (cIn == '<') {
                            iNewState = 73;
                        }
                        if (cIn >= 'a' && cIn <= 'p') {
                            iNewState = 20;
                        }
                        if (cIn >= 'q' && cIn <= 'z') {
                            iNewState = 30;
                        }
                        if (cIn == '\'') {
                            iNewState = 31;
                        }
                        if (cIn >= '0' && cIn <= '9') {
                            iNewState = 40;
                        }
                        if (cIn != ' ' && cIn != '\n' && cIn != '\r' && cIn != '\t') break;
                        iNewState = 0;
                        break;
                    }
                    case 1: {
                        if (cIn == '\n') {
                            iNewState = 0;
                            break;
                        }
                        iNewState = 1;
                        break;
                    }
                    case 2: {
                        if (cIn == '>') {
                            iNewState = 3;
                            break;
                        }
                        iNewState = 2;
                        break;
                    }
                    case 3: {
                        if (cIn == '>') {
                            iNewState = 3;
                            break;
                        }
                        if (cIn == '*') {
                            iNewState = 0;
                            break;
                        }
                        iNewState = 2;
                        break;
                    }
                    case 10: {
                        if (cIn == '\"') {
                            iNewState = 11;
                            break;
                        }
                        if (cIn == '\\') {
                            iNewState = 12;
                            break;
                        }
                        iNewState = 10;
                        break;
                    }
                    case 11: {
                        iNewState = 100;
                        break;
                    }
                    case 12: {
                        iNewState = 10;
                        break;
                    }
                    case 20: {
                        if (cIn >= 'a' && cIn <= 'z') {
                            iNewState = 30;
                            break;
                        }
                        if (cIn == '_') {
                            iNewState = 30;
                            break;
                        }
                        if (cIn >= '0' && cIn <= '9') {
                            iNewState = 21;
                            break;
                        }
                        iNewState = 100;
                        break;
                    }
                    case 21: {
                        if (cIn >= 'a' && cIn <= 'z') {
                            iNewState = 30;
                            break;
                        }
                        if (cIn == '_') {
                            iNewState = 30;
                            break;
                        }
                        if (cIn >= '0' && cIn <= '9') {
                            iNewState = 22;
                            break;
                        }
                        iNewState = 100;
                        break;
                    }
                    case 22: {
                        if (cIn >= 'a' && cIn <= 'z') {
                            iNewState = 30;
                            break;
                        }
                        if (cIn == '_') {
                            iNewState = 30;
                            break;
                        }
                        if (cIn >= '0' && cIn <= '9') {
                            iNewState = 30;
                            break;
                        }
                        iNewState = 100;
                        break;
                    }
                    case 30: {
                        if (cIn >= 'a' && cIn <= 'z') {
                            iNewState = 30;
                            break;
                        }
                        if (cIn == '_') {
                            iNewState = 30;
                            break;
                        }
                        if (cIn >= '0' && cIn <= '9') {
                            iNewState = 30;
                            break;
                        }
                        iNewState = 100;
                        break;
                    }
                    case 31: {
                        if (cIn == '\'') {
                            iNewState = 100;
                            break;
                        }
                        iNewState = 31;
                        break;
                    }
                    case 32: {
                        iNewState = 100;
                        break;
                    }
                    case 40: {
                        if (cIn >= '0' && cIn <= '9') {
                            iNewState = 41;
                            break;
                        }
                        if (cIn == ':') {
                            iNewState = 50;
                            break;
                        }
                        if (cIn == '/') {
                            iNewState = 60;
                            break;
                        }
                        iNewState = 100;
                        break;
                    }
                    case 41: {
                        if (cIn >= '0' && cIn <= '9') {
                            iNewState = 42;
                            break;
                        }
                        if (cIn == '/') {
                            iNewState = 60;
                            break;
                        }
                        if (cIn == ':') {
                            iNewState = 50;
                            break;
                        }
                        iNewState = 100;
                        break;
                    }
                    case 42: {
                        if (cIn >= '0' && cIn <= '9') {
                            iNewState = 42;
                            break;
                        }
                        iNewState = 100;
                        break;
                    }
                    case 60: {
                        if (cIn < '0' || cIn > '9') break;
                        iNewState = 61;
                        break;
                    }
                    case 61: {
                        if (cIn >= '0' && cIn <= '9') {
                            iNewState = 62;
                            break;
                        }
                        if (cIn == '/') {
                            iNewState = 63;
                            break;
                        }
                        iNewState = 100;
                        break;
                    }
                    case 62: {
                        if (cIn == '/') {
                            iNewState = 63;
                            break;
                        }
                        iNewState = 100;
                        break;
                    }
                    case 63: {
                        if (cIn < '0' || cIn > '9') break;
                        iNewState = 64;
                        break;
                    }
                    case 64: {
                        if (cIn < '0' || cIn > '9') break;
                        iNewState = 65;
                        break;
                    }
                    case 65: {
                        if (cIn >= '0' && cIn <= '9') {
                            iNewState = 66;
                            break;
                        }
                        iNewState = 100;
                        break;
                    }
                    case 66: {
                        if (cIn < '0' || cIn > '9') break;
                        iNewState = 67;
                        break;
                    }
                    case 67: {
                        iNewState = 100;
                        break;
                    }
                    case 50: {
                        if (cIn < '0' || cIn > '9') break;
                        iNewState = 51;
                        break;
                    }
                    case 51: {
                        if (cIn < '0' || cIn > '9') break;
                        iNewState = 52;
                        break;
                    }
                    case 52: {
                        if (cIn == 'a') {
                            iNewState = 56;
                            break;
                        }
                        if (cIn == 'p') {
                            iNewState = 58;
                            break;
                        }
                        if (cIn == ':') {
                            iNewState = 53;
                            break;
                        }
                        iNewState = 100;
                        break;
                    }
                    case 53: {
                        if (cIn < '0' || cIn > '9') break;
                        iNewState = 54;
                        break;
                    }
                    case 54: {
                        if (cIn < '0' || cIn > '9') break;
                        iNewState = 55;
                        break;
                    }
                    case 55: {
                        if (cIn == 'a') {
                            iNewState = 56;
                            break;
                        }
                        if (cIn == 'p') {
                            iNewState = 58;
                            break;
                        }
                        iNewState = 100;
                        break;
                    }
                    case 56: {
                        if (cIn != 'm') break;
                        iNewState = 57;
                        break;
                    }
                    case 57: {
                        iNewState = 100;
                        break;
                    }
                    case 58: {
                        if (cIn != 'm') break;
                        iNewState = 59;
                        break;
                    }
                    case 59: {
                        iNewState = 100;
                        break;
                    }
                    case 90: {
                        iNewState = 100;
                        break;
                    }
                    case 91: {
                        iNewState = 100;
                        break;
                    }
                    case 92: {
                        iNewState = 100;
                        break;
                    }
                    case 93: {
                        iNewState = 100;
                        break;
                    }
                    case 94: {
                        iNewState = 100;
                        break;
                    }
                    case 95: {
                        iNewState = 100;
                        break;
                    }
                    case 96: {
                        iNewState = 100;
                        break;
                    }
                    case 97: {
                        iNewState = 100;
                        break;
                    }
                    case 98: {
                        iNewState = 100;
                        break;
                    }
                    case 99: {
                        iNewState = 100;
                        break;
                    }
                    case 80: {
                        iNewState = 100;
                        break;
                    }
                    case 81: {
                        iNewState = 100;
                        break;
                    }
                    case 82: {
                        iNewState = 100;
                        break;
                    }
                    case 83: {
                        if (cIn == '*') {
                            iNewState = 1;
                            break;
                        }
                        if (cIn == '<') {
                            iNewState = 2;
                            break;
                        }
                        iNewState = 100;
                        break;
                    }
                    case 84: {
                        if (cIn == '=') {
                            iNewState = 70;
                            break;
                        }
                        iNewState = 100;
                        break;
                    }
                    case 70: {
                        iNewState = 100;
                        break;
                    }
                    case 71: {
                        if (cIn == '=') {
                            iNewState = 72;
                            break;
                        }
                        iNewState = 100;
                        break;
                    }
                    case 72: {
                        iNewState = 100;
                        break;
                    }
                    case 73: {
                        if (cIn == '=') {
                            iNewState = 74;
                            break;
                        }
                        if (cIn == '>') {
                            iNewState = 75;
                            break;
                        }
                        iNewState = 100;
                        break;
                    }
                    case 74: {
                        iNewState = 100;
                        break;
                    }
                    case 75: {
                        iNewState = 100;
                        break;
                    }
                }
                if (iNewState != 100 && iNewState != 200) {
                    if (iNewState != 12 && (iNewState != 10 || iState != 0) && iNewState != 11) {
                        sScanned = String.valueOf(String.valueOf(sScanned)).concat(String.valueOf(String.valueOf(cReal)));
                    }
                    this.nextChar();
                } else {
                    bContinue = false;
                }
                if (this.getChar() != '\u0000' || iNewState != 0 && iNewState != 1) continue;
                bContinue = false;
            }
            this.token = new Token();
            this.token.value = sScanned;
            this.token.charCount = this.charCount;
            this.token.lineCount = this.lineCount;
            if (iNewState == 100) {
                switch (iState) {
                    case 11: {
                        this.token.typePrimary = 8;
                        this.token.typeSecondary = 4;
                        break;
                    }
                    case 20: {
                        this.token.typePrimary = 8;
                        this.token.typeSecondary = 2;
                        break;
                    }
                    case 21: {
                        this.token.typePrimary = 8;
                        this.token.typeSecondary = 2;
                        break;
                    }
                    case 22: {
                        this.token.typePrimary = 8;
                        this.token.typeSecondary = 2;
                        break;
                    }
                    case 30: 
                    case 32: {
                        sScanned = sScanned.toLowerCase();
                        if (sScanned.equals("x10gimli")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 1;
                        }
                        if (sScanned.equals("end")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 2;
                        }
                        if (sScanned.equals("definitions")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 4;
                        }
                        if (sScanned.equals("functions")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 8;
                        }
                        if (sScanned.equals("begin")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 16;
                        }
                        if (sScanned.equals("triggers")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 32;
                        }
                        if (sScanned.equals("mode")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 256;
                        }
                        if (sScanned.equals("control")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 512;
                        }
                        if (sScanned.equals("start")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 65536;
                        }
                        if (sScanned.equals("finish")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 131072;
                        }
                        if (sScanned.equals("if")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 1024;
                        }
                        if (sScanned.equals("then")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 2048;
                        }
                        if (sScanned.equals("else")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 4096;
                        }
                        if (sScanned.equals("while")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 8192;
                        }
                        if (sScanned.equals("do")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 16384;
                        }
                        if (sScanned.equals("trigger")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 32768;
                        }
                        if (sScanned.equals("motion")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 262144;
                        }
                        if (sScanned.equals("return")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 524288;
                        }
                        if (sScanned.equals("define")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 0x200000;
                        }
                        if (sScanned.equals("new")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 0x100000;
                        }
                        if (sScanned.equals("imports")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 0x400000;
                        }
                        if (sScanned.equals("for")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 0x800000;
                        }
                        if (sScanned.equals("foreach")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 0x1000000;
                        }
                        if (sScanned.equals("case")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 0x2000000;
                        }
                        if (sScanned.equals("of")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 0x4000000;
                        }
                        if (sScanned.equals("to")) {
                            this.token.typePrimary = 4;
                            this.token.typeSecondary = 0x8000000;
                        }
                        if (FuncCommand.existsCommand(sScanned)) {
                            this.token.typePrimary = 2;
                            this.token.typeSecondary = 1;
                        }
                        if (ValueIdent.existsPreDefined(sScanned)) {
                            this.token.typePrimary = 2;
                            this.token.typeSecondary = 2;
                        }
                        if (ValueDay.dayStringToInt(sScanned) != 0) {
                            this.token.typePrimary = 8;
                            this.token.typeSecondary = 16;
                        }
                        if (ValueMonth.monthStringToInt(sScanned) != 0) {
                            this.token.typePrimary = 8;
                            this.token.typeSecondary = 32;
                        }
                        if (X10Data.stringToFunctionCode(sScanned.toUpperCase()) != 0) {
                            this.token.typePrimary = 8;
                            this.token.typeSecondary = 128;
                        }
                        if (sScanned.equals("or")) {
                            this.token.typePrimary = 1;
                            this.token.typeSecondary = 512;
                        }
                        if (sScanned.equals("and")) {
                            this.token.typePrimary = 1;
                            this.token.typeSecondary = 512;
                        }
                        if (sScanned.equals("true")) {
                            this.token.typePrimary = 8;
                            this.token.typeSecondary = 256;
                        }
                        if (sScanned.equals("false")) {
                            this.token.typePrimary = 8;
                            this.token.typeSecondary = 256;
                        }
                        if (this.token.typePrimary == 0) {
                            this.token.typePrimary = 2;
                            this.token.typeSecondary = 0x100000;
                        }
                        sScanned.toUpperCase();
                        break;
                    }
                    case 40: {
                        this.token.typePrimary = 8;
                        this.token.typeSecondary = 1;
                        break;
                    }
                    case 41: {
                        this.token.typePrimary = 8;
                        this.token.typeSecondary = 1;
                        break;
                    }
                    case 42: {
                        this.token.typePrimary = 8;
                        this.token.typeSecondary = 1;
                        break;
                    }
                    case 61: {
                        this.token.typePrimary = 8;
                        this.token.typeSecondary = 64;
                        break;
                    }
                    case 62: {
                        this.token.typePrimary = 8;
                        this.token.typeSecondary = 64;
                        break;
                    }
                    case 65: {
                        this.token.typePrimary = 8;
                        this.token.typeSecondary = 64;
                        break;
                    }
                    case 67: {
                        this.token.typePrimary = 8;
                        this.token.typeSecondary = 64;
                        break;
                    }
                    case 52: {
                        this.token.typePrimary = 8;
                        this.token.typeSecondary = 8;
                        break;
                    }
                    case 55: {
                        this.token.typePrimary = 8;
                        this.token.typeSecondary = 8;
                        break;
                    }
                    case 57: {
                        this.token.typePrimary = 8;
                        this.token.typeSecondary = 8;
                        break;
                    }
                    case 59: {
                        this.token.typePrimary = 8;
                        this.token.typeSecondary = 8;
                        break;
                    }
                    case 90: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 8;
                        break;
                    }
                    case 91: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 1;
                        break;
                    }
                    case 92: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 2;
                        break;
                    }
                    case 93: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 4;
                        break;
                    }
                    case 94: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 128;
                        break;
                    }
                    case 95: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 256;
                        break;
                    }
                    case 96: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 1024;
                        break;
                    }
                    case 97: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 2048;
                        break;
                    }
                    case 98: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 4096;
                        break;
                    }
                    case 99: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 8192;
                        break;
                    }
                    case 80: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 32;
                        break;
                    }
                    case 81: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 32;
                        break;
                    }
                    case 82: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 32;
                        break;
                    }
                    case 83: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 32;
                        break;
                    }
                    case 84: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 16;
                        break;
                    }
                    case 70: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 64;
                        break;
                    }
                    case 71: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 64;
                        break;
                    }
                    case 72: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 64;
                        break;
                    }
                    case 73: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 64;
                        break;
                    }
                    case 74: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 64;
                        break;
                    }
                    case 75: {
                        this.token.typePrimary = 1;
                        this.token.typeSecondary = 64;
                        break;
                    }
                }
            }
            if (iNewState == 200) {
                this.token.typePrimary = 32;
                Debug.error(201, "(Scanner) Invalid token in input stream - ".concat(String.valueOf(String.valueOf(this.token.value))));
            }
        } else {
            this.token = new Token();
            this.token.typePrimary = 16;
        }
    }
}

