/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.System;

import X10Gimli.Command.Command;
import X10Gimli.Debug;
import X10Gimli.System.Definition;
import X10Gimli.System.Environment;
import X10Gimli.System.SystemModel;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueIdent;
import X10Gimli.Value.ValueType;
import java.util.ArrayList;
import java.util.Calendar;

public class EnvironmentSmall {
    private Calendar calTime;
    private Calendar calLastTime;
    private ArrayList vDefinitions;
    private EnvironmentSmall eParent;
    private ValueType vReturn;

    public EnvironmentSmall() {
        this.calLastTime = this.calTime = Calendar.getInstance();
        this.vDefinitions = new ArrayList();
    }

    public EnvironmentSmall(EnvironmentSmall parent) {
        this.calLastTime = this.calTime = Calendar.getInstance();
        this.vDefinitions = new ArrayList();
        this.setParent(parent);
        parent.setReturn(null);
    }

    public int depth() {
        if (this.getParent() == null) {
            return 1;
        }
        return this.getParent().depth() + 1;
    }

    public void setTime() {
        this.calLastTime = this.calTime;
        this.calTime = Calendar.getInstance();
    }

    public void setDefinitions(ArrayList defs) {
        if (defs != null) {
            this.vDefinitions = defs;
        }
    }

    public void setParent(EnvironmentSmall parent) {
        this.eParent = parent;
    }

    public void setReturn(ValueType val) {
        this.vReturn = val;
    }

    public Calendar getStartTime() {
        return this.calLastTime;
    }

    public Calendar getEndTime() {
        return this.calTime;
    }

    public ArrayList getDefinitions() {
        return this.vDefinitions;
    }

    public EnvironmentSmall getParent() {
        return this.eParent;
    }

    public ValueType getReturn() {
        return this.vReturn;
    }

    public EnvironmentSmall spawnEnvironment() {
        return new EnvironmentSmall(this);
    }

    public ValueType executeCommands(ArrayList commands) {
        try {
            int size = commands.size();
            for (int i = 0; i < size; ++i) {
                Command c = (Command)commands.get(i);
                this.executeCommand(c);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
        }
        return this.getReturn();
    }

    public ValueType executeCommand(Command command) {
        if (command != null) {
            try {
                ValueType v;
                if (Debug.yesLevel(4)) {
                    command.doOutput(this);
                }
                ValueType valueType = v = command.execute(this);
                return valueType;
            }
            catch (Exception e) {
                Debug.printCallStack("Problem executing command.", e);
            }
        }
        return null;
    }

    public Environment getFullEnvironment() {
        if (this instanceof Environment) {
            return (Environment)this;
        }
        if (this.eParent != null) {
            return this.eParent.getFullEnvironment();
        }
        return null;
    }

    public SystemModel getSystemModel() {
        if (this instanceof SystemModel) {
            return (SystemModel)this;
        }
        if (this.eParent != null) {
            return this.eParent.getSystemModel();
        }
        return null;
    }

    public void setDefinition(Definition def) {
        Definition finddef = this.findDefinition(def.getName());
        if (finddef != null) {
            finddef.setValue(def.getValue());
        } else {
            this.addDefinition(def);
        }
    }

    public void addDefinition(Definition def) {
        this.vDefinitions.add(new Definition(def.getName(), def.getValue()));
    }

    public Definition findDefinition(String name) {
        int size = this.vDefinitions.size();
        for (int i = 0; i < size; ++i) {
            Definition d = (Definition)this.vDefinitions.get(i);
            if (d.getName() != name) continue;
            return d;
        }
        if (this.eParent != null) {
            return this.eParent.findDefinition(name);
        }
        return null;
    }

    public ValueType getDefinition(ValueType val) {
        Definition def;
        Value realval = val.getValue(this);
        if (realval instanceof ValueIdent && (def = this.findDefinition(realval.getValueString())) != null) {
            return def.getValue();
        }
        return val;
    }
}

