/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.System;

import X10Gimli.Command.BeginCommand;
import X10Gimli.Command.Command;
import X10Gimli.Command.MotionCommand;
import X10Gimli.Command.TriggerCommand;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.ValueType;
import java.util.Calendar;

public class Trigger {
    private String sName = "";
    private ValueType ctTriggerCase;
    private Command cCommand;
    private boolean bTriggered = false;
    private Calendar timeActive = Calendar.getInstance();

    public void setName(String name) {
        if (name != null) {
            this.sName = name.toUpperCase().intern();
        }
    }

    public void setCase(ValueType eventcase) {
        this.ctTriggerCase = eventcase;
    }

    public void setCommand(Command command) {
        this.cCommand = command;
    }

    public String getName() {
        return this.sName;
    }

    public ValueType getCase() {
        return this.ctTriggerCase;
    }

    public Command getCommand() {
        return this.cCommand;
    }

    public boolean isTriggered(EnvironmentSmall t) {
        if (!this.bTriggered && this.timeActive.before(Calendar.getInstance())) {
            if (this.ctTriggerCase.getValue(t).getBoolean()) {
                this.bTriggered = true;
            }
            return this.bTriggered;
        }
        return false;
    }

    public void reset(EnvironmentSmall t) {
        this.timeActive = this.ctTriggerCase.resetTime(t);
        this.bTriggered = false;
    }

    public String toX10GIMLI(int depth) {
        char[] sBytes = new char[15];
        for (int i = 0; i < 15; ++i) {
            sBytes[i] = 32;
        }
        StringBuffer sBuf = new StringBuffer("");
        int indent = depth * 2;
        sBuf.append(sBytes, 0, indent);
        if (this.sName != null) {
            sBuf.append(this.sName);
            sBuf.append(" ");
        }
        sBuf.append("(");
        sBuf.append(this.ctTriggerCase.toX10GIMLI());
        sBuf.append(") do");
        if (this.cCommand instanceof BeginCommand || this.cCommand instanceof MotionCommand || this.cCommand instanceof TriggerCommand) {
            sBuf.append("\r\n");
            sBuf.append(this.cCommand.toX10GIMLI(depth + 1));
        } else {
            sBuf.append(" ");
            sBuf.append(this.cCommand.toX10GIMLI(0));
        }
        return sBuf.toString();
    }
}

