/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli;

import X10Gimli.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Properties;

public class SystemProperties {
    private String sFilename = "default.X10GIMLI";
    private Properties props = new Properties();

    public SystemProperties() {
        this.setDefaultProperties();
    }

    public SystemProperties(String fname) {
        if (fname != null) {
            this.sFilename = !fname.toUpperCase().endsWith(".X10GIMLI") ? String.valueOf(String.valueOf(fname)).concat(".X10GIMLI") : fname;
        }
        this.setDefaultProperties();
    }

    private void setDefaultProperties() {
        if (this.props.getProperty("SOURCE") == null) {
            this.props.setProperty("SOURCE", "X10Gimli.GIM");
        }
        if (this.props.getProperty("NUM_PATHS") == null) {
            this.props.setProperty("NUM_PATHS", "0");
        }
        if (this.props.getProperty("MASTER_LOG_FILE") == null) {
            this.props.setProperty("MASTER_LOG_FILE", "master.log");
        }
        if (this.props.getProperty("EXECUTION_LOG_FILE") == null) {
            this.props.setProperty("EXECUTION_LOG_FILE", "exec.log");
        }
        if (this.props.getProperty("SYSTEM_LOG_FILE") == null) {
            this.props.setProperty("SYSTEM_LOG_FILE", "system.log");
        }
        if (this.props.getProperty("USER_LOG_FILE") == null) {
            this.props.setProperty("USER_LOG_FILE", "user.log");
        }
        if (this.props.getProperty("ERROR_LOG_FILE") == null) {
            this.props.setProperty("ERROR_LOG_FILE", "error.log");
        }
        if (this.props.getProperty("EXECUTION_LOG") == null) {
            this.props.setProperty("EXECUTION_LOG", "FALSE");
        }
        if (this.props.getProperty("SYSTEM_LOG") == null) {
            this.props.setProperty("SYSTEM_LOG", "TRUE");
        }
        if (this.props.getProperty("USER_LOG") == null) {
            this.props.setProperty("USER_LOG", "FALSE");
        }
        if (this.props.getProperty("ERROR_LOG") == null) {
            this.props.setProperty("ERROR_LOG", "FALSE");
        }
    }

    public void save() {
        try {
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Saving properties file \"").append(this.sFilename).append("\"...\""))));
            File outFile = new File(this.sFilename);
            FileOutputStream outStream = new FileOutputStream(outFile);
            this.props.store(outStream, "X10GIMLI startup properties");
        }
        catch (Exception e) {
            Debug.printCallStack("Exception saving startup properties.", e);
        }
    }

    public void load() {
        try {
            Debug.log(1, String.valueOf(String.valueOf(new StringBuffer("\"Loading properties file \"").append(this.sFilename).append("\"...\""))));
            File inFile = new File(this.sFilename);
            if (!inFile.exists()) {
                this.setDefaultProperties();
                Debug.log(2, String.valueOf(String.valueOf(new StringBuffer("\"Unable to find file \"").append(this.sFilename).append("\"...\""))));
                return;
            }
            FileInputStream inStream = new FileInputStream(inFile);
            this.props.load(inStream);
        }
        catch (Exception e) {
            Debug.printCallStack("Exception loading startup properties.", e);
        }
    }

    public ArrayList getPaths() {
        int numPaths = Integer.parseInt(this.props.getProperty("NUM_PATHS"));
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < numPaths; ++i) {
            list.add(this.props.getProperty(String.valueOf(String.valueOf(new StringBuffer("PATH").append(i + 1)))));
        }
        return list;
    }

    public void setPaths(Object[] list) {
        if (list != null) {
            int numPaths = list.length;
            this.props.setProperty("NUM_PATHS", "".concat(String.valueOf(String.valueOf(numPaths))));
            for (int i = 0; i < numPaths; ++i) {
                this.props.setProperty(String.valueOf(String.valueOf(new StringBuffer("PATH").append(i + 1))), (String)list[i]);
            }
        }
    }

    public void setPaths(ArrayList list) {
        if (list != null) {
            this.setPaths(list.toArray());
        }
    }

    public void addPath(String path) {
        int numPaths = Integer.parseInt(this.props.getProperty("NUM_PATHS")) + 1;
        this.props.setProperty("NUM_PATHS", "".concat(String.valueOf(String.valueOf(numPaths))));
        this.props.setProperty("PATH".concat(String.valueOf(String.valueOf(numPaths))), path);
    }

    public String getProperty(String s) {
        return this.props.getProperty(s);
    }

    public void setProperty(String s, String v) {
        this.props.setProperty(s, v);
    }
}

