/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Value;

import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Token;
import X10Gimli.Value.ValueBoolean;
import X10Gimli.Value.ValueCommand;
import X10Gimli.Value.ValueDate;
import X10Gimli.Value.ValueDay;
import X10Gimli.Value.ValueIdent;
import X10Gimli.Value.ValueMonth;
import X10Gimli.Value.ValueNothing;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueString;
import X10Gimli.Value.ValueTime;
import X10Gimli.Value.ValueType;
import X10Gimli.Value.ValueX10;
import java.util.Calendar;

public abstract class Value
extends ValueType {
    protected static final int NOTEQUAL = 100;
    protected static final int EQUAL = 0;
    protected static final int GREATER = 1;
    protected static final int LESS = -1;
    private String sVal;
    protected StringBuffer sbuf = new StringBuffer();

    public static Value getValue(Token token) {
        if (token.typePrimary == 8) {
            switch (token.typeSecondary) {
                case 1: {
                    return new ValueNumber(token.value);
                }
                case 2: {
                    return new ValueX10(token.value);
                }
                case 4: {
                    return new ValueString(token.value);
                }
                case 8: {
                    return new ValueTime(token.value);
                }
                case 16: {
                    return new ValueDay(token.value);
                }
                case 32: {
                    return new ValueMonth(token.value);
                }
                case 128: {
                    return new ValueCommand(token.value);
                }
                case 64: {
                    return new ValueDate(token.value);
                }
                case 256: {
                    return new ValueBoolean(token.value);
                }
            }
        }
        if (token.typePrimary == 2) {
            switch (token.typeSecondary) {
                case 0x100000: {
                    return new ValueIdent(token.value);
                }
                case 2: {
                    return new ValueIdent(token.value);
                }
            }
        }
        return ValueNothing.value;
    }

    public void setValueString(String value) {
        this.sVal = value.intern();
    }

    public String getValueString() {
        return this.sVal;
    }

    public char getHouseCode() {
        return '\u0000';
    }

    public int getDeviceCode() {
        return 0;
    }

    public int getNumber() {
        return 0;
    }

    public Calendar getTime() {
        return null;
    }

    public Calendar getDate() {
        return null;
    }

    public String getString() {
        return null;
    }

    public int getDay() {
        return 0;
    }

    public int getMonth() {
        return 0;
    }

    public int getCommand() {
        return 0;
    }

    public String getCommandString() {
        return null;
    }

    public boolean getBoolean() {
        return false;
    }

    public Value applyCondition(String op, ValueType val, EnvironmentSmall env) {
        int comp = this instanceof ValueIdent ? this.getValue(env).compareTo(val, env) : this.compareTo(val, env);
        if (comp == 100) {
            if (op == "<>") {
                return new ValueBoolean(true);
            }
            return new ValueBoolean(false);
        }
        if (op == "==") {
            return new ValueBoolean(comp == 0);
        }
        if (op == "<>") {
            return new ValueBoolean(comp != 0);
        }
        if (op == ">") {
            return new ValueBoolean(comp > 0);
        }
        if (op == ">=") {
            return new ValueBoolean(comp >= 0);
        }
        if (op == "<") {
            return new ValueBoolean(comp < 0);
        }
        if (op == "<=") {
            return new ValueBoolean(comp <= 0);
        }
        return new ValueBoolean(false);
    }

    public Value applyLogic(String op, ValueType val, EnvironmentSmall env) {
        return new ValueBoolean(false);
    }

    public Value getValue(EnvironmentSmall env) {
        return this;
    }

    public Calendar resetTime(EnvironmentSmall env) {
        return Calendar.getInstance();
    }

    public abstract String toX10GIMLI();

    static {
        NOTEQUAL = 100;
        EQUAL = 0;
        GREATER = 1;
        LESS = -1;
    }
}

