/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Value;

import X10Gimli.Debug;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueNothing;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueType;
import X10Gimli.X10.X10Data;

public final class ValueCommand
extends Value {
    private int iCommand;

    public ValueCommand() {
    }

    public ValueCommand(String string) {
        this.setValueString(string.toUpperCase());
        this.setCommand(this.getValueString());
    }

    public ValueCommand(int command) {
        this.setCommand(command);
    }

    public void setCommand(int command) {
        this.iCommand = command;
        this.makeString();
    }

    public void setCommand(String command) {
        this.iCommand = X10Data.stringToFunctionCode(command);
        this.makeString();
    }

    public int getCommand() {
        return this.iCommand;
    }

    public String getCommandString() {
        return X10Data.functionCodeToString(this.iCommand);
    }

    public int getNumber() {
        return this.iCommand;
    }

    public Value applyArithmetic(String op, ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if (cmp instanceof ValueCommand || cmp instanceof ValueNumber) {
            if (op == "+") {
                return new ValueCommand(this.getCommand() + this.getNumber());
            }
            if (op == "-") {
                return new ValueCommand(this.getCommand() - this.getNumber());
            }
        }
        Debug.error(102, "(Runtime) Incompatible arithmetic operation for COMMAND type.");
        return ValueNothing.value;
    }

    public int compareTo(ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if (cmp instanceof ValueCommand || cmp instanceof ValueNumber) {
            if (this.getNumber() > cmp.getNumber()) {
                return 1;
            }
            if (this.getNumber() < cmp.getNumber()) {
                return -1;
            }
            if (this.getNumber() == cmp.getNumber()) {
                return 0;
            }
            return 100;
        }
        Debug.error(101, "(WARNING) Incompatible comparison to COMMAND type : ".concat(String.valueOf(String.valueOf(cmp.string))));
        return 100;
    }

    public String toString() {
        return X10Data.functionCodeToString(this.iCommand);
    }

    public String toX10GIMLI() {
        return this.toString();
    }
}

