/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Value;

import X10Gimli.Debug;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueDay;
import X10Gimli.Value.ValueMonth;
import X10Gimli.Value.ValueNothing;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueType;
import java.util.Calendar;
import java.util.GregorianCalendar;

public final class ValueDate
extends Value {
    private Calendar calDate;
    private boolean bFullPrecision;

    public ValueDate() {
    }

    public ValueDate(String string) {
        this.setValueString(string.toUpperCase());
        this.setDate(string);
    }

    public ValueDate(Calendar date) {
        this.setDate(date);
    }

    public ValueDate(Calendar date, boolean b) {
        this.setDate(date);
        this.setPrecision(b);
    }

    public void setDate(Calendar date) {
        this.calDate = date;
        this.setPrecision(true);
        this.makeString();
    }

    public void setDate(String date) {
        String m = null;
        String d = null;
        String y = null;
        int l = date.length();
        if (l >= 3) {
            m = date.substring(0, 1);
            if (date.charAt(1) == '/') {
                if (l >= 6) {
                    if (date.charAt(3) == '/') {
                        d = date.substring(2, 3);
                        y = date.substring(4, l);
                    } else if (date.charAt(4) == '/') {
                        d = date.substring(2, 4);
                        y = date.substring(5, l);
                    }
                } else {
                    d = date.substring(2, l);
                }
            } else if (date.charAt(2) == '/') {
                m = date.substring(0, 2);
                if (date.length() >= 7) {
                    if (date.charAt(4) == '/') {
                        d = date.substring(3, 4);
                        y = date.substring(5, l);
                    } else if (date.charAt(5) == '/') {
                        d = date.substring(3, 5);
                        y = date.substring(6, l);
                    }
                } else {
                    d = date.substring(3, l);
                }
            }
        }
        if (m != null && d != null) {
            int month = Integer.parseInt(m);
            int day = Integer.parseInt(d);
            int year = 0;
            if (y != null) {
                year = Integer.parseInt(y);
                if (y.length() < 4) {
                    year += 2000;
                }
            }
            this.calDate = new GregorianCalendar();
            this.calDate.set(year, month - 1, day);
            this.setPrecision(y != null);
        }
    }

    public void setPrecision(boolean b) {
        this.bFullPrecision = b;
        this.makeString();
    }

    public Calendar getDate() {
        return this.calDate;
    }

    public int getDay() {
        return this.calDate.get(7);
    }

    public int getMonth() {
        return this.calDate.get(2);
    }

    public boolean isPrecise() {
        return this.bFullPrecision;
    }

    public Value applyArithmetic(String op, ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        Calendar c1 = (Calendar)this.getDate().clone();
        if (cmp instanceof ValueDate) {
            Calendar c2 = cmp.getDate();
            if (op.equals("+")) {
                c1.add(5, c2.get(5));
                c1.add(2, c2.get(2) + 1);
                return new ValueDate(c1, this.isPrecise());
            }
            if (op.equals("-")) {
                c1.add(5, -c2.get(5));
                c1.add(2, -(c2.get(2) + 1));
                return new ValueDate(c1, this.isPrecise());
            }
        }
        if (cmp instanceof ValueNumber || cmp instanceof ValueDay) {
            if (op.equals("+")) {
                c1.add(5, cmp.getNumber());
                return new ValueDate(c1, this.isPrecise());
            }
            if (op.equals("-")) {
                c1.add(5, -cmp.getNumber());
                return new ValueDate(c1, this.isPrecise());
            }
        }
        if (cmp instanceof ValueMonth) {
            if (op.equals("+")) {
                c1.add(2, cmp.getNumber());
                return new ValueDate(c1, this.isPrecise());
            }
            if (op.equals("-")) {
                c1.add(2, -cmp.getNumber());
                return new ValueDate(c1, this.isPrecise());
            }
        }
        Debug.error(102, "(Runtime) Incompatible arithmetic operation for DATE type.");
        return ValueNothing.value;
    }

    public int compareTo(ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if (cmp instanceof ValueDate) {
            Calendar c1 = this.getDate();
            Calendar c2 = cmp.getDate();
            if (this.isPrecise() && ((ValueDate)cmp).isPrecise()) {
                if (c1.get(1) < c2.get(1)) {
                    return -1;
                }
                if (c1.get(1) > c2.get(1)) {
                    return 1;
                }
                if (c1.get(1) == c2.get(1)) {
                    if (c1.get(2) < c2.get(2)) {
                        return -1;
                    }
                    if (c1.get(2) > c2.get(2)) {
                        return 1;
                    }
                    if (c1.get(2) == c2.get(2)) {
                        if (c1.get(5) < c2.get(5)) {
                            return -1;
                        }
                        if (c1.get(5) > c2.get(5)) {
                            return 1;
                        }
                        if (c1.get(5) == c2.get(5)) {
                            return 0;
                        }
                    }
                }
            } else {
                if (c1.get(2) < c2.get(2)) {
                    return -1;
                }
                if (c1.get(2) > c2.get(2)) {
                    return 1;
                }
                if (c1.get(2) == c2.get(2)) {
                    if (c1.get(5) < c2.get(5)) {
                        return -1;
                    }
                    if (c1.get(5) > c2.get(5)) {
                        return 1;
                    }
                    if (c1.get(5) == c2.get(5)) {
                        return 0;
                    }
                }
            }
            return 100;
        }
        if (cmp instanceof ValueDay) {
            if (this.getDay() > cmp.getDay()) {
                return 1;
            }
            if (this.getDay() < cmp.getDay()) {
                return -1;
            }
            if (this.getDay() == cmp.getDay()) {
                return 0;
            }
            return 100;
        }
        if (cmp instanceof ValueMonth) {
            if (this.getMonth() > cmp.getMonth()) {
                return 1;
            }
            if (this.getMonth() < cmp.getMonth()) {
                return -1;
            }
            if (this.getMonth() == cmp.getMonth()) {
                return 0;
            }
            return 100;
        }
        Debug.error(101, "(WARNING) Incompatible comparison to DATE type : ".concat(String.valueOf(String.valueOf(cmp.string))));
        return 100;
    }

    public Calendar resetTime(EnvironmentSmall env) {
        Calendar temp = Calendar.getInstance();
        temp.add(5, 1);
        return temp;
    }

    public String toString() {
        this.sbuf.setLength(0);
        if (this.calDate != null) {
            this.sbuf.append(this.calDate.get(2) + 1);
            this.sbuf.append("/");
            this.sbuf.append(this.calDate.get(5));
            if (this.isPrecise()) {
                this.sbuf.append("/");
                this.sbuf.append(this.calDate.get(1));
            }
        }
        return this.sbuf.toString();
    }

    public String toX10GIMLI() {
        return this.toString();
    }
}

