/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Value;

import X10Gimli.Debug;
import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.Value;
import X10Gimli.Value.ValueDate;
import X10Gimli.Value.ValueNothing;
import X10Gimli.Value.ValueNumber;
import X10Gimli.Value.ValueType;
import java.util.Calendar;

public final class ValueMonth
extends Value {
    private int iMonth;

    public ValueMonth() {
    }

    public ValueMonth(String string) {
        this.setValueString(string.toUpperCase());
        this.setMonth(this.getValueString());
    }

    public ValueMonth(int month) {
        this.setMonth(month);
    }

    public void setMonth(int month) {
        this.iMonth = ((month - 1) % 12 + 12) % 12 + 1;
        this.makeString();
    }

    public void setMonth(String month) {
        this.setMonth(ValueMonth.monthStringToInt(month));
        this.makeString();
    }

    public int getMonth() {
        return this.iMonth;
    }

    public int getNumber() {
        return this.iMonth;
    }

    public Value applyArithmetic(String op, ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if (cmp instanceof ValueMonth || cmp instanceof ValueNumber) {
            if (op == "+") {
                return new ValueMonth(this.getMonth() + this.getNumber());
            }
            if (op == "-") {
                return new ValueMonth(this.getMonth() - this.getNumber());
            }
        }
        Debug.error(102, "(Runtime) Incompatible arithmetic operation for MONTH type.");
        return ValueNothing.value;
    }

    public int compareTo(ValueType val, EnvironmentSmall env) {
        Value cmp = val.getValue(env);
        if (cmp instanceof ValueMonth || cmp instanceof ValueNumber || cmp instanceof ValueDate) {
            if (this.getNumber() > cmp.getNumber()) {
                return 1;
            }
            if (this.getNumber() < cmp.getNumber()) {
                return -1;
            }
            if (this.getNumber() == cmp.getNumber()) {
                return 0;
            }
            return 100;
        }
        Debug.error(101, "(WARNING) Incompatible comparison to MONTH type : ".concat(String.valueOf(String.valueOf(cmp.string))));
        return 100;
    }

    public Calendar resetTime(EnvironmentSmall env) {
        Calendar temp = Calendar.getInstance();
        temp.add(2, 1);
        return temp;
    }

    public String toString() {
        switch (this.iMonth) {
            case 1: {
                return "JANUARY";
            }
            case 2: {
                return "FEBRUARY";
            }
            case 3: {
                return "MARCH";
            }
            case 4: {
                return "APRIL";
            }
            case 5: {
                return "MAY";
            }
            case 6: {
                return "JUNE";
            }
            case 7: {
                return "JULY";
            }
            case 8: {
                return "AUGUST";
            }
            case 9: {
                return "SEPTEMBER";
            }
            case 10: {
                return "OCTOBER";
            }
            case 11: {
                return "NOVEMBER";
            }
            case 12: {
                return "DECEMBER";
            }
        }
        return "";
    }

    public static int monthStringToInt(String month) {
        if (month.equalsIgnoreCase("JAN")) {
            return 0;
        }
        if (month.equalsIgnoreCase("JANUARY")) {
            return 0;
        }
        if (month.equalsIgnoreCase("FEB")) {
            return 1;
        }
        if (month.equalsIgnoreCase("FEBRUARY")) {
            return 1;
        }
        if (month.equalsIgnoreCase("MAR")) {
            return 2;
        }
        if (month.equalsIgnoreCase("MARCH")) {
            return 2;
        }
        if (month.equalsIgnoreCase("APR")) {
            return 3;
        }
        if (month.equalsIgnoreCase("APRIL")) {
            return 3;
        }
        if (month.equalsIgnoreCase("MAY")) {
            return 4;
        }
        if (month.equalsIgnoreCase("JUN")) {
            return 5;
        }
        if (month.equalsIgnoreCase("JUNE")) {
            return 5;
        }
        if (month.equalsIgnoreCase("JUL")) {
            return 6;
        }
        if (month.equalsIgnoreCase("JULY")) {
            return 6;
        }
        if (month.equalsIgnoreCase("AUG")) {
            return 7;
        }
        if (month.equalsIgnoreCase("AUGUST")) {
            return 7;
        }
        if (month.equalsIgnoreCase("SEP")) {
            return 8;
        }
        if (month.equalsIgnoreCase("SEPTEMBER")) {
            return 8;
        }
        if (month.equalsIgnoreCase("OCT")) {
            return 9;
        }
        if (month.equalsIgnoreCase("OCTOBER")) {
            return 9;
        }
        if (month.equalsIgnoreCase("NOV")) {
            return 10;
        }
        if (month.equalsIgnoreCase("NOVEMBER")) {
            return 10;
        }
        if (month.equalsIgnoreCase("DEC")) {
            return 11;
        }
        if (month.equalsIgnoreCase("DECEMBER")) {
            return 11;
        }
        return 0;
    }

    public String toX10GIMLI() {
        return this.toString();
    }
}

