/*
 * Decompiled with CFR 0.152.
 */
package X10Gimli.Value;

import X10Gimli.System.EnvironmentSmall;
import X10Gimli.Value.Value;
import java.util.Calendar;

public abstract class ValueType {
    public String string = "";
    public static final int ARITHMETIC = 1;
    public static final int CONDITION = 2;
    public static final int LOGIC = 3;

    public static int operationType(String s) {
        if (s == "+") {
            return 1;
        }
        if (s == "-") {
            return 1;
        }
        if (s == "*") {
            return 1;
        }
        if (s == "/") {
            return 1;
        }
        if (s == "==") {
            return 2;
        }
        if (s == ">") {
            return 2;
        }
        if (s == ">=") {
            return 2;
        }
        if (s == "<") {
            return 2;
        }
        if (s == "<=") {
            return 2;
        }
        if (s == "<>") {
            return 2;
        }
        if (s == "AND") {
            return 3;
        }
        if (s == "OR") {
            return 3;
        }
        return 0;
    }

    public Value applyOperation(String op, ValueType val, EnvironmentSmall env) {
        switch (ValueType.operationType(op)) {
            case 1: {
                return this.applyArithmetic(op, val, env);
            }
            case 2: {
                return this.applyCondition(op, val, env);
            }
            case 3: {
                return this.applyLogic(op, val, env);
            }
        }
        return null;
    }

    public abstract Value getValue(EnvironmentSmall var1);

    public abstract Value applyArithmetic(String var1, ValueType var2, EnvironmentSmall var3);

    public abstract Value applyLogic(String var1, ValueType var2, EnvironmentSmall var3);

    public abstract Value applyCondition(String var1, ValueType var2, EnvironmentSmall var3);

    public abstract int compareTo(ValueType var1, EnvironmentSmall var2);

    public abstract Calendar resetTime(EnvironmentSmall var1);

    public abstract String toX10GIMLI();

    protected void makeString() {
        this.string = this.toString().intern();
    }

    static {
        ARITHMETIC = 1;
        CONDITION = 2;
        LOGIC = 3;
    }
}

