/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.util.Enumeration;
import java.util.Vector;
import tools.BaseApplet;
import tools.BaseThread;
import tools.EventProcessorInterface;
import tools.Globals;
import tools.TypeConverter;
import tools.VarMonitor;

public final class TraceMonitor
extends BaseApplet {
    public static Object eventsCountMutex = new Object();
    public static int eventsCount;
    public boolean show;
    private static Vector docs;
    private static EventProcessorInterface baseEventProcessor;
    private static Vector eventsQueue;
    private static final String goEventPrefix = "<*GO*>";
    private static final String statusEventPrefix = "<*ST*>";
    private static int repetitions;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean getShow() {
        Thread thread = Thread.currentThread();
        if (thread instanceof BaseThread) {
            String string = ((BaseThread)thread).a._getDocPath();
            if (string == null) {
                return false;
            }
            TraceMonitor traceMonitor = null;
            int n = 0;
            Vector vector = docs;
            synchronized (vector) {
                Enumeration enumeration = docs.elements();
                while (enumeration.hasMoreElements()) {
                    TraceMonitor traceMonitor2 = (TraceMonitor)enumeration.nextElement();
                    if (!string.equals(traceMonitor2._getDocPath())) continue;
                    traceMonitor = traceMonitor2;
                    ++n;
                }
                if (n == 0) {
                    return false;
                }
                if (n != true) return true;
                return traceMonitor.show;
            }
        }
        System.out.println("getShow?");
        return false;
    }

    public void start() {
        super.start();
        this.show = false;
        Vector vector = docs;
        synchronized (vector) {
            docs.addElement(this);
            return;
        }
    }

    public void stop() {
        super.stop();
        BaseApplet.setAppletPruningThreshold(50);
        this.show = false;
        Vector vector = docs;
        synchronized (vector) {
            docs.removeElement(this);
            return;
        }
    }

    public void destroy() {
        System.runFinalization();
        Thread.yield();
        System.gc();
        Thread.yield();
        System.gc();
        Thread.yield();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doRun() {
        Thread thread = Thread.currentThread();
        if (baseEventProcessor == null) {
            try {
                baseEventProcessor = (EventProcessorInterface)Class.forName("BaseEventProcessor").newInstance();
            }
            catch (Exception exception) {}
        }
        String string = this._getBasesOffset().replace('/', '.');
        EventProcessorInterface eventProcessorInterface = null;
        EventProcessorInterface eventProcessorInterface2 = null;
        try {
            if (this.getParameter("dirEventProcessor") != null) {
                eventProcessorInterface = (EventProcessorInterface)Class.forName(String.valueOf(string) + "EventProcessor").newInstance();
            }
        }
        catch (Exception exception) {}
        try {
            if (this.getParameter("docEventProcessor") != null) {
                eventProcessorInterface2 = (EventProcessorInterface)Class.forName(String.valueOf(string) + this._getDocName()).newInstance();
            }
        }
        catch (Exception exception) {}
        Vector vector = eventsQueue;
        synchronized (vector) {
            eventsQueue.removeAllElements();
            eventsQueue.addElement("onLoad");
        }
        repetitions = 0;
        while (thread == this.thread) {
            vector = eventsQueue;
            synchronized (vector) {
                block22: {
                    do {
                        if (eventsQueue.size() != 0) {
                            String string2 = (String)eventsQueue.elementAt(0);
                            if (!this.processEvent(string2, eventProcessorInterface, eventProcessorInterface2)) {
                                return;
                            }
                            break block22;
                        }
                        try {
                            eventsQueue.wait(250L);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    } while (thread == this.thread);
                    return;
                }
                eventsQueue.removeElementAt(0);
            }
        }
        return;
    }

    private boolean processEvent(String string, EventProcessorInterface eventProcessorInterface, EventProcessorInterface eventProcessorInterface2) {
        if (!(this.show || "onLoad".equals(string) || "generate".equals(string) || "show".equals(string))) {
            return true;
        }
        try {
            EventProcessorInterface eventProcessorInterface3;
            if (string.startsWith(goEventPrefix)) {
                this.show = false;
                String string2 = string.substring(goEventPrefix.length());
                this._go(string2, "_top");
                return false;
            }
            if (string.startsWith(statusEventPrefix)) {
                this.showStatus(string.substring(statusEventPrefix.length()));
                return true;
            }
            if ("generate".equals(string)) {
                Globals.genBegin();
            }
            if ((eventProcessorInterface3 = eventProcessorInterface2) != null && !eventProcessorInterface3.process(string)) {
                return true;
            }
            eventProcessorInterface3 = eventProcessorInterface;
            if (eventProcessorInterface3 != null && !eventProcessorInterface3.process(string)) {
                return true;
            }
            eventProcessorInterface3 = baseEventProcessor;
            if (eventProcessorInterface3 != null && !eventProcessorInterface3.process(string)) {
                return true;
            }
            String string3 = this._getDocPath();
            if ("onLoad".equals(string)) {
                if (TypeConverter.toBoolean(VarMonitor.get("%0"))) {
                    Globals.save(string3);
                    VarMonitor.set("%0", new Boolean(false));
                    eventsQueue.addElement("show");
                } else if (Globals.restore(string3)) {
                    eventsQueue.addElement("show");
                } else {
                    eventsQueue.addElement("generate");
                }
            }
            if ("generate".equals(string)) {
                if (++repetitions < 10 && Globals.checkRepetitions(string3)) {
                    eventsQueue.addElement("generate");
                } else {
                    if (repetitions > 3) {
                        System.out.println("generate" + repetitions);
                    }
                    repetitions = 0;
                    Globals.save(string3);
                    eventsQueue.addElement("show");
                }
                Globals.genEnd();
            }
            if ("show".equals(string)) {
                this.show = true;
            }
            TraceMonitor.incEventsCount();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    private static void incEventsCount() {
        Object object = eventsCountMutex;
        synchronized (object) {
            ++eventsCount;
            eventsCountMutex.notifyAll();
            return;
        }
    }

    public static void event(String string) {
        if (string == null) {
            return;
        }
        Vector vector = eventsQueue;
        synchronized (vector) {
            if (eventsQueue.indexOf(string) == -1) {
                eventsQueue.addElement(string);
                eventsQueue.notifyAll();
            }
            return;
        }
    }

    public static void eventGo(String string) {
        if (string != null && string.trim().length() > 0) {
            TraceMonitor.event(goEventPrefix + string);
        }
    }

    public static void eventStatus(String string) {
        if (string != null) {
            TraceMonitor.event(statusEventPrefix + string);
        }
    }

    static {
        docs = new Vector();
        eventsQueue = new Vector();
    }
}

