/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import tools.GraphXY;
import tools.GraphXYDesc;
import tools.SortedIntegers;
import tools.XY;

public final class Curve {
    public boolean dynamic = true;
    public int id;
    public double t1 = Double.NaN;
    public double t2 = Double.NaN;
    public int points = 50;
    public Color color = Color.black;
    public int width = 1;
    public Color fillColor;
    public String fillMode = "axes";
    public String fillStyle = "solid";
    public int fillStep = 5;
    public Polygon poly;

    public boolean c(int n, int n2) {
        if (this.poly == null) {
            return false;
        }
        return this.poly.inside(n, n2);
    }

    void calc(GraphXYDesc graphXYDesc) {
        Object object;
        this.poly = null;
        if (this.points < 2) {
            return;
        }
        int n = graphXYDesc.g.w + 1;
        int n2 = graphXYDesc.g.h + 1;
        if (Double.isNaN(this.t1)) {
            this.t1 = graphXYDesc.g.xAxes.beg;
        }
        if (Double.isNaN(this.t2)) {
            this.t2 = graphXYDesc.g.xAxes.end;
        }
        double d = this.t1;
        double d2 = (this.t2 - this.t1) / (double)(this.points - 1);
        int[] nArray = new int[3 * this.points];
        int[] nArray2 = new int[3 * this.points];
        XY xY = new XY();
        Object object2 = null;
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.points) {
            graphXYDesc.graphFunc(this.id, d, xY);
            if (!Double.isNaN(xY.x) && !Double.isNaN(xY.y)) {
                boolean bl2;
                object = graphXYDesc.g.XY2Point(xY);
                boolean bl3 = bl2 = ((Point)object).x >= -1 && ((Point)object).x <= n && ((Point)object).y >= -1 && ((Point)object).y <= n2;
                if (object2 != null) {
                    nArray[n3] = ((Point)object2).x;
                    nArray2[n3] = ((Point)object2).y;
                    if (!bl) {
                        if (nArray[n3] < -1) {
                            nArray[n3] = -1;
                        }
                        if (nArray[n3] > n) {
                            nArray[n3] = n;
                        }
                        if (nArray2[n3] < -1) {
                            nArray2[n3] = -1;
                        }
                        if (nArray2[n3] > n2) {
                            nArray2[n3] = n2;
                        }
                    }
                    ++n3;
                    if (!(bl && bl2 || ((Point)object2).x < -1 && ((Point)object).x < -1 || ((Point)object2).x > n && ((Point)object).x > n || ((Point)object2).y < -1 && ((Point)object).y < -1 || ((Point)object2).y > n2 && ((Point)object).y > n2)) {
                        Point point = this.interVer((Point)object2, (Point)object, ((Point)object2).x < ((Point)object).x ? -1 : n, -1, n2);
                        if (point != null) {
                            nArray[n3] = point.x;
                            nArray2[n3] = point.y;
                            ++n3;
                        }
                        if ((point = this.interVer((Point)object2, (Point)object, ((Point)object2).x < ((Point)object).x ? n : -1, -1, n2)) != null) {
                            nArray[n3] = point.x;
                            nArray2[n3] = point.y;
                            ++n3;
                        }
                        if ((point = this.interHor((Point)object2, (Point)object, ((Point)object2).y < ((Point)object).y ? -1 : n2, -1, n)) != null) {
                            nArray[n3] = point.x;
                            nArray2[n3] = point.y;
                            ++n3;
                        }
                        if ((point = this.interHor((Point)object2, (Point)object, ((Point)object2).y < ((Point)object).y ? n2 : -1, -1, n)) != null) {
                            nArray[n3] = point.x;
                            nArray2[n3] = point.y;
                            ++n3;
                        }
                    }
                }
                object2 = object;
                bl = bl2;
            }
            ++n4;
            d += d2;
        }
        if (object2 != null) {
            nArray[n3] = ((Point)object2).x;
            nArray2[n3] = ((Point)object2).y;
            if (!bl) {
                if (nArray[n3] < -1) {
                    nArray[n3] = -1;
                }
                if (nArray[n3] > n) {
                    nArray[n3] = n;
                }
                if (nArray2[n3] < -1) {
                    nArray2[n3] = -1;
                }
                if (nArray2[n3] > n2) {
                    nArray2[n3] = n2;
                }
            }
            ++n3;
        }
        if (n3 > 0) {
            if (this.fillMode.equals("up")) {
                nArray[n3] = nArray[n3 - 1];
                nArray2[n3] = 0;
                nArray[++n3] = nArray[0];
                nArray2[n3] = 0;
                ++n3;
            } else if (this.fillMode.equals("down")) {
                nArray[n3] = nArray[n3 - 1];
                nArray2[n3] = graphXYDesc.g.h;
                nArray[++n3] = nArray[0];
                nArray2[n3] = graphXYDesc.g.h;
                ++n3;
            } else if (this.fillMode.equals("axes")) {
                object = new XY();
                Point point = graphXYDesc.g.XY2Point((XY)object);
                nArray[n3] = nArray[n3 - 1];
                nArray2[n3] = point.y;
                nArray[++n3] = nArray[0];
                nArray2[n3] = point.y;
                ++n3;
            }
            this.poly = new Polygon(nArray, nArray2, n3);
        }
    }

    Point interVer(Point point, Point point2, int n, int n2, int n3) {
        if (point.x == point2.x) {
            return null;
        }
        if (point.x < point2.x && (n < point.x || n > point2.x)) {
            return null;
        }
        if (point.x > point2.x && (n < point2.x || n > point.x)) {
            return null;
        }
        int n4 = point.y + (n - point.x) * (point2.y - point.y) / (point2.x - point.x);
        if (n4 <= n2 || n4 >= n3) {
            return null;
        }
        return new Point(n, n4);
    }

    Point interHor(Point point, Point point2, int n, int n2, int n3) {
        if (point.y == point2.y) {
            return null;
        }
        if (point.y < point2.y && (n < point.y || n > point2.y)) {
            return null;
        }
        if (point.y > point2.y && (n < point2.y || n > point.y)) {
            return null;
        }
        int n4 = point.x + (n - point.y) * (point2.x - point.x) / (point2.y - point.y);
        if (n4 <= n2 || n4 >= n3) {
            return null;
        }
        return new Point(n4, n);
    }

    void fill(Graphics graphics, GraphXYDesc graphXYDesc) {
        if (this.poly == null || this.fillColor == null) {
            return;
        }
        if (this.fillStyle.equals("solid")) {
            graphics.setColor(this.fillColor);
            graphics.fillPolygon(this.poly);
            return;
        }
        if (this.fillStyle.equals("diag1")) {
            this.shadeDiag1(graphics, graphXYDesc.g);
            return;
        }
        if (this.fillStyle.equals("diag2")) {
            this.shadeDiag2(graphics, graphXYDesc.g);
            return;
        }
        if (this.fillStyle.equals("vert")) {
            this.shadeVert(graphics, graphXYDesc.g);
            return;
        }
        if (this.fillStyle.equals("horiz")) {
            this.shadeHoriz(graphics, graphXYDesc.g);
            return;
        }
        if (this.fillStyle.equals("cross1")) {
            this.shadeDiag1(graphics, graphXYDesc.g);
            this.shadeDiag2(graphics, graphXYDesc.g);
            return;
        }
        if (this.fillStyle.equals("cross2")) {
            this.shadeHoriz(graphics, graphXYDesc.g);
            this.shadeVert(graphics, graphXYDesc.g);
        }
    }

    void shadeVert(Graphics graphics, GraphXY graphXY) {
        if (this.poly == null) {
            return;
        }
        Rectangle rectangle = this.poly.getBoundingBox();
        int n = this.poly.npoints;
        int n2 = this.fillStep;
        if (n2 < 1) {
            n2 = 1;
        }
        graphics.setColor(this.fillColor);
        int n3 = rectangle.x / n2 * n2;
        while (n3 <= rectangle.x + rectangle.width) {
            int n4;
            int n5;
            int n6;
            SortedIntegers sortedIntegers = new SortedIntegers();
            int n7 = 0;
            while (n7 < n) {
                int n8;
                n6 = this.poly.xpoints[n7];
                n5 = this.poly.ypoints[n7];
                n4 = n7 < n - 1 ? this.poly.xpoints[n7 + 1] : this.poly.xpoints[0];
                int n9 = n8 = n7 < n - 1 ? this.poly.ypoints[n7 + 1] : this.poly.ypoints[0];
                if (n6 != n4 && (n6 < n4 && n3 >= n6 && n3 < n4 || n4 < n6 && n3 >= n4 && n3 < n6)) {
                    sortedIntegers.add(n8 - (n8 - n5) * (n4 - n3) / (n4 - n6));
                }
                ++n7;
            }
            n6 = 0;
            while (n6 < sortedIntegers.size() - 1) {
                n5 = (Integer)sortedIntegers.elementAt(n6);
                n4 = n6 + 1;
                n4 = (Integer)sortedIntegers.elementAt(n4);
                graphics.drawLine(n3, n5, n3, n4);
                n6 += 2;
            }
            n3 += n2;
        }
    }

    void shadeHoriz(Graphics graphics, GraphXY graphXY) {
        if (this.poly == null) {
            return;
        }
        Rectangle rectangle = this.poly.getBoundingBox();
        int n = this.poly.npoints;
        int n2 = this.fillStep;
        if (n2 < 1) {
            n2 = 1;
        }
        graphics.setColor(this.fillColor);
        int n3 = rectangle.y / n2 * n2;
        while (n3 <= rectangle.y + rectangle.height) {
            int n4;
            int n5;
            int n6;
            SortedIntegers sortedIntegers = new SortedIntegers();
            int n7 = 0;
            while (n7 < n) {
                int n8;
                n6 = this.poly.xpoints[n7];
                n5 = this.poly.ypoints[n7];
                n4 = n7 < n - 1 ? this.poly.xpoints[n7 + 1] : this.poly.xpoints[0];
                int n9 = n8 = n7 < n - 1 ? this.poly.ypoints[n7 + 1] : this.poly.ypoints[0];
                if (n5 != n8 && (n5 < n8 && n3 >= n5 && n3 < n8 || n8 < n5 && n3 >= n8 && n3 < n5)) {
                    sortedIntegers.add(n4 - (n4 - n6) * (n8 - n3) / (n8 - n5));
                }
                ++n7;
            }
            n6 = 0;
            while (n6 < sortedIntegers.size() - 1) {
                n5 = (Integer)sortedIntegers.elementAt(n6);
                n4 = n6 + 1;
                n4 = (Integer)sortedIntegers.elementAt(n4);
                graphics.drawLine(n5, n3, n4, n3);
                n6 += 2;
            }
            n3 += n2;
        }
    }

    void shadeDiag1(Graphics graphics, GraphXY graphXY) {
        if (this.poly == null) {
            return;
        }
        Rectangle rectangle = this.poly.getBoundingBox();
        int n = this.poly.npoints;
        int n2 = this.fillStep;
        if ((n2 = (n2 + n2 / 2) / 2 * 2) < 2) {
            n2 = 2;
        }
        graphics.setColor(this.fillColor);
        int n3 = rectangle.x + rectangle.y;
        while (n3 <= rectangle.x + rectangle.y + rectangle.width + rectangle.height) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            SortedIntegers sortedIntegers = new SortedIntegers();
            int n11 = 0;
            while (n11 < n) {
                n10 = this.poly.xpoints[n11];
                n9 = this.poly.ypoints[n11];
                n8 = n11 < n - 1 ? this.poly.xpoints[n11 + 1] : this.poly.xpoints[0];
                n7 = n11 < n - 1 ? this.poly.ypoints[n11 + 1] : this.poly.ypoints[0];
                n6 = n10 - n9;
                n5 = n10 + n9;
                n4 = n8 - n7;
                int n12 = n8 + n7;
                if (n5 != n12 && (n5 < n12 && n3 >= n5 && n3 < n12 || n12 < n5 && n3 >= n12 && n3 < n5)) {
                    int n13 = n4 - (n4 - n6) * (n12 - n3) / (n12 - n5);
                    sortedIntegers.add(n13 / 2 * 2);
                }
                ++n11;
            }
            n10 = 0;
            while (n10 < sortedIntegers.size() - 1) {
                n9 = (Integer)sortedIntegers.elementAt(n10);
                n8 = n10 + 1;
                n8 = (Integer)sortedIntegers.elementAt(n8);
                n7 = (n3 + n9) / 2;
                n6 = (n3 - n9) / 2;
                n5 = (n3 + n8) / 2;
                n4 = (n3 - n8) / 2;
                graphics.drawLine(n7, n6, n5, n4);
                n10 += 2;
            }
            n3 += n2;
        }
    }

    void shadeDiag2(Graphics graphics, GraphXY graphXY) {
        if (this.poly == null) {
            return;
        }
        Rectangle rectangle = this.poly.getBoundingBox();
        int n = this.poly.npoints;
        int n2 = this.fillStep;
        if ((n2 = (n2 + n2 / 2) / 2 * 2) < 2) {
            n2 = 2;
        }
        graphics.setColor(this.fillColor);
        int n3 = rectangle.y - rectangle.x - rectangle.width;
        while (n3 <= rectangle.y + rectangle.height - rectangle.x) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            SortedIntegers sortedIntegers = new SortedIntegers();
            int n11 = 0;
            while (n11 < n) {
                n10 = this.poly.xpoints[n11];
                n9 = this.poly.ypoints[n11];
                n8 = n11 < n - 1 ? this.poly.xpoints[n11 + 1] : this.poly.xpoints[0];
                n7 = n11 < n - 1 ? this.poly.ypoints[n11 + 1] : this.poly.ypoints[0];
                n6 = n9 + n10;
                n5 = n9 - n10;
                n4 = n7 + n8;
                int n12 = n7 - n8;
                if (n5 != n12 && (n5 < n12 && n3 >= n5 && n3 < n12 || n12 < n5 && n3 >= n12 && n3 < n5)) {
                    int n13 = n4 - (n4 - n6) * (n12 - n3) / (n12 - n5);
                    sortedIntegers.add(n13 / 2 * 2 + 2);
                }
                ++n11;
            }
            n10 = 0;
            while (n10 < sortedIntegers.size() - 1) {
                n9 = (Integer)sortedIntegers.elementAt(n10);
                n8 = n10 + 1;
                n8 = (Integer)sortedIntegers.elementAt(n8);
                n7 = (n9 - n3) / 2;
                n6 = (n9 + n3) / 2;
                n5 = (n8 - n3) / 2;
                n4 = (n8 + n3) / 2;
                graphics.drawLine(n7, n6, n5, n4);
                n10 += 2;
            }
            n3 += n2;
        }
    }

    void draw(Graphics graphics) {
        if (this.poly == null) {
            return;
        }
        int n = this.poly.npoints;
        if (this.fillMode.equals("up") || this.fillMode.equals("down") || this.fillMode.equals("axes")) {
            n -= 2;
        }
        if (n < 2) {
            return;
        }
        graphics.setColor(this.color);
        boolean bl = false;
        int n2 = 1;
        while (n2 < n) {
            int n3 = this.poly.xpoints[n2 - 1];
            int n4 = this.poly.ypoints[n2 - 1];
            int n5 = this.poly.xpoints[n2];
            int n6 = this.poly.ypoints[n2];
            graphics.drawLine(n3, n4, n5, n6);
            if (this.width > 1) {
                int n7;
                int n8;
                boolean bl2;
                int n9 = Math.abs(n3 - n5);
                boolean bl3 = bl2 = n9 >= (n8 = Math.abs(n4 - n6));
                if (bl2) {
                    n7 = 1;
                    while (n7 < this.width) {
                        graphics.drawLine(n3, n4 - n7, n5, n6 - n7);
                        graphics.drawLine(n3, n4 + n7, n5, n6 + n7);
                        ++n7;
                    }
                } else {
                    n7 = 1;
                    while (n7 < this.width) {
                        graphics.drawLine(n3 - n7, n4, n5 - n7, n6);
                        graphics.drawLine(n3 + n7, n4, n5 + n7, n6);
                        ++n7;
                    }
                }
                if (n2 > 1 && bl2 != bl) {
                    int[] nArray = new int[4];
                    int[] nArray2 = new int[4];
                    nArray[0] = n3;
                    nArray2[0] = n4 - this.width;
                    nArray[1] = n3 + this.width;
                    nArray2[1] = n4;
                    nArray[2] = n3;
                    nArray2[2] = n4 + this.width;
                    nArray[3] = n3 - this.width;
                    nArray2[3] = n4;
                    graphics.fillPolygon(nArray, nArray2, 4);
                }
                bl = bl2;
            }
            ++n2;
        }
    }
}

