/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import tools.Control;
import tools.ImageFamily;
import tools.TypeConverter;

public final class Scroll
extends Control {
    double value;
    double min = -1.0;
    double max = 1.0;
    double step = 0.02;
    ImageFamily i0;
    ImageFamily i1;
    ImageFamily i2;
    int w0;
    int h0;
    int w1;
    int h1;
    int w2;
    int h2;
    boolean bright0;
    boolean bright1;
    boolean bright2;
    boolean pressed1;
    boolean pressed2;
    int pos;
    int offset;
    boolean drag;
    boolean sizesGot;
    static final Color bordColorB = Color.white;
    static final Color bordColorD = Color.black;

    void doInit() {
        if (this.w > this.h) {
            try {
                if (this.i0 == null) {
                    this.i0 = new ImageFamily("/decor/misc/ScrollThumbHoriz.png", this);
                }
            }
            catch (Exception exception) {}
            try {
                if (this.i1 == null) {
                    this.i1 = new ImageFamily("/decor/misc/ScrollLeft.png", this);
                }
            }
            catch (Exception exception) {}
            try {
                if (this.i2 == null) {
                    this.i2 = new ImageFamily("/decor/misc/ScrollRight.png", this);
                }
            }
            catch (Exception exception) {}
        } else {
            try {
                if (this.i0 == null) {
                    this.i0 = new ImageFamily("/decor/misc/ScrollThumbVert.png", this);
                }
            }
            catch (Exception exception) {}
            try {
                if (this.i1 == null) {
                    this.i1 = new ImageFamily("/decor/misc/ScrollUp.png", this);
                }
            }
            catch (Exception exception) {}
            try {
                if (this.i2 == null) {
                    this.i2 = new ImageFamily("/decor/misc/ScrollDown.png", this);
                }
            }
            catch (Exception exception) {}
        }
        this.getSizes();
        super.doInit();
    }

    void getSizes() {
        if (this.sizesGot) {
            return;
        }
        int n = this.w > this.h ? this.h : this.w;
        int n2 = 0;
        int n3 = 0;
        if (this.i0 != null && this.i0.getSource() != null) {
            n2 = this.i0.getSource().getWidth(this);
            n3 = this.i0.getSource().getHeight(this);
        }
        this.w0 = n2 < 0 ? n : n2;
        this.h0 = n3 < 0 ? n : n3;
        int n4 = 0;
        int n5 = 0;
        if (this.i1 != null && this.i1.getSource() != null) {
            n4 = this.i1.getSource().getWidth(this);
            n5 = this.i1.getSource().getHeight(this);
        }
        this.w1 = n4 < 0 ? n : n4;
        this.h1 = n5 < 0 ? n : n5;
        int n6 = 0;
        int n7 = 0;
        if (this.i2 != null && this.i2.getSource() != null) {
            n6 = this.i2.getSource().getWidth(this);
            n7 = this.i2.getSource().getHeight(this);
        }
        this.w2 = n6 < 0 ? n : n6;
        int n8 = this.h2 = n7 < 0 ? n : n7;
        if (this.w > this.h) {
            ++this.w1;
            ++this.w2;
        } else {
            ++this.h1;
            ++this.h2;
        }
        boolean bl = this.sizesGot = n2 >= 0 && n3 >= 0 && n4 >= 0 && n5 >= 0 && n6 >= 0 && n7 >= 0;
        if (this.sizesGot) {
            this.checkValue();
        }
    }

    void getProps(Component component) {
        super.getProps(component);
        String string = this.getParameter("value");
        if (string != null) {
            this.value = TypeConverter.toDouble(string);
        }
        if ((string = this.getParameter("min")) != null) {
            this.min = TypeConverter.toDouble(string);
        }
        if ((string = this.getParameter("max")) != null) {
            this.max = TypeConverter.toDouble(string);
        }
        this.step = (string = this.getParameter("step")) != null ? TypeConverter.toDouble(string) : (this.max - this.min) / 100.0;
        this.checkValue();
    }

    public Object get(String string) {
        if (string == null || "value".equals(string)) {
            return new Double(this.value);
        }
        if ("min".equals(string)) {
            return new Double(this.min);
        }
        if ("max".equals(string)) {
            return new Double(this.max);
        }
        if ("step".equals(string)) {
            return new Double(this.step);
        }
        return super.get(string);
    }

    protected void set(Component component, Object object, String string) {
        if (string == null || "value".equals(string)) {
            this.value = TypeConverter.toDouble(object);
            this.checkValue();
            return;
        }
        if ("min".equals(string)) {
            this.min = TypeConverter.toDouble(object);
            if (this.max < this.min) {
                this.max = this.min;
            }
            this.checkValue();
            return;
        }
        if ("max".equals(string)) {
            this.max = TypeConverter.toDouble(object);
            if (this.min > this.max) {
                this.min = this.max;
            }
            this.checkValue();
            return;
        }
        if ("step".equals(string)) {
            this.step = TypeConverter.toDouble(object);
            this.checkValue();
            return;
        }
        super.set(component, object, string);
    }

    void checkValue() {
        if (this.min < this.max) {
            this.step = Math.abs(this.step);
            this.max = this.min + (double)((int)((this.max - this.min) / this.step + 0.5)) * this.step;
            this.value = this.min + (double)((int)((this.value - this.min) / this.step + 0.5)) * this.step;
            if (this.value < this.min) {
                this.value = this.min;
            }
            if (this.value > this.max) {
                this.value = this.max;
            }
            this.pos = this.w > this.h ? (this.w > this.w0 + this.w1 + this.w2 ? (int)((this.value - this.min) / (this.max - this.min) * (double)(this.w - this.w0 - this.w1 - this.w2) + 0.5) : 0) : (this.h > this.h0 + this.h1 + this.h2 ? this.h - this.h0 - this.h1 - this.h2 - (int)((this.value - this.min) / (this.max - this.min) * (double)(this.h - this.h0 - this.h1 - this.h2) + 0.5) : 0);
        } else {
            this.value = this.min;
            this.pos = 0;
        }
        this.repaint();
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.disabled || this.hidden) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.w > this.h) {
            if (n > this.pos + this.w1 && n < this.pos + this.w1 + this.w0) {
                bl = true;
            } else if (n < this.w1) {
                bl2 = true;
            } else if (n > this.w - this.w2) {
                bl3 = true;
            }
        } else if (n2 > this.pos + this.h1 && n2 < this.pos + this.h1 + this.h0) {
            bl = true;
        } else if (n2 < this.h1) {
            bl2 = true;
        } else if (n2 > this.h - this.h2) {
            bl3 = true;
        }
        if (this.bright0 != bl) {
            this.bright0 = bl;
            this.repaint();
        }
        if (this.bright1 != bl2) {
            this.bright1 = bl2;
            this.repaint();
        }
        if (this.bright2 != bl3) {
            this.bright2 = bl3;
            this.repaint();
        }
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.disabled || this.hidden) {
            return true;
        }
        if (this.w > this.h) {
            if (n > this.pos + this.w1 && n < this.pos + this.w1 + this.w0) {
                this.drag = true;
                this.offset = n - this.pos - this.w1;
            } else if (n < this.w1) {
                this.pressed1 = true;
            } else if (n > this.w - this.w2) {
                this.pressed2 = true;
            }
        } else if (n2 > this.pos + this.h1 && n2 < this.pos + this.h1 + this.h0) {
            this.drag = true;
            this.offset = this.pos + this.h1 + this.h0 - n2;
        } else if (n2 < this.h1) {
            this.pressed1 = true;
        } else if (n2 > this.h - this.h2) {
            this.pressed2 = true;
        }
        this.repaint();
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.disabled || this.hidden) {
            return true;
        }
        if (!this.drag) {
            if (this.w > this.h) {
                if (n < this.w1) {
                    this.value -= this.step;
                } else if (n > this.w - this.w2) {
                    this.value += this.step;
                } else if (n < this.pos + this.w1) {
                    this.value -= 10.0 * this.step;
                } else if (n > this.pos + this.w1 + this.w0) {
                    this.value += 10.0 * this.step;
                }
            } else if (n2 < this.h1) {
                this.value += this.step;
            } else if (n2 > this.h - this.h2) {
                this.value -= this.step;
            } else if (n2 < this.pos + this.h1) {
                this.value += 10.0 * this.step;
            } else if (n2 > this.pos + this.h1 + this.h0) {
                this.value -= 10.0 * this.step;
            }
            this.checkValue();
            this.event(null);
        }
        this.drag = false;
        this.pressed1 = false;
        this.pressed2 = false;
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (!this.drag || this.disabled || this.hidden) {
            return true;
        }
        if (this.w > this.w0 + this.w1 + this.w2) {
            this.value = this.min + (this.max - this.min) * (double)(n - this.w1 - this.offset) / (double)(this.w - this.w0 - this.w1 - this.w2);
        }
        if (this.h > this.h0 + this.h1 + this.h2) {
            this.value = this.min + (this.max - this.min) * (double)(this.h - n2 - this.h1 - this.offset) / (double)(this.h - this.h0 - this.h1 - this.h2);
        }
        this.checkValue();
        this.event(null);
        return true;
    }

    void doUpdate(Graphics graphics) {
        Image image;
        Image image2;
        if (this.hidden) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.w, this.h);
            return;
        }
        this.getSizes();
        if (!this.entered) {
            this.bright2 = false;
            this.bright1 = false;
            this.bright0 = false;
        }
        Image image3 = this.i0 == null ? null : (this.disabled ? this.i0.getContour() : (image2 = this.bright0 ? this.i0.getBright() : this.i0.getSource()));
        Image image4 = this.i1 == null ? null : (this.disabled ? this.i1.getContour() : (image = this.bright1 ? this.i1.getBright() : this.i1.getSource()));
        Image image5 = this.i2 == null ? null : (this.disabled ? this.i2.getContour() : (this.bright2 ? this.i2.getBright() : this.i2.getSource()));
        this.drawBack(graphics);
        if (this.w > this.h) {
            this.drawButton(graphics, this.pos + this.w1, (this.h - this.h0) / 2, this.w0, this.h0, false, image2);
            this.drawButton(graphics, 0, (this.h - this.h1) / 2, this.w1, this.h1, this.pressed1, image);
            this.drawButton(graphics, this.w - this.w2, (this.h - this.h2) / 2, this.w2, this.h2, this.pressed2, image5);
            return;
        }
        this.drawButton(graphics, (this.w - this.w0) / 2, this.pos + this.h1, this.w0, this.h0, false, image2);
        this.drawButton(graphics, (this.w - this.w1) / 2, 0, this.w1, this.h1, this.pressed1, image);
        this.drawButton(graphics, (this.w - this.w2) / 2, this.h - this.h2, this.w2, this.h2, this.pressed2, image5);
    }

    void drawBack(Graphics graphics) {
        Color color = this.disabled || this.backColor == null ? Color.lightGray : this.backColor;
        graphics.setColor(color);
        graphics.fillRect(0, 0, this.w, this.h);
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        float[] fArray = Color.RGBtoHSB(n, n2, n3, null);
        fArray[1] = (float)((double)fArray[1] * 2.5);
        fArray[2] = (float)((double)fArray[2] * 0.7);
        if (fArray[1] > 1.0f) {
            fArray[1] = 1.0f;
        }
        color = Color.getHSBColor(fArray[0], fArray[1], fArray[2]);
        graphics.setColor(color);
        if (this.w > this.h && this.w > this.w1 + this.w2 + 14 && this.h > 7) {
            graphics.fillRect(this.w1 + 7, (this.h - 7) / 2, this.w - this.w1 - this.w2 - 14, 7);
        }
        if (this.w <= this.h && this.h > this.h1 + this.h2 + 14 && this.w > 7) {
            graphics.fillRect((this.w - 7) / 2, this.h1 + 7, 7, this.h - this.h1 - this.h2 - 14);
        }
    }

    void drawButton(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, Image image) {
        int n5;
        int n6 = n5 = bl ? 1 : 0;
        if (image != null) {
            graphics.drawImage(image, n + n5, n2 + n5, this);
        }
        if (this.disabled) {
            return;
        }
        graphics.setColor(bl ? bordColorD : bordColorB);
        graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 2);
        graphics.drawLine(n + 1, n2 + 1, n + n3 - 2, n2 + 1);
        graphics.setColor(!bl ? bordColorD : bordColorB);
        graphics.drawLine(n + n3 - 1, n2 + 2, n + n3 - 1, n2 + n4 - 1);
        graphics.drawLine(n + 2, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
    }
}

