#include "mcadincl.h"
#include "math.h"
#include "stdlib.h"

/* Cephes functions */

typedef struct
	{
	double r;
	double i;
	} cmplx;

extern int    airy(double x,double *ai,double *aip,double *bi,double *bip );
extern double beta(double x,double y);
extern double dawsn(double x);
extern double ellie(double phi,double m);
extern double ellik(double phi,double m);
extern double ellpe(double m);
extern int    ellpj(double u,double  m,double *sn,double *cn,double *dn,double *phi);
extern double ellpk(double m);
extern double expn(int n,double x);
extern int    fresnl(double x,double *S,double *C );
extern double igam (double a,double x);
extern double igamc (double a,double x);
extern double igami (double a,double x);
extern double incbet (double a,double b,double x);
extern double incbi (double a,double b,double x);
extern double hyp2f0(double a,double b,double x ,int type,double *err);
extern double hyp2f1(double a,double b,double c,double x );
extern double hyperg(double a,double b,double x);
extern double iv(double n,double x);
extern double jv(double n,double x);
extern double kn(int n,double x);
extern double lbeta(double x,double y);
extern double lgam(double x);
extern double onef2(double a,double b,double c,double x ,double *err );
extern double psi(double x);
extern double rgamma(double x);
extern double round(double x);
extern int    shichi(double x,double *si,double *ci);
extern int    sici(double x,double *si,double *ci);
extern double spence(double x);
extern double struve(double n,double x);
extern double threef0(double a,double b,double c,double x ,double *err );
extern double yv(double n,double x);
extern double zeta(double x,double q);
extern double zetac(double x);
extern void   csqrt( cmplx *z , cmplx *w );
extern void   cdiv( cmplx *a , cmplx *b , cmplx *c);
/* Borz functions */
extern double bino(double a,int k);
extern void   clgam( cmplx *z, cmplx *v);
extern void   cbeta( cmplx *x, cmplx *y, cmplx *z);
extern void   clbeta( cmplx *x, cmplx *y, cmplx *z);
extern void   cpsi( cmplx *z, cmplx *v);
extern double semifact( int n );
extern double legendrepol( int m, int l, double x );
extern double legendrepolnorm( int m, int l, double x );
/* Amos functions */
extern int    zbesj_(double *zr, double *zi, double *fnu, long int *kode, 
	 long int *n, double *cyr, double *cyi, long int *nz, long int *ierr);
extern int    zbesy_(double *zr, double *zi, double *fnu, long int *kode, 
	 long int *n, double *cyr, double *cyi, long int *nz, double *cwrkr, 
	 double *cwrki, long int *ierr);
extern int    zbesh_(double *zr, double *zi, double *fnu, long int *kode, 
	 long int *m, long int *n, double *cyr, double *cyi, long int *nz, 
	 long int *ierr);
extern int    zbesi_(double *zr, double *zi, double *fnu, long int *kode,
	 long int *n, double *cyr, double *cyi, long int *nz, long int *ierr);
extern int    zbesk_(double *zr, double *zi, double *fnu, long int *kode, 
	 long int *n, double *cyr, double *cyi, long int *nz, long int *ierr);
extern int    zairy_(double *zr, double *zi, long int *id, long int *kode, 
	 double *air, double *aii, long int *nz, long int *ierr);
extern int    zbiry_(double *zr, double *zi, long int *id, long int *kode, 
	 double *bir, double *bii, long int *ierr);
/* Carlson elliptic integrals */
extern double rf_(double *x, double *y, double *z, double *errtol, long int *ierr);
extern double rd_(double *x, double *y, double *z, double *errtol, long int *ierr);
extern double rj_(double *x, double *y, double *z, double *p, double *errtol,
			long int *ierr);
/* Smith routines for legendre polynomials and functions */ 
extern int dxlegf_(double *dnu1, long int *nudiff, long int *mu1, long int *mu2, 
		double *theta, long int *id, double *pqa, long int *ipqa, long int *ierror);
extern int dxnrmp_(long int *nu, long int *mu1, long int *mu2, double *darg, 
		long int *mode, double *dpn, long int *ipn, long int *isig, long int *ierror);



extern double PI, PIO2, SQ2PI;
extern int sgngam;
int merror = -1;
int maskploss = 1; /* partial loss of precision is an error by default */

LRESULT H1vFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x   );

FUNCTIONINFO    H1v = 
{ 
"H1v",			 /* Name by which mathcad will recognize the function*/
"v,z",			      /* H1v will be called as H1v(v,z)*/
"Hankel function of real order v and complex argument z (1st kind). Argument z must be nonzero and is considered in the cut plane -pi < arg(z) <= pi.",    /* description of H1v(a,b)*/
(LPCFUNCTION)H1vFunction,      /* pointer to the executible code*/
COMPLEX_SCALAR, 
2,		  /* the return type is also a complex scalar*/
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   /* both arguments are complex scalars*/
};


/* this code executes the calculation*/
LRESULT H1vFunction(   LPCOMPLEXSCALAR     c,  /*put return value here*/
				LPCCOMPLEXSCALAR    v,  /* 1st argument*/
				LPCCOMPLEXSCALAR    x   ) /* 2nd argument*/
{
	/*  Hankel function of real order v and argument x (1st kind) */
	// check that the first argument is real
	if ( v->imag != 0.0 )
	    // if it is not, display "must be real" error message 
	    // under the scalar argument( the 1st argument )
		return MAKELRESULT( 1 , 1 );
	if ( ( x->imag == 0.0 ) && ( x->real == 0.0 ) )
		return MAKELRESULT( 6 , 2 );
	if ( ( x->imag == 0.0 ) && ( x->real > 0 ) && ( floor( v->real ) == v->real ) )
	{
		c->real = jv(v->real,x->real);
		c->imag = yv(v->real,x->real);

		if (merror != -1)
		{
			int ierr;

			ierr = merror + 4;
			merror = -1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
	else
	{     
		long int kode, m, n, nz, ierr;

		kode = 1; n = 1; m = 1;
		if ( v->real >= 0.0 )
			zbesh_( &x->real , &x->imag , &v->real , &kode , &m , &n , &c->real , 
				  &c->imag , &nz , &ierr );
		else
		{
			double v1,h1r,h1i,cosv,sinv;

			v1 = -v->real;
			zbesh_( &x->real , &x->imag , &v1 , &kode , &m , &n , &h1r , &h1i ,
				  &nz , &ierr );
			v1 *= PI; cosv = cos( v1 ); sinv = sin( v1 );
			c->real = h1r * cosv - h1i * sinv;
			c->imag = h1i * cosv + h1r * sinv;
		}
		if ( maskploss == 0 && ierr == 3 ) ierr = 0;
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 2 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
	}
}

LRESULT H1eFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x   );

FUNCTIONINFO    H1e = 
{ 
"H1e",			 /* Name by which mathcad will recognize the function*/
"v,z",			      /* H1e will be called as H1e(v,z)*/
"Exponentially scaled Hankel function of real order v and complex argument z (1st kind). Argument z must be nonzero and is considered in the cut plane -pi < arg(z) <= pi.",    /* description of H1e(a,b)*/
(LPCFUNCTION)H1eFunction,      /* pointer to the executible code*/
COMPLEX_SCALAR, 
2,		  /* the return type is also a complex scalar*/
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   /* both arguments are complex scalars*/
};


/* this code executes the calculation*/
LRESULT H1eFunction(   LPCOMPLEXSCALAR     c,  /*put return value here*/
				LPCCOMPLEXSCALAR    v,  /* 1st argument*/
				LPCCOMPLEXSCALAR    x   ) /* 2nd argument*/
{
	/*  Hankel function of real order v and argument x (1st kind) */
	// check that the first argument is real
	if ( v->imag != 0.0 )
	    // if it is not, display "must be real" error message 
	    // under the scalar argument( the 1st argument )
		return MAKELRESULT( 1 , 1 );
	if ( ( x->imag == 0.0 ) && ( x->real == 0.0 ) )
		return MAKELRESULT( 6 , 2 );
	if ( ( x->imag == 0.0 ) && ( x->real > 0 ) && ( floor( v->real ) == v->real ) )
	{
		double vr, vi, cs, sn;

		cs = cos( x->real ); sn = sin( x->real );
		vr = jv(v->real,x->real);
		vi = yv(v->real,x->real);
		c->real = vr * cs + vi * sn;
		c->imag = vi * cs - vr * sn;

		if (merror != -1)
		{
			int ierr;

			ierr = merror + 4;
			merror = -1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
	else
	{     
		long int kode, m, n, nz, ierr;

		kode = 2; n = 1; m = 1;
		if ( v->real >= 0.0 )
			zbesh_( &x->real , &x->imag , &v->real , &kode , &m , &n , &c->real , 
				  &c->imag , &nz , &ierr );
		else
		{
			double v1,h1r,h1i,cosv,sinv;

			v1 = -v->real;
			zbesh_( &x->real , &x->imag , &v1 , &kode , &m , &n , &h1r , &h1i ,
				  &nz , &ierr );
			v1 *= PI; cosv = cos( v1 ); sinv = sin( v1 );
			c->real = h1r * cosv - h1i * sinv;
			c->imag = h1i * cosv + h1r * sinv;
		}
		if ( maskploss == 0 && ierr == 3 ) ierr = 0;
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 2 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
	}
}


LRESULT H2vFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x   );

FUNCTIONINFO    H2v = 
{ 
"H2v",			 /* Name by which mathcad will recognize the function*/
"v,z",			      /* H2v will be called as H2v(v,z)*/
"Hankel function of real order v and complex argument z (2nd kind). Argument z must be nonzero and is considered in the cut plane -pi < arg(z) <= pi.",    /* description of H2v(a,b)*/
(LPCFUNCTION)H2vFunction,      /* pointer to the executible code*/
COMPLEX_SCALAR, 
2,		  /* the return type is also a complex scalar*/
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   /* both arguments are complex scalars*/
};


/* this code executes the calculation*/
LRESULT H2vFunction(   LPCOMPLEXSCALAR     c,  /*put return value here*/
				LPCCOMPLEXSCALAR    v,  /* 1st argument*/
				LPCCOMPLEXSCALAR    x   ) /* 2nd argument*/
{
	/*  Hankel function of real order v and argument x (2st kind) */
	// check that the first argument is real
	if ( v->imag != 0.0 )
	    // if it is not, display "must be real" error message 
	    // under the scalar argument( the 1st argument )
		return MAKELRESULT( 1 , 1 );
	if ( ( x->imag == 0.0 ) && ( x->real == 0.0 ) )
		return MAKELRESULT( 6 , 2 );
	if ( ( x->imag == 0.0 ) && ( x->real > 0 ) && ( floor( v->real ) == v->real ) )
	{
		c->real =  jv(v->real,x->real);
		c->imag = -yv(v->real,x->real);

		if (merror != -1)
		{
			int ierr;

			ierr = merror + 4;
			merror = -1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
	else
	{     
		long int kode, m, n, nz, ierr;

		kode = 1; n = 1; m = 2;
		if ( v->real >= 0.0 )
			zbesh_( &x->real , &x->imag , &v->real , &kode , &m , &n , &c->real , 
				  &c->imag , &nz , &ierr );
		else
		{
			double v1,h2r,h2i,cosv,sinv;

			v1 = -v->real;
			zbesh_( &x->real , &x->imag , &v1 , &kode , &m , &n , &h2r , &h2i ,
				  &nz , &ierr );
			v1 *= PI; cosv = cos( v1 ); sinv = sin( v1 );
			c->real = h2r * cosv + h2i * sinv;
			c->imag = h2i * cosv - h2r * sinv;
		}
		if ( maskploss == 0 && ierr == 3 ) ierr = 0;
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 2 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
	}
}

LRESULT H2eFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x   );

FUNCTIONINFO    H2e = 
{ 
"H2e",			 /* Name by which mathcad will recognize the function*/
"v,z",			      /* H2e will be called as H2e(v,z)*/
"Exponentially scaled Hankel function of real order v and complex argument z (2nd kind). Argument z must be nonzero and is considered in the cut plane -pi < arg(z) <= pi.",    /* description of H2e(a,b)*/
(LPCFUNCTION)H2eFunction,      /* pointer to the executible code*/
COMPLEX_SCALAR, 
2,		  /* the return type is also a complex scalar*/
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   /* both arguments are complex scalars*/
};


/* this code executes the calculation*/
LRESULT H2eFunction(   LPCOMPLEXSCALAR     c,  /*put return value here*/
				LPCCOMPLEXSCALAR    v,  /* 1st argument*/
				LPCCOMPLEXSCALAR    x   ) /* 2nd argument*/
{
	/*  Hankel function of real order v and argument x (1st kind) */
	// check that the first argument is real
	if ( v->imag != 0.0 )
	    // if it is not, display "must be real" error message 
	    // under the scalar argument( the 1st argument )
		return MAKELRESULT( 1 , 1 );
	if ( ( x->imag == 0.0 ) && ( x->real == 0.0 ) )
		return MAKELRESULT( 6 , 2 );
	if ( ( x->imag == 0.0 ) && ( x->real > 0 ) && ( floor( v->real ) == v->real ) )
	{
		double vr, vi, cs, sn;

		cs = cos( x->real ); sn = sin( x->real );
		vr = jv(v->real,x->real);
		vi = - yv(v->real,x->real);
		c->real = vr * cs - vi * sn;
		c->imag = vi * cs + vr * sn;

		if (merror != -1)
		{
			int ierr;

			ierr = merror + 4;
			merror = -1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
	else
	{     
		long int kode, m, n, nz, ierr;

		kode = 2; n = 1; m = 2;
		if ( v->real >= 0.0 )
			zbesh_( &x->real , &x->imag , &v->real , &kode , &m , &n , &c->real , 
				  &c->imag , &nz , &ierr );
		else
		{
			double v1,h2r,h2i,cosv,sinv;

			v1 = -v->real;
			zbesh_( &x->real , &x->imag , &v1 , &kode , &m , &n , &h2r , &h2i ,
				  &nz , &ierr );
			v1 *= PI; cosv = cos( v1 ); sinv = sin( v1 );
			c->real = h2r * cosv + h2i * sinv;
			c->imag = h2i * cosv - h2r * sinv;
		}
		if ( maskploss == 0 && ierr == 3 ) ierr = 0;
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 2 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
	}
}

LRESULT JvcFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x   );

FUNCTIONINFO    Jvc = 
{ 
"Jv",			 /* Name by which mathcad will recognize the function*/
"v,z",			      /* Jv will be called as Jv(v,z)*/
"Bessel function of real order v and complex argument z. Argument z is considered in the cut plane -pi < arg(z) <= pi.",    /* description of Jv(a,b)*/
(LPCFUNCTION)JvcFunction,      /* pointer to the executible code*/
COMPLEX_SCALAR, 
2,		  /* the return type is also a complex scalar*/
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   /* both arguments are complex scalars*/
};


/* this code executes the calculation*/
LRESULT JvcFunction(   LPCOMPLEXSCALAR     c,  /*put return value here*/
				LPCCOMPLEXSCALAR    v,  /* 1st argument*/
				LPCCOMPLEXSCALAR    x   ) /* 2nd argument*/
{
	/*  Bessel function of real order v and argument x */
	// check that the first argument is real
	if ( v->imag != 0.0 )
	    // if it is not, display "must be real" error message 
	    // under the scalar argument( the 1st argument )
		return MAKELRESULT( 1 , 1 );
	if ( ( x->imag == 0.0 ) && ( ( x->real >= 0 ) || ( floor( v->real ) == v->real ) ) )
	{
		c->real = jv(v->real,x->real);

		if (merror != -1)
		{
			int ierr;

			ierr = merror + 4;
			merror = -1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
	else
	{     
		long int kode,n,nz,ierr,sign;
		double v1,cosv,sinv,jr,ji,yr,yi;

		kode = 1; n = 1;
		if ( v->real >= 0.0 )
			zbesj_( &x->real , &x->imag , &v->real , &kode , &n , &c->real , 
				  &c->imag , &nz , &ierr );
		else
		{
			v1 = - v->real;
			if ( floor( v1 ) == v1 )
			{
				nz = (int)v1;
				if ( ( nz & 1 ) == 1) sign = -1;
				else sign = 1;
				zbesj_( &x->real , &x->imag , &v1 , &kode , &n , &c->real , 
					  &c->imag , &nz , &ierr );
				c->real *= sign;
				c->imag *= sign;
			}
			else
			{
				zbesy_( &x->real , &x->imag , &v1 , &kode , &n , &yr , &yi ,
					  &nz , &jr , &ji , &ierr );
				if (ierr == 0)
				{
					zbesj_( &x->real , &x->imag , &v1 , &kode , &n , &jr , &ji ,
						  &nz , &ierr );
					v1 *= PI; cosv = cos( v1 ); sinv = sin( v1 );
					c->real = jr * cosv - yr * sinv;
					c->imag = ji * cosv - yi * sinv;
				}
			}
		}
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 2 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
	}
}

LRESULT JveFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x   );

FUNCTIONINFO    Jve = 
{ 
"Je",			 /* Name by which mathcad will recognize the function*/
"v,z",			      /* Je will be called as Je(v,z)*/
"Exponentially scaled Bessel function of real order v and complex argument z. Argument z is considered in the cut plane -pi < arg(z) <= pi.",    /* description of Je(a,b)*/
(LPCFUNCTION)JveFunction,      /* pointer to the executible code*/
COMPLEX_SCALAR, 
2,		  /* the return type is also a complex scalar*/
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   /* both arguments are complex scalars*/
};


/* this code executes the calculation*/
LRESULT JveFunction(   LPCOMPLEXSCALAR     c,  /*put return value here*/
				LPCCOMPLEXSCALAR    v,  /* 1st argument*/
				LPCCOMPLEXSCALAR    x   ) /* 2nd argument*/
{
	/*  Bessel function of real order v and argument x */
	// check that the first argument is real
	if ( v->imag != 0.0 )
	    // if it is not, display "must be real" error message 
	    // under the scalar argument( the 1st argument )
		return MAKELRESULT( 1 , 1 );
	if ( ( x->imag == 0.0 ) && ( ( x->real >= 0 ) || ( floor( v->real ) == v->real ) ) )
	{
		c->real = jv(v->real,x->real);

		if (merror != -1)
		{
			int ierr;

			ierr = merror + 4;
			merror = -1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
	else
	{     
		long int kode,n,nz,ierr,sign;
		double v1,cosv,sinv,jr,ji,yr,yi;

		kode = 2; n = 1;
		if ( v->real >= 0.0 )
			zbesj_( &x->real , &x->imag , &v->real , &kode , &n , &c->real , 
				  &c->imag , &nz , &ierr );
		else
		{
			v1 = - v->real;
			if ( floor( v1 ) == v1 )
			{
				nz = (int)v1;
				if ( ( nz & 1 ) == 1) sign = -1;
				else sign = 1;
				zbesj_( &x->real , &x->imag , &v1 , &kode , &n , &c->real , 
					  &c->imag , &nz , &ierr );
				c->real *= sign;
				c->imag *= sign;
			}
			else
			{
				zbesy_( &x->real , &x->imag , &v1 , &kode , &n , &yr , &yi ,
					  &nz , &jr , &ji , &ierr );
				if (ierr == 0)
				{
					zbesj_( &x->real , &x->imag , &v1 , &kode , &n , &jr , &ji ,
						  &nz , &ierr );
					v1 *= PI; cosv = cos( v1 ); sinv = sin( v1 );
					c->real = jr * cosv - yr * sinv;
					c->imag = ji * cosv - yi * sinv;
				}
			}
		}
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 2 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
	}
}


LRESULT YvcFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x   );

FUNCTIONINFO    Yvc = 
{ 
"Yv",			 /* Name by which mathcad will recognize the function*/
"v,z",			      /* Yv will be called as Yv(v,z)*/
"Neumann function of real order v and complex argument z. Argument z must be nonzero and is considered in the cut plane -pi < arg(z) <= pi.",    /* description of Yv(a,b)*/
(LPCFUNCTION)YvcFunction,      /* pointer to the executible code*/
COMPLEX_SCALAR, 
2,		  /* the return type is also a complex scalar*/
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   /* both arguments are complex scalars*/
};


/* this code executes the calculation*/
LRESULT YvcFunction(   LPCOMPLEXSCALAR     c,  /*put return value here*/
				LPCCOMPLEXSCALAR    v,  /* 1st argument*/
				LPCCOMPLEXSCALAR    x   ) /* 2nd argument*/
{
	
	/*  Neumann function of real order v and argument x */
	// check that the first argument is real
	if ( v->imag != 0.0 )
	    // if it is not, display "must be real" error message 
	    // under the scalar argument( the 1st argument )
		return MAKELRESULT( 1 , 1 );
	if ( ( x->imag == 0.0 ) && ( x->real == 0.0 ) )
		return MAKELRESULT( 6 , 2 );
	if ( ( x->imag == 0.0 ) && ( x->real >= 0.0 ) && ( floor(v->real) == v->real ) )
	{
		c->real = yv(v->real,x->real);

		if (merror != -1)
		{
			int ierr;

			ierr = merror + 4;
			merror = -1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
	else
	{     
		long int kode,n,nz,ierr,sign;
		double v1,cosv,sinv,jr,ji,yr,yi;

		kode = 1; n = 1;
		if ( v->real >= 0.0 )
			zbesy_( &x->real , &x->imag , &v->real , &kode , &n , &c->real , 
				  &c->imag , &nz , &jr , &ji , &ierr );
		else
		{
			v1 = - v->real;
			if ( floor( v1 ) == v1 )
			{
				nz = (int)v1;
				if ( ( nz & 1 ) == 1) sign = -1;
				else sign = 1;
				zbesy_( &x->real , &x->imag , &v1 , &kode , &n , &c->real , 
					  &c->imag , &nz , &jr , &ji , &ierr );
				c->real *= sign;
				c->imag *= sign;
			}
			else
			{
				zbesy_( &x->real , &x->imag , &v1 , &kode , &n , &yr , &yi ,
					  &nz , &jr , &ji , &ierr );
				if (ierr == 0)
				{
					zbesj_( &x->real , &x->imag , &v1 , &kode , &n , &jr , &ji ,
						  &nz , &ierr );
					v1 *= PI; cosv = cos( v1 ); sinv = sin( v1 );
					c->real = jr * sinv + yr * cosv;
					c->imag = ji * sinv + yi * cosv;
				}
			}
		}
		if ( ( x->imag == 0.0 ) && ( x->real > 0.0 ) ) c->imag = 0.0;

		if ( maskploss == 0 && ierr == 3 ) ierr = 0;
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 2 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
	}
}

LRESULT YveFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x   );

FUNCTIONINFO    Yve = 
{ 
"Ye",			 /* Name by which mathcad will recognize the function*/
"v,z",			      /* Ye will be called as Ye(v,z)*/
"Exponentially scaled Neumann function of real order v and complex argument z. Argument z must be nonzero and is considered in the cut plane -pi < arg(z) <= pi.",    /* description of Ye(a,b)*/
(LPCFUNCTION)YveFunction,      /* pointer to the executible code*/
COMPLEX_SCALAR, 
2,		  /* the return type is also a complex scalar*/
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   /* both arguments are complex scalars*/
};


/* this code executes the calculation*/
LRESULT YveFunction(   LPCOMPLEXSCALAR     c,  /*put return value here*/
				LPCCOMPLEXSCALAR    v,  /* 1st argument*/
				LPCCOMPLEXSCALAR    x   ) /* 2nd argument*/
{
	
	/*  Neumann function of real order v and argument x */
	// check that the first argument is real
	if ( v->imag != 0.0 )
	    // if it is not, display "must be real" error message 
	    // under the scalar argument( the 1st argument )
		return MAKELRESULT( 1 , 1 );
	if ( ( x->imag == 0.0 ) && ( x->real == 0.0 ) )
		return MAKELRESULT( 6 , 2 );
	if ( ( x->imag == 0.0 ) && ( x->real >= 0.0 ) && ( floor(v->real) == v->real ) )
	{
		c->real = yv(v->real,x->real);

		if (merror != -1)
		{
			int ierr;

			ierr = merror + 4;
			merror = -1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
	else
	{     
		long int kode,n,nz,ierr,sign;
		double v1,cosv,sinv,jr,ji,yr,yi;

		kode = 2; n = 1;
		if ( v->real >= 0.0 )
			zbesy_( &x->real , &x->imag , &v->real , &kode , &n , &c->real , 
				  &c->imag , &nz , &jr , &ji , &ierr );
		else
		{
			v1 = - v->real;
			if ( floor( v1 ) == v1 )
			{
				nz = (int)v1;
				if ( ( nz & 1 ) == 1) sign = -1;
				else sign = 1;
				zbesy_( &x->real , &x->imag , &v1 , &kode , &n , &c->real , 
					  &c->imag , &nz , &jr , &ji , &ierr );
				c->real *= sign;
				c->imag *= sign;
			}
			else
			{
				zbesy_( &x->real , &x->imag , &v1 , &kode , &n , &yr , &yi ,
					  &nz , &jr , &ji , &ierr );
				if (ierr == 0)
				{
					zbesj_( &x->real , &x->imag , &v1 , &kode , &n , &jr , &ji ,
						  &nz , &ierr );
					v1 *= PI; cosv = cos( v1 ); sinv = sin( v1 );
					c->real = jr * sinv + yr * cosv;
					c->imag = ji * sinv + yi * cosv;
				}
			}
		}
		if ( ( x->imag == 0.0 ) && ( x->real > 0.0 ) ) c->imag = 0.0;

		if ( maskploss == 0 && ierr == 3 ) ierr = 0;
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 2 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
	}
}


LRESULT IvcFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x   );

FUNCTIONINFO    Ivc = 
{ 
"Iv",			 /* Name by which mathcad will recognize the function*/
"v,z",			      /* Iv will be called as Iv(v,z)*/
"Modified Bessel function of real order v and complex argument z. Argument z is considered in the cut plane -pi < arg(z) <= pi.", /* description of Iv(a,b)*/
(LPCFUNCTION)IvcFunction,      /* pointer to the executible code*/
COMPLEX_SCALAR, 
2,		  /* the return type is also a complex scalar*/
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   /* both arguments are complex scalars*/
};


/* this code executes the calculation*/
LRESULT IvcFunction(   LPCOMPLEXSCALAR     c,  /*put return value here*/
				LPCCOMPLEXSCALAR    v,  /* 1st argument*/
				LPCCOMPLEXSCALAR    x   ) /* 2nd argument*/
{ 
	/*  Modified Bessel function of real order v and argument x */
	// check that the first argument is real
	if ( v->imag != 0.0 )
	    // if it is not, display "must be real" error message 
	    // under the scalar argument( the 1st argument )
		return MAKELRESULT( 1 , 1 );
	if ( ( x->imag == 0.0 ) && ( ( x->real >= 0.0 ) || ( floor( v->real ) == v->real ) )
	     && ( fabs(x->real) <= 28.0 ) && ( fabs(v->real) <= 30.0 ) )
	{
		c->real=iv(v->real,x->real);

		if (merror != -1)
		{
			int ierr;

			ierr = merror + 4;
			merror = -1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
	else
	{
		long int kode,n,nz,ierr;

		kode = 1; n = 1;
		if ( v->real >= 0.0 )
			zbesi_( &x->real , &x->imag , &v->real , &kode , &n , &c->real , 
				  &c->imag , &nz , &ierr );
		else
		{
			double v1, kvr, kvi;

			v1 = -v->real;
			if ( floor( v1 ) == v1 )
				zbesi_( &x->real , &x->imag , &v1 , &kode , &n , &c->real , 
					  &c->imag , &nz , &ierr );
			else
			{
				zbesi_( &x->real , &x->imag , &v1 , &kode , &n , &c->real , 
					  &c->imag , &nz , &ierr );
				if ( ierr == 0 )
				{
					zbesk_( &x->real , &x->imag , &v1 , &kode , &n , &kvr , 
						  &kvi , &nz , &ierr );
					v1 = 2 * sin( v1*PI ) / PI;
					c->real = c->real + v1 * kvr;
					c->imag = c->imag + v1 * kvi;
				}
			}
		}
		if ( ( x->imag == 0.0 ) && ( ( x->real >= 0.0 ) || 
					     ( floor( v->real ) == v->real ) ) )
			c->imag = 0.0;

		if ( maskploss == 0 && ierr == 3 ) ierr = 0;
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 2 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
	}
}

LRESULT IveFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x   );

FUNCTIONINFO    Ive = 
{ 
"Ie",			 /* Name by which mathcad will recognize the function*/
"v,z",			      /* Ie will be called as Ie(v,z)*/
"Exponentially scaled modified Bessel function of real order v and complex argument z. Argument z is considered in the cut plane -pi < arg(z) <= pi.", /* description of Ie(a,b)*/
(LPCFUNCTION)IveFunction,      /* pointer to the executible code*/
COMPLEX_SCALAR, 
2,		  /* the return type is also a complex scalar*/
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   /* both arguments are complex scalars*/
};


/* this code executes the calculation*/
LRESULT IveFunction(   LPCOMPLEXSCALAR     c,  /*put return value here*/
				LPCCOMPLEXSCALAR    v,  /* 1st argument*/
				LPCCOMPLEXSCALAR    x   ) /* 2nd argument*/
{
	/*  Modified Bessel function of real order v and argument x */
	// check that the first argument is real
	if ( v->imag != 0.0 )
	    // if it is not, display "must be real" error message 
	    // under the scalar argument( the 1st argument )
		return MAKELRESULT( 1 , 1 );
	if ( ( x->imag == 0.0 ) && ( ( x->real >= 0.0 ) || ( floor( v->real ) == v->real ) )
	     && ( fabs(x->real) <= 28.0 ) && ( fabs(v->real) <= 30.0 ) )
	{
		c->real = exp( -fabs( x->real ) ) * iv(v->real,x->real);

		if (merror != -1)
		{
			int ierr;

			ierr = merror + 4;
			merror = -1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
	else
	{
		long int kode,n,nz,ierr;

		kode = 2; n = 1;
		if ( v->real >= 0.0 )
			zbesi_( &x->real , &x->imag , &v->real , &kode , &n , &c->real , 
				  &c->imag , &nz , &ierr );
		else
		{
			double v1, kvr, kvi;

			v1 = -v->real;
			if ( floor( v1 ) == v1 )
				zbesi_( &x->real , &x->imag , &v1 , &kode , &n , &c->real , 
					  &c->imag , &nz , &ierr );
			else
			{
				zbesi_( &x->real , &x->imag , &v1 , &kode , &n , &c->real , 
					  &c->imag , &nz , &ierr );
				if ( ierr == 0 )
				{
					zbesk_( &x->real , &x->imag , &v1 , &kode , &n , &kvr , 
						  &kvi , &nz , &ierr );
					v1 = 2 * sin( v1*PI ) / PI;
					c->real = c->real + v1 * kvr;
					c->imag = c->imag + v1 * kvi;
				}
			}
		}
		if ( ( x->imag == 0.0 ) && ( ( x->real >= 0.0 ) || 
					     ( floor( v->real ) == v->real ) ) )
			c->imag = 0.0;

		if ( maskploss == 0 && ierr == 3 ) ierr = 0;
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 2 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
	}
}

LRESULT KvcFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x   );

FUNCTIONINFO    Kvc = 
{ 
"Kv",			 /* Name by which mathcad will recognize the function*/
"v,z",			      /* Kv will be called as Kv(v,z)*/
"Modified Bessel function of the third kind of real order v and complex argument z. Argument z must be nonzero and is considered in the cut plane -pi < arg(z) <= pi.", /* description of Kv(a,b)*/
(LPCFUNCTION)KvcFunction,      /* pointer to the executible code*/
COMPLEX_SCALAR, 
2,		  /* the return type is also a complex scalar*/
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   /* both arguments are complex scalars*/
};


/* this code executes the calculation*/
LRESULT KvcFunction(   LPCOMPLEXSCALAR     c,  /*put return value here*/
				LPCCOMPLEXSCALAR    v,  /* 1st argument*/
				LPCCOMPLEXSCALAR    x   ) /* 2nd argument*/
{
	/*  Modified Neumann function of real order v and argument x */
	// check that the first argument is real
	if ( v->imag != 0.0 )
	    // if it is not, display "must be real" error message 
	    // under the scalar argument( the 1st argument )
		return MAKELRESULT( 1 , 1 );
	if ( ( x->imag == 0.0 ) && ( x->real == 0.0 ) )
		return MAKELRESULT( 6 , 2 );
	if ( ( x->imag == 0.0 ) && ( x->real >= 0 ) && ( floor( v->real ) == v->real ) &&
	     ( fabs(v->real) <= 31.0 ) )
		{
		c->real=kn( (int)v->real ,x->real);
		if (merror != -1)
		{
			int ierr;

			ierr = merror + 4;
			merror = -1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
		}
	else
		{
		long int kode,n,nz,ierr;
		double v1;

		kode = 1; n = 1; v1 = fabs( v->real );
		zbesk_( &x->real , &x->imag , &v1 , &kode , &n , &c->real , 
			  &c->imag , &nz , &ierr );
		if ( ( x->imag == 0.0 ) && ( x->real >= 0.0 ) )
			c->imag = 0.0;

		if ( maskploss == 0 && ierr == 3 ) ierr = 0;
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 2 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
		}
}


LRESULT KveFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x   );

FUNCTIONINFO    Kve = 
{ 
"Ke",			 /* Name by which mathcad will recognize the function*/
"v,z",			      /* Ke will be called as Ke(v,z)*/
"Exponentially scaled modified Bessel function of the third kind of real order v and complex argument z. Argument z must be nonzero and is considered in the cut plane -pi < arg(z) <= pi.", /* description of Ke(a,b)*/
(LPCFUNCTION)KveFunction,      /* pointer to the executible code*/
COMPLEX_SCALAR, 
2,		  /* the return type is also a complex scalar*/
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   /* both arguments are complex scalars*/
};


/* this code executes the calculation*/
LRESULT KveFunction(   LPCOMPLEXSCALAR     c,  /*put return value here*/
				LPCCOMPLEXSCALAR    v,  /* 1st argument*/
				LPCCOMPLEXSCALAR    x   ) /* 2nd argument*/
{
	/*  Modified Neumann function of real order v and argument x */
	// check that the first argument is real
	if ( v->imag != 0.0 )
	    // if it is not, display "must be real" error message 
	    // under the scalar argument( the 1st argument )
		return MAKELRESULT( 1 , 1 );
	if ( ( x->imag == 0.0 ) && ( x->real == 0.0 ) )
		return MAKELRESULT( 6 , 2 );
	if ( ( x->imag == 0.0 ) && ( x->real >= 0 ) && ( floor( v->real ) == v->real ) &&
	     ( fabs(v->real) <= 31.0 ) )
		{
		c->real = exp( x->real ) * kn( (int)v->real ,x->real);
		if (merror != -1)
		{
			int ierr;

			ierr = merror + 4;
			merror = -1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
		}
	else
		{
		long int kode,n,nz,ierr;
		double v1;

		kode = 2; n = 1; v1 = fabs( v->real );
		zbesk_( &x->real , &x->imag , &v1 , &kode , &n , &c->real , 
			  &c->imag , &nz , &ierr );
		if ( ( x->imag == 0.0 ) && ( x->real >= 0.0 ) )
			c->imag = 0.0;

		if ( maskploss == 0 && ierr == 3 ) ierr = 0;
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 2 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
		}
}


LRESULT jsphFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    jsph = 
{ 
"jv",	       // Name by which mathcad will recognize the function.
"v,x",      // jsph will be called as jv(v,x).
"Spherical Bessel function of real order v and complex argument z. Argument z is considered in the cut plane -pi < arg(z) <= pi.",  // Description of jv(v,x).
(LPCFUNCTION)jsphFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT jsphFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	// check that the first argument is real
	// if it is not, display "must be real" error message 
	// under the scalar argument
	if ( v->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( ( x->imag == 0.0 ) && ( x->real == 0.0 ) )
		return MAKELRESULT( 6 , 2 );
	if ( ( x->real > 0.0 ) && ( x->imag == 0.0 ) ) 
	{
		double y;

		y=PIO2/x->real;
		c->real=sqrt(y)*jv(v->real+0.5,x->real);  // this code executes the calculation
		if (merror != -1) 
		{
			int ierr;
			ierr=merror+4;
			merror=-1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
	else
	{
		long int kode, n, nz, ierr, sign;
		double   v1, cosv, sinv, jr, ji, yr, yi;
		cmplx     y, z;

		kode = 1; n = 1; v1 = v->real + 0.5;
		if ( v1 >= 0.0 )
			zbesj_( &x->real , &x->imag , &v1 , &kode , &n , &c->real , 
				  &c->imag , &nz , &ierr );
		else
		{
			v1 = - v1;
			if ( floor( v1 ) == v1 )
			{
				nz = (int)v1;
				if ( ( nz & 1 ) == 1) sign = -1;
				else sign = 1;
				zbesj_( &x->real , &x->imag , &v1 , &kode , &n , &c->real , 
					  &c->imag , &nz , &ierr );
				c->real *= sign;
				c->imag *= sign;
			}
			else
			{
				zbesy_( &x->real , &x->imag , &v1 , &kode , &n , &yr , &yi ,
					  &nz , &jr , &ji , &ierr );
				if (ierr == 0)
				{
					zbesj_( &x->real , &x->imag , &v1 , &kode , &n , &jr , &ji ,
						  &nz , &ierr );
					v1 *= PI; cosv = cos( v1 ); sinv = sin( v1 );
					c->real = jr * cosv - yr * sinv;
					c->imag = ji * cosv - yi * sinv;
				}
			}
		}
/* The following if is because z is in the cut plane -PI < arg(z) <= PI */
		if ( x->imag < 0.0 ) sign = -1;
		else sign = 1;
		y.r = x->real / PIO2; y.i = x->imag / PIO2;
		csqrt( &y , &z );
		cdiv( &z , c , &y );
		c->real = sign * y.r;
		c->imag = sign * y.i;

		if ( maskploss == 0 && ierr == 3 ) ierr = 0;
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 2 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
	}
}
//xxxyyy

LRESULT ysphFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    ysph = 
{ 
"yv",	       // Name by which mathcad will recognize the function.
"v,x",      // ysph will be called as yv(v,x).
"Spherical Neumann function of real order v and complex argument z. Argument z must be nonzero and is considered in the cut plane -pi < arg(z) <= pi.",    /* description of yv(a,b)*/
(LPCFUNCTION)ysphFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT ysphFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	// check that the first argument is real
	// if it is not, display "must be real" error message 
	// under the scalar argument
	if ( v->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( ( x->imag == 0.0 ) && ( x->real == 0.0 ) )
		return MAKELRESULT( 6 , 2 );
	else
	{     
		long int kode, n, nz, ierr, sign;
		double   v1, cosv, sinv, jr, ji, yr, yi;
		cmplx     y, z;

		kode = 1; n = 1; v1 = v->real + 0.5;
		if ( v1 >= 0.0 )
			zbesy_( &x->real , &x->imag , &v1 , &kode , &n , &c->real , 
				  &c->imag , &nz , &jr , &ji , &ierr );
		else
		{
			v1 = - v1;
			if ( floor( v1 ) == v1 )
			{
				nz = (int)v1;
				if ( ( nz & 1 ) == 1) sign = -1;
				else sign = 1;
				zbesy_( &x->real , &x->imag , &v1 , &kode , &n , &c->real , 
					  &c->imag , &nz , &jr , &ji , &ierr );
				c->real *= sign;
				c->imag *= sign;
			}
			else
			{
				zbesy_( &x->real , &x->imag , &v1 , &kode , &n , &yr , &yi ,
					  &nz , &jr , &ji , &ierr );
				if (ierr == 0)
				{
					zbesj_( &x->real , &x->imag , &v1 , &kode , &n , &jr , &ji ,
						  &nz , &ierr );
					v1 *= PI; cosv = cos( v1 ); sinv = sin( v1 );
					c->real = jr * sinv + yr * cosv;
					c->imag = ji * sinv + yi * cosv;
				}
			}
		}
		if ( ( x->imag == 0.0 ) && ( x->real > 0.0 ) ) c->imag = 0.0;
/* The following if is because z is in the cut plane -PI < arg(z) <= PI */
		if ( x->imag < 0.0 ) sign = -1;
		else sign = 1;
		y.r = x->real / PIO2; y.i = x->imag / PIO2;
		csqrt( &y , &z );
		cdiv( &z , c , &y );
		c->real = sign * y.r;
		c->imag = sign * y.i;

		if ( maskploss == 0 && ierr == 3 ) ierr = 0;
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 2 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
	}
}
//xxxyyy

LRESULT h1sphFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    h1sph = 
{ 
"h1v",	       // Name by which mathcad will recognize the function.
"v,x",      // h1sph will be called as h1v(v,x).
"Spherical Hankel function of real order v and complex argument z (1st kind). Argument z must be nonzero and is considered in the cut plane -pi < arg(z) <= pi.",    /* description of h1v(a,b)*/
(LPCFUNCTION)h1sphFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT h1sphFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	// check that the first argument is real
	// if it is not, display "must be real" error message 
	// under the scalar argument
	if ( v->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( ( x->imag == 0.0 ) && ( x->real == 0.0 ) )
		return MAKELRESULT( 6 , 2 );
	else
	{     
		long int kode, n, nz, ierr, sign, m;
		double   v1, cosv, sinv, h1r, h1i;
		cmplx     y, z;

		kode = 1; n = 1; v1 = v->real + 0.5; m = 1;
		if ( v1 >= 0.0 )
			zbesh_( &x->real , &x->imag , &v1 , &kode , &m , &n , &c->real , 
				  &c->imag , &nz , &ierr );
		else
		{
			v1 = -v1;
			zbesh_( &x->real , &x->imag , &v1 , &kode , &m , &n , &h1r , &h1i ,
				  &nz , &ierr );
			v1 *= PI; cosv = cos( v1 ); sinv = sin( v1 );
			c->real = h1r * cosv - h1i * sinv;
			c->imag = h1i * cosv + h1r * sinv;
		}
/* The following if is because z is in the cut plane -PI < arg(z) <= PI */
		if ( x->imag < 0.0 ) sign = -1;
		else sign = 1;
		y.r = x->real / PIO2; y.i = x->imag / PIO2;
		csqrt( &y , &z );
		cdiv( &z , c , &y );
		c->real = sign * y.r;
		c->imag = sign * y.i;

		if ( maskploss == 0 && ierr == 3 ) ierr = 0;
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 2 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
	}
}
//xxxyyy

LRESULT h2sphFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    h2sph = 
{ 
"h2v",	       // Name by which mathcad will recognize the function.
"v,x",      // h2sph will be called as h2v(v,x).
"Spherical Hankel function of real order v and complex argument z (2nd kind). Argument z must be nonzero and is considered in the cut plane -pi < arg(z) <= pi.",    /* description of h2v(a,b)*/
(LPCFUNCTION)h2sphFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT h2sphFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x   ) // arguments    

{
	// check that the first argument is real
	// if it is not, display "must be real" error message 
	// under the scalar argument
	if ( v->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( ( x->imag == 0.0 ) && ( x->real == 0.0 ) )
		return MAKELRESULT( 6 , 2 );
	else
	{     
		long int kode, n, nz, ierr, sign, m;
		double   v1, cosv, sinv, h2r, h2i;
		cmplx     y, z;

		kode = 1; n = 1; v1 = v->real + 0.5; m = 2;
		if ( v1 >= 0.0 )
			zbesh_( &x->real , &x->imag , &v1 , &kode , &m , &n , &c->real , 
				  &c->imag , &nz , &ierr );
		else
		{
			v1 = -v1;
			zbesh_( &x->real , &x->imag , &v1 , &kode , &m , &n , &h2r , &h2i ,
				  &nz , &ierr );
			v1 *= PI; cosv = cos( v1 ); sinv = sin( v1 );
			c->real = h2r * cosv + h2i * sinv;
			c->imag = h2i * cosv - h2r * sinv;
		}
/* The following if is because z is in the cut plane -PI < arg(z) <= PI */
		if ( x->imag < 0.0 ) sign = -1;
		else sign = 1;
		y.r = x->real / PIO2; y.i = x->imag / PIO2;
		csqrt( &y , &z );
		cdiv( &z , c , &y );
		c->real = sign * y.r;
		c->imag = sign * y.i;

		if ( maskploss == 0 && ierr == 3 ) ierr = 0;
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 2 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
	}
}
//xxxyyy


LRESULT AiFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    Ai = 
{ 
"Ai",	       // Name by which mathcad will recognize the function.
"x",      // Ai will be called as Ai(x).
"First Airy function, solution of the differential equation y\"=xy. The argument can be complex",  // Description of Ai(x).
(LPCFUNCTION)AiFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,		  
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT AiFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x ) // arguments    
						    
{
	if ( x->imag == 0.0 )
	{
		double ai, aip, bi, bip;

		airy( x->real, &ai, &aip, &bi, &bip );   // this code executes the calculation
		c->real=ai;
		if (merror != -1) 
		{
			int ierr;

			ierr=merror+4;
			merror=-1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
	else
	{
		long int id,kode,nz,ierr;

		id = 0; kode = 1;
		zairy_( &x->real , &x->imag , &id , &kode , &c->real , &c->imag ,
			  &nz , &ierr );
		if ( maskploss == 0 && ierr == 3 ) ierr = 0;
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 1 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
	}
}

LRESULT AieFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    Aie = 
{ 
"Ae",	       // Name by which mathcad will recognize the function.
"x",      // Ai will be called as Ae(x).
"Exponentially scaled first Airy function of complex argument.",  // Description of Ae(x).
(LPCFUNCTION)AieFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,		  
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT AieFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x ) // arguments    
						    
{
	long int id,kode,nz,ierr;

	id = 0; kode = 2;
	zairy_( &x->real , &x->imag , &id , &kode , &c->real , &c->imag ,
			  &nz , &ierr );
	if ( maskploss == 0 && ierr == 3 ) ierr = 0;
	if (ierr == 0) return 0;
	else if (ierr == 1) return MAKELRESULT( 5 , 1 );
	else if (ierr == 2) return MAKELRESULT( 7 , 1 );
	else if (ierr == 3) return MAKELRESULT( 10 , 1 );
	else if (ierr == 4) return MAKELRESULT( 9 , 1 );
	else if (ierr == 5) return MAKELRESULT( 12 , 1 );
	else return MAKELRESULT( 4 , 1 );
}


LRESULT BiFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    Bi = 
{ 
"Bi",	       // Name by which mathcad will recognize the function.
"x",      // Bi will be called as Bi(x).
"Second Airy function, solution of the differential equation y\"=xy. The argument can be complex",  // Description of Bi(x).
(LPCFUNCTION)BiFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,		  
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT BiFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x ) // arguments    
						    
{
	if ( x->imag == 0.0 )
	{
		double ai, aip, bi, bip;

		airy( x->real, &ai, &aip, &bi, &bip );   // this code executes the calculation
		c->real=bi;
		if (merror != -1) 
		{
			int ierr;

			ierr=merror+4;
			merror=-1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
	else
	{
		long int id,kode,ierr;

		id = 0; kode = 1;
		zbiry_( &x->real , &x->imag , &id , &kode , &c->real , &c->imag , &ierr );
		if ( maskploss == 0 && ierr == 3 ) ierr = 0;
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 1 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
	}
}

LRESULT BieFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    Bie = 
{ 
"Be",	       // Name by which mathcad will recognize the function.
"x",      // Bie will be called as Be(x).
"Exponentially scaled second Airy function of complex argument.",  // Description of Be(x).
(LPCFUNCTION)BieFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,		  
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT BieFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x ) // arguments    
						    
{
	long int id,kode,ierr;

	id = 0; kode = 2;
	zbiry_( &x->real , &x->imag , &id , &kode , &c->real , &c->imag , &ierr );
	if ( maskploss == 0 && ierr == 3 ) ierr = 0;
	if (ierr == 0) return 0;
	else if (ierr == 1) return MAKELRESULT( 5 , 1 );
	else if (ierr == 2) return MAKELRESULT( 7 , 1 );
	else if (ierr == 3) return MAKELRESULT( 10 , 1 );
	else if (ierr == 4) return MAKELRESULT( 9 , 1 );
	else if (ierr == 5) return MAKELRESULT( 12 , 1 );
	else return MAKELRESULT( 4 , 1 );
}


LRESULT AipFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    Aip = 
{ 
"Aip",	       // Name by which mathcad will recognize the function.
"x",      // Aip will be called as Aip(x).
"Derivative of the first Airy function, solution of the differential equation y\"=xy. The argument can be complex",  // Description of Aip(x).
(LPCFUNCTION)AipFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,		  
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT AipFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x ) // arguments    
						    
{
	if ( x->imag == 0.0 )
	{
		double ai, aip, bi, bip;

		airy( x->real, &ai, &aip, &bi, &bip );   // this code executes the calculation
		c->real=aip;
		if (merror != -1) 
		{
			int ierr;

			ierr=merror+4;
			merror=-1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
	else
	{
		long int id,kode,nz,ierr;

		id = 1; kode = 1;
		zairy_( &x->real , &x->imag , &id , &kode , &c->real , &c->imag ,
			  &nz , &ierr );
		if ( maskploss == 0 && ierr == 3 ) ierr = 0;
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 1 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
	}
}

LRESULT AipeFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    Aipe = 
{ 
"Aep",	       // Name by which mathcad will recognize the function.
"x",      // Aep will be called as Aep(x).
"Exponentially scaled derivative of first Airy function of complex argument.",  // Description of Aep(x).
(LPCFUNCTION)AipeFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,		  
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT AipeFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x ) // arguments    
						    
{
	long int id,kode,nz,ierr;

	id = 1; kode = 2;
	zairy_( &x->real , &x->imag , &id , &kode , &c->real , &c->imag ,
			  &nz , &ierr );
	if ( maskploss == 0 && ierr == 3 ) ierr = 0;
	if (ierr == 0) return 0;
	else if (ierr == 1) return MAKELRESULT( 5 , 1 );
	else if (ierr == 2) return MAKELRESULT( 7 , 1 );
	else if (ierr == 3) return MAKELRESULT( 10 , 1 );
	else if (ierr == 4) return MAKELRESULT( 9 , 1 );
	else if (ierr == 5) return MAKELRESULT( 12 , 1 );
	else return MAKELRESULT( 4 , 1 );
}


LRESULT BipFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    Bip = 
{ 
"Bip",	       // Name by which mathcad will recognize the function.
"x",      // Bip will be called as Bip(x).
"Derivative of the second Airy function, solution of the differential equation y\"=xy. The argument can be complex",  // Description of Bip(x).
(LPCFUNCTION)BipFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,		  
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT BipFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x ) // arguments    
						    
{
	if ( x->imag == 0.0 )
	{
		double ai, aip, bi, bip;

		airy( x->real, &ai, &aip, &bi, &bip );   // this code executes the calculation
		c->real=bip;
		if (merror != -1) 
		{
			int ierr;

			ierr=merror+4;
			merror=-1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
	else
	{
		long int id,kode,ierr;

		id = 1; kode = 1;
		zbiry_( &x->real , &x->imag , &id , &kode , &c->real , &c->imag , &ierr );
		if ( maskploss == 0 && ierr == 3 ) ierr = 0;
		if (ierr == 0) return 0;
		else if (ierr == 1) return MAKELRESULT( 5 , 1 );
		else if (ierr == 2) return MAKELRESULT( 7 , 1 );
		else if (ierr == 3) return MAKELRESULT( 10 , 1 );
		else if (ierr == 4) return MAKELRESULT( 9 , 1 );
		else if (ierr == 5) return MAKELRESULT( 12 , 1 );
		else return MAKELRESULT( 4 , 1 );
	}
}

LRESULT BipeFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    Bipe = 
{ 
"Bep",	       // Name by which mathcad will recognize the function.
"x",      // Bipe will be called as Bep(x).
"Exponentially scaled first derivative of second Airy function of complex argument.",  // Description of Bipe(x).
(LPCFUNCTION)BipeFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,		  
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT BipeFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x ) // arguments    
						    
{
	long int id,kode,ierr;

	id = 1; kode = 2;
	zbiry_( &x->real , &x->imag , &id , &kode , &c->real , &c->imag , &ierr );
	if ( maskploss == 0 && ierr == 3 ) ierr = 0;
	if (ierr == 0) return 0;
	else if (ierr == 1) return MAKELRESULT( 5 , 1 );
	else if (ierr == 2) return MAKELRESULT( 7 , 1 );
	else if (ierr == 3) return MAKELRESULT( 10 , 1 );
	else if (ierr == 4) return MAKELRESULT( 9 , 1 );
	else if (ierr == 5) return MAKELRESULT( 12 , 1 );
	else return MAKELRESULT( 4 , 1 );
}


LRESULT struvecFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    struvec = 
{ 
"Struve",	       // Name by which mathcad will recognize the function.
"v,x",      // struvec will be called as Struve(v,x).
"Computes the Struve function of real order v and real argument x. Negative x is rejected unless v is an integer.",  // Description of Struve(v,x).
(LPCFUNCTION)struvecFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT struvecFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    v,
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( v->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	c->real=struve(v->real,x->real);   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}


LRESULT lgFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x   );

FUNCTIONINFO    lg = 
{ 
"lgam",			 /* Name by which mathcad will recognize the function*/
"z",			      /* lgam will be called as lgam(x)*/
"Natural logarithm of gamma function. Argument z is considered in the cut plane -pi < arg(z) <= pi.", /* description of lgam(x)*/
(LPCFUNCTION)lgFunction,      /* pointer to the executible code*/
COMPLEX_SCALAR, 
1,		  /* the return type is also a complex scalar*/
{ COMPLEX_SCALAR }   /* both arguments are complex scalars*/
};


/* this code executes the calculation*/
LRESULT lgFunction(   LPCOMPLEXSCALAR     c,  /*put return value here*/
				LPCCOMPLEXSCALAR    x   ) /* argument*/
{
	
	/*  Returns the base e (2.718...) logarithm of 
	    gamma function of the argument */
	if ( x->imag == 0.0 )
	{
	c->real=lgam(x->real);
	if ( x->real < 0 ) c->imag = -ceil( -x->real ) * PI;
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
	}
	else
	{
	  clgam( x, c);
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
	}
}


LRESULT rgamFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x  );

FUNCTIONINFO    rgam = 
{ 
"rgam",	       // Name by which mathcad will recognize the function.
"x",      // rgam will be called as rgam(x).
"Returns one divided by the gamma function of the argument.",  // Description of rgam(x).
(LPCFUNCTION)rgamFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT rgamFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	c->real=rgamma(x->real);   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy



LRESULT binomialFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    k );

FUNCTIONINFO    binomial = 
{ 
"binomial",	       // Name by which mathcad will recognize the function.
"a,k",      // binomial will be called as binomial(a,k).
"Binomial coefficient, a is real k must be a non negative integer.",  // Description of binomial(a,k).
(LPCFUNCTION)binomialFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT binomialFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    k   ) // arguments    
						    
{ int j;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( a->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( k->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( floor(k->real) != k->real )
		return MAKELRESULT( 11 , 2 );
	j=(int)floor(k->real);
	c->real=bino(a->real,j);   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}

LRESULT Beta1Function(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x,
				LPCCOMPLEXSCALAR    y );

FUNCTIONINFO    Beta1 = 
{ 
"beta",	       // Name by which mathcad will recognize the function.
"x,y",		// Beta1 will be called as beta(x,y).
"Beta function or Euler's integral of the first kind.  The arguments can be complex",  // Description of beta(x,y).
(LPCFUNCTION)Beta1Function,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT Beta1Function(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x,
				LPCCOMPLEXSCALAR    y   ) // arguments    
						    
{
	if ( ( x->imag == 0.0 ) && ( y->imag == 0.0 ) )
	{
		c->real=beta(x->real,y->real);   // this code executes the calculation
		if (merror != -1) 
		{
			int ierr;
			ierr=merror+4;
			merror=-1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
	else
	{
		cbeta( x, y, c);
		if (merror != -1) 
		{
			int ierr;
			ierr=merror+4;
			merror=-1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
}

LRESULT lbeta1Function(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x,
				LPCCOMPLEXSCALAR    y );

FUNCTIONINFO    lbeta1 = 
{ 
"lbeta",	       // Name by which mathcad will recognize the function.
"x,y",		// lbeta1 will be called as lbeta(x,y).
"Natural logarithm of beta function. Arguments are considered in the cut plane -pi < arg(z) <= pi.",  // Description of lbeta(x,y).
(LPCFUNCTION)lbeta1Function,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT lbeta1Function(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x,
				LPCCOMPLEXSCALAR    y   ) // arguments    
						    
{
	if ( ( x->imag == 0.0 ) && ( y->imag == 0.0 ) )
	{
		double n, sum;

		c->real=lbeta(x->real,y->real);   // this code executes the calculation
		n = 0.0;
		if ( x->real < 0 ) n += ceil( -x->real );
		if ( y->real < 0 ) n += ceil( -y->real );
		sum = x->real + y->real;
		if ( sum < 0 ) n -= ceil( -sum );
		c->imag = -n * PI;
		if (merror != -1) 
		{
			int ierr;
			ierr=merror+4;
			merror=-1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
	else
	{
		clbeta( x, y, c);
		if (merror != -1) 
		{
			int ierr;
			ierr=merror+4;
			merror=-1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
}

LRESULT psicFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    psic = 
{ 
"Psi",	       //Name by which mathcad will recognize the function.
"z",		 //psic will be called as Psi(x).
"Logarithmic derivative of the gamma function. The argument can be complex",  //Description of Psi(x).
(LPCFUNCTION)psicFunction,   //Pointer to the executible code.
COMPLEX_SCALAR,      //the return type is a complex scalar
1,		  
{ COMPLEX_SCALAR }   //arguments are complex scalars
};


LRESULT psicFunction(   LPCOMPLEXSCALAR     c,  //put return value here
				LPCCOMPLEXSCALAR    x )     //arguments
{
	// check that the argument is real
	if ( x->imag == 0.0 )
		c->real=psi(x->real);
	else
		cpsi( x, c );
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}

LRESULT igammaFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    igamma = 
{ 
"igam",	       // Name by which mathcad will recognize the function.
"a,x",      // igamma will be called as igam(a,x).
"Incomplete gamma integral; both arguments must be real and positive.",  // Description of igam(a,x).
(LPCFUNCTION)igammaFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT igammaFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( a->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	c->real = igam( a->real , x->real );   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy

LRESULT igammacFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    igammac = 
{ 
"igamc",	       // Name by which mathcad will recognize the function.
"a,x",      // igammac will be called as igamc(a,x).
"Complemented incomplete gamma integral; both arguments must be real and positive.",  // Description of igamc(a,x).
(LPCFUNCTION)igammacFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT igammacFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( a->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	c->real = igamc( a->real , x->real );   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy


LRESULT igammaiFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    igammai = 
{ 
"igami",	       // Name by which mathcad will recognize the function.
"a,x",      // igammai will be called as igami(a,x).
"Inverse of complemented imcomplete gamma integral of real arguments.",  // Description of igami(a,x).
(LPCFUNCTION)igammaiFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT igammaiFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( a->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	c->real = igami( a->real , x->real );   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy


LRESULT ibetaFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    b,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    ibeta = 
{ 
"ibeta",	       // Name by which mathcad will recognize the function.
"a,b,x",      // ibeta will be called as ibeta(a,b,x).
"Incomplete beta integral; the domain of definition is 0<=x<=1, a>0 and b>0.",  // Description of ibeta(a,b,x).
(LPCFUNCTION)ibetaFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
3,
{ COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT ibetaFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    b,
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( a->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( b->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 3 );
	c->real = incbet( a->real , b->real , x->real );   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy


LRESULT ibetaiFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    b,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    ibetai = 
{ 
"ibetai",	       // Name by which mathcad will recognize the function.
"a,b,x",      // ibetai will be called as ibetai(a,b,x).
"Inverse of incomplete beta integral; the domain of definition is a>0 and b>0.",  // Description of ibetai(a,b,x).
(LPCFUNCTION)ibetaiFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
3,
{ COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT ibetaiFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    b,
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( a->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( b->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 3 );
	c->real = incbi( a->real , b->real , x->real );   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy





LRESULT hyp1c1Function(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    b,
				LPCCOMPLEXSCALAR    x   );

FUNCTIONINFO    hyp1c1 = 
{ 
"hyp1f1",	       // Name by which mathcad will recognize the function.
"a,b,x",      // hyp1c1 will be called as hyp1f1(a,b,x).
"Confluent hypergeometric function 1F1 with real arguments.",  // Description of hyperg(a,b,x).
(LPCFUNCTION)hyp1c1Function,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
3,
{ COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT hyp1c1Function(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    b,
				LPCCOMPLEXSCALAR    x
				  ) // arguments    
						    
{
	if ( a->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( b->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 3 );
	c->real = hyperg( a->real, b->real, x->real );   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}


LRESULT hyp2c0Function(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    b,
				LPCCOMPLEXSCALAR    x   );

FUNCTIONINFO    hyp2c0 = 
{ 
"hyp2f0",	       // Name by which mathcad will recognize the function.
"a,b,x",      // hyp1c1 will be called as hyp2f0(a,b,x).
"Hypergeometric function 2F0 with real arguments.",  // Description of hyp2f0(a,b,x).
(LPCFUNCTION)hyp2c0Function,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
3,
{ COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT hyp2c0Function(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    b,
				LPCCOMPLEXSCALAR    x
				  ) // arguments    
						    
{ double err;int type=1;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( a->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( b->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 3 );
	c->real = hyp2f0( a->real, b->real, x->real , type, &err );   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}

LRESULT hyp2c1Function(   LPCOMPLEXSCALAR     d,
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    b,
				LPCCOMPLEXSCALAR    c,
				LPCCOMPLEXSCALAR    x   );

FUNCTIONINFO    hyp2c1 = 
{ 
"hyp2f1",	       // Name by which mathcad will recognize the function.
"a,b,c,x",      // hyp2c1 will be called as hyp2f1(a,b,c,x).
"Gauss hypergeometric function 2F1 with real arguments.",  // Description of hyp2f1(a,b,x).
(LPCFUNCTION)hyp2c1Function,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
4,   // arguments are complex scalars
{ COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR}
};


LRESULT hyp2c1Function(   LPCOMPLEXSCALAR     d,  // put return value here
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    b,
				LPCCOMPLEXSCALAR    c,
				LPCCOMPLEXSCALAR    x
				  ) // arguments    
						    
{
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( a->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( b->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( c->imag != 0.0 )
		return MAKELRESULT( 1 , 3 );
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 4 );
	if ( fabs(x->real) > 1.0 )
		return MAKELRESULT( 5 , 4 );
	// this code executes the calculation
	d->real = hyp2f1( a->real, b->real, c->real, x->real );
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}


LRESULT hyp1c2Function(   LPCOMPLEXSCALAR     d,
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    b,
				LPCCOMPLEXSCALAR    c,
				LPCCOMPLEXSCALAR    x   );

FUNCTIONINFO    hyp1c2 = 
{ 
"hyp1f2",	       // Name by which mathcad will recognize the function.
"a,b,c,x",      // hyp1c2 will be called as hyp1f2(a,b,c,x).
"Hypergeometric function 1F2 with real arguments.",  // Description of hyp1f2(a,b,x).
(LPCFUNCTION)hyp1c2Function,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
4,   // arguments are complex scalars
{ COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR}
};


LRESULT hyp1c2Function(   LPCOMPLEXSCALAR     d,  // put return value here
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    b,
				LPCCOMPLEXSCALAR    c,
				LPCCOMPLEXSCALAR    x
				  ) // arguments    
						    
{ double err;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( a->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( b->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( c->imag != 0.0 )
		return MAKELRESULT( 1 , 3 );
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 4 );
	// this code executes the calculation
	d->real = onef2( a->real, b->real, c->real, x->real , &err);
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}


LRESULT hyp3c0Function(   LPCOMPLEXSCALAR     d,
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    b,
				LPCCOMPLEXSCALAR    c,
				LPCCOMPLEXSCALAR    x   );

FUNCTIONINFO    hyp3c0 = 
{ 
"hyp3f0",	       // Name by which mathcad will recognize the function.
"a,b,c,x",      // hyp3c0 will be called as hyp3f0(a,b,c,x).
"Hypergeometric function 3F0 with real arguments.",  // Description of hyp3f0(a,b,c,x).
(LPCFUNCTION)hyp3c0Function,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
4,   // arguments are complex scalars
{ COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR}
};


LRESULT hyp3c0Function(   LPCOMPLEXSCALAR     d,  // put return value here
				LPCCOMPLEXSCALAR    a,
				LPCCOMPLEXSCALAR    b,
				LPCCOMPLEXSCALAR    c,
				LPCCOMPLEXSCALAR    x
				  ) // arguments    
						    
{ double err;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( a->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( b->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( c->imag != 0.0 )
		return MAKELRESULT( 1 , 3 );
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 4 );
	// this code executes the calculation
	d->real = threef0( a->real, b->real, c->real, x->real , &err);
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}



LRESULT LegEFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x,
				LPCCOMPLEXSCALAR    k );

FUNCTIONINFO    LegE = 
{ 
"LegendreE",	       // Name by which mathcad will recognize the function.
"x,k",      // LegE will be called as LegendreE(x,k).
"Legendre's canonical incomplete elliptic integral of the second kind with real arguments.",  // Description of LegendreE(x,k).
(LPCFUNCTION)LegEFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR,  COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT LegEFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x,
				LPCCOMPLEXSCALAR    k   ) // arguments    
						    
{ double y,z;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( fabs(x->real) > 1.0 )
		return MAKELRESULT( 5 , 1 );
	if ( k->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	y = asin(x->real);
	z = k->real * k->real;
	c->real=ellie(y,z);  // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy

LRESULT LegFFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x,
				LPCCOMPLEXSCALAR    k );

FUNCTIONINFO    LegF = 
{ 
"LegendreF",	       // Name by which mathcad will recognize the function.
"x,k",      // LegF will be called as LegendreF(x,k).
"Legendre's canonical incomplete elliptic integral of the first kind with real arguments.",  // Description of LegendreF(x,k).
(LPCFUNCTION)LegFFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR,  COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT LegFFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x,
				LPCCOMPLEXSCALAR    k   ) // arguments    
						    
{ double y,z;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( fabs(x->real) > 1.0 )
		return MAKELRESULT( 5 , 1 );
	if ( k->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	y = asin(x->real);
	z = k->real * k->real;
	c->real = ellik(y,z);   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy

LRESULT LegPFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x,
				LPCCOMPLEXSCALAR    n,
				LPCCOMPLEXSCALAR    k );

FUNCTIONINFO    LegP = 
{ 
"LegendreP",	       // Name by which mathcad will recognize the function.
"x,n,k",      // LegP will be called as LegendreP(x,n,k).
"Legendre's canonical incomplete elliptic integral of the third kind with real arguments.",  // Description of LegendreP(x,n,k).
(LPCFUNCTION)LegPFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
3,
{ COMPLEX_SCALAR,  COMPLEX_SCALAR,  COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT LegPFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x,
				LPCCOMPLEXSCALAR    n,
				LPCCOMPLEXSCALAR    k   ) // arguments    
						    
{
	double    kx, xq, one, onexq, onekxq, onenxq, tol;
	long int  ierr;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( fabs(x->real) > 1.0 )
		return MAKELRESULT( 5 , 1 );
	if ( n->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( k->imag != 0.0 )
		return MAKELRESULT( 1 , 3 );
	// this code executes the calculation
	kx = k->real * x->real;
	xq = x->real * x->real;
	tol = 0.001;
	one = 1.0;
	onexq = ( 1.0 - x->real ) * ( 1.0 + x->real ) ;
	onekxq = ( 1.0 - kx ) * ( 1.0 + kx );
	onenxq = 1.0 - n->real * xq;
	c->real = rf_( &onexq, &onekxq, &one, &tol, &ierr );
	if ( ierr != 0 ) return MAKELRESULT( 5 , 1 );
	c->real += (n->real * xq * rj_( &onexq, &onekxq, &one, &onenxq, &tol, &ierr ) / 3.0);
	if ( ierr != 0 ) return MAKELRESULT( 5 , 1 );
	c->real *= x->real;
	return 0;
}
//xxxyyy

LRESULT LegEcFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    k );

FUNCTIONINFO    LegEc = 
{ 
"LegendreEc",	       // Name by which mathcad will recognize the function.
"k",      // LegEc will be called as LegendreEc(k).
"Legendre's complete elliptic integral of the second kind with real argument.",  // Description of LegendreEc(k).
(LPCFUNCTION)LegEcFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT LegEcFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    k   ) // arguments    
						    
{ double y;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( k->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( fabs(k->real) > 1.0 )
		return MAKELRESULT( 5 , 1 );
	y = k->real;
	y = ( 1.0 - y ) * ( 1.0 + y );
	c->real=ellpe(y);  // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy

LRESULT LegEc1Function(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    k );

FUNCTIONINFO    LegEc1 = 
{ 
"LegendreEc1",	       // Name by which mathcad will recognize the function.
"k",      // LegEc1 will be called as LegendreEc1(k).
"Associated Legendre's complete elliptic integral of the second kind with real argument.",  // Description of LegendreEc1(k).
(LPCFUNCTION)LegEc1Function,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT LegEc1Function(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    k   ) // arguments    
						    
{ double y;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( k->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( fabs(k->real) > 1.0 )
		return MAKELRESULT( 5 , 1 );
	y=k->real;
	y*=y;
	c->real=ellpe(y);  // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy


LRESULT LegKcFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    k );

FUNCTIONINFO    LegKc = 
{ 
"LegendreKc",	       // Name by which mathcad will recognize the function.
"k",      // LegKc will be called as LegendreKc(k).
"Legendre's complete elliptic integral of the first kind with real argument.",  // Description of LegendreKc(k).
(LPCFUNCTION)LegKcFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT LegKcFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    k   ) // arguments    
						    
{ double y;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( k->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( fabs(k->real) > 1.0 )
		return MAKELRESULT( 5 , 1 );
	y = k->real;
	y = ( 1.0-y ) * ( 1.0+y );
	c->real=ellpk(y);  // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy

LRESULT LegKc1Function(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    k );

FUNCTIONINFO    LegKc1 = 
{ 
"LegendreKc1",	       // Name by which mathcad will recognize the function.
"k",      // LegKc1 will be called as LegendreKc1(k).
"Associated Legendre's complete elliptic integral of the first kind with real argument.",  // Description of LegendreKc1(k).
(LPCFUNCTION)LegKc1Function,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT LegKc1Function(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    k   ) // arguments    
						    
{ double y;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( k->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( fabs(k->real) > 1.0 )
		return MAKELRESULT( 5 , 1 );
	y=k->real;
	y*=y;
	c->real=ellpk(y);  // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy

LRESULT LegPcFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    n,
				LPCCOMPLEXSCALAR    k );

FUNCTIONINFO    LegPc = 
{ 
"LegendrePc",	       // Name by which mathcad will recognize the function.
"n,k",      // LegPc will be called as LegendrePc(n,k).
"Legendre's complete elliptic integral of the third kind with real arguments.",  // Description of LegendrePc(n,k).
(LPCFUNCTION)LegPcFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR,  COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT LegPcFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    n,
				LPCCOMPLEXSCALAR    k   ) // arguments    
						    
{
	double    zero, one, onekq, onen, tol;
	long int  ierr;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( n->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( n->real >= 1.0 )
		return MAKELRESULT( 5 , 1 );
	if ( k->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( fabs(k->real) >= 1.0 )
		return MAKELRESULT( 5 , 2 );
	// this code executes the calculation
	tol = 0.001;
	zero = 0.0;
	one = 1.0;
	onekq = ( 1.0 - k->real ) * ( 1.0 + k->real );
	onen = 1.0 - n->real;
	c->real = rf_( &zero, &onekq, &one, &tol, &ierr );
	if ( ierr != 0 ) return MAKELRESULT( 5 , 1 );
	c->real += (n->real * rj_( &zero, &onekq, &one, &onen, &tol, &ierr ) / 3.0);
	if ( ierr != 0 ) return MAKELRESULT( 5 , 1 );
	return 0;
}
//xxxyyy

LRESULT LegPc1Function(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    n,
				LPCCOMPLEXSCALAR    k );

FUNCTIONINFO    LegPc1 = 
{ 
"LegendrePc1",	       // Name by which mathcad will recognize the function.
"n,k",      // LegPc1 will be called as LegendrePc1(n,k).
"Associated Legendre's complete elliptic integral of the third kind with real arguments.",  // Description of LegendrePc1(n,k).
(LPCFUNCTION)LegPc1Function,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR,  COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT LegPc1Function(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    n,
				LPCCOMPLEXSCALAR    k   ) // arguments    
						    
{
	double    zero, one, kq, onen, tol;
	long int  ierr;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( n->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( n->real >= 1.0 )
		return MAKELRESULT( 5 , 1 );
	if ( k->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( (fabs(k->real) > 1.0) || (fabs(k->real) == 0.0) )
		return MAKELRESULT( 5 , 2 );
	// this code executes the calculation
	tol = 0.001;
	zero = 0.0;
	one = 1.0;
	kq = k->real * k->real;
	onen = 1.0 - n->real;
	c->real = rf_( &zero, &kq, &one, &tol, &ierr );
	if ( ierr != 0 ) return MAKELRESULT( 5 , 1 );
	c->real += (n->real * rj_( &zero, &kq, &one, &onen, &tol, &ierr ) / 3.0);
	if ( ierr != 0 ) return MAKELRESULT( 5 , 1 );
	return 0;
}
//xxxyyy

LRESULT RfFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x,
				LPCCOMPLEXSCALAR    y,
				LPCCOMPLEXSCALAR    z );

FUNCTIONINFO    Rf = 
{ 
"Rf",	       // Name by which mathcad will recognize the function.
"x,y,z",      // Rf will be called as Rf(x,y,z).
"Carlson's incomplete elliptic integral of the first kind with real arguments.",  // Description of Rf(x,y,z).
(LPCFUNCTION)RfFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
3,
{ COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT RfFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x,
				LPCCOMPLEXSCALAR    y,
				LPCCOMPLEXSCALAR    z ) // arguments    
						    
{
	  static double tol = 0.001;
	  long int ierr;

	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( y->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( z->imag != 0.0 )
		return MAKELRESULT( 1 , 3 );
	if ( x->real < 0.0 )
		return MAKELRESULT( 5 , 1 );
	if ( y->real < 0.0 )
		return MAKELRESULT( 5 , 2 );
	if ( z->real < 0.0 )
		return MAKELRESULT( 5 , 3 );
	// this code executes the calculation
	c->real = rf_( &x->real, &y->real, &z->real, &tol, &ierr );
	if ( ierr != 0 ) return MAKELRESULT( 5 , 1 );
	else  return 0;
}
//xxxyyy

LRESULT RdFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x,
				LPCCOMPLEXSCALAR    y,
				LPCCOMPLEXSCALAR    z );

FUNCTIONINFO    Rd = 
{ 
"Rd",	       // Name by which mathcad will recognize the function.
"x,y,z",      // Rd will be called as Rd(x,y,z).
"Carlson's incomplete elliptic integral of the second kind with real argument.",  // Description of Rd(x,y,z).
(LPCFUNCTION)RdFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
3,
{ COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT RdFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x,
				LPCCOMPLEXSCALAR    y,
				LPCCOMPLEXSCALAR    z ) // arguments    
						    
{
	  static double tol = 0.001;
	  long int ierr;

	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( y->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( z->imag != 0.0 )
		return MAKELRESULT( 1 , 3 );
	if ( x->real < 0.0 )
		return MAKELRESULT( 5 , 1 );
	if ( y->real < 0.0 )
		return MAKELRESULT( 5 , 2 );
	if ( z->real <= 0.0 )
		return MAKELRESULT( 5 , 3 );
	// this code executes the calculation
	c->real = rd_( &x->real, &y->real, &z->real, &tol, &ierr );
	if ( ierr != 0 ) return MAKELRESULT( 5 , 1 );
	else  return 0;
}
//xxxyyy

LRESULT RjFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x,
				LPCCOMPLEXSCALAR    y,
				LPCCOMPLEXSCALAR    z,
				LPCCOMPLEXSCALAR    p );

FUNCTIONINFO    Rj = 
{ 
"Rj",	       // Name by which mathcad will recognize the function.
"x,y,z,p",      // Rj will be called as Rj(x,y,z,p).
"Carlson's incomplete elliptic integral of the third kind with real argument.",  // Description of Rj(x,y,z,p).
(LPCFUNCTION)RjFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
4,
{ COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT RjFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x,
				LPCCOMPLEXSCALAR    y,
				LPCCOMPLEXSCALAR    z,
				LPCCOMPLEXSCALAR    p ) // arguments    
						    
{
	  static double tol = 0.001;
	  long int ierr;

	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( y->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( z->imag != 0.0 )
		return MAKELRESULT( 1 , 3 );
	if ( p->imag != 0.0 )
		return MAKELRESULT( 1 , 4 );
	if ( x->real < 0.0 )
		return MAKELRESULT( 5 , 1 );
	if ( y->real < 0.0 )
		return MAKELRESULT( 5 , 2 );
	if ( z->real < 0.0 )
		return MAKELRESULT( 5 , 3 );
	if ( p->real <= 0.0 )
		return MAKELRESULT( 5 , 4 );
	// this code executes the calculation
	c->real = rj_( &x->real, &y->real, &z->real, &p->real, &tol, &ierr );
	if ( ierr != 0 ) return MAKELRESULT( 5 , 1 );
	else  return 0;
}
//xxxyyy


LRESULT snFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    u,
				LPCCOMPLEXSCALAR    k );

FUNCTIONINFO    sn = 
{ 
"sn",	       // Name by which mathcad will recognize the function.
"u,k",      // sn will be called as sn(u,k).
"Jacobian elliptic functions sn(u,k) of real arguments.",  // Description of sn(u,k).
(LPCFUNCTION)snFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT snFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    u,
				LPCCOMPLEXSCALAR    k   ) // arguments    
						    
{
	double sn,cn,dn,phi,m;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( u->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( k->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	  m = k->real * k->real;
	if ( m > 1.0 ) return MAKELRESULT( 5 , 1 );
	ellpj(u->real ,m ,&sn ,&cn ,&dn ,&phi );   // this code executes the calculation
	c->real=sn;
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy

LRESULT cnFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    u,
				LPCCOMPLEXSCALAR    k );

FUNCTIONINFO    cn = 
{ 
"cn",	       // Name by which mathcad will recognize the function.
"u,k",      // cn will be called as cn(u,k).
"Jacobian elliptic functions cn(u,k) of real arguments.",  // Description of cn(u,k).
(LPCFUNCTION)cnFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT cnFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    u,
				LPCCOMPLEXSCALAR    k   ) // arguments    
						    
{ 
	double sn,cn,dn,phi,m;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( u->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( k->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	m = k->real * k->real;
	if ( m > 1.0 ) return MAKELRESULT( 5 , 1 );
	ellpj(u->real ,m ,&sn ,&cn ,&dn ,&phi );   // this code executes the calculation
	c->real=cn;
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy


LRESULT dnFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    u,
				LPCCOMPLEXSCALAR    k );

FUNCTIONINFO    dn = 
{ 
"dn",	       // Name by which mathcad will recognize the function.
"u,k",      // dn will be called as dn(u,k).
"Jacobian elliptic functions dn(u,k) of real arguments.",  // Description of dn(u,k).
(LPCFUNCTION)dnFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT dnFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    u,
				LPCCOMPLEXSCALAR    k   ) // arguments    
						    
{
	double sn,cn,dn,phi,m;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( u->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( k->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	m = k->real * k->real;
	if ( m > 1.0 ) return MAKELRESULT( 5 , 1 );
	ellpj(u->real ,m ,&sn ,&cn ,&dn ,&phi );   // this code executes the calculation
	c->real=dn;
	if (merror != -1)
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy

LRESULT phiFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    u,
				LPCCOMPLEXSCALAR    k );

FUNCTIONINFO    phi = 
{ 
"phi",	       // Name by which mathcad will recognize the function.
"u,k",      // phi will be called as phi(u,k).
"Amplitude of jacobian elliptic functions phi(u,k) of real arguments.",  // Description of phi(u,k).
(LPCFUNCTION)phiFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR, COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT phiFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    u,
				LPCCOMPLEXSCALAR    k   ) // arguments    
						    
{ 
	double sn,cn,dn,phi,m;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( u->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( k->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	m = k->real * k->real;
	if ( m > 1.0 ) return MAKELRESULT( 5 , 1 );
	ellpj(u->real ,m ,&sn ,&cn ,&dn ,&phi );   // this code executes the calculation
	c->real=phi;
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy


LRESULT DawsonFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    Dawson = 
{ 
"Dawson",	       // Name by which mathcad will recognize the function.
"x",      // Dawson will be called as Dawson(x).
"Dawson's Integral of real argument.",  // Description of Dawson(x).
(LPCFUNCTION)DawsonFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT DawsonFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	c->real=dawsn(x->real);   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy


LRESULT FresnelCFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    FresnelC = 
{ 
"FresnelC",	       // Name by which mathcad will recognize the function.
"x",      // FresnelC will be called as FresnelC(x).
"Fresnel integral C(x) of real argument.",  // Description of FresnelC(x).
(LPCFUNCTION)FresnelCFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT FresnelCFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x) // arguments    
						    
{ double fs,fc;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	fresnl( x->real, &fs, &fc);
	c->real=fc;   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy


LRESULT FresnelSFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    FresnelS = 
{ 
"FresnelS",	       // Name by which mathcad will recognize the function.
"x",      // FresnelS will be called as FresnelS(x).
"Fresnel integral S(x) of real argument.",  // Description of FresnelS(x).
(LPCFUNCTION)FresnelSFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR}   // arguments are complex scalars
};


LRESULT FresnelSFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x) // arguments    
						    
{ double fs,fc;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	fresnl( x->real, &fs, &fc);
	c->real=fs;   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy

LRESULT dilogFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    dilog = 
{ 
"dilog",	       // Name by which mathcad will recognize the function.
"x",      // dilog will be called as dilog(x).
"Dilogarithm function of real argument.",  // Description of dilog(x).
(LPCFUNCTION)dilogFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT dilogFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	c->real=spence(x->real);   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy

LRESULT RiezetaFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    Riezeta = 
{ 
"Zeta",	       // Name by which mathcad will recognize the function.
"x",      // Riezeta will be called as Zeta(x).
"Riemann zeta function of real argument. x must be positive",  // Description of Zeta(x).
(LPCFUNCTION)RiezetaFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT RiezetaFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	c->real=1.0+zetac(x->real);   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy

LRESULT Riezeta2Function(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x,
				LPCCOMPLEXSCALAR    q );

FUNCTIONINFO    Riezeta2 = 
{ 
"Zeta2",	       // Name by which mathcad will recognize the function.
"x,q",      // Riezeta2 will be called as Zeta2(x,q).
"Riemann zeta function of two arguments. It is the sum, for k integer ranging from 0 to infinity, of (k+q)^-x where q is a positive integer and x > 1.",  // Description of Zeta2(x,q).
(LPCFUNCTION)Riezeta2Function,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR, COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT Riezeta2Function(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x,
				LPCCOMPLEXSCALAR    q   ) // arguments    
						    
{
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( q->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	c->real=zeta(x->real,q->real);   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy

LRESULT expintFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    n,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    expint = 
{ 
"Ei",	       // Name by which mathcad will recognize the function.
"n,x",      // expint will be called as Ei(n,x).
"Exponential integral Ei. n in an integer, x is real.",  // Description of Ei(n,x).
(LPCFUNCTION)expintFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
2,
{ COMPLEX_SCALAR, COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT expintFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    n,
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	int j;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( n->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( floor(n->real) != n->real )
		return MAKELRESULT( 11 , 1 );
	j=(int)floor(n->real);
	c->real=expn( j , x->real );   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy

LRESULT sinintFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    sinint = 
{ 
"Si",	       // Name by which mathcad will recognize the function.
"x",      // sinint will be called as Si(x).
"Sine integral of real argument.",  // Description of Si(x).
(LPCFUNCTION)sinintFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT sinintFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	double si,ci;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	sici( x->real , &si , &ci );
	c->real=si;   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy

LRESULT cosintFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    cosint = 
{ 
"Ci",	       // Name by which mathcad will recognize the function.
"x",      // cosint will be called as Ci(x).
"Cosine integral of real argument.",  // Description of Ci(x).
(LPCFUNCTION)cosintFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT cosintFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	double si,ci;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	sici( x->real , &si , &ci );
	c->real=ci;   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy

LRESULT sinhintFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    sinhint = 
{ 
"Shi",	       // Name by which mathcad will recognize the function.
"x",      // sinhint will be called as Shi(x).
"Hyperbolic sine integral of real argument.",  // Description of Shi(x).
(LPCFUNCTION)sinhintFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT sinhintFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	double si,ci;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	shichi( x->real , &si , &ci );
	c->real=si;   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy

LRESULT coshintFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    coshint = 
{ 
"Chi",	       // Name by which mathcad will recognize the function.
"x",      // coshint will be called as Chi(x).
"Hyperbolic cosine integral of real argument.",  // Description of Chi(x).
(LPCFUNCTION)coshintFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT coshintFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	double si,ci;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	shichi( x->real , &si , &ci );
	c->real=ci;   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy


LRESULT PlmFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    n,
				LPCCOMPLEXSCALAR    m,
				LPCCOMPLEXSCALAR    x);

FUNCTIONINFO    Plm = 
{ 
"Plm",	       // Name by which mathcad will recognize the function.
"l,m,x",      // Plm will be called as Plm(l,m,x).
"First kind Legendre polynomials and associated functions of degree l and integer order m. \
Plm(l,m,x) = (-1)^m (1-x^2)^(m/2) d^m( Pn(n,x) )/dx^m where l and x must be real \
and Pn(n,x) is the Legendre polynomial.",  
// Description of Plm(l,m,x).
(LPCFUNCTION)PlmFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
3,
{ COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT PlmFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    n,
				LPCCOMPLEXSCALAR    m,
				LPCCOMPLEXSCALAR    x)
				// arguments    
						    
{
	int m0;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( n->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( m->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 3 );
	m0 = (int) floor( m->real );
	if ( floor( m->real ) != m->real )
		return MAKELRESULT( 11 , 2 );
	if ( floor( n->real ) == n->real )
	{
		int n0;

		n0 = (int) floor( n->real );
		c->real = legendrepol( n0, m0, x->real );  // this code executes the calculation
		if (merror != -1) 
		{
			int ierr;
			ierr=merror+4;
			merror=-1;
			return MAKELRESULT( ierr , 1 );
		}
		else  return 0;
	}
	else
	{
		double theta, deg;
		long int ierror, id, ip, nudiff;

		if ( n->real < -0.5 ) deg = -n->real - 1.0;
		else deg = n->real;
		if ( ( x->real < 0.0 ) || ( x->real > 1.0 ) )
			return MAKELRESULT( 5 , 3 );
		theta = acos( x->real );
		if ( m0 >= 0 ) id = 3;
		else
		{
			id = 1;
			m0 = -m0;
		}
		nudiff = 0;
		dxlegf_( &deg, &nudiff, &m0, &m0, &theta, &id, &c->real, &ip, &ierror );
		if ( ( ierror >= 210 ) || ( ( ierror >= 201 ) && ( ierror <= 204 ) ) )
			return MAKELRESULT( 5 , 3 );
		if ( ( ierror == 205 ) || ( ierror == 206 ) )
			return MAKELRESULT( 4 , 3 );
		if ( ( ierror == 207 ) || ( ierror == 208 ) || ( ip != 0 ) )
			return MAKELRESULT( 7 , 3 );
		return 0;
	}
}
//xxxyyy

LRESULT QlmFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    n,
				LPCCOMPLEXSCALAR    m,
				LPCCOMPLEXSCALAR    x);

FUNCTIONINFO    Qlm = 
{ 
"Qlm",	       // Name by which mathcad will recognize the function.
"l,m,x",      // Qlm will be called as Qlm(l,m,x).
"Second kind Legendre functions of degree l, integer order m and argument 0<=x<1. ",  
// Description of Qlm(l,m,x).
(LPCFUNCTION)QlmFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
3,
{ COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT QlmFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    n,
				LPCCOMPLEXSCALAR    m,
				LPCCOMPLEXSCALAR    x)
				// arguments    
						    
{
	double theta;
	long int m0, ierror, id, ip, nudiff;

	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( n->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( m->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 3 );
	m0 = (int) floor( m->real );
	if ( floor( m->real ) != m->real )
		return MAKELRESULT( 11 , 2 );
	if ( m0 < 0 )
		return MAKELRESULT( 5 , 2 );
	if ( n->real < -0.5 )
		return MAKELRESULT( 5 , 1 );
	if ( ( x->real < 0.0 ) || ( x->real >= 1.0 ) )
		return MAKELRESULT( 5 , 3 );

	theta = acos( x->real );
	id = 2;
	nudiff = 0;
	dxlegf_( &n->real, &nudiff, &m0, &m0, &theta, &id, &c->real, &ip, &ierror );
	if ( ( ierror >= 210 ) || ( ( ierror >= 201 ) && ( ierror <= 204 ) ) )
		return MAKELRESULT( 5 , 3 );
	if ( ( ierror == 205 ) || ( ierror == 206 ) )
		return MAKELRESULT( 4 , 3 );
	if ( ( ierror == 207 ) || ( ierror == 208 ) || ( ip != 0 ) )
		return MAKELRESULT( 7 , 3 );
	return 0;
}
//xxxyyy

LRESULT pnormFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    n,
				LPCCOMPLEXSCALAR    m,
				LPCCOMPLEXSCALAR    x);

FUNCTIONINFO    pnorm = 
{ 
"plm",	       // Name by which mathcad will recognize the function.
"l,m,x",      // pnorm will be called as plm(l,m,x).
"Normalized first kind Legendre polynomials and associated functions of integer degree l and integer order m.",
// Description of plm(l,m,x).
(LPCFUNCTION)pnormFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
3,
{ COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT pnormFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    n,
				LPCCOMPLEXSCALAR    m,
				LPCCOMPLEXSCALAR    x)
				// arguments    
						    
{
	int m0, n0;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( n->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( m->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 3 );
	if ( floor( n->real ) != n->real )
		return MAKELRESULT( 11 , 1 );
	n0 = (int) floor( n->real );
	if ( floor( m->real ) != m->real )
		return MAKELRESULT( 11 , 2 );
	m0 = (int) floor( m->real );
	c->real = legendrepolnorm( n0, m0, x->real );  // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;

}
//xxxyyy


LRESULT YlmFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    n,
				LPCCOMPLEXSCALAR    m,
				LPCCOMPLEXSCALAR    theta,
				LPCCOMPLEXSCALAR    phi);

FUNCTIONINFO    Ylm = 
{ 
"Ylm",	       // Name by which mathcad will recognize the function.
"l,m,theta,phi",      // Ylm will be called as Ylm(l,m,theta,phi).
"Spherical harmonic of integer degree l, integer order m, latitude theta in [-PI,PI] and longitude phi.",
// Description of Ylm(l,m,theta,phi).
(LPCFUNCTION)YlmFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
4,
{ COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT YlmFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    n,
				LPCCOMPLEXSCALAR    m,
				LPCCOMPLEXSCALAR    theta,
				LPCCOMPLEXSCALAR    phi)
				// arguments    
						    
{
	double p;
	int m0, n0;

	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( n->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( m->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( theta->imag != 0.0 )
		return MAKELRESULT( 1 , 3 );
	if ( phi->imag != 0.0 )
		return MAKELRESULT( 1 , 4 );
	if ( fabs(theta->real) > PI )
		return MAKELRESULT( 5 , 3 );
	if ( floor( n->real ) != n->real )
		return MAKELRESULT( 11 , 1 );
	n0 = (int) floor( n->real );
	if ( floor( m->real ) != m->real )
		return MAKELRESULT( 11 , 2 );
	m0 = (int) floor( m->real );

	p = cos( theta->real );
	c->real = legendrepolnorm( n0, m0, p );  // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else
	{
		c->real /= SQ2PI;
		p = m0 * (phi->real);
		c->imag = c->real * sin( p );
		c->real *= cos( p );
		return 0;
	}
		
}
//xxxyyy


LRESULT YlFunction(   LPCOMPLEXARRAY     c,
				LPCCOMPLEXSCALAR    l,
				LPCCOMPLEXSCALAR    theta,
				LPCCOMPLEXSCALAR    phi );

FUNCTIONINFO    Yl = 
{ 
"Yl",	       // Name by which mathcad will recognize the function.
"l,theta,phi",      // Yl will be called as Yl(l,theta,phi).
"Sequence of spherical harmonic of integer degree l, integer order m=0..l, latitude theta in [-PI,PI] and longitude phi.",  // Description of Yl(l,theta,phi).
(LPCFUNCTION)YlFunction,   // Pointer to the executible code.
COMPLEX_ARRAY,      // the return type is a complex scalar
3,
{ COMPLEX_SCALAR, COMPLEX_SCALAR, COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT YlFunction(   LPCOMPLEXARRAY     c,  // put return value here
				LPCCOMPLEXSCALAR    l,
				LPCCOMPLEXSCALAR    theta,
				LPCCOMPLEXSCALAR    phi ) // arguments    

{
	long int l0, m0, m1, mode, isig, ierror, *ip;
	int m;
	double *dp, cphi, sphi, cm, sm, p;

	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( l->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( theta->imag != 0.0 )
		return MAKELRESULT( 1 , 2 );
	if ( phi->imag != 0.0 )
		return MAKELRESULT( 1 , 3 );
	l0 = floor( l->real );
	if ( l->real != floor( l->real ) )
		return MAKELRESULT( 11 , 1 );
	if ( l0 < 0 )
		return MAKELRESULT( 5 , 1 );

	if ( !MathcadArrayAllocate( c, l0+1 , 1, 1, 1 ) )
		return MAKELRESULT( 2 , 1 );
	m0 = 0;
	m1 = l0;
	mode = 2;
	if ( ( dp = (double *)calloc( l0+1 , sizeof( double ) ) ) == NULL )
	{
		MathcadArrayFree( c );
		return MAKELRESULT( 2 , 1 );
	}
	if ( ( ip = (long int *)calloc( l0+1 , sizeof( long int ) ) ) == NULL )
	{
		free( dp );
		MathcadArrayFree( c );
		return MAKELRESULT( 2 , 1 );
	}
// this code executes the calculation
	dxnrmp_( &l0, &m0, &m1, &theta->real, &mode, dp, ip, &isig, &ierror );
	if ( ierror != 0 ) 
	{
		free( ip );
		free( dp );
		MathcadArrayFree( c );
	}
	if ( ( ierror >= 210 ) || ( ( ierror >= 201 ) && ( ierror <= 204 ) ) )
		return MAKELRESULT( 5 , 3 );
	if ( ( ierror == 205 ) || ( ierror == 206 ) )
		return MAKELRESULT( 4 , 3 );
	if ( ( ierror == 207 ) || ( ierror == 208 ) )
		return MAKELRESULT( 7 , 3 );
	cphi = cos( phi->real );
	sphi = sin( phi->real );
	cm = 1.0 / SQ2PI;
	sm = 0.0;
	for( m = 1; m <= l0; m += 2 )
		dp[ m ] = -dp[ m ];
	for( m = 0; m <= l0; m++ )
	{
		if ( ip[ m ] != 0 )
		{
			free( ip );
			free( dp );
			MathcadArrayFree( c );
			return MAKELRESULT( 7 , 1 );
		}
		c->hReal[0][m] = dp[ m ] * cm;
		c->hImag[0][m] = dp[ m ] * sm;
		p = cphi * cm - sphi * sm;
		sm = sphi * cm + cphi * sm;
		cm = p;
	}
	free( ip );
	free( dp );
	return 0;
}
//xxxyyy


LRESULT arrotFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    arrot = 
{ 
"round",	       // Name by which mathcad will recognize the function.
"x",      // arrot will be called as round(x).
"Round real x to nearest or even integer number.",  // Description of round(x).
(LPCFUNCTION)arrotFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT arrotFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	c->real = round( x->real );   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy

LRESULT signumFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    signum = 
{ 
"signum",	       // Name by which mathcad will recognize the function.
"x",      // signum will be called as signum(x).
"Sign of x.",  // Description of signum(x).
(LPCFUNCTION)signumFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT signumFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	c->real = (x->real >= 0.0) ? 1.0 : -1.0;   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy


LRESULT csgnFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    csgn = 
{ 
"csgn",	       // Name by which mathcad will recognize the function.
"x",      // csgn will be called as csgn(x).
"Complex sign of x.",  // Description of csgn(x).
(LPCFUNCTION)csgnFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT csgnFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x   ) // arguments    
						    
{
	if ( x->real != 0.0 )
	c->real = (x->real >= 0.0) ? 1.0 : -1.0;
  else
	c->real = (x->imag >= 0.0) ? 1.0 : -1.0;   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy

LRESULT sfactFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    sfact = 
{ 
"sfact",	       // Name by which mathcad will recognize the function.
"n",      // sfact will be called as sfact(n).
"Semifactorial of integer n.",  // Description of sfact(n).
(LPCFUNCTION)sfactFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT sfactFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x ) // arguments    
						    
{
	int n;
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , 1 );
	if ( x->real < 0 )
		return MAKELRESULT( 5 , 1 );
	n = (int)floor( x->real);
	if ( x->real != floor( x->real) )
		return MAKELRESULT( 11 , 1 );
	c->real = semifact( n );
	  // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy



LRESULT maskFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x );

FUNCTIONINFO    mask = 
{ 
"mask",	       // Name by which mathcad will recognize the function.
"x",      // mask will be called as mask(x).
"Masks and unmasks the partial loss of precision error. If called with x = 0 that error \
message is disabled, if called with x != 0 that error message is enabled. Returns the \
previous state; default is unmasked.",  // Description of mask(x).
(LPCFUNCTION)maskFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
1,
{ COMPLEX_SCALAR }   // arguments are complex scalars
};


LRESULT maskFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x  ) // arguments    
						    
{
	c->real = (double)maskploss;
	if ( ( x->real == 0.0 ) && ( x->imag == 0.0 ) ) 
		maskploss = 0;
	else
		maskploss = 1;
	return 0.0;
}
//xxxyyy


/*xxxyyy
LRESULT xxxFunction(   LPCOMPLEXSCALAR     c,
				LPCCOMPLEXSCALAR    x,.... );

FUNCTIONINFO    xxx = 
{ 
"yyy",	       // Name by which mathcad will recognize the function.
"arg1,arg2,..",      // xxx will be called as yyy(arg1,arg2,..).
"................",  // Description of yyy(arg1,arg2,..).
(LPCFUNCTION)xxxFunction,   // Pointer to the executible code.
COMPLEX_SCALAR,      // the return type is a complex scalar
nargs,
{ COMPLEX_SCALAR, ....}   // arguments are complex scalars
};


LRESULT xxxFunction(   LPCOMPLEXSCALAR     c,  // put return value here
				LPCCOMPLEXSCALAR    x,...   ) // arguments    
						    
{
	// check that the arguments are real
	// if one (or more) of them is not, display "must be real" error message 
	// under the scalar argument
	if ( x->imag != 0.0 )
		return MAKELRESULT( 1 , narg );
	.............   // this code executes the calculation
	if (merror != -1) 
	{
		int ierr;
		ierr=merror+4;
		merror=-1;
		return MAKELRESULT( ierr , 1 );
	}
	else  return 0;
}
//xxxyyy
*/
