/* dlegf.f -- translated by f2c (version of 16 May 1991  13:06:06).
   You must link the resulting object file with the libraries:
	-link <S|C|M|L>f2c.lib   (in that order)
*/

#include "f2c.h"

/* Common Block Declarations */

struct {
    integer nbitsf;
} dxblk1_;

#define dxblk1_1 dxblk1_

struct {
    doublereal radix, radixl, rad2l, dlg10r;
    integer l, l2, kmax;
} dxblk2_;

#define dxblk2_1 dxblk2_

struct {
    integer nlg102, mlg102, lg102[21];
} dxblk3_;

#define dxblk3_1 dxblk3_

/* Table of constant values */

static integer c__0 = 0;
static doublereal c_b4 = 0.;
static doublereal c_b29 = 1.;
static integer c__10 = 10;
static integer c__14 = 14;
static integer c__15 = 15;
static integer c__16 = 16;
static integer c__8 = 8;
static integer c__2 = 2;
static real c_b103 = 1.f;
static integer c_n1 = -1;
static doublereal c_b125 = 10.;

/* DECK DXNRMP */
/* Subroutine */ int dxnrmp_(integer *nu, integer *mu1, integer *mu2, 
	doublereal *darg, integer *mode, doublereal *dpn, integer *ipn, 
	integer *isig, integer *ierror)
{
    /* System generated locals */
    integer i__1;
    doublereal d__1, d__2;

    /* Builtin functions */
    double sqrt(doublereal), d_lg10(doublereal *), atan(doublereal), cos(
	    doublereal), sin(doublereal);

    /* Local variables */
    static integer i, j, k;
    static doublereal p, s, t;
    extern /* Subroutine */ int dxadd_(doublereal *, integer *, doublereal *, 
	    integer *, doublereal *, integer *, integer *);
    static doublereal x;
    extern /* Subroutine */ int dxadj_(doublereal *, integer *, integer *), 
	    dxred_(doublereal *, integer *, integer *);
    static doublereal c1, c2;
    extern /* Subroutine */ int dxset_(integer *, integer *, doublereal *, 
	    integer *, integer *);
    static doublereal p1, p2, p3, dk;
    static integer ip, mu;
    static doublereal sx, tx;
    static integer ip1, ip2;

/* ***BEGIN PROLOGUE  DXNRMP */
/* ***PURPOSE  Compute normalized Legendre polynomials. */
/* ***LIBRARY   SLATEC */
/* ***CATEGORY  C3A2, C9 */
/* ***TYPE      DOUBLE PRECISION (XNRMP-S, DXNRMP-D) */
/* ***KEYWORDS  LEGENDRE FUNCTIONS */
/* ***AUTHOR  Lozier, Daniel W., (National Bureau of Standards) */
/*           Smith, John M., (NBS and George Mason University) */
/* ***DESCRIPTION */

/*        SUBROUTINE TO CALCULATE NORMALIZED LEGENDRE POLYNOMIALS */
/*        (XNRMP is single-precision version) */
/*        DXNRMP calculates normalized Legendre polynomials of varying */
/*        order and fixed argument and degree. The order MU and degree */
/*        NU are non-negative integers and the argument is real. Because 
*/
/*        the algorithm requires the use of numbers outside the normal */
/*        machine range, this subroutine employs a special arithmetic */
/*        called extended-range arithmetic. See J.M. Smith, F.W.J. Olver, 
*/
/*        and D.W. Lozier, Extended-Range Arithmetic and Normalized */
/*        Legendre Polynomials, ACM Transactions on Mathematical Soft- */
/*        ware, 93-105, March 1981, for a complete description of the */
/*        algorithm and special arithmetic. Also see program comments */
/*        in DXSET. */

/*        The normalized Legendre polynomials are multiples of the */
/*        associated Legendre polynomials of the first kind where the */
/*        normalizing coefficients are chosen so as to make the integral 
*/
/*        from -1 to 1 of the square of each function equal to 1. See */
/*        E. Jahnke, F. Emde and F. Losch, Tables of Higher Functions, */
/*        McGraw-Hill, New York, 1960, p. 121. */

/*        The input values to DXNRMP are NU, MU1, MU2, DARG, and MODE. */
/*        These must satisfy */
/*          1. NU .GE. 0 specifies the degree of the normalized Legendre 
*/
/*             polynomial that is wanted. */
/*          2. MU1 .GE. 0 specifies the lowest-order normalized Legendre 
*/
/*             polynomial that is wanted. */
/*          3. MU2 .GE. MU1 specifies the highest-order normalized Leg- */

/*             endre polynomial that is wanted. */
/*         4a. MODE = 1 and -1.0D0 .LE. DARG .LE. 1.0D0 specifies that */
/*             Normalized Legendre(NU, MU, DARG) is wanted for MU = MU1, 
*/
/*             MU1 + 1, ..., MU2. */
/*         4b. MODE = 2 and -3.14159... .LT. DARG .LT. 3.14159... spec- */

/*             ifies that Normalized Legendre(NU, MU, COS(DARG)) is */
/*             wanted for MU = MU1, MU1 + 1, ..., MU2. */

/*        The output of DXNRMP consists of the two vectors DPN and IPN */
/*        and the error estimate ISIG. The computed values are stored as 
*/
/*        extended-range numbers such that */
/*             (DPN(1),IPN(1))=NORMALIZED LEGENDRE(NU,MU1,DX) */
/*             (DPN(2),IPN(2))=NORMALIZED LEGENDRE(NU,MU1+1,DX) */
/*                . */
/*                . */
/*             (DPN(K),IPN(K))=NORMALIZED LEGENDRE(NU,MU2,DX) */
/*        where K = MU2 - MU1 + 1 and DX = DARG or COS(DARG) according */
/*        to whether MODE = 1 or 2. Finally, ISIG is an estimate of the */

/*        number of decimal digits lost through rounding errors in the */
/*        computation. For example if DARG is accurate to 12 significant 
*/
/*        decimals, then the computed function values are accurate to */
/*        12 - ISIG significant decimals (except in neighborhoods of */
/*        zeros). */

/*        The interpretation of (DPN(I),IPN(I)) is DPN(I)*(IR**IPN(I)) */
/*        where IR is the internal radix of the computer arithmetic. When 
*/
/*        IPN(I) = 0 the value of the normalized Legendre polynomial is */

/*        contained entirely in DPN(I) and subsequent double-precision */
/*        computations can be performed without further consideration of 
*/
/*        extended-range arithmetic. However, if IPN(I) .NE. 0 the corre- 
*/
/*        sponding value of the normalized Legendre polynomial cannot be 
*/
/*        represented in double-precision because of overflow or under- */

/*        flow. THE USER MUST TEST IPN(I) IN HIS/HER PROGRAM. In the case 
*/
/*        that IPN(I) is nonzero, the user could rewrite his/her program 
*/
/*        to use extended range arithmetic. */



/*        The interpretation of (DPN(I),IPN(I)) can be changed to */
/*        DPN(I)*(10**IPN(I)) by calling the extended-range subroutine */
/*        DXCON. This should be done before printing the computed values. 
*/
/*        As an example of usage, the Fortran coding */
/*              J = K */
/*              DO 20 I = 1, K */
/*              CALL DXCON(DPN(I), IPN(I),IERROR) */
/*              IF (IERROR.NE.0) RETURN */
/*              PRINT 10, DPN(I), IPN(I) */
/*           10 FORMAT(1X, D30.18 , I15) */
/*              IF ((IPN(I) .EQ. 0) .OR. (J .LT. K)) GO TO 20 */
/*              J = I - 1 */
/*           20 CONTINUE */
/*        will print all computed values and determine the largest J */
/*        such that IPN(1) = IPN(2) = ... = IPN(J) = 0. Because of the */
/*        change of representation caused by calling DXCON, (DPN(I), */
/*        IPN(I)) for I = J+1, J+2, ... cannot be used in subsequent */
/*        extended-range computations. */

/*        IERROR is an error indicator. If no errors are detected, */
/*        IERROR=0 when control returns to the calling routine. If */
/*        an error is detected, IERROR is returned as nonzero. The */
/*        calling routine must check the value of IERROR. */

/*        If IERROR=212 or 213, invalid input was provided to DXNRMP. */
/*        If IERROR=201,202,203, or 204, invalid input was provided */
/*        to DXSET. */
/*        If IERROR=205 or 206, an internal consistency error occurred */
/*        in DXSET (probably due to a software malfunction in the */
/*        library routine I1MACH). */
/*        If IERROR=207, an overflow or underflow of an extended-range */
/*        number was detected in DXADJ. */
/*        If IERROR=208, an overflow or underflow of an extended-range */
/*        number was detected in DXC210. */

/* ***SEE ALSO  DXSET */
/* ***REFERENCES  Smith, Olver and Lozier, Extended-Range Arithmetic and 
*/
/*                 Normalized Legendre Polynomials, ACM Trans on Math */
/*                 Softw, v 7, n 1, March 1981, pp 93--105. */
/* ***ROUTINES CALLED  DXADD, DXADJ, DXRED, DXSET, XERMSG */
/* ***REVISION HISTORY  (YYMMDD) */
/*   820712  DATE WRITTEN */
/*   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS) */

/*   901019  Revisions to prologue.  (DWL and WRB) */
/*   901106  Changed all specific intrinsics to generic.  (WRB) */
/*           Corrected order of sections in prologue and added TYPE */
/*           section.  (WRB) */
/*           CALLs to XERROR changed to CALLs to XERMSG.  (WRB) */
/*   920127  Revised PURPOSE section of prologue.  (DWL) */
/* ***END PROLOGUE  DXNRMP */
/* CALL DXSET TO INITIALIZE EXTENDED-RANGE ARITHMETIC (SEE DXSET */
/* LISTING FOR DETAILS) */
/* ***FIRST EXECUTABLE STATEMENT  DXNRMP */
    /* Parameter adjustments */
    --ipn;
    --dpn;

    /* Function Body */
    *ierror = 0;
    dxset_(&c__0, &c__0, &c_b4, &c__0, ierror);
    if (*ierror != 0) {
	return 0;
    }

/*        TEST FOR PROPER INPUT VALUES. */

    if (*nu < 0) {
	goto L110;
    }
    if (*mu1 < 0) {
	goto L110;
    }
    if (*mu1 > *mu2) {
	goto L110;
    }
    if (*nu == 0) {
	goto L90;
    }
    if (*mode < 1 || *mode > 2) {
	goto L110;
    }
    switch (*mode) {
	case 1:  goto L10;
	case 2:  goto L20;
    }
L10:
    if (abs(*darg) > 1.) {
	goto L120;
    }
    if (abs(*darg) == 1.) {
	goto L90;
    }
    x = *darg;
    sx = sqrt((abs(x) + 1.) * (.5 - abs(x) + .5));
    tx = x / sx;
/* Computing 2nd power */
    d__2 = tx;
    d__1 = *nu * 2. * (d__2 * d__2 + 5.);
    *isig = (integer) d_lg10(&d__1);
    goto L30;
L20:
    if (abs(*darg) > atan(1.) * 4.) {
	goto L120;
    }
    if (*darg == 0.) {
	goto L90;
    }
    x = cos(*darg);
    sx = (d__1 = sin(*darg), abs(d__1));
    tx = x / sx;
    d__2 = *nu * 2. * ((d__1 = *darg * tx, abs(d__1)) + 5.);
    *isig = (integer) d_lg10(&d__2);

/*        BEGIN CALCULATION */

L30:
    mu = *mu2;
    i = *mu2 - *mu1 + 1;

/*        IF MU.GT.NU, NORMALIZED LEGENDRE(NU,MU,X)=0. */

L40:
    if (mu <= *nu) {
	goto L50;
    }
    dpn[i] = 0.;
    ipn[i] = 0;
    --i;
    --mu;
    if (i > 0) {
	goto L40;
    }
    *isig = 0;
    goto L160;
L50:
    mu = *nu;

/*        P1 = 0. = NORMALIZED LEGENDRE(NU,NU+1,X) */

    p1 = 0.;
    ip1 = 0;

/*        CALCULATE P2 = NORMALIZED LEGENDRE(NU,NU,X) */

    p2 = 1.;
    ip2 = 0;
    p3 = .5;
    dk = 2.;
    i__1 = *nu;
    for (j = 1; j <= i__1; ++j) {
	p3 = (dk + 1.) / dk * p3;
	p2 *= sx;
	dxadj_(&p2, &ip2, ierror);
	if (*ierror != 0) {
	    return 0;
	}
	dk += 2.;
/* L60: */
    }
    p2 *= sqrt(p3);
    dxadj_(&p2, &ip2, ierror);
    if (*ierror != 0) {
	return 0;
    }
    s = tx * 2.;
    t = 1. / *nu;
    if (*mu2 < *nu) {
	goto L70;
    }
    dpn[i] = p2;
    ipn[i] = ip2;
    --i;
    if (i == 0) {
	goto L140;
    }

/*        RECURRENCE PROCESS */

L70:
    p = mu * t;
    c1 = 1. / sqrt((1. - p + t) * (p + 1.));
    c2 = s * p * c1 * p2;
    c1 = -sqrt((p + 1. + t) * (1. - p)) * c1 * p1;
    dxadd_(&c2, &ip2, &c1, &ip1, &p, &ip, ierror);
    if (*ierror != 0) {
	return 0;
    }
    --mu;
    if (mu > *mu2) {
	goto L80;
    }

/*        STORE IN ARRAY DPN FOR RETURN TO CALLING ROUTINE. */

    dpn[i] = p;
    ipn[i] = ip;
    --i;
    if (i == 0) {
	goto L140;
    }
L80:
    p1 = p2;
    ip1 = ip2;
    p2 = p;
    ip2 = ip;
    if (mu <= *mu1) {
	goto L140;
    }
    goto L70;

/*        SPECIAL CASE WHEN X=-1 OR +1, OR NU=0. */

L90:
    k = *mu2 - *mu1 + 1;
    i__1 = k;
    for (i = 1; i <= i__1; ++i) {
	dpn[i] = 0.;
	ipn[i] = 0;
/* L100: */
    }
    *isig = 0;
    if (*mu1 > 0) {
	goto L160;
    }
    *isig = 1;
    dpn[1] = sqrt(*nu + .5);
    ipn[1] = 0;
    if (*nu % 2 == 0) {
	goto L160;
    }
    if (*mode == 1 && *darg == 1.) {
	goto L160;
    }
    if (*mode == 2) {
	goto L160;
    }
    dpn[1] = -dpn[1];
    goto L160;

/*          ERROR PRINTOUTS AND TERMINATION. */

L110:
    *ierror = 212;
    return 0;
L120:
    *ierror = 213;
    return 0;

/*        RETURN TO CALLING PROGRAM */

L140:
    k = *mu2 - *mu1 + 1;
    i__1 = k;
    for (i = 1; i <= i__1; ++i) {
	dxred_(&dpn[i], &ipn[i], ierror);
	if (*ierror != 0) {
	    return 0;
	}
/* L150: */
    }
L160:
    return 0;
} /* dxnrmp_ */

/* DECK DXLEGF */
/* Subroutine */ int dxlegf_(doublereal *dnu1, integer *nudiff, integer *mu1, 
	integer *mu2, doublereal *theta, integer *id, doublereal *pqa, 
	integer *ipqa, integer *ierror)
{
    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    double atan(doublereal), d_mod(doublereal *, doublereal *), cos(
	    doublereal), sin(doublereal);

    /* Local variables */
    static integer i, l;
    static doublereal x;
    extern /* Subroutine */ int dxred_(doublereal *, integer *, integer *), 
	    dxset_(integer *, integer *, doublereal *, integer *, integer *), 
	    dxpmu_(doublereal *, doublereal *, integer *, integer *, 
	    doublereal *, doublereal *, doublereal *, integer *, doublereal *,
	     integer *, integer *), dxqmu_(doublereal *, doublereal *, 
	    integer *, integer *, doublereal *, doublereal *, doublereal *, 
	    integer *, doublereal *, integer *, integer *), dxqnu_(doublereal 
	    *, doublereal *, integer *, doublereal *, doublereal *, 
	    doublereal *, integer *, doublereal *, integer *, integer *);
    static doublereal sx;
    extern /* Subroutine */ int dxpnrm_(doublereal *, doublereal *, integer *,
	     integer *, doublereal *, integer *, integer *);
    static doublereal pi2;
    extern /* Subroutine */ int dxpmup_(doublereal *, doublereal *, integer *,
	     integer *, doublereal *, integer *, integer *), dxpqnu_(
	    doublereal *, doublereal *, integer *, doublereal *, integer *, 
	    doublereal *, integer *, integer *);
    static doublereal dnu2;

/* ***BEGIN PROLOGUE  DXLEGF */
/* DXSET (probably due to a software malfunction in the library routine */

/* I1MACH). */
/*   If IERROR=207, an overflow or underflow of an extended-range number 
*/
/* was detected in DXADJ. */
/*   If IERROR=208, an overflow or underflow of an extended-range number 
*/
/* was detected in DXC210. */

/* ***SEE ALSO  DXSET */
/* ***REFERENCES  Olver and Smith, Associated Legendre Functions on the */

/*                 Cut, J Comp Phys, v 51, n 3, Sept 1983, pp 502--518. */

/*               Smith, Olver and Lozier, Extended-Range Arithmetic and */

/*                 Normalized Legendre Polynomials, ACM Trans on Math */
/*                 Softw, v 7, n 1, March 1981, pp 93--105. */
/* ***ROUTINES CALLED  DXPMU, DXPMUP, DXPNRM, DXPQNU, DXQMU, DXQNU, DXRED,
 */
/*                    DXSET, XERMSG */
/* ***REVISION HISTORY  (YYMMDD) */
/*   820728  DATE WRITTEN */
/*   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS) */

/*   901019  Revisions to prologue.  (DWL and WRB) */
/*   901106  Changed all specific intrinsics to generic.  (WRB) */
/*           Corrected order of sections in prologue and added TYPE */
/*           section.  (WRB) */
/*           CALLs to XERROR changed to CALLs to XERMSG.  (WRB) */
/*   920127  Revised PURPOSE section of prologue.  (DWL) */
/* ***END PROLOGUE  DXLEGF */

/* ***FIRST EXECUTABLE STATEMENT  DXLEGF */
    /* Parameter adjustments */
    --ipqa;
    --pqa;

    /* Function Body */
    *ierror = 0;
    dxset_(&c__0, &c__0, &c_b4, &c__0, ierror);
    if (*ierror != 0) {
	return 0;
    }
    pi2 = atan(1.) * 2.;

/*        ZERO OUTPUT ARRAYS */

    l = *mu2 - *mu1 + *nudiff + 1;
    i__1 = l;
    for (i = 1; i <= i__1; ++i) {
	pqa[i] = 0.;
/* L290: */
	ipqa[i] = 0;
    }

/*        CHECK FOR VALID INPUT VALUES */

    if (*nudiff < 0) {
	goto L400;
    }
    if (*dnu1 < -.5) {
	goto L400;
    }
    if (*mu2 < *mu1) {
	goto L400;
    }
    if (*mu1 < 0) {
	goto L400;
    }
    if (*theta <= 0. || *theta > pi2) {
	goto L420;
    }
    if (*id < 1 || *id > 4) {
	goto L400;
    }
    if (*mu1 != *mu2 && *nudiff > 0) {
	goto L400;
    }

/*        IF DNU1 IS NOT AN INTEGER, NORMALIZED P(MU,DNU,X) */
/*        CANNOT BE CALCULATED.  IF DNU1 IS AN INTEGER AND */
/*        MU1.GT.DNU2 THEN ALL VALUES OF P(+MU,DNU,X) AND */
/*        NORMALIZED P(MU,NU,X) WILL BE ZERO. */

    dnu2 = *dnu1 + *nudiff;
    if (*id == 3 && d_mod(dnu1, &c_b29) != 0.) {
	goto L295;
    }
    if (*id == 4 && d_mod(dnu1, &c_b29) != 0.) {
	goto L400;
    }
    if ((*id == 3 || *id == 4) && (doublereal) (*mu1) > dnu2) {
	return 0;
    }
L295:

    x = cos(*theta);
    sx = 1. / sin(*theta);
    if (*id == 2) {
	goto L300;
    }
    if (*mu2 - *mu1 <= 0) {
	goto L360;
    }

/*        FIXED NU, VARIABLE MU */
/*        CALL DXPMU TO CALCULATE P(-MU1,NU,X),....,P(-MU2,NU,X) */

    dxpmu_(dnu1, &dnu2, mu1, mu2, theta, &x, &sx, id, &pqa[1], &ipqa[1], 
	    ierror);
    if (*ierror != 0) {
	return 0;
    }
    goto L380;

L300:
    if (*mu2 == *mu1) {
	goto L320;
    }

/*        FIXED NU, VARIABLE MU */
/*        CALL DXQMU TO CALCULATE Q(MU1,NU,X),....,Q(MU2,NU,X) */

    dxqmu_(dnu1, &dnu2, mu1, mu2, theta, &x, &sx, id, &pqa[1], &ipqa[1], 
	    ierror);
    if (*ierror != 0) {
	return 0;
    }
    goto L390;

/*        FIXED MU, VARIABLE NU */
/*        CALL DXQNU TO CALCULATE Q(MU,DNU1,X),....,Q(MU,DNU2,X) */

L320:
    dxqnu_(dnu1, &dnu2, mu1, theta, &x, &sx, id, &pqa[1], &ipqa[1], ierror);
    if (*ierror != 0) {
	return 0;
    }
    goto L390;

/*        FIXED MU, VARIABLE NU */
/*        CALL DXPQNU TO CALCULATE P(-MU,DNU1,X),....,P(-MU,DNU2,X) */

L360:
    dxpqnu_(dnu1, &dnu2, mu1, theta, id, &pqa[1], &ipqa[1], ierror);
    if (*ierror != 0) {
	return 0;
    }

/*        IF ID = 3, TRANSFORM P(-MU,NU,X) VECTOR INTO */
/*        P(MU,NU,X) VECTOR. */

L380:
    if (*id == 3) {
	dxpmup_(dnu1, &dnu2, mu1, mu2, &pqa[1], &ipqa[1], ierror);
    }
    if (*ierror != 0) {
	return 0;
    }

/*        IF ID = 4, TRANSFORM P(-MU,NU,X) VECTOR INTO */
/*        NORMALIZED P(MU,NU,X) VECTOR. */

    if (*id == 4) {
	dxpnrm_(dnu1, &dnu2, mu1, mu2, &pqa[1], &ipqa[1], ierror);
    }
    if (*ierror != 0) {
	return 0;
    }

/*        PLACE RESULTS IN REDUCED FORM IF POSSIBLE */
/*        AND RETURN TO MAIN PROGRAM. */

L390:
    i__1 = l;
    for (i = 1; i <= i__1; ++i) {
	dxred_(&pqa[i], &ipqa[i], ierror);
	if (*ierror != 0) {
	    return 0;
	}
/* L395: */
    }
    return 0;

/*        *****     ERROR TERMINATION     ***** */

L400:
    *ierror = 210;
    return 0;
L420:
    *ierror = 211;
    return 0;
} /* dxlegf_ */

/* DECK DXSET */
/* Subroutine */ int dxset_(integer *irad, integer *nradpl, doublereal *dzero,
	 integer *nbits, integer *ierror)
{
    /* Initialized data */

    static integer log102[20] = { 301,29,995,663,981,195,213,738,894,724,493,
	    26,768,189,881,462,108,541,310,428 };
    static integer iflag = 0;

    /* System generated locals */
    integer i__1, i__2;
    doublereal d__1;

    /* Builtin functions */
    double d_lg10(doublereal *), pow_di(doublereal *, integer *);
    integer pow_ii(integer *, integer *);

    /* Local variables */
    static integer lg102x, log2r, i, j, k, iradx;
    extern integer i1mach_(integer *);
    static integer ic, nb, ii, kk, it, lx, nrdplc, lgtemp[20], iminex, imaxex,
	     nbitsx;
    static doublereal dzerox;
    static integer np1;

/* ***BEGIN PROLOGUE  DXSET */
/*                 (X,IX)*(Y,IY) + (U,IU)*(V,IV) */

/* CAN BE COMPUTED AND STORED IN ADJUSTED FORM WITH NO EXPLICIT */
/* CALLS TO DXADJ. */

/*   WHEN AN EXTENDED-RANGE NUMBER IS TO BE PRINTED, IT MUST BE */
/* CONVERTED TO AN EXTENDED-RANGE FORM WITH DECIMAL RADIX.  SUBROUTINE */
/* DXCON IS PROVIDED FOR THIS PURPOSE. */

/*   THE SUBROUTINES CONTAINED IN THIS PACKAGE ARE */

/*     SUBROUTINE DXADD */
/* USAGE */
/*                  CALL DXADD(X,IX,Y,IY,Z,IZ,IERROR) */
/*                  IF (IERROR.NE.0) RETURN */
/* DESCRIPTION */
/*                  FORMS THE EXTENDED-RANGE SUM  (Z,IZ) = */
/*                  (X,IX) + (Y,IY).  (Z,IZ) IS ADJUSTED */
/*                  BEFORE RETURNING. THE INPUT OPERANDS */
/*                  NEED NOT BE IN ADJUSTED FORM, BUT THEIR */
/*                  PRINCIPAL PARTS MUST SATISFY */
/*                  RADIX**(-2L).LE.ABS(X).LE.RADIX**(2L), */
/*                  RADIX**(-2L).LE.ABS(Y).LE.RADIX**(2L). */

/*     SUBROUTINE DXADJ */
/* USAGE */
/*                  CALL DXADJ(X,IX,IERROR) */
/*                  IF (IERROR.NE.0) RETURN */
/* DESCRIPTION */
/*                  TRANSFORMS (X,IX) SO THAT */
/*                  RADIX**(-L) .LE. ABS(X) .LT. RADIX**L. */
/*                  ON MOST COMPUTERS THIS TRANSFORMATION DOES */
/*                  NOT CHANGE THE MANTISSA OF X PROVIDED RADIX IS */
/*                  THE NUMBER BASE OF DOUBLE-PRECISION ARITHMETIC. */

/*     SUBROUTINE DXC210 */
/* USAGE */
/*                  CALL DXC210(K,Z,J,IERROR) */
/*                  IF (IERROR.NE.0) RETURN */
/* DESCRIPTION */
/*                  GIVEN K THIS SUBROUTINE COMPUTES J AND Z */
/*                  SUCH THAT  RADIX**K = Z*10**J, WHERE Z IS IN */
/*                  THE RANGE 1/10 .LE. Z .LT. 1. */
/*                  THE VALUE OF Z WILL BE ACCURATE TO FULL */
/*                  DOUBLE-PRECISION PROVIDED THE NUMBER */
/*                  OF DECIMAL PLACES IN THE LARGEST */
/*                  INTEGER PLUS THE NUMBER OF DECIMAL */
/*                  PLACES CARRIED IN DOUBLE-PRECISION DOES NOT */
/*                  EXCEED 60. DXC210 IS CALLED BY SUBROUTINE */
/*                  DXCON WHEN NECESSARY. THE USER SHOULD */
/*                  NEVER NEED TO CALL DXC210 DIRECTLY. */

/*     SUBROUTINE DXCON */
/* USAGE */
/*                  CALL DXCON(X,IX,IERROR) */
/*                  IF (IERROR.NE.0) RETURN */
/* DESCRIPTION */
/*                  CONVERTS (X,IX) = X*RADIX**IX */
/*                  TO DECIMAL FORM IN PREPARATION FOR */
/*                  PRINTING, SO THAT (X,IX) = X*10**IX */
/*                  WHERE 1/10 .LE. ABS(X) .LT. 1 */
/*                  IS RETURNED, EXCEPT THAT IF */
/*                  (ABS(X),IX) IS BETWEEN RADIX**(-2L) */
/*                  AND RADIX**(2L) THEN THE REDUCED */
/*                  FORM WITH IX = 0 IS RETURNED. */

/*     SUBROUTINE DXRED */
/* USAGE */
/*                  CALL DXRED(X,IX,IERROR) */
/*                  IF (IERROR.NE.0) RETURN */
/* DESCRIPTION */
/*                  IF */
/*                  RADIX**(-2L) .LE. (ABS(X),IX) .LE. RADIX**(2L) */
/*                  THEN DXRED TRANSFORMS (X,IX) SO THAT IX=0. */
/*                  IF (X,IX) IS OUTSIDE THE ABOVE RANGE, */
/*                  THEN DXRED TAKES NO ACTION. */
/*                  THIS SUBROUTINE IS USEFUL IF THE */
/*                  RESULTS OF EXTENDED-RANGE CALCULATIONS */
/*                  ARE TO BE USED IN SUBSEQUENT ORDINARY */
/*                  DOUBLE-PRECISION CALCULATIONS. */

/* ***REFERENCES  Smith, Olver and Lozier, Extended-Range Arithmetic and 
*/
/*                 Normalized Legendre Polynomials, ACM Trans on Math */
/*                 Softw, v 7, n 1, March 1981, pp 93--105. */
/* ***ROUTINES CALLED  I1MACH, XERMSG */
/* ***COMMON BLOCKS    DXBLK1, DXBLK2, DXBLK3 */
/* ***REVISION HISTORY  (YYMMDD) */
/*   820712  DATE WRITTEN */
/*   881020  Revised to meet SLATEC CML recommendations.  (DWL and JMS) */

/*   901019  Revisions to prologue.  (DWL and WRB) */
/*   901106  Changed all specific intrinsics to generic.  (WRB) */
/*           Corrected order of sections in prologue and added TYPE */
/*           section.  (WRB) */
/*           CALLs to XERROR changed to CALLs to XERMSG.  (WRB) */
/*   920127  Revised PURPOSE section of prologue.  (DWL) */
/* ***END PROLOGUE  DXSET */


/*   LOG102 CONTAINS THE FIRST 60 DIGITS OF LOG10(2) FOR USE IN */
/* CONVERSION OF EXTENDED-RANGE NUMBERS TO BASE 10 . */

/* FOLLOWING CODING PREVENTS DXSET FROM BEING EXECUTED MORE THAN ONCE. */
/* THIS IS IMPORTANT BECAUSE SOME SUBROUTINES (SUCH AS DXNRMP AND */
/* DXLEGF) CALL DXSET TO MAKE SURE EXTENDED-RANGE ARITHMETIC HAS */
/* BEEN INITIALIZED. THE USER MAY WANT TO PRE-EMPT THIS CALL, FOR */
/* EXAMPLE WHEN I1MACH IS NOT AVAILABLE. SEE CODING BELOW. */
/* ***FIRST EXECUTABLE STATEMENT  DXSET */
    *ierror = 0;
    if (iflag != 0) {
	return 0;
    }
    iradx = *irad;
    nrdplc = *nradpl;
    dzerox = *dzero;
    iminex = 0;
    imaxex = 0;
    nbitsx = *nbits;
/* FOLLOWING 5 STATEMENTS SHOULD BE DELETED IF I1MACH IS */
/* NOT AVAILABLE OR NOT CONFIGURED TO RETURN THE CORRECT */
/* MACHINE-DEPENDENT VALUES. */
    if (iradx == 0) {
	iradx = i1mach_(&c__10);
    }
    if (nrdplc == 0) {
	nrdplc = i1mach_(&c__14);
    }
    if (dzerox == 0.) {
	iminex = i1mach_(&c__15);
    }
    if (dzerox == 0.) {
	imaxex = i1mach_(&c__16);
    }
    if (nbitsx == 0) {
	nbitsx = i1mach_(&c__8);
    }
    if (iradx == 2) {
	goto L10;
    }
    if (iradx == 4) {
	goto L10;
    }
    if (iradx == 8) {
	goto L10;
    }
    if (iradx == 16) {
	goto L10;
    }
    *ierror = 201;
    return 0;
L10:
    log2r = 0;
    if (iradx == 2) {
	log2r = 1;
    }
    if (iradx == 4) {
	log2r = 2;
    }
    if (iradx == 8) {
	log2r = 3;
    }
    if (iradx == 16) {
	log2r = 4;
    }
    dxblk1_1.nbitsf = log2r * nrdplc;
    dxblk2_1.radix = (doublereal) iradx;
    dxblk2_1.dlg10r = d_lg10(&dxblk2_1.radix);
    if (dzerox != 0.) {
	goto L14;
    }
/* Computing MIN */
    i__1 = (1 - iminex) / 2, i__2 = (imaxex - 1) / 2;
    lx = min(i__1,i__2);
    goto L16;
L14:
    lx = (integer) (d_lg10(&dzerox) * .5 / dxblk2_1.dlg10r);
/* RADIX**(2*L) SHOULD NOT OVERFLOW, BUT REDUCE L BY 1 FOR FURTHER */
/* PROTECTION. */
    --lx;
L16:
    dxblk2_1.l2 = lx << 1;
    if (lx >= 4) {
	goto L20;
    }
    *ierror = 202;
    return 0;
L20:
    dxblk2_1.l = lx;
    dxblk2_1.radixl = pow_di(&dxblk2_1.radix, &dxblk2_1.l);
/* Computing 2nd power */
    d__1 = dxblk2_1.radixl;
    dxblk2_1.rad2l = d__1 * d__1;
/*    IT IS NECESSARY TO RESTRICT NBITS (OR NBITSX) TO BE LESS THAN SOME 
*/
/* UPPER LIMIT BECAUSE OF BINARY-TO-DECIMAL CONVERSION. SUCH CONVERSION */

/* IS DONE BY DXC210 AND REQUIRES A CONSTANT THAT IS STORED TO SOME FIXED 
*/
/* PRECISION. THE STORED CONSTANT (LOG102 IN THIS ROUTINE) PROVIDES */
/* FOR CONVERSIONS ACCURATE TO THE LAST DECIMAL DIGIT WHEN THE INTEGER */
/* WORD LENGTH DOES NOT EXCEED 63. A LOWER LIMIT OF 15 BITS IS IMPOSED */
/* BECAUSE THE SOFTWARE IS DESIGNED TO RUN ON COMPUTERS WITH INTEGER WORD 
*/
/* LENGTH OF AT LEAST 16 BITS. */
    if (15 <= nbitsx && nbitsx <= 63) {
	goto L30;
    }
    *ierror = 203;
    return 0;
L30:
    i__1 = nbitsx - 1;
    dxblk2_1.kmax = pow_ii(&c__2, &i__1) - dxblk2_1.l2;
    nb = (nbitsx - 1) / 2;
    dxblk3_1.mlg102 = pow_ii(&c__2, &nb);
    if (1 <= nrdplc * log2r && nrdplc * log2r <= 120) {
	goto L40;
    }
    *ierror = 204;
    return 0;
L40:
    dxblk3_1.nlg102 = nrdplc * log2r / nb + 3;
    np1 = dxblk3_1.nlg102 + 1;

/*   AFTER COMPLETION OF THE FOLLOWING LOOP, IC CONTAINS */
/* THE INTEGER PART AND LGTEMP CONTAINS THE FRACTIONAL PART */
/* OF LOG10(IRADX) IN RADIX 1000. */
    ic = 0;
    for (ii = 1; ii <= 20; ++ii) {
	i = 21 - ii;
	it = log2r * log102[i - 1] + ic;
	ic = it / 1000;
	lgtemp[i - 1] = it % 1000;
/* L50: */
    }

/*   AFTER COMPLETION OF THE FOLLOWING LOOP, LG102 CONTAINS */
/* LOG10(IRADX) IN RADIX MLG102. THE RADIX POINT IS */
/* BETWEEN LG102(1) AND LG102(2). */
    dxblk3_1.lg102[0] = ic;
    i__1 = np1;
    for (i = 2; i <= i__1; ++i) {
	lg102x = 0;
	i__2 = nb;
	for (j = 1; j <= i__2; ++j) {
	    ic = 0;
	    for (kk = 1; kk <= 20; ++kk) {
		k = 21 - kk;
		it = (lgtemp[k - 1] << 1) + ic;
		ic = it / 1000;
		lgtemp[k - 1] = it % 1000;
/* L60: */
	    }
	    lg102x = (lg102x << 1) + ic;
/* L70: */
	}
	dxblk3_1.lg102[i - 1] = lg102x;
/* L80: */
    }

/* CHECK SPECIAL CONDITIONS REQUIRED BY SUBROUTINES... */
    if (nrdplc < dxblk2_1.l) {
	goto L90;
    }
    *ierror = 205;
    return 0;
L90:
    if (dxblk2_1.l * 6 <= dxblk2_1.kmax) {
	goto L100;
    }
    *ierror = 206;
    return 0;
L100:
    iflag = 1;
    return 0;
} /* dxset_ */

/* DECK DXRED */
/* Subroutine */ int dxred_(doublereal *x, integer *ix, integer *ierror)
{
    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    double pow_di(doublereal *, integer *), d_sign(doublereal *, doublereal *)
	    ;

    /* Local variables */
    static integer i;
    static doublereal xa;
    static integer ixa, ixa1, ixa2;

/* ***BEGIN PROLOGUE  DXRED */
/* ***PURPOSE  To provide double-precision floating-point arithmetic */
/*            with an extended exponent range. */
/* ***LIBRARY   SLATEC */
/* ***CATEGORY  A3D */
/* ***TYPE      DOUBLE PRECISION (XRED-S, DXRED-D) */
/* ***KEYWORDS  EXTENDED-RANGE DOUBLE-PRECISION ARITHMETIC */
/* ***AUTHOR  Lozier, Daniel W., (National Bureau of Standards) */
/*           Smith, John M., (NBS and George Mason University) */
/* ***DESCRIPTION */
/*     DOUBLE PRECISION X */
/*     INTEGER IX */

/*                  IF */
/*                  RADIX**(-2L) .LE. (ABS(X),IX) .LE. RADIX**(2L) */
/*                  THEN DXRED TRANSFORMS (X,IX) SO THAT IX=0. */
/*                  IF (X,IX) IS OUTSIDE THE ABOVE RANGE, */
/*                  THEN DXRED TAKES NO ACTION. */
/*                  THIS SUBROUTINE IS USEFUL IF THE */
/*                  RESULTS OF EXTENDED-RANGE CALCULATIONS */
/*                  ARE TO BE USED IN SUBSEQUENT ORDINARY */
/*                  DOUBLE-PRECISION CALCULATIONS. */

/* ***SEE ALSO  DXSET */
/* ***REFERENCES  (NONE) */
/* ***ROUTINES CALLED  (NONE) */
/* ***COMMON BLOCKS    DXBLK2 */
/* ***REVISION HISTORY  (YYMMDD) */
/*   820712  DATE WRITTEN */
/*   881020  Revised to meet SLATEC CML recommendations.  (DWL and JMS) */

/*   901019  Revisions to prologue.  (DWL and WRB) */
/*   901106  Changed all specific intrinsics to generic.  (WRB) */
/*           Corrected order of sections in prologue and added TYPE */
/*           section.  (WRB) */
/*   920127  Revised PURPOSE section of prologue.  (DWL) */
/* ***END PROLOGUE  DXRED */

/* ***FIRST EXECUTABLE STATEMENT  DXRED */
    *ierror = 0;
    if (*x == 0.) {
	goto L90;
    }
    xa = abs(*x);
    if (*ix == 0) {
	goto L70;
    }
    ixa = abs(*ix);
    ixa1 = ixa / dxblk2_1.l2;
    ixa2 = ixa % dxblk2_1.l2;
    if (*ix > 0) {
	goto L40;
    }
L10:
    if (xa > 1.) {
	goto L20;
    }
    xa *= dxblk2_1.rad2l;
    ++ixa1;
    goto L10;
L20:
    xa /= pow_di(&dxblk2_1.radix, &ixa2);
    if (ixa1 == 0) {
	goto L70;
    }
    i__1 = ixa1;
    for (i = 1; i <= i__1; ++i) {
	if (xa < 1.) {
	    goto L100;
	}
	xa /= dxblk2_1.rad2l;
/* L30: */
    }
    goto L70;

L40:
    if (xa < 1.) {
	goto L50;
    }
    xa /= dxblk2_1.rad2l;
    ++ixa1;
    goto L40;
L50:
    xa *= pow_di(&dxblk2_1.radix, &ixa2);
    if (ixa1 == 0) {
	goto L70;
    }
    i__1 = ixa1;
    for (i = 1; i <= i__1; ++i) {
	if (xa > 1.) {
	    goto L100;
	}
	xa *= dxblk2_1.rad2l;
/* L60: */
    }
L70:
    if (xa > dxblk2_1.rad2l) {
	goto L100;
    }
    if (xa > 1.) {
	goto L80;
    }
    if (dxblk2_1.rad2l * xa < 1.) {
	goto L100;
    }
L80:
    *x = d_sign(&xa, x);
L90:
    *ix = 0;
L100:
    return 0;
} /* dxred_ */

/* DECK DXQNU */
/* Subroutine */ int dxqnu_(doublereal *nu1, doublereal *nu2, integer *mu1, 
	doublereal *theta, doublereal *x, doublereal *sx, integer *id, 
	doublereal *pqa, integer *ipqa, integer *ierror)
{
    /* System generated locals */
    doublereal d__1;

    /* Local variables */
    static integer ipql1, ipql2, k;
    extern /* Subroutine */ int dxadd_(doublereal *, integer *, doublereal *, 
	    integer *, doublereal *, integer *, integer *), dxadj_(doublereal 
	    *, integer *, integer *);
    static doublereal x1, x2, pq;
    static integer mu;
    static doublereal nu;
    extern /* Subroutine */ int dxpqnu_(doublereal *, doublereal *, integer *,
	     doublereal *, integer *, doublereal *, integer *, integer *);
    static doublereal pq1, pq2, dmu;
    static integer ipq, ipq1, ipq2;
    static doublereal pql1, pql2;

/* ***BEGIN PROLOGUE  DXQNU */
/* ***SUBSIDIARY */
/* ***PURPOSE  To compute the values of Legendre functions for DXLEGF. */
/*            Method: backward nu-wise recurrence for Q(MU,NU,X) for */
/*            fixed mu to obtain Q(MU1,NU1,X), Q(MU1,NU1+1,X), ..., */
/*            Q(MU1,NU2,X). */
/* ***LIBRARY   SLATEC */
/* ***CATEGORY  C3A2, C9 */
/* ***TYPE      DOUBLE PRECISION (XQNU-S, DXQNU-D) */
/* ***KEYWORDS  LEGENDRE FUNCTIONS */
/* ***AUTHOR  Smith, John M., (NBS and George Mason University) */
/* ***ROUTINES CALLED  DXADD, DXADJ, DXPQNU */
/* ***REVISION HISTORY  (YYMMDD) */
/*   820728  DATE WRITTEN */
/*   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS) */

/*   901019  Revisions to prologue.  (DWL and WRB) */
/*   901106  Corrected order of sections in prologue and added TYPE */
/*           section.  (WRB) */
/*   920127  Revised PURPOSE section of prologue.  (DWL) */
/* ***END PROLOGUE  DXQNU */
/* ***FIRST EXECUTABLE STATEMENT  DXQNU */
    /* Parameter adjustments */
    --ipqa;
    --pqa;

    /* Function Body */
    *ierror = 0;
    k = 0;
    pq2 = 0.;
    ipq2 = 0;
    pql2 = 0.;
    ipql2 = 0;
    if (*mu1 == 1) {
	goto L290;
    }
    mu = 0;

/*        CALL DXPQNU TO OBTAIN Q(0.,NU2,X) AND Q(0.,NU2-1,X) */

    dxpqnu_(nu1, nu2, &mu, theta, id, &pqa[1], &ipqa[1], ierror);
    if (*ierror != 0) {
	return 0;
    }
    if (*mu1 == 0) {
	return 0;
    }
    k = (integer) (*nu2 - *nu1 + 1.5);
    pq2 = pqa[k];
    ipq2 = ipqa[k];
    pql2 = pqa[k - 1];
    ipql2 = ipqa[k - 1];
L290:
    mu = 1;

/*        CALL DXPQNU TO OBTAIN Q(1.,NU2,X) AND Q(1.,NU2-1,X) */

    dxpqnu_(nu1, nu2, &mu, theta, id, &pqa[1], &ipqa[1], ierror);
    if (*ierror != 0) {
	return 0;
    }
    if (*mu1 == 1) {
	return 0;
    }
    nu = *nu2;
    pq1 = pqa[k];
    ipq1 = ipqa[k];
    pql1 = pqa[k - 1];
    ipql1 = ipqa[k - 1];
L300:
    mu = 1;
    dmu = 1.;
L320:

/*        FORWARD RECURRENCE IN MU TO OBTAIN Q(MU1,NU2,X) AND */
/*              Q(MU1,NU2-1,X) USING */
/*              Q(MU+1,NU,X)=-2.*MU*X*SQRT(1./(1.-X**2))*Q(MU,NU,X) */
/*                   -(NU+MU)*(NU-MU+1.)*Q(MU-1,NU,X) */

/*              FIRST FOR NU=NU2 */

    x1 = dmu * -2. * *x * *sx * pq1;
    x2 = (nu + dmu) * (nu - dmu + 1.) * pq2;
    d__1 = -x2;
    dxadd_(&x1, &ipq1, &d__1, &ipq2, &pq, &ipq, ierror);
    if (*ierror != 0) {
	return 0;
    }
    dxadj_(&pq, &ipq, ierror);
    if (*ierror != 0) {
	return 0;
    }
    pq2 = pq1;
    ipq2 = ipq1;
    pq1 = pq;
    ipq1 = ipq;
    ++mu;
    dmu += 1.;
    if (mu < *mu1) {
	goto L320;
    }
    pqa[k] = pq;
    ipqa[k] = ipq;
    if (k == 1) {
	return 0;
    }
    if (nu < *nu2) {
	goto L340;
    }

/*              THEN FOR NU=NU2-1 */

    nu += -1.;
    pq2 = pql2;
    ipq2 = ipql2;
    pq1 = pql1;
    ipq1 = ipql1;
    --k;
    goto L300;

/*         BACKWARD RECURRENCE IN NU TO OBTAIN */
/*              Q(MU1,NU1,X),Q(MU1,NU1+1,X),....,Q(MU1,NU2,X) */
/*              USING */
/*              (NU-MU+1.)*Q(MU,NU+1,X)= */
/*                       (2.*NU+1.)*X*Q(MU,NU,X)-(NU+MU)*Q(MU,NU-1,X) */

L340:
    pq1 = pqa[k];
    ipq1 = ipqa[k];
    pq2 = pqa[k + 1];
    ipq2 = ipqa[k + 1];
L350:
    if (nu <= *nu1) {
	return 0;
    }
    --k;
    x1 = (nu * 2. + 1.) * *x * pq1 / (nu + dmu);
    x2 = -(nu - dmu + 1.) * pq2 / (nu + dmu);
    dxadd_(&x1, &ipq1, &x2, &ipq2, &pq, &ipq, ierror);
    if (*ierror != 0) {
	return 0;
    }
    dxadj_(&pq, &ipq, ierror);
    if (*ierror != 0) {
	return 0;
    }
    pq2 = pq1;
    ipq2 = ipq1;
    pq1 = pq;
    ipq1 = ipq;
    pqa[k] = pq;
    ipqa[k] = ipq;
    nu += -1.;
    goto L350;
} /* dxqnu_ */

/* DECK DXQMU */
/* Subroutine */ int dxqmu_(doublereal *nu1, doublereal *nu2, integer *mu1, 
	integer *mu2, doublereal *theta, doublereal *x, doublereal *sx, 
	integer *id, doublereal *pqa, integer *ipqa, integer *ierror)
{
    /* System generated locals */
    doublereal d__1;

    /* Local variables */
    static integer k;
    extern /* Subroutine */ int dxadd_(doublereal *, integer *, doublereal *, 
	    integer *, doublereal *, integer *, integer *), dxadj_(doublereal 
	    *, integer *, integer *);
    static doublereal x1, x2, pq;
    static integer mu;
    static doublereal nu;
    extern /* Subroutine */ int dxpqnu_(doublereal *, doublereal *, integer *,
	     doublereal *, integer *, doublereal *, integer *, integer *);
    static doublereal pq1, pq2, dmu;
    static integer ipq, ipq1, ipq2;

/* ***BEGIN PROLOGUE  DXQMU */
/* ***SUBSIDIARY */
/* ***PURPOSE  To compute the values of Legendre functions for DXLEGF. */
/*            Method: forward mu-wise recurrence for Q(MU,NU,X) for fixed 
*/
/*            nu to obtain Q(MU1,NU,X), Q(MU1+1,NU,X), ..., Q(MU2,NU,X). 
*/
/* ***LIBRARY   SLATEC */
/* ***CATEGORY  C3A2, C9 */
/* ***TYPE      DOUBLE PRECISION (XQMU-S, DXQMU-D) */
/* ***KEYWORDS  LEGENDRE FUNCTIONS */
/* ***AUTHOR  Smith, John M., (NBS and George Mason University) */
/* ***ROUTINES CALLED  DXADD, DXADJ, DXPQNU */
/* ***REVISION HISTORY  (YYMMDD) */
/*   820728  DATE WRITTEN */
/*   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS) */

/*   901019  Revisions to prologue.  (DWL and WRB) */
/*   901106  Corrected order of sections in prologue and added TYPE */
/*           section.  (WRB) */
/*   920127  Revised PURPOSE section of prologue.  (DWL) */
/* ***END PROLOGUE  DXQMU */
/* ***FIRST EXECUTABLE STATEMENT  DXQMU */
    /* Parameter adjustments */
    --ipqa;
    --pqa;

    /* Function Body */
    *ierror = 0;
    mu = 0;

/*        CALL DXPQNU TO OBTAIN Q(0.,NU1,X) */

    dxpqnu_(nu1, nu2, &mu, theta, id, &pqa[1], &ipqa[1], ierror);
    if (*ierror != 0) {
	return 0;
    }
    pq2 = pqa[1];
    ipq2 = ipqa[1];
    mu = 1;

/*        CALL DXPQNU TO OBTAIN Q(1.,NU1,X) */

    dxpqnu_(nu1, nu2, &mu, theta, id, &pqa[1], &ipqa[1], ierror);
    if (*ierror != 0) {
	return 0;
    }
    nu = *nu1;
    k = 0;
    mu = 1;
    dmu = 1.;
    pq1 = pqa[1];
    ipq1 = ipqa[1];
    if (*mu1 > 0) {
	goto L310;
    }
    ++k;
    pqa[k] = pq2;
    ipqa[k] = ipq2;
    if (*mu2 < 1) {
	goto L330;
    }
L310:
    if (*mu1 > 1) {
	goto L320;
    }
    ++k;
    pqa[k] = pq1;
    ipqa[k] = ipq1;
    if (*mu2 <= 1) {
	goto L330;
    }
L320:

/*        FORWARD RECURRENCE IN MU TO OBTAIN */
/*                  Q(MU1,NU,X),Q(MU1+1,NU,X),....,Q(MU2,NU,X) USING */
/*             Q(MU+1,NU,X)=-2.*MU*X*SQRT(1./(1.-X**2))*Q(MU,NU,X) */
/*                               -(NU+MU)*(NU-MU+1.)*Q(MU-1,NU,X) */

    x1 = dmu * -2. * *x * *sx * pq1;
    x2 = (nu + dmu) * (nu - dmu + 1.) * pq2;
    d__1 = -x2;
    dxadd_(&x1, &ipq1, &d__1, &ipq2, &pq, &ipq, ierror);
    if (*ierror != 0) {
	return 0;
    }
    dxadj_(&pq, &ipq, ierror);
    if (*ierror != 0) {
	return 0;
    }
    pq2 = pq1;
    ipq2 = ipq1;
    pq1 = pq;
    ipq1 = ipq;
    ++mu;
    dmu += 1.;
    if (mu < *mu1) {
	goto L320;
    }
    ++k;
    pqa[k] = pq;
    ipqa[k] = ipq;
    if (*mu2 > mu) {
	goto L320;
    }
L330:
    return 0;
} /* dxqmu_ */

/* DECK DXPQNU */
/* Subroutine */ int dxpqnu_(doublereal *nu1, doublereal *nu2, integer *mu, 
	doublereal *theta, integer *id, doublereal *pqa, integer *ipqa, 
	integer *ierror)
{
    /* System generated locals */
    integer i__1;
    doublereal d__1;

    /* Builtin functions */
    double d_mod(doublereal *, doublereal *), cos(doublereal), sin(doublereal)
	    , tan(doublereal), log(doublereal);

    /* Local variables */
    static doublereal flok, a;
    static integer i, j, k;
    static doublereal r;
    extern /* Subroutine */ int dxadd_(doublereal *, integer *, doublereal *, 
	    integer *, doublereal *, integer *, integer *);
    static doublereal w, x, y, z;
    extern /* Subroutine */ int dxadj_(doublereal *, integer *, integer *);
    static integer ipsik;
    extern doublereal dxpsi_(doublereal *, integer *, integer *);
    static integer j0, ipsix;
    static doublereal x1, x2;
    static integer ia;
    static doublereal di;
    static integer if_;
    static doublereal pq, nu, xs, factmu, pq1, pq2;
    static integer ix1;
    static doublereal dmu;
    static integer ipq, ixs, ipq1, ipq2;

/* ***BEGIN PROLOGUE  DXPQNU */
/* ***SUBSIDIARY */
/* ***PURPOSE  To compute the values of Legendre functions for DXLEGF. */
/*            This subroutine calculates initial values of P or Q using */

/*            power series, then performs forward nu-wise recurrence to */

/*            obtain P(-MU,NU,X), Q(0,NU,X), or Q(1,NU,X). The nu-wise */
/*            recurrence is stable for P for all mu and for Q for mu=0,1. 
*/
/* ***LIBRARY   SLATEC */
/* ***CATEGORY  C3A2, C9 */
/* ***TYPE      DOUBLE PRECISION (XPQNU-S, DXPQNU-D) */
/* ***KEYWORDS  LEGENDRE FUNCTIONS */
/* ***AUTHOR  Smith, John M., (NBS and George Mason University) */
/* ***ROUTINES CALLED  DXADD, DXADJ, DXPSI */
/* ***COMMON BLOCKS    DXBLK1 */
/* ***REVISION HISTORY  (YYMMDD) */
/*   820728  DATE WRITTEN */
/*   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS) */

/*   901019  Revisions to prologue.  (DWL and WRB) */
/*   901106  Changed all specific intrinsics to generic.  (WRB) */
/*           Corrected order of sections in prologue and added TYPE */
/*           section.  (WRB) */
/*   920127  Revised PURPOSE section of prologue.  (DWL) */
/* ***END PROLOGUE  DXPQNU */

/*        J0, IPSIK, AND IPSIX ARE INITIALIZED IN THIS SUBROUTINE. */
/*        J0 IS THE NUMBER OF TERMS USED IN SERIES EXPANSION */
/*        IN SUBROUTINE DXPQNU. */
/*        IPSIK, IPSIX ARE VALUES OF K AND X RESPECTIVELY */
/*        USED IN THE CALCULATION OF THE DXPSI FUNCTION. */

/* ***FIRST EXECUTABLE STATEMENT  DXPQNU */
    /* Parameter adjustments */
    --ipqa;
    --pqa;

    /* Function Body */
    *ierror = 0;
    j0 = dxblk1_1.nbitsf;
    ipsik = dxblk1_1.nbitsf / 10 + 1;
    ipsix = ipsik * 5;
    ipq = 0;
/*        FIND NU IN INTERVAL [-.5,.5) IF ID=2  ( CALCULATION OF Q ) */
    nu = d_mod(nu1, &c_b29);
    if (nu >= .5) {
	nu += -1.;
    }
/*        FIND NU IN INTERVAL (-1.5,-.5] IF ID=1,3, OR 4  ( CALC. OF P ) 
*/
    if (*id != 2 && nu > -.5) {
	nu += -1.;
    }
/*        CALCULATE MU FACTORIAL */
    k = *mu;
    dmu = (doublereal) (*mu);
    if (*mu <= 0) {
	goto L60;
    }
    factmu = 1.;
    if_ = 0;
    i__1 = k;
    for (i = 1; i <= i__1; ++i) {
	factmu *= i;
/* L50: */
	dxadj_(&factmu, &if_, ierror);
    }
    if (*ierror != 0) {
	return 0;
    }
L60:
    if (k == 0) {
	factmu = 1.;
    }
    if (k == 0) {
	if_ = 0;
    }

/*        X=COS(THETA) */
/*        Y=SIN(THETA/2)**2=(1-X)/2=.5-.5*X */
/*        R=TAN(THETA/2)=SQRT((1-X)/(1+X) */

    x = cos(*theta);
/* Computing 2nd power */
    d__1 = sin(*theta / 2.);
    y = d__1 * d__1;
    r = tan(*theta / 2.);

/*        USE ASCENDING SERIES TO CALCULATE TWO VALUES OF P OR Q */
/*        FOR USE AS STARTING VALUES IN RECURRENCE RELATION. */

    pq2 = 0.;
    for (j = 1; j <= 2; ++j) {
	ipq1 = 0;
	if (*id == 2) {
	    goto L80;
	}

/*        SERIES FOR P ( ID = 1, 3, OR 4 ) */
/*        P(-MU,NU,X)=1./FACTORIAL(MU)*SQRT(((1.-X)/(1.+X))**MU) */
/*                *SUM(FROM 0 TO J0-1)A(J)*(.5-.5*X)**J */

	ipq = 0;
	pq = 1.;
	a = 1.;
	ia = 0;
	i__1 = j0;
	for (i = 2; i <= i__1; ++i) {
	    di = (doublereal) i;
	    a = a * y * (di - 2. - nu) * (di - 1. + nu) / ((di - 1. + dmu) * (
		    di - 1.));
	    dxadj_(&a, &ia, ierror);
	    if (*ierror != 0) {
		return 0;
	    }
	    if (a == 0.) {
		goto L66;
	    }
	    dxadd_(&pq, &ipq, &a, &ia, &pq, &ipq, ierror);
	    if (*ierror != 0) {
		return 0;
	    }
/* L65: */
	}
L66:
	if (*mu <= 0) {
	    goto L90;
	}
	x2 = r;
	x1 = pq;
	k = *mu;
	i__1 = k;
	for (i = 1; i <= i__1; ++i) {
	    x1 *= x2;
/* L77: */
	    dxadj_(&x1, &ipq, ierror);
	}
	if (*ierror != 0) {
	    return 0;
	}
	pq = x1 / factmu;
	ipq -= if_;
	dxadj_(&pq, &ipq, ierror);
	if (*ierror != 0) {
	    return 0;
	}
	goto L90;

/*        Z=-LN(R)=.5*LN((1+X)/(1-X)) */

L80:
	z = -log(r);
	d__1 = nu + 1.;
	w = dxpsi_(&d__1, &ipsik, &ipsix);
	xs = 1. / sin(*theta);

/*        SERIES SUMMATION FOR Q ( ID = 2 ) */
/*        Q(0,NU,X)=SUM(FROM 0 TO J0-1)((.5*LN((1+X)/(1-X)) */
/*    +DXPSI(J+1,IPSIK,IPSIX)-DXPSI(NU+1,IPSIK,IPSIX)))*A(J)*(.5-.5*X)
**J */

/*        Q(1,NU,X)=-SQRT(1./(1.-X**2))+SQRT((1-X)/(1+X)) */
/*             *SUM(FROM 0 T0 J0-1)(-NU*(NU+1)/2*LN((1+X)/(1-X)) */
/*                 +(J-NU)*(J+NU+1)/(2*(J+1))+NU*(NU+1)* */
/*     (DXPSI(NU+1,IPSIK,IPSIX)-DXPSI(J+1,IPSIK,IPSIX))*A(J)*(.5-.5*X)
**J */

/*        NOTE, IN THIS LOOP K=J+1 */

	pq = 0.;
	ipq = 0;
	ia = 0;
	a = 1.;
	i__1 = j0;
	for (k = 1; k <= i__1; ++k) {
	    flok = (doublereal) k;
	    if (k == 1) {
		goto L81;
	    }
	    a = a * y * (flok - 2. - nu) * (flok - 1. + nu) / ((flok - 1. + 
		    dmu) * (flok - 1.));
	    dxadj_(&a, &ia, ierror);
	    if (*ierror != 0) {
		return 0;
	    }
L81:
	    if (*mu >= 1) {
		goto L83;
	    }
	    x1 = (dxpsi_(&flok, &ipsik, &ipsix) - w + z) * a;
	    ix1 = ia;
	    dxadd_(&pq, &ipq, &x1, &ix1, &pq, &ipq, ierror);
	    if (*ierror != 0) {
		return 0;
	    }
	    goto L85;
L83:
	    x1 = (nu * (nu + 1.) * (z - w + dxpsi_(&flok, &ipsik, &ipsix)) + (
		    nu - flok + 1.) * (nu + flok) / (flok * 2.)) * a;
	    ix1 = ia;
	    dxadd_(&pq, &ipq, &x1, &ix1, &pq, &ipq, ierror);
	    if (*ierror != 0) {
		return 0;
	    }
L85:
	    ;
	}
	if (*mu >= 1) {
	    pq = -r * pq;
	}
	ixs = 0;
	if (*mu >= 1) {
	    d__1 = -xs;
	    dxadd_(&pq, &ipq, &d__1, &ixs, &pq, &ipq, ierror);
	}
	if (*ierror != 0) {
	    return 0;
	}
	if (j == 2) {
	    *mu = -(*mu);
	}
	if (j == 2) {
	    dmu = -dmu;
	}
L90:
	if (j == 1) {
	    pq2 = pq;
	}
	if (j == 1) {
	    ipq2 = ipq;
	}
	nu += 1.;
/* L100: */
    }
    k = 0;
    if (nu - 1.5 < *nu1) {
	goto L120;
    }
    ++k;
    pqa[k] = pq2;
    ipqa[k] = ipq2;
    if (nu > *nu2 + .5) {
	return 0;
    }
L120:
    pq1 = pq;
    ipq1 = ipq;
    if (nu < *nu1 + .5) {
	goto L130;
    }
    ++k;
    pqa[k] = pq;
    ipqa[k] = ipq;
    if (nu > *nu2 + .5) {
	return 0;
    }

/*        FORWARD NU-WISE RECURRENCE FOR F(MU,NU,X) FOR FIXED MU */
/*        USING */
/*        (NU+MU+1)*F(MU,NU,X)=(2.*NU+1)*F(MU,NU,X)-(NU-MU)*F(MU,NU-1,X) 
*/
/*        WHERE F(MU,NU,X) MAY BE P(-MU,NU,X) OR IF MU IS REPLACED */
/*        BY -MU THEN F(MU,NU,X) MAY BE Q(MU,NU,X). */
/*        NOTE, IN THIS LOOP, NU=NU+1 */

L130:
    x1 = (nu * 2. - 1.) / (nu + dmu) * x * pq1;
    x2 = (nu - 1. - dmu) / (nu + dmu) * pq2;
    d__1 = -x2;
    dxadd_(&x1, &ipq1, &d__1, &ipq2, &pq, &ipq, ierror);
    if (*ierror != 0) {
	return 0;
    }
    dxadj_(&pq, &ipq, ierror);
    if (*ierror != 0) {
	return 0;
    }
    nu += 1.;
    pq2 = pq1;
    ipq2 = ipq1;
    goto L120;

} /* dxpqnu_ */

/* DECK DXPNRM */
/* Subroutine */ int dxpnrm_(doublereal *nu1, doublereal *nu2, integer *mu1, 
	integer *mu2, doublereal *pqa, integer *ipqa, integer *ierror)
{
    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    double sqrt(doublereal);

    /* Local variables */
    static doublereal prod;
    static integer i, j, k, l;
    extern /* Subroutine */ int dxadj_(doublereal *, integer *, integer *);
    static integer iprod;
    static doublereal c1;
    static integer mu;
    static doublereal nu, dmu;

/* ***BEGIN PROLOGUE  DXPNRM */
/* ***SUBSIDIARY */
/* ***PURPOSE  To compute the values of Legendre functions for DXLEGF. */
/*            This subroutine transforms an array of Legendre functions */

/*            of the first kind of negative order stored in array PQA */
/*            into normalized Legendre polynomials stored in array PQA. */

/*            The original array is destroyed. */
/* ***LIBRARY   SLATEC */
/* ***CATEGORY  C3A2, C9 */
/* ***TYPE      DOUBLE PRECISION (XPNRM-S, DXPNRM-D) */
/* ***KEYWORDS  LEGENDRE FUNCTIONS */
/* ***AUTHOR  Smith, John M., (NBS and George Mason University) */
/* ***ROUTINES CALLED  DXADJ */
/* ***REVISION HISTORY  (YYMMDD) */
/*   820728  DATE WRITTEN */
/*   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS) */

/*   901019  Revisions to prologue.  (DWL and WRB) */
/*   901106  Changed all specific intrinsics to generic.  (WRB) */
/*           Corrected order of sections in prologue and added TYPE */
/*           section.  (WRB) */
/*   920127  Revised PURPOSE section of prologue.  (DWL) */
/* ***END PROLOGUE  DXPNRM */
/* ***FIRST EXECUTABLE STATEMENT  DXPNRM */
    /* Parameter adjustments */
    --ipqa;
    --pqa;

    /* Function Body */
    *ierror = 0;
    l = (integer) (*mu2 - *mu1 + (*nu2 - *nu1 + 1.5));
    mu = *mu1;
    dmu = (doublereal) (*mu1);
    nu = *nu1;

/*         IF MU .GT.NU, NORM P =0. */

    j = 1;
L500:
    if (dmu <= nu) {
	goto L505;
    }
    pqa[j] = 0.;
    ipqa[j] = 0;
    ++j;
    if (j > l) {
	return 0;
    }

/*        INCREMENT EITHER MU OR NU AS APPROPRIATE. */

    if (*mu2 > *mu1) {
	dmu += 1.;
    }
    if (*nu2 - *nu1 > .5) {
	nu += 1.;
    }
    goto L500;

/*         TRANSFORM P(-MU,NU,X) INTO NORMALIZED P(MU,NU,X) USING */
/*              NORM P(MU,NU,X)= */
/*                 SQRT((NU+.5)*FACTORIAL(NU+MU)/FACTORIAL(NU-MU)) */
/*                              *P(-MU,NU,X) */

L505:
    prod = 1.;
    iprod = 0;
    k = mu << 1;
    if (k <= 0) {
	goto L520;
    }
    i__1 = k;
    for (i = 1; i <= i__1; ++i) {
	prod *= sqrt(nu + dmu + 1. - i);
/* L510: */
	dxadj_(&prod, &iprod, ierror);
    }
    if (*ierror != 0) {
	return 0;
    }
L520:
    i__1 = l;
    for (i = j; i <= i__1; ++i) {
	c1 = prod * sqrt(nu + .5);
	pqa[i] *= c1;
	ipqa[i] += iprod;
	dxadj_(&pqa[i], &ipqa[i], ierror);
	if (*ierror != 0) {
	    return 0;
	}
	if (*nu2 - *nu1 > .5) {
	    goto L530;
	}
	if (dmu >= nu) {
	    goto L525;
	}
	prod = sqrt(nu + dmu + 1.) * prod;
	if (nu > dmu) {
	    prod *= sqrt(nu - dmu);
	}
	dxadj_(&prod, &iprod, ierror);
	if (*ierror != 0) {
	    return 0;
	}
	++mu;
	dmu += 1.;
	goto L540;
L525:
	prod = 0.;
	iprod = 0;
	++mu;
	dmu += 1.;
	goto L540;
L530:
	prod = sqrt(nu + dmu + 1.) * prod;
	if (nu != dmu - 1.) {
	    prod /= sqrt(nu - dmu + 1.);
	}
	dxadj_(&prod, &iprod, ierror);
	if (*ierror != 0) {
	    return 0;
	}
	nu += 1.;
L540:
	;
    }
    return 0;
} /* dxpnrm_ */

/* DECK DXPMUP */
/* Subroutine */ int dxpmup_(doublereal *nu1, doublereal *nu2, integer *mu1, 
	integer *mu2, doublereal *pqa, integer *ipqa, integer *ierror)
{
    /* System generated locals */
    integer i__1;
    real r__1;

    /* Builtin functions */
    double r_mod(real *, real *);
    integer pow_ii(integer *, integer *);

    /* Local variables */
    static doublereal prod;
    static integer i, j, k, l, n;
    extern /* Subroutine */ int dxadj_(doublereal *, integer *, integer *);
    static integer iprod, mu;
    static doublereal nu, dmu;

/* ***BEGIN PROLOGUE  DXPMUP */
/* ***SUBSIDIARY */
/* ***PURPOSE  To compute the values of Legendre functions for DXLEGF. */
/*            This subroutine transforms an array of Legendre functions */

/*            of the first kind of negative order stored in array PQA */
/*            into Legendre functions of the first kind of positive */
/*            order stored in array PQA. The original array is destroyed. 
*/
/* ***LIBRARY   SLATEC */
/* ***CATEGORY  C3A2, C9 */
/* ***TYPE      DOUBLE PRECISION (XPMUP-S, DXPMUP-D) */
/* ***KEYWORDS  LEGENDRE FUNCTIONS */
/* ***AUTHOR  Smith, John M., (NBS and George Mason University) */
/* ***ROUTINES CALLED  DXADJ */
/* ***REVISION HISTORY  (YYMMDD) */
/*   820728  DATE WRITTEN */
/*   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS) */

/*   901019  Revisions to prologue.  (DWL and WRB) */
/*   901106  Changed all specific intrinsics to generic.  (WRB) */
/*           Corrected order of sections in prologue and added TYPE */
/*           section.  (WRB) */
/*   920127  Revised PURPOSE section of prologue.  (DWL) */
/* ***END PROLOGUE  DXPMUP */
/* ***FIRST EXECUTABLE STATEMENT  DXPMUP */
    /* Parameter adjustments */
    --ipqa;
    --pqa;

    /* Function Body */
    *ierror = 0;
    nu = *nu1;
    mu = *mu1;
    dmu = (doublereal) mu;
    n = (integer) (*nu2 - *nu1 + .1) + (*mu2 - *mu1) + 1;
    j = 1;
    r__1 = nu;
    if (r_mod(&r__1, &c_b103) != 0.f) {
	goto L210;
    }
L200:
    if (dmu < nu + 1.) {
	goto L210;
    }
    pqa[j] = 0.;
    ipqa[j] = 0;
    ++j;
    if (j > n) {
	return 0;
    }
/*        INCREMENT EITHER MU OR NU AS APPROPRIATE. */
    if (*nu2 - *nu1 > .5) {
	nu += 1.;
    }
    if (*mu2 > *mu1) {
	++mu;
    }
    goto L200;

/*        TRANSFORM P(-MU,NU,X) TO P(MU,NU,X) USING */
/*        P(MU,NU,X)=(NU-MU+1)*(NU-MU+2)*...*(NU+MU)*P(-MU,NU,X)*(-1)**MU 
*/

L210:
    prod = 1.;
    iprod = 0;
    k = mu << 1;
    if (k == 0) {
	goto L222;
    }
    i__1 = k;
    for (l = 1; l <= i__1; ++l) {
	prod *= dmu - nu - l;
/* L220: */
	dxadj_(&prod, &iprod, ierror);
    }
    if (*ierror != 0) {
	return 0;
    }
L222:
    i__1 = n;
    for (i = j; i <= i__1; ++i) {
	if (mu == 0) {
	    goto L225;
	}
	pqa[i] = pqa[i] * prod * pow_ii(&c_n1, &mu);
	ipqa[i] += iprod;
	dxadj_(&pqa[i], &ipqa[i], ierror);
	if (*ierror != 0) {
	    return 0;
	}
L225:
	if (*nu2 - *nu1 > .5) {
	    goto L230;
	}
	prod = (dmu - nu) * prod * (-dmu - nu - 1.);
	dxadj_(&prod, &iprod, ierror);
	if (*ierror != 0) {
	    return 0;
	}
	++mu;
	dmu += 1.;
	goto L240;
L230:
	prod = prod * (-dmu - nu - 1.) / (dmu - nu - 1.);
	dxadj_(&prod, &iprod, ierror);
	if (*ierror != 0) {
	    return 0;
	}
	nu += 1.;
L240:
	;
    }
    return 0;
} /* dxpmup_ */

/* DECK DXPMU */
/* Subroutine */ int dxpmu_(doublereal *nu1, doublereal *nu2, integer *mu1, 
	integer *mu2, doublereal *theta, doublereal *x, doublereal *sx, 
	integer *id, doublereal *pqa, integer *ipqa, integer *ierror)
{
    static integer j, n;
    extern /* Subroutine */ int dxadd_(doublereal *, integer *, doublereal *, 
	    integer *, doublereal *, integer *, integer *), dxadj_(doublereal 
	    *, integer *, integer *);
    static doublereal p0, x1, x2;
    static integer mu, ip0;
    extern /* Subroutine */ int dxpqnu_(doublereal *, doublereal *, integer *,
	     doublereal *, integer *, doublereal *, integer *, integer *);

/* ***BEGIN PROLOGUE  DXPMU */
/* ***SUBSIDIARY */
/* ***PURPOSE  To compute the values of Legendre functions for DXLEGF. */
/*            Method: backward mu-wise recurrence for P(-MU,NU,X) for */
/*            fixed nu to obtain P(-MU2,NU1,X), P(-(MU2-1),NU1,X), ..., */

/*            P(-MU1,NU1,X) and store in ascending mu order. */
/* ***LIBRARY   SLATEC */
/* ***CATEGORY  C3A2, C9 */
/* ***TYPE      DOUBLE PRECISION (XPMU-S, DXPMU-D) */
/* ***KEYWORDS  LEGENDRE FUNCTIONS */
/* ***AUTHOR  Smith, John M., (NBS and George Mason University) */
/* ***ROUTINES CALLED  DXADD, DXADJ, DXPQNU */
/* ***REVISION HISTORY  (YYMMDD) */
/*   820728  DATE WRITTEN */
/*   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS) */

/*   901019  Revisions to prologue.  (DWL and WRB) */
/*   901106  Changed all specific intrinsics to generic.  (WRB) */
/*           Corrected order of sections in prologue and added TYPE */
/*           section.  (WRB) */
/*   920127  Revised PURPOSE section of prologue.  (DWL) */
/* ***END PROLOGUE  DXPMU */

/*        CALL DXPQNU TO OBTAIN P(-MU2,NU,X) */

/* ***FIRST EXECUTABLE STATEMENT  DXPMU */
    /* Parameter adjustments */
    --ipqa;
    --pqa;

    /* Function Body */
    *ierror = 0;
    dxpqnu_(nu1, nu2, mu2, theta, id, &pqa[1], &ipqa[1], ierror);
    if (*ierror != 0) {
	return 0;
    }
    p0 = pqa[1];
    ip0 = ipqa[1];
    mu = *mu2 - 1;

/*        CALL DXPQNU TO OBTAIN P(-MU2-1,NU,X) */

    dxpqnu_(nu1, nu2, &mu, theta, id, &pqa[1], &ipqa[1], ierror);
    if (*ierror != 0) {
	return 0;
    }
    n = *mu2 - *mu1 + 1;
    pqa[n] = p0;
    ipqa[n] = ip0;
    if (n == 1) {
	goto L300;
    }
    pqa[n - 1] = pqa[1];
    ipqa[n - 1] = ipqa[1];
    if (n == 2) {
	goto L300;
    }
    j = n - 2;
L290:

/*        BACKWARD RECURRENCE IN MU TO OBTAIN */
/*              P(-MU2,NU1,X),P(-(MU2-1),NU1,X),....P(-MU1,NU1,X) */
/*              USING */
/*              (NU-MU)*(NU+MU+1.)*P(-(MU+1),NU,X)= */
/*                2.*MU*X*SQRT((1./(1.-X**2))*P(-MU,NU,X)-P(-(MU-1),NU,X) 
*/

    x1 = mu * 2. * *x * *sx * pqa[j + 1];
    x2 = -(*nu1 - mu) * (*nu1 + mu + 1.) * pqa[j + 2];
    dxadd_(&x1, &ipqa[j + 1], &x2, &ipqa[j + 2], &pqa[j], &ipqa[j], ierror);
    if (*ierror != 0) {
	return 0;
    }
    dxadj_(&pqa[j], &ipqa[j], ierror);
    if (*ierror != 0) {
	return 0;
    }
    if (j == 1) {
	goto L300;
    }
    --j;
    --mu;
    goto L290;
L300:
    return 0;
} /* dxpmu_ */

/* DECK DXCON */
/* Subroutine */ int dxcon_(doublereal *x, integer *ix, integer *ierror)
{
    /* Initialized data */

    static integer ispace = 1;

    /* System generated locals */
    integer i__1;
    doublereal d__1;

    /* Builtin functions */
    integer i_sign(integer *, integer *);
    double d_lg10(doublereal *), pow_di(doublereal *, integer *);

    /* Local variables */
    extern /* Subroutine */ int dxc210_(integer *, doublereal *, integer *, 
	    integer *);
    static doublereal a, b;
    static integer i, j, icase;
    static doublereal z;
    extern /* Subroutine */ int dxadj_(doublereal *, integer *, integer *), 
	    dxred_(doublereal *, integer *, integer *);
    static integer itemp, i1, j1, j2;

/* ***BEGIN PROLOGUE  DXCON */
/* ***PURPOSE  To provide double-precision floating-point arithmetic */
/*            with an extended exponent range. */
/* ***LIBRARY   SLATEC */
/* ***CATEGORY  A3D */
/* ***TYPE      DOUBLE PRECISION (XCON-S, DXCON-D) */
/* ***KEYWORDS  EXTENDED-RANGE DOUBLE-PRECISION ARITHMETIC */
/* ***AUTHOR  Lozier, Daniel W., (National Bureau of Standards) */
/*           Smith, John M., (NBS and George Mason University) */
/* ***DESCRIPTION */
/*     DOUBLE PRECISION X */
/*     INTEGER IX */

/*                  CONVERTS (X,IX) = X*RADIX**IX */
/*                  TO DECIMAL FORM IN PREPARATION FOR */
/*                  PRINTING, SO THAT (X,IX) = X*10**IX */
/*                  WHERE 1/10 .LE. ABS(X) .LT. 1 */
/*                  IS RETURNED, EXCEPT THAT IF */
/*                  (ABS(X),IX) IS BETWEEN RADIX**(-2L) */
/*                  AND RADIX**(2L) THEN THE REDUCED */
/*                  FORM WITH IX = 0 IS RETURNED. */

/* ***SEE ALSO  DXSET */
/* ***REFERENCES  (NONE) */
/* ***ROUTINES CALLED  DXADJ, DXC210, DXRED */
/* ***COMMON BLOCKS    DXBLK2 */
/* ***REVISION HISTORY  (YYMMDD) */
/*   820712  DATE WRITTEN */
/*   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS) */

/*   901019  Revisions to prologue.  (DWL and WRB) */
/*   901106  Changed all specific intrinsics to generic.  (WRB) */
/*           Corrected order of sections in prologue and added TYPE */
/*           section.  (WRB) */
/*   920127  Revised PURPOSE section of prologue.  (DWL) */
/* ***END PROLOGUE  DXCON */

/*   THE CONDITIONS IMPOSED ON L AND KMAX BY THIS SUBROUTINE */
/* ARE */
/*    (1) 4 .LE. L .LE. 2**NBITS - 1 - KMAX */

/*    (2) KMAX .LE. ((2**NBITS)-2)/LOG10R - L */

/* THESE CONDITIONS MUST BE MET BY APPROPRIATE CODING */
/* IN SUBROUTINE DXSET. */



/*   THE PARAMETER ISPACE IS THE INCREMENT USED IN FORM- */
/* ING THE AUXILIARY INDEX OF THE DECIMAL EXTENDED-RANGE */
/* FORM. THE RETURNED VALUE OF IX WILL BE AN INTEGER MULT- */
/* IPLE OF ISPACE. ISPACE MUST SATISFY 1 .LE. ISPACE .LE. */
/* L/2. IF A VALUE GREATER THAN 1 IS TAKEN, THE RETURNED */
/* VALUE OF X WILL SATISFY 10**(-ISPACE) .LE. ABS(X) .LE. 1 */
/* WHEN (ABS(X),IX) .LT. RADIX**(-2L), AND 1/10 .LE. ABS(X) */
/* .LT. 10**(ISPACE-1) WHEN (ABS(X),IX) .GT. RADIX**(2L). */

/* ***FIRST EXECUTABLE STATEMENT  DXCON */
    *ierror = 0;
    dxred_(x, ix, ierror);
    if (*ierror != 0) {
	return 0;
    }
    if (*ix == 0) {
	goto L150;
    }
    dxadj_(x, ix, ierror);
    if (*ierror != 0) {
	return 0;
    }

/* CASE 1 IS WHEN (X,IX) IS LESS THAN RADIX**(-2L) IN MAGNITUDE, */
/* CASE 2 IS WHEN (X,IX) IS GREATER THAN RADIX**(2L) IN MAGNITUDE. */
    itemp = 1;
    icase = (i_sign(&itemp, ix) + 3) / 2;
    switch (icase) {
	case 1:  goto L10;
	case 2:  goto L20;
    }
L10:
    if (abs(*x) < 1.) {
	goto L30;
    }
    *x /= dxblk2_1.radixl;
    *ix += dxblk2_1.l;
    goto L30;
L20:
    if (abs(*x) >= 1.) {
	goto L30;
    }
    *x *= dxblk2_1.radixl;
    *ix -= dxblk2_1.l;
L30:

/* AT THIS POINT, RADIX**(-L) .LE. ABS(X) .LT. 1.0D0     IN CASE 1, */
/*                      1.0D0 .LE. ABS(X) .LT. RADIX**L  IN CASE 2. */
    d__1 = abs(*x);
    i = (integer) (d_lg10(&d__1) / dxblk2_1.dlg10r);
    a = pow_di(&dxblk2_1.radix, &i);
    switch (icase) {
	case 1:  goto L40;
	case 2:  goto L60;
    }
L40:
    if (a <= dxblk2_1.radix * abs(*x)) {
	goto L50;
    }
    --i;
    a /= dxblk2_1.radix;
    goto L40;
L50:
    if (abs(*x) < a) {
	goto L80;
    }
    ++i;
    a *= dxblk2_1.radix;
    goto L50;
L60:
    if (a <= abs(*x)) {
	goto L70;
    }
    --i;
    a /= dxblk2_1.radix;
    goto L60;
L70:
    if (abs(*x) < dxblk2_1.radix * a) {
	goto L80;
    }
    ++i;
    a *= dxblk2_1.radix;
    goto L70;
L80:

/* AT THIS POINT I IS SUCH THAT */
/* RADIX**(I-1) .LE. ABS(X) .LT. RADIX**I      IN CASE 1, */
/*     RADIX**I .LE. ABS(X) .LT. RADIX**(I+1)  IN CASE 2. */
    itemp = (integer) (ispace / dxblk2_1.dlg10r);
    a = pow_di(&dxblk2_1.radix, &itemp);
    b = pow_di(&c_b125, &ispace);
L90:
    if (a <= b) {
	goto L100;
    }
    --itemp;
    a /= dxblk2_1.radix;
    goto L90;
L100:
    if (b < a * dxblk2_1.radix) {
	goto L110;
    }
    ++itemp;
    a *= dxblk2_1.radix;
    goto L100;
L110:

/* AT THIS POINT ITEMP IS SUCH THAT */
/* RADIX**ITEMP .LE. 10**ISPACE .LT. RADIX**(ITEMP+1). */
    if (itemp > 0) {
	goto L120;
    }
/* ITEMP = 0 IF, AND ONLY IF, ISPACE = 1 AND RADIX = 16.0D0 */
    i__1 = -i;
    *x *= pow_di(&dxblk2_1.radix, &i__1);
    *ix += i;
    dxc210_(ix, &z, &j, ierror);
    if (*ierror != 0) {
	return 0;
    }
    *x *= z;
    *ix = j;
    switch (icase) {
	case 1:  goto L130;
	case 2:  goto L140;
    }
L120:
    i1 = i / itemp;
    i__1 = -i1 * itemp;
    *x *= pow_di(&dxblk2_1.radix, &i__1);
    *ix += i1 * itemp;

/* AT THIS POINT, */
/* RADIX**(-ITEMP) .LE. ABS(X) .LT. 1.0D0        IN CASE 1, */
/*           1.0D0 .LE. ABS(X) .LT. RADIX**ITEMP IN CASE 2. */
    dxc210_(ix, &z, &j, ierror);
    if (*ierror != 0) {
	return 0;
    }
    j1 = j / ispace;
    j2 = j - j1 * ispace;
    *x = *x * z * pow_di(&c_b125, &j2);
    *ix = j1 * ispace;

/* AT THIS POINT, */
/*  10.0D0**(-2*ISPACE) .LE. ABS(X) .LT. 1.0D0                IN CASE 1, 
*/
/*           10.0D0**-1 .LE. ABS(X) .LT. 10.0D0**(2*ISPACE-1) IN CASE 2. 
*/
    switch (icase) {
	case 1:  goto L130;
	case 2:  goto L140;
    }
L130:
    if (b * abs(*x) >= 1.) {
	goto L150;
    }
    *x *= b;
    *ix -= ispace;
    goto L130;
L140:
    if (abs(*x) * 10. < b) {
	goto L150;
    }
    *x /= b;
    *ix += ispace;
    goto L140;
L150:
    return 0;
} /* dxcon_ */

/* DECK DXC210 */
/* Subroutine */ int dxc210_(integer *k, doublereal *z, integer *j, integer *
	ierror)
{
    /* System generated locals */
    integer i__1;
    doublereal d__1;

    /* Builtin functions */
    double pow_dd(doublereal *, doublereal *);

    /* Local variables */
    static integer i, m, ja, ka, ic, id, ii, it, ka1, ka2, nm1, np1;

/* ***BEGIN PROLOGUE  DXC210 */
/* ***PURPOSE  To provide double-precision floating-point arithmetic */
/*            with an extended exponent range. */
/* ***LIBRARY   SLATEC */
/* ***CATEGORY  A3D */
/* ***TYPE      DOUBLE PRECISION (XC210-S, DXC210-D) */
/* ***KEYWORDS  EXTENDED-RANGE DOUBLE-PRECISION ARITHMETIC */
/* ***AUTHOR  Lozier, Daniel W., (National Bureau of Standards) */
/*           Smith, John M., (NBS and George Mason University) */
/* ***DESCRIPTION */
/*     INTEGER K, J */
/*     DOUBLE PRECISION Z */

/*                  GIVEN K THIS SUBROUTINE COMPUTES J AND Z */
/*                  SUCH THAT  RADIX**K = Z*10**J, WHERE Z IS IN */
/*                  THE RANGE 1/10 .LE. Z .LT. 1. */
/*                  THE VALUE OF Z WILL BE ACCURATE TO FULL */
/*                  DOUBLE-PRECISION PROVIDED THE NUMBER */
/*                  OF DECIMAL PLACES IN THE LARGEST */
/*                  INTEGER PLUS THE NUMBER OF DECIMAL */
/*                  PLACES CARRIED IN DOUBLE-PRECISION DOES NOT */
/*                  EXCEED 60. DXC210 IS CALLED BY SUBROUTINE */
/*                  DXCON WHEN NECESSARY. THE USER SHOULD */
/*                  NEVER NEED TO CALL DXC210 DIRECTLY. */

/* ***SEE ALSO  DXSET */
/* ***REFERENCES  (NONE) */
/* ***ROUTINES CALLED  XERMSG */
/* ***COMMON BLOCKS    DXBLK3 */
/* ***REVISION HISTORY  (YYMMDD) */
/*   820712  DATE WRITTEN */
/*   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS) */

/*   901019  Revisions to prologue.  (DWL and WRB) */
/*   901106  Changed all specific intrinsics to generic.  (WRB) */
/*           Corrected order of sections in prologue and added TYPE */
/*           section.  (WRB) */
/*           CALLs to XERROR changed to CALLs to XERMSG.  (WRB) */
/*   920127  Revised PURPOSE section of prologue.  (DWL) */
/* ***END PROLOGUE  DXC210 */

/*   THE CONDITIONS IMPOSED ON NLG102, MLG102, AND LG102 BY */
/* THIS SUBROUTINE ARE */

/*     (1) NLG102 .GE. 2 */

/*     (2) MLG102 .GE. 1 */

/*     (3) 2*MLG102*(MLG102 - 1) .LE. 2**NBITS - 1 */

/* THESE CONDITIONS MUST BE MET BY APPROPRIATE CODING */
/* IN SUBROUTINE DXSET. */

/* ***FIRST EXECUTABLE STATEMENT  DXC210 */
    *ierror = 0;
    if (*k == 0) {
	goto L70;
    }
    m = dxblk3_1.mlg102;
    ka = abs(*k);
    ka1 = ka / m;
    ka2 = ka % m;
    if (ka1 >= m) {
	goto L60;
    }
    nm1 = dxblk3_1.nlg102 - 1;
    np1 = dxblk3_1.nlg102 + 1;
    it = ka2 * dxblk3_1.lg102[np1 - 1];
    ic = it / m;
    id = it % m;
    *z = (doublereal) id;
    if (ka1 > 0) {
	goto L20;
    }
    i__1 = nm1;
    for (ii = 1; ii <= i__1; ++ii) {
	i = np1 - ii;
	it = ka2 * dxblk3_1.lg102[i - 1] + ic;
	ic = it / m;
	id = it % m;
	*z = *z / m + id;
/* L10: */
    }
    ja = ka * dxblk3_1.lg102[0] + ic;
    goto L40;
L20:
    i__1 = nm1;
    for (ii = 1; ii <= i__1; ++ii) {
	i = np1 - ii;
	it = ka2 * dxblk3_1.lg102[i - 1] + ka1 * dxblk3_1.lg102[i] + ic;
	ic = it / m;
	id = it % m;
	*z = *z / m + id;
/* L30: */
    }
    ja = ka * dxblk3_1.lg102[0] + ka1 * dxblk3_1.lg102[1] + ic;
L40:
    *z /= m;
    if (*k > 0) {
	goto L50;
    }
    *j = -ja;
    d__1 = -(*z);
    *z = pow_dd(&c_b125, &d__1);
    goto L80;
L50:
    *j = ja + 1;
    d__1 = *z - 1.;
    *z = pow_dd(&c_b125, &d__1);
    goto L80;
L60:
/*   THIS ERROR OCCURS IF K EXCEEDS  MLG102**2 - 1  IN MAGNITUDE. */

    *ierror = 208;
    return 0;
L70:
    *j = 0;
    *z = 1.;
L80:
    return 0;
} /* dxc210_ */

/* DECK DXADJ */
/* Subroutine */ int dxadj_(doublereal *x, integer *ix, integer *ierror)
{
/* ***BEGIN PROLOGUE  DXADJ */
/* ***PURPOSE  To provide double-precision floating-point arithmetic */
/*            with an extended exponent range. */
/* ***LIBRARY   SLATEC */
/* ***CATEGORY  A3D */
/* ***TYPE      DOUBLE PRECISION (XADJ-S, DXADJ-D) */
/* ***KEYWORDS  EXTENDED-RANGE DOUBLE-PRECISION ARITHMETIC */
/* ***AUTHOR  Lozier, Daniel W., (National Bureau of Standards) */
/*           Smith, John M., (NBS and George Mason University) */
/* ***DESCRIPTION */
/*     DOUBLE PRECISION X */
/*     INTEGER IX */

/*                  TRANSFORMS (X,IX) SO THAT */
/*                  RADIX**(-L) .LE. ABS(X) .LT. RADIX**L. */
/*                  ON MOST COMPUTERS THIS TRANSFORMATION DOES */
/*                  NOT CHANGE THE MANTISSA OF X PROVIDED RADIX IS */
/*                  THE NUMBER BASE OF DOUBLE-PRECISION ARITHMETIC. */

/* ***SEE ALSO  DXSET */
/* ***REFERENCES  (NONE) */
/* ***ROUTINES CALLED  XERMSG */
/* ***COMMON BLOCKS    DXBLK2 */
/* ***REVISION HISTORY  (YYMMDD) */
/*   820712  DATE WRITTEN */
/*   881020  Revised to meet SLATEC CML recommendations.  (DWL and JMS) */

/*   901019  Revisions to prologue.  (DWL and WRB) */
/*   901106  Changed all specific intrinsics to generic.  (WRB) */
/*           Corrected order of sections in prologue and added TYPE */
/*           section.  (WRB) */
/*           CALLs to XERROR changed to CALLs to XERMSG.  (WRB) */
/*   920127  Revised PURPOSE section of prologue.  (DWL) */
/* ***END PROLOGUE  DXADJ */

/*   THE CONDITION IMPOSED ON L AND KMAX BY THIS SUBROUTINE */
/* IS */
/*     2*L .LE. KMAX */

/* THIS CONDITION MUST BE MET BY APPROPRIATE CODING */
/* IN SUBROUTINE DXSET. */

/* ***FIRST EXECUTABLE STATEMENT  DXADJ */
    *ierror = 0;
    if (*x == 0.) {
	goto L50;
    }
    if (abs(*x) >= 1.) {
	goto L20;
    }
    if (dxblk2_1.radixl * abs(*x) >= 1.) {
	goto L60;
    }
    *x *= dxblk2_1.rad2l;
    if (*ix < 0) {
	goto L10;
    }
    *ix -= dxblk2_1.l2;
    goto L70;
L10:
    if (*ix < -dxblk2_1.kmax + dxblk2_1.l2) {
	goto L40;
    }
    *ix -= dxblk2_1.l2;
    goto L70;
L20:
    if (abs(*x) < dxblk2_1.radixl) {
	goto L60;
    }
    *x /= dxblk2_1.rad2l;
    if (*ix > 0) {
	goto L30;
    }
    *ix += dxblk2_1.l2;
    goto L70;
L30:
    if (*ix > dxblk2_1.kmax - dxblk2_1.l2) {
	goto L40;
    }
    *ix += dxblk2_1.l2;
    goto L70;
L40:
    *ierror = 207;
    return 0;
L50:
    *ix = 0;
L60:
    if (abs(*ix) > dxblk2_1.kmax) {
	goto L40;
    }
L70:
    return 0;
} /* dxadj_ */

/* DECK DXADD */
/* Subroutine */ int dxadd_(doublereal *x, integer *ix, doublereal *y, 
	integer *iy, doublereal *z, integer *iz, integer *ierror)
{
    /* System generated locals */
    integer i__1;

    /* Builtin functions */
    double pow_di(doublereal *, integer *);

    /* Local variables */
    static integer i, j;
    static doublereal s, t;
    extern /* Subroutine */ int dxadj_(doublereal *, integer *, integer *);
    static integer i1, i2, is;

/* ***BEGIN PROLOGUE  DXADD */
/* ***PURPOSE  To provide double-precision floating-point arithmetic */
/*            with an extended exponent range. */
/* ***LIBRARY   SLATEC */
/* ***CATEGORY  A3D */
/* ***TYPE      DOUBLE PRECISION (XADD-S, DXADD-D) */
/* ***KEYWORDS  EXTENDED-RANGE DOUBLE-PRECISION ARITHMETIC */
/* ***AUTHOR  Lozier, Daniel W., (National Bureau of Standards) */
/*           Smith, John M., (NBS and George Mason University) */
/* ***DESCRIPTION */
/*     DOUBLE PRECISION X, Y, Z */
/*     INTEGER IX, IY, IZ */

/*                  FORMS THE EXTENDED-RANGE SUM  (Z,IZ) = */
/*                  (X,IX) + (Y,IY).  (Z,IZ) IS ADJUSTED */
/*                  BEFORE RETURNING. THE INPUT OPERANDS */
/*                  NEED NOT BE IN ADJUSTED FORM, BUT THEIR */
/*                  PRINCIPAL PARTS MUST SATISFY */
/*                  RADIX**(-2L).LE.ABS(X).LE.RADIX**(2L), */
/*                  RADIX**(-2L).LE.ABS(Y).LE.RADIX**(2L). */

/* ***SEE ALSO  DXSET */
/* ***REFERENCES  (NONE) */
/* ***ROUTINES CALLED  DXADJ */
/* ***COMMON BLOCKS    DXBLK2 */
/* ***REVISION HISTORY  (YYMMDD) */
/*   820712  DATE WRITTEN */
/*   881020  Revised to meet SLATEC CML recommendations.  (DWL and JMS) */

/*   901019  Revisions to prologue.  (DWL and WRB) */
/*   901106  Changed all specific intrinsics to generic.  (WRB) */
/*           Corrected order of sections in prologue and added TYPE */
/*           section.  (WRB) */
/*   920127  Revised PURPOSE section of prologue.  (DWL) */
/* ***END PROLOGUE  DXADD */

/*   THE CONDITIONS IMPOSED ON L AND KMAX BY THIS SUBROUTINE */
/* ARE */
/*     (1) 1 .LT. L .LE. 0.5D0*LOGR(0.5D0*DZERO) */

/*     (2) NRADPL .LT. L .LE. KMAX/6 */

/*     (3) KMAX .LE. (2**NBITS - 4*L - 1)/2 */

/* THESE CONDITIONS MUST BE MET BY APPROPRIATE CODING */
/* IN SUBROUTINE DXSET. */

/* ***FIRST EXECUTABLE STATEMENT  DXADD */
    *ierror = 0;
    if (*x != 0.) {
	goto L10;
    }
    *z = *y;
    *iz = *iy;
    goto L220;
L10:
    if (*y != 0.) {
	goto L20;
    }
    *z = *x;
    *iz = *ix;
    goto L220;
L20:
    if (*ix >= 0 && *iy >= 0) {
	goto L40;
    }
    if (*ix < 0 && *iy < 0) {
	goto L40;
    }
    if (abs(*ix) <= dxblk2_1.l * 6 && abs(*iy) <= dxblk2_1.l * 6) {
	goto L40;
    }
    if (*ix >= 0) {
	goto L30;
    }
    *z = *y;
    *iz = *iy;
    goto L220;
L30:
    *z = *x;
    *iz = *ix;
    goto L220;
L40:
    i = *ix - *iy;
    if (i < 0) {
	goto L80;
    } else if (i == 0) {
	goto L50;
    } else {
	goto L90;
    }
L50:
    if (abs(*x) > 1. && abs(*y) > 1.) {
	goto L60;
    }
    if (abs(*x) < 1. && abs(*y) < 1.) {
	goto L70;
    }
    *z = *x + *y;
    *iz = *ix;
    goto L220;
L60:
    s = *x / dxblk2_1.radixl;
    t = *y / dxblk2_1.radixl;
    *z = s + t;
    *iz = *ix + dxblk2_1.l;
    goto L220;
L70:
    s = *x * dxblk2_1.radixl;
    t = *y * dxblk2_1.radixl;
    *z = s + t;
    *iz = *ix - dxblk2_1.l;
    goto L220;
L80:
    s = *y;
    is = *iy;
    t = *x;
    goto L100;
L90:
    s = *x;
    is = *ix;
    t = *y;
L100:

/*  AT THIS POINT, THE ONE OF (X,IX) OR (Y,IY) THAT HAS THE */
/* LARGER AUXILIARY INDEX IS STORED IN (S,IS). THE PRINCIPAL */
/* PART OF THE OTHER INPUT IS STORED IN T. */

    i1 = abs(i) / dxblk2_1.l;
    i2 = abs(i) % dxblk2_1.l;
    if (abs(t) >= dxblk2_1.radixl) {
	goto L130;
    }
    if (abs(t) >= 1.) {
	goto L120;
    }
    if (dxblk2_1.radixl * abs(t) >= 1.) {
	goto L110;
    }
    j = i1 + 1;
    i__1 = dxblk2_1.l - i2;
    t *= pow_di(&dxblk2_1.radix, &i__1);
    goto L140;
L110:
    j = i1;
    i__1 = -i2;
    t *= pow_di(&dxblk2_1.radix, &i__1);
    goto L140;
L120:
    j = i1 - 1;
    if (j < 0) {
	goto L110;
    }
    i__1 = -i2;
    t = t * pow_di(&dxblk2_1.radix, &i__1) / dxblk2_1.radixl;
    goto L140;
L130:
    j = i1 - 2;
    if (j < 0) {
	goto L120;
    }
    i__1 = -i2;
    t = t * pow_di(&dxblk2_1.radix, &i__1) / dxblk2_1.rad2l;
L140:

/*  AT THIS POINT, SOME OR ALL OF THE DIFFERENCE IN THE */
/* AUXILIARY INDICES HAS BEEN USED TO EFFECT A LEFT SHIFT */
/* OF T.  THE SHIFTED VALUE OF T SATISFIES */

/*       RADIX**(-2*L) .LE. ABS(T) .LE. 1.0D0 */

/* AND, IF J=0, NO FURTHER SHIFTING REMAINS TO BE DONE. */

    if (j == 0) {
	goto L190;
    }
    if (abs(s) >= dxblk2_1.radixl || j > 3) {
	goto L150;
    }
    if (abs(s) >= 1.) {
	switch (j) {
	    case 1:  goto L180;
	    case 2:  goto L150;
	    case 3:  goto L150;
	}
    }
    if (dxblk2_1.radixl * abs(s) >= 1.) {
	switch (j) {
	    case 1:  goto L180;
	    case 2:  goto L170;
	    case 3:  goto L150;
	}
    }
    switch (j) {
	case 1:  goto L180;
	case 2:  goto L170;
	case 3:  goto L160;
    }
L150:
    *z = s;
    *iz = is;
    goto L220;
L160:
    s *= dxblk2_1.radixl;
L170:
    s *= dxblk2_1.radixl;
L180:
    s *= dxblk2_1.radixl;
L190:

/*   AT THIS POINT, THE REMAINING DIFFERENCE IN THE */
/* AUXILIARY INDICES HAS BEEN USED TO EFFECT A RIGHT SHIFT */
/* OF S.  IF THE SHIFTED VALUE OF S WOULD HAVE EXCEEDED */
/* RADIX**L, THEN (S,IS) IS RETURNED AS THE VALUE OF THE */
/* SUM. */

    if (abs(s) > 1. && abs(t) > 1.) {
	goto L200;
    }
    if (abs(s) < 1. && abs(t) < 1.) {
	goto L210;
    }
    *z = s + t;
    *iz = is - j * dxblk2_1.l;
    goto L220;
L200:
    s /= dxblk2_1.radixl;
    t /= dxblk2_1.radixl;
    *z = s + t;
    *iz = is - j * dxblk2_1.l + dxblk2_1.l;
    goto L220;
L210:
    s *= dxblk2_1.radixl;
    t *= dxblk2_1.radixl;
    *z = s + t;
    *iz = is - j * dxblk2_1.l - dxblk2_1.l;
L220:
    dxadj_(z, iz, ierror);
    return 0;
} /* dxadd_ */

/* DECK DXPSI */
doublereal dxpsi_(doublereal *a, integer *ipsik, integer *ipsix)
{
    /* Initialized data */

    static doublereal cnum[12] = { 1.,-1.,1.,-1.,1.,-691.,1.,-3617.,43867.,
	    -174611.,77683.,-236364091. };
    static doublereal cdenom[12] = { 12.,120.,252.,240.,132.,32760.,12.,8160.,
	    14364.,6600.,276.,65520. };

    /* System generated locals */
    integer i__1, i__2;
    doublereal ret_val, d__1;

    /* Builtin functions */
    double log(doublereal);

    /* Local variables */
    static doublereal b, c;
    static integer i, k, m, n, k1;

/* ***BEGIN PROLOGUE  DXPSI */
/* ***SUBSIDIARY */
/* ***PURPOSE  To compute values of the Psi function for DXLEGF. */
/* ***LIBRARY   SLATEC */
/* ***CATEGORY  C7C */
/* ***TYPE      DOUBLE PRECISION (XPSI-S, DXPSI-D) */
/* ***KEYWORDS  PSI FUNCTION */
/* ***AUTHOR  Smith, John M., (NBS and George Mason University) */
/* ***ROUTINES CALLED  (NONE) */
/* ***REVISION HISTORY  (YYMMDD) */
/*   820728  DATE WRITTEN */
/*   890126  Revised to meet SLATEC CML recommendations.  (DWL and JMS) */

/*   901019  Revisions to prologue.  (DWL and WRB) */
/*   901106  Changed all specific intrinsics to generic.  (WRB) */
/*           Corrected order of sections in prologue and added TYPE */
/*           section.  (WRB) */
/*   920127  Revised PURPOSE section of prologue.  (DWL) */
/* ***END PROLOGUE  DXPSI */

/*        CNUM(I) AND CDENOM(I) ARE THE ( REDUCED ) NUMERATOR */
/*        AND 2*I*DENOMINATOR RESPECTIVELY OF THE 2*I TH BERNOULLI */
/*        NUMBER. */

/* ***FIRST EXECUTABLE STATEMENT  DXPSI */
/* Computing MAX */
    i__1 = 0, i__2 = *ipsix - (integer) (*a);
    n = max(i__1,i__2);
    b = n + *a;
    k1 = *ipsik - 1;

/*        SERIES EXPANSION FOR A .GT. IPSIX USING IPSIK-1 TERMS. */

    c = 0.;
    i__1 = k1;
    for (i = 1; i <= i__1; ++i) {
	k = *ipsik - i;
/* L12: */
/* Computing 2nd power */
	d__1 = b;
	c = (c + cnum[k - 1] / cdenom[k - 1]) / (d__1 * d__1);
    }
    ret_val = log(b) - (c + .5 / b);
    if (n == 0) {
	goto L20;
    }
    b = 0.;

/*        RECURRENCE FOR A .LE. IPSIX. */

    i__1 = n;
    for (m = 1; m <= i__1; ++m) {
/* L15: */
	b += 1. / (n - m + *a);
    }
    ret_val -= b;
L20:
    return ret_val;
} /* dxpsi_ */

