/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import tools.GraphXY;
import tools.TypeConverter;
import tools.Var;
import tools.VarMonitor;
import tools.XY;

public final class Formula
implements Var {
    String name;
    GraphXY parent;
    public boolean dynamic = true;
    public boolean hidden;
    public double x;
    public double y;
    public String xAlign = "center";
    public Color foreColor = Color.black;
    public Color backColor;
    public String fontName = "TimesRoman";
    public boolean fontBold = true;
    public boolean fontItalic = false;
    public int fontSize = 18;
    public String text;
    String t;
    int version;
    int px;
    int py;
    int w;
    int h;
    Font f1;
    Font f2;
    FontMetrics fm1;
    FontMetrics fm2;
    int th1;
    int th2;

    public String getName() {
        return this.name;
    }

    public String getRadioGroup() {
        return null;
    }

    public String getRadioField() {
        return null;
    }

    public Formula(String string) {
        this.name = string;
    }

    public Formula() {
    }

    public Object get(String string) {
        if ("dynamic".equals(string)) {
            return new Boolean(this.dynamic);
        }
        if ("hidden".equals(string)) {
            return new Boolean(this.hidden);
        }
        if ("foreColor".equals(string)) {
            return this.foreColor;
        }
        if ("backColor".equals(string)) {
            return this.backColor;
        }
        if ("fontName".equals(string)) {
            return this.fontName;
        }
        if ("fontSize".equals(string)) {
            return new Integer(this.fontSize);
        }
        if ("fontBold".equals(string)) {
            return new Boolean(this.fontBold);
        }
        if ("fontItalic".equals(string)) {
            return new Boolean(this.fontItalic);
        }
        if ("x".equals(string)) {
            return new Double(this.x);
        }
        if ("y".equals(string)) {
            return new Double(this.y);
        }
        if ("xAlign".equals(string)) {
            return this.xAlign;
        }
        if ("text".equals(string)) {
            return this.text;
        }
        return null;
    }

    public void set(Object object, String string) {
        if (!this.dynamic) {
            return;
        }
        if ("hidden".equals(string)) {
            this.hidden = TypeConverter.toBoolean(object);
        } else if ("foreColor".equals(string)) {
            this.foreColor = object == null ? Color.black : (object instanceof Color ? (Color)object : TypeConverter.parseColor(object.toString(), Color.black));
        } else if ("backColor".equals(string)) {
            this.backColor = object == null ? Color.black : (object instanceof Color ? (Color)object : TypeConverter.parseColor(object.toString(), Color.black));
        } else if ("fontName".equals(string)) {
            this.fontName = object == null ? "" : (!(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false));
        } else if ("fontSize".equals(string)) {
            this.fontSize = TypeConverter.toInteger(object);
        } else if ("fontBold".equals(string)) {
            this.fontBold = TypeConverter.toBoolean(object);
        } else if ("fontItalic".equals(string)) {
            this.fontItalic = TypeConverter.toBoolean(object);
        } else if ("x".equals(string)) {
            this.x = TypeConverter.toDouble(object);
        } else if ("y".equals(string)) {
            this.y = TypeConverter.toDouble(object);
        } else if ("xAlign".equals(string)) {
            this.xAlign = object == null ? "" : (!(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false));
        } else if ("text".equals(string)) {
            String string2 = object == null ? "" : (this.text = !(object instanceof Double) ? object.toString() : TypeConverter.double2String((Double)object, 2, false, false, false, false));
        }
        if (Thread.currentThread() != this.parent.thread) {
            this.parent.incEventsCount();
        }
    }

    void draw(Graphics graphics, GraphXY graphXY) {
        this.draw(graphics, graphXY, 0, 0);
    }

    void draw(Graphics graphics, GraphXY graphXY, int n, int n2) {
        if (this.hidden || Double.isNaN(this.x) || Double.isNaN(this.y)) {
            return;
        }
        Font font = graphics.getFont();
        int n3 = 0;
        if (this.fontItalic) {
            n3 += 2;
        }
        if (this.fontBold) {
            ++n3;
        }
        this.f1 = new Font(this.fontName, n3, this.fontSize);
        graphics.setFont(this.f1);
        this.fm1 = graphics.getFontMetrics();
        int n4 = 2 * this.fontSize / 3;
        this.f2 = new Font(this.fontName, n3, n4);
        graphics.setFont(this.f2);
        this.fm2 = graphics.getFontMetrics();
        if (this.text == null) {
            return;
        }
        this.t = VarMonitor.parseString(this.text);
        if (this.t == null) {
            return;
        }
        this.version = 0;
        if (this.t.startsWith("[1]")) {
            this.version = 1;
            this.t = this.t.substring(3);
        }
        this.th1 = (int)((double)this.fontSize / 1.5);
        this.th2 = (int)((double)n4 / 1.5);
        this.drawFormula(graphics, false);
        if (graphXY != null) {
            Point point = graphXY.XY2Point(new XY(this.x, this.y));
            this.px = point.x - this.w / 2;
            if ("left".equals(this.xAlign)) {
                this.px = point.x;
            }
            if ("right".equals(this.xAlign)) {
                this.px = point.x - this.w;
            }
            this.py = point.y;
            if (this.backColor != null) {
                graphics.setColor(this.backColor);
                graphics.fillRect(this.px, this.py - this.th1 - this.th2 / 2 - 2, this.w, this.th1 + this.th2 + 3);
            }
        } else {
            this.px = (n - this.w) / 2;
            if ("left".equals(this.xAlign)) {
                this.px = 0;
            }
            if ("right".equals(this.xAlign)) {
                this.px = n - this.w;
            }
            this.py = n2 / 2;
            if (this.backColor != null) {
                graphics.setColor(this.backColor);
                graphics.fillRect(0, this.py - this.th1 - this.th2 / 2 - 2, n, this.th1 + this.th2 + 3);
            }
        }
        this.drawFormula(graphics, true);
        graphics.setFont(font);
    }

    void drawFormula(Graphics graphics, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (bl) {
            graphics.setColor(this.foreColor);
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        int n4 = this.t.length();
        int n5 = 0;
        while (n5 < n4) {
            if (n5 < n4 - 1 && this.t.charAt(n5 + 1) == '{' && (this.t.charAt(n5) == '^' || this.t.charAt(n5) == '_')) {
                int n6;
                if (stringBuffer.length() > 0) {
                    String string = stringBuffer.toString();
                    stringBuffer = new StringBuffer(10);
                    n3 = n2 = (n = this.processBaseString(graphics, string, n, bl));
                }
                String string = (n6 = this.t.indexOf("}", n5 + 1)) == -1 ? this.t.substring(n5 + 2) : this.t.substring(n5 + 2, n6);
                int n7 = this.fm2.stringWidth(string);
                if (this.t.charAt(n5) == '^') {
                    if (bl) {
                        graphics.setFont(this.f2);
                        graphics.drawString(string, this.px + n2 + (this.fontItalic ? 1 : 0), this.py - this.th1 + this.th2 / 2);
                    }
                    if ((n2 += n7) > n) {
                        n = n2;
                    }
                } else {
                    if (bl) {
                        graphics.setFont(this.f2);
                        graphics.drawString(string, this.px + n3 - (this.fontItalic ? 1 : 0), this.py + this.th2 / 2);
                    }
                    if ((n3 += n7) > n) {
                        n = n3;
                    }
                }
                if (n6 == -1) break;
                n5 = n6;
            } else {
                stringBuffer.append(this.t.charAt(n5));
            }
            ++n5;
        }
        if (stringBuffer.length() > 0) {
            String string = stringBuffer.toString();
            n = this.processBaseString(graphics, string, n, bl);
        }
        this.w = n;
    }

    int processBaseString(Graphics graphics, String string, int n, boolean bl) {
        if (bl) {
            graphics.setFont(this.f1);
        }
        switch (this.version) {
            default: {
                return this.processBaseString_0(graphics, string, n, bl);
            }
            case 1: 
        }
        return this.processBaseString_1(graphics, string, n, bl);
    }

    int processBaseString_0(Graphics graphics, String string, int n, boolean bl) {
        int n2 = 0;
        while (true) {
            int n3;
            String string2;
            String string3 = string2 = (n3 = string.indexOf("\\", n2)) == -1 ? string.substring(n2) : string.substring(n2, n3);
            if (bl) {
                graphics.drawString(string2, this.px + n, this.py);
            }
            n += this.fm1.stringWidth(string2);
            if (n3 == -1) break;
            if (string.startsWith("cdot", n3 + 1)) {
                int n4;
                int n5 = n4 = this.fontSize <= 20 ? 2 : 3;
                if (bl) {
                    graphics.drawOval(this.px + n + 1, this.py - this.th1 / 2 - 1, n4, n4);
                    graphics.fillOval(this.px + n + 1, this.py - this.th1 / 2 - 1, n4, n4);
                }
                n += n4 + 2;
                n2 = n3 + 5;
                continue;
            }
            n2 = n3 + 1;
        }
        return n;
    }

    int processBaseString_1(Graphics graphics, String string, int n, boolean bl) {
        int n2 = 0;
        while (true) {
            int n3;
            String string2;
            int n4 = Integer.MAX_VALUE;
            int n5 = string.indexOf("\\", n2);
            if (n5 != -1 && n4 > n5) {
                n4 = n5;
            }
            if ((n5 = string.indexOf("=", n2)) != -1 && n4 > n5) {
                n4 = n5;
            }
            if ((n5 = string.indexOf("+", n2)) != -1 && n4 > n5) {
                n4 = n5;
            }
            if ((n5 = string.indexOf("-", n2)) != -1 && n4 > n5) {
                n4 = n5;
            }
            if ((n5 = string.indexOf(">", n2)) != -1 && n4 > n5) {
                n4 = n5;
            }
            if ((n5 = string.indexOf("<", n2)) != -1 && n4 > n5) {
                n4 = n5;
            }
            String string3 = string2 = n4 == Integer.MAX_VALUE ? string.substring(n2) : string.substring(n2, n4);
            if (bl) {
                graphics.drawString(string2, this.px + n, this.py);
            }
            n += this.fm1.stringWidth(string2);
            if (n4 == Integer.MAX_VALUE) break;
            int n6 = this.px + n + 2;
            int n7 = this.py - this.th1 / 2 - 1;
            int n8 = this.fm1.stringWidth("+") - 1;
            int n9 = n8 / 2;
            int n10 = n9 / 2;
            if (string.startsWith("=", n4)) {
                if (bl) {
                    graphics.drawLine(n6, n7 - n10, n6 + n8, n7 - n10);
                    graphics.drawLine(n6, n7 + n10, n6 + n8, n7 + n10);
                }
                n += n8 + 4;
                n2 = n4 + 1;
                continue;
            }
            if (string.startsWith("\\neq", n4)) {
                if (bl) {
                    graphics.drawLine(n6, n7 - n10, n6 + n8, n7 - n10);
                    graphics.drawLine(n6, n7 + n10, n6 + n8, n7 + n10);
                    graphics.drawLine(n6 + n8 - 2, n7 - n9 - 2, n6 + 2, n7 + n9 + 2);
                }
                n += n8 + 4;
                n2 = n4 + 4;
                continue;
            }
            if (string.startsWith("<", n4)) {
                if (bl) {
                    graphics.drawLine(n6, n7, n6 + n8, n7 - n9);
                    graphics.drawLine(n6, n7, n6 + n8, n7 + n9);
                }
                n += n8 + 4;
                n2 = n4 + 1;
                continue;
            }
            if (string.startsWith("\\leq", n4)) {
                if (bl) {
                    graphics.drawLine(n6, n7 - n10, n6 + n8, n7 - n10 - n9);
                    graphics.drawLine(n6, n7 - n10, n6 + n8, n7 - n10 + n9);
                    graphics.drawLine(n6, n7 + n10, n6 + n8, n7 + n10 + n9);
                }
                n += n8 + 4;
                n2 = n4 + 4;
                continue;
            }
            if (string.startsWith(">", n4)) {
                if (bl) {
                    graphics.drawLine(n6, n7 - n9, n6 + n8, n7);
                    graphics.drawLine(n6, n7 + n9, n6 + n8, n7);
                }
                n += n8 + 4;
                n2 = n4 + 1;
                continue;
            }
            if (string.startsWith("\\geq", n4)) {
                if (bl) {
                    graphics.drawLine(n6, n7 - n10 - n9, n6 + n8, n7 - n10);
                    graphics.drawLine(n6, n7 - n10 + n9, n6 + n8, n7 - n10);
                    graphics.drawLine(n6, n7 + n10 + n9, n6 + n8, n7 + n10);
                }
                n += n8 + 4;
                n2 = n4 + 4;
                continue;
            }
            if (string.startsWith("+", n4)) {
                if (bl) {
                    graphics.drawLine(n6, n7, n6 + 2 * n9, n7);
                    graphics.drawLine(n6 + n9, n7 - n9, n6 + n9, n7 + n9);
                }
                n += 2 * n9 + 4;
                n2 = n4 + 1;
                continue;
            }
            if (string.startsWith("-", n4)) {
                if (bl) {
                    graphics.drawLine(n6, n7, n6 + 2 * n9, n7);
                }
                n += 2 * n9 + 4;
                n2 = n4 + 1;
                continue;
            }
            if (string.startsWith("\\cdot", n4)) {
                int n11 = n3 = this.fontSize <= 20 ? 2 : 3;
                if (bl) {
                    graphics.drawOval(n6, n7 - n3 / 2, n3, n3);
                    graphics.fillOval(n6, n7 - n3 / 2, n3, n3);
                }
                n += n3 + 4;
                n2 = n4 + 5;
                continue;
            }
            if (string.startsWith("\\times", n4)) {
                if (bl) {
                    graphics.drawLine(n6, n7 - n9, n6 + 2 * n9, n7 + n9);
                    graphics.drawLine(n6, n7 + n9, n6 + 2 * n9, n7 - n9);
                }
                n += 2 * n9 + 4;
                n2 = n4 + 6;
                continue;
            }
            if (string.startsWith("\\div", n4)) {
                int n12 = n3 = this.fontSize <= 20 ? 2 : 3;
                if (bl) {
                    graphics.drawOval(n6, n7 - n3 / 2 - n10 - 1, n3, n3);
                    graphics.fillOval(n6, n7 - n3 / 2 - n10 - 1, n3, n3);
                    graphics.drawOval(n6, n7 - n3 / 2 + n10 + 1, n3, n3);
                    graphics.fillOval(n6, n7 - n3 / 2 + n10 + 1, n3, n3);
                }
                n += n3 + 4;
                n2 = n4 + 4;
                continue;
            }
            if (string.startsWith("\\frac{", n4)) {
                n3 = string.indexOf("}{", n4 + 6);
                if (n3 == -1) {
                    n2 = n4 + 1;
                    continue;
                }
                int n13 = string.indexOf("}", n3 + 2);
                if (n13 == -1) {
                    n2 = n4 + 1;
                    continue;
                }
                String string4 = string.substring(n4 + 6, n3).trim();
                String string5 = string.substring(n3 + 2, n13).trim();
                if (string4.length() > 0 || string5.length() > 0) {
                    int n14 = this.fm2.stringWidth(string4);
                    int n15 = this.fm2.stringWidth(string5);
                    int n16 = Math.max(n14, n15);
                    if (bl) {
                        graphics.drawLine(n6, n7, n6 + n16, n7);
                        graphics.setFont(this.f2);
                        graphics.drawString(string4, n6 + (n16 - n14) / 2 + 1 + (this.fontItalic ? 1 : 0), this.py - this.th1 + this.th2 / 2);
                        graphics.drawString(string5, n6 + (n16 - n15) / 2 + 1 - (this.fontItalic ? 1 : 0), this.py + this.th2 / 2);
                        graphics.setFont(this.f1);
                    }
                    n += n16 + 4;
                }
                n2 = n13 + 1;
                continue;
            }
            n2 = n4 + 1;
        }
        return n;
    }
}

