/*
 * Decompiled with CFR 0.152.
 */
package tools;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.io.Serializable;
import tools.TraceMonitor;
import tools.Tree;
import tools.TreeIterator;
import tools.TypeConverter;

public class TreeComponent
extends Component {
    Tree tree;
    Applet a;
    ScrollPane sp;
    Font f;
    Font fb;
    FontMetrics fm;
    FontMetrics fmb;
    int th;
    Color lineColor;
    Color foreColor;
    Color backColor;
    Color foreColorSel;
    Color backColorSel;
    boolean first = true;
    static boolean redrawFlag1;
    boolean redrawFlag2;

    public static void redraw() {
        redrawFlag1 = true;
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        int n;
        Serializable serializable;
        if (this.tree == null) {
            serializable = this;
            while (serializable != null) {
                if (serializable instanceof Applet) {
                    this.a = (Applet)serializable;
                }
                if (serializable instanceof ScrollPane) {
                    this.sp = (ScrollPane)serializable;
                }
                serializable = ((Component)serializable).getParent();
            }
            String string = this.a.getParameter("fontName");
            if (string == null) {
                string = "TimesRoman";
            }
            if ((n = TypeConverter.toInteger(this.a.getParameter("fontSize"))) == 0) {
                n = 12;
            }
            this.f = new Font(string, 0, n);
            graphics.setFont(this.f);
            this.fm = graphics.getFontMetrics();
            this.fb = new Font(string, 1, n);
            graphics.setFont(this.fb);
            this.fmb = graphics.getFontMetrics();
            this.th = this.fm.getHeight() / 2 * 2;
            this.lineColor = TypeConverter.parseColor(this.a.getParameter("lineColor"), Color.gray);
            this.foreColor = TypeConverter.parseColor(this.a.getParameter("foreColor"), Color.black);
            this.backColor = TypeConverter.parseColor(this.a.getParameter("backColor"), Color.white);
            this.foreColorSel = TypeConverter.parseColor(this.a.getParameter("foreColorSel"), Color.white);
            this.backColorSel = TypeConverter.parseColor(this.a.getParameter("backColorSel"), new Color(128));
            this.sp.getVAdjustable().setUnitIncrement(this.th);
            this.sp.getHAdjustable().setUnitIncrement(this.th);
            this.tree = Tree.subtree;
        }
        serializable = graphics.getClipBounds();
        int n2 = ((Rectangle)serializable).y / this.th;
        n = n2 + ((Rectangle)serializable).height / this.th + 1;
        boolean bl = false;
        TreeIterator treeIterator = new TreeIterator(this.tree);
        Tree tree = this.tree;
        while (tree != null) {
            if (treeIterator.n >= n2) {
                if (treeIterator.n > n) break;
                if (tree.getText() == null) {
                    bl = true;
                }
                this.drawTreeLine(graphics, treeIterator);
            }
            tree = treeIterator.getNext();
        }
        this.redrawFlag2 = bl;
    }

    void drawTreeLine(Graphics graphics, TreeIterator treeIterator) {
        boolean bl;
        Tree tree = treeIterator.t;
        int n = treeIterator.getLevel();
        int n2 = n * this.th;
        int n3 = treeIterator.n * this.th;
        int n4 = this.th / 3 * 2;
        int n5 = (this.th - n4) / 2;
        if (TreeIterator.hasChildren(tree)) {
            graphics.setColor(this.lineColor);
            graphics.drawRect(n2 + n5, n3 + n5, n4, n4);
            graphics.drawLine(n2 + n5 + 3, n3 + n5 + n4 / 2, n2 + n5 + n4 - 3, n3 + n5 + n4 / 2);
            if (!tree.expanded) {
                graphics.drawLine(n2 + n5 + n4 / 2, n3 + n5 + 3, n2 + n5 + n4 / 2, n3 + n5 + n4 - 3);
            }
            graphics.setColor(this.lineColor);
            graphics.drawLine(n2 + n5 + n4 / 2, n3, n2 + n5 + n4 / 2, n3 + n5);
            if (!TreeIterator.isLastSibling(tree)) {
                graphics.drawLine(n2 + n5 + n4 / 2, n3 + this.th - n5, n2 + n5 + n4 / 2, n3 + this.th);
            }
        } else {
            graphics.setColor(this.lineColor);
            graphics.drawLine(n2 + n5 + n4 / 2, n3 + n5 + n4 / 2, n2 + n5 + n4, n3 + n5 + n4 / 2);
            if (TreeIterator.isLastSibling(tree)) {
                graphics.drawLine(n2 + n5 + n4 / 2, n3, n2 + n5 + n4 / 2, n3 + n5 + n4 / 2);
            } else {
                graphics.drawLine(n2 + n5 + n4 / 2, n3, n2 + n5 + n4 / 2, n3 + this.th);
            }
        }
        graphics.setColor(this.lineColor);
        n2 = n2 + n5 + n4 / 2 - this.th;
        Tree tree2 = tree.parent;
        while (n2 > 0) {
            if (!TreeIterator.isLastSibling(tree2)) {
                graphics.drawLine(n2, n3, n2, n3 + this.th);
            }
            n2 -= this.th;
            tree2 = tree2.parent;
        }
        String string = tree.getText();
        if (string == null) {
            string = ". . .";
        }
        graphics.setFont((bl = tree.isOrdered()) ? this.fb : this.f);
        int n6 = (bl ? this.fmb : this.fm).stringWidth(string);
        if (tree == Tree.current) {
            graphics.setColor(this.backColorSel);
            graphics.fillRect(this.th * (n + 1) - 1, n3 + 1, n6 + 2, this.th - 1);
            graphics.setColor(this.foreColorSel);
        } else {
            graphics.setColor(this.foreColor);
        }
        graphics.drawString(string, this.th * (n + 1), (treeIterator.n + 1) * this.th - this.th / 4 + 1);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.tree == null) {
            return true;
        }
        int n3 = this.sp.getScrollPosition().x;
        int n4 = this.sp.getScrollPosition().y;
        int n5 = this.getSize().height;
        int n6 = (n4 + n2) / this.th;
        TreeIterator treeIterator = new TreeIterator(this.tree);
        Tree tree = this.tree;
        while (tree != null) {
            if (n6 == treeIterator.n) {
                Tree.current = tree;
                if (n > this.th * (treeIterator.getLevel() + 1)) break;
                if (tree.expanded) {
                    tree.collapse();
                    break;
                }
                tree.collapse();
                tree.expanded = true;
                break;
            }
            tree = treeIterator.getNext();
        }
        this.invalidate();
        this.sp.validate();
        this.repaint();
        int n7 = this.getSize().height;
        if (n5 < n7 && n2 > this.sp.getSize().height - this.th * 2) {
            this.sp.setScrollPosition(n3, n4 + this.th);
        }
        TraceMonitor.event(this.a.getParameter("name"));
        return true;
    }

    public Dimension getPreferredSize() {
        if (this.tree == null) {
            return new Dimension(0, 0);
        }
        int n = 0;
        TreeIterator treeIterator = new TreeIterator(this.tree);
        Tree tree = this.tree;
        while (tree != null) {
            int n2;
            String string = tree.getText();
            if (string != null && (n2 = (tree.isOrdered() ? this.fmb : this.fm).stringWidth(string) + this.th * (treeIterator.getLevel() + 1)) > n) {
                n = n2;
            }
            tree = treeIterator.getNext();
        }
        return new Dimension(n, this.th * (treeIterator.n + 1));
    }

    public void tick() {
        Object object;
        if (this.sp == null || this.tree == null || !this.first && !redrawFlag1 && !this.redrawFlag2) {
            return;
        }
        if (this.first) {
            object = Tree.current;
            while (object != null) {
                ((Tree)object).expanded = true;
                object = ((Tree)object).parent;
            }
        }
        this.invalidate();
        this.sp.validate();
        this.repaint();
        if (this.first) {
            object = new TreeIterator(this.tree);
            Tree tree = this.tree;
            while (tree != null) {
                if (tree == Tree.current) {
                    this.sp.setScrollPosition(0, (((TreeIterator)object).n - 2) * this.th);
                    break;
                }
                tree = ((TreeIterator)object).getNext();
            }
        }
        this.first = false;
        redrawFlag1 = false;
    }
}

