#include <string.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#define M_PI	3.14159265359

struct	dint_tag {
		int a;
		int b;
		};
		
typedef struct dint_tag dint;
		
void main(int argc, char **argv);
double calc_surface_area(int n, char *ptr, int radius);
dint factorial(int nom, int denom);
int power(int a, int b);
void usage(void);
void banner(void);


void usage(void)
{
	printf("sphere <dimensions> [radius to calculate]\n");
}

void banner(void)
{
	printf("\nSurface area and volume calculator for multi-dimensional spheres\n");
	printf("by S.Goodwin 1997 - Freely distributable\n\n");	
}

dint reduce_fraction(dint f)
{
int l;

	if ((f.a/f.b)*f.b == f.a)
		{
		f.a /= f.b;
		f.b = 1;
		}
	else
		{
		for(l=2;l<10;l++)
			{
			if ((f.a/l)*l == f.a && (f.b/l)*l == f.b)
				{
				f.a /= l;
				f.b /= l;
				l=2;
				}
			}
		}

	return(f);
}

dint factorial(int nom, int denom)
{
dint rt = {1,1};
int n;

	if (denom == 1)		/* a whole number */
		{
		if (nom <= 1)
			return(rt);
		else
			{
			rt.a = nom * factorial(nom-1, denom).a;
			return(rt);
			}
		}
	else if (denom == 2)
		{
		n = nom/2;
		rt.a = factorial(n*2+2, 1).a;
		rt.b = factorial(n+1, 1).a;
		
		rt.b *= (int)(pow((double)4, (double)(n+1)));
		
		rt = reduce_fraction(rt);
		
		return(rt);
		}
	else
		return(rt);		/* ASSERTion */
}

double calc_surface_area(int n, char *ptr, int radius)
{
dint power_pi;
dint answer;
int tmp;
double area;

	power_pi.a = n;
	power_pi.b = 2;
	/**/
	if (n&1)
		answer = factorial(n, 2);
	else
		answer = factorial(n/2, 1);

	/* recipricate */
	tmp = answer.a;
	answer.a = answer.b;
	answer.b = tmp;
	
	answer.a *= n;
	
	answer = reduce_fraction(answer);

	if (n & 1)	/* Odd numbers */ 
		power_pi.a -= 1;	/* there's always a root pi in the denom */

	sprintf(ptr, "(%d * pi", answer.a);
	if (power_pi.a != power_pi.b)
		sprintf(strchr(ptr, '\0'), "^%d", power_pi.a/power_pi.b);

	/* Add power of pi */
	if (answer.b == 1)
		strcat(ptr, ")");
	else
		sprintf(strchr(ptr, '\0'), ")/%d", answer.b);	

	/* Add  * r ^ n */
	switch(n)
		{
		case	0:	/* ASSERTion */
		case	1:	
				break;
		case	2:
				strcat(ptr, " * r");
				break;
		default:
				sprintf(strchr(ptr, '\0'), " * r^%d", n-1);	
				break;
		}

	/* Now calculate the area */
	if (radius)
		{
		area = (double)((double)answer.a * pow(M_PI, (double)(power_pi.a/power_pi.b)) * pow((double)radius, (double)(n-1)));
		area /= (double)answer.b;
		}
	else
		area = 0;
		
	return(area);
}


void main(int argc, char **argv)
{
int dimensions, radius = 0;
double area;
char surface[100];

	banner();

	if (argc < 2)
		usage();
	else
		{
		dimensions = atoi(argv[1]);
		
		if (argc > 2)
			radius = atoi(argv[2]);
	
		area = calc_surface_area(dimensions, &surface[0], radius);
	
		printf("A %d dimensional sphere has a surface area of %s\n",
			dimensions, surface);
		
		if (radius)
			{
			printf("Surface area = (approx) %f\n", area);
			printf("Volume = (approx) %f\n", (area*(double)radius)/(double)dimensions);
			}
		
		printf("\n");
		}
}

