/*
 * Decompiled with CFR 0.152.
 */
package addressbook;

import addressbook.AddressBookResources;
import addressbook.BaseAttrTableModel;
import addressbook.Contact;
import addressbook.ContactFrame;
import addressbook.DataBookIO;
import addressbook.EMail;
import addressbook.Folder;
import addressbook.GenericAttribute;
import addressbook.Link;
import addressbook.OptionsFrame;
import addressbook.ProfileFrame;
import addressbook.Telephone;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import rogatkin.ActionPerformer;
import rogatkin.BaseController;
import rogatkin.Persistable;
import rogatkin.Program;
import rogatkin.Serializer;

public class AddressBookFrame
extends JFrame
implements ActionListener,
Program,
Persistable {
    public static final String PROGRAMNAME = "R-AddressBook";
    public static final String VERSION = "version 1.0preview";
    public static final String DEDICATED = "E. B.";
    public static final String COPYRIGHT = "Copyright \u00a9 2000, 2001 Dmitriy Rogatkin\n All rights reserved.";
    public static final int BUILD = 3;
    public static final Integer COMP_ACTIONPERFORMER = new Integer(101);
    public static final String ABVIEW = "DataBookView";
    public static final String VIEW = "View";
    public static final String SORTBY = "SortBy";
    public static final String NAMESORT = "LastNameSort";
    public static final String SORTORDER = "SortOrder";
    public static final String BOUNDS = "Bounds";
    public static final String HOME = "R-AddressBook.home";
    public static final String STOR_NAME = "datastorage.xml";
    static final int MENU = 1;
    static final int TOOL = 2;
    static final int STATUS = 4;
    static final int SEARCH = 8;
    static final int FOLDER = 16;
    int view = 31;
    boolean standalone;
    int sortField;
    int subSortField;
    boolean sortDir;
    BaseController controller;
    Vector folders;
    DataBookIO io;
    Properties properties;
    private JLabel statusLine;
    JCheckBoxMenuItem m_toolBar;
    JCheckBoxMenuItem m_statusBar;
    JCheckBoxMenuItem m_folder;
    JTable table;
    JTree tree;
    JComponent lastFocused;
    static /* synthetic */ Class class$javax$swing$JComboBox;

    public AddressBookFrame(BaseController baseController) {
        super(PROGRAMNAME);
        this.controller = baseController;
        if (this.controller == null) {
            this.controller = new BaseController(this){
                Image mainicon;
                {
                    AddressBookFrame.this.standalone = true;
                }

                public Image getMainIcon() {
                    if (this.mainicon == null) {
                        this.mainicon = BaseController.getResourceIcon((String)"AddressBook.jpg").getImage();
                    }
                    return this.mainicon;
                }
            };
        }
        this.controller.add((Component)this, (Object)this.getName());
        this.properties = System.getProperties();
        try {
            this.io = new DataBookIO(this.properties);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            JOptionPane.showMessageDialog(this, "Exception: " + noClassDefFoundError);
            return;
        }
        this.setIconImage(this.controller.getMainIcon());
        this.controller.load();
        Container container = this.getContentPane();
        if ((this.view & 1) != 0) {
            this.setJMenuBar(this.createMenu());
        }
        if ((this.view & 2) != 0) {
            container.add((Component)this.createToolBar(0), "North");
        }
        container.add((Component)this.createBook(), "Center");
        if ((this.view & 4) != 0) {
            container.add((Component)this.createStatusBar(), "South");
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AddressBookFrame.this.actionPerformed(new ActionEvent(this, 0, AddressBookFrame.this.standalone ? "Exit" : "Close"));
            }
        });
        this.pack();
        this.setVisible(true);
        this.setStatusText(PROGRAMNAME);
    }

    public String getName() {
        return PROGRAMNAME;
    }

    public String getVersion() {
        return VERSION;
    }

    public void save() {
        Serializer serializer = this.controller.getSerializer();
        serializer.setProperty((Object)ABVIEW, (Object)VIEW, (Object)new Integer(this.view));
        serializer.setProperty((Object)ABVIEW, (Object)SORTBY, (Object)new Integer(this.sortField));
        serializer.setProperty((Object)ABVIEW, (Object)NAMESORT, (Object)new Integer(this.subSortField));
        serializer.setProperty((Object)ABVIEW, (Object)SORTORDER, (Object)new Integer(this.sortDir ? 1 : 0));
        Rectangle rectangle = this.getBounds();
        Integer[] integerArray = new Integer[]{new Integer(rectangle.x), new Integer(rectangle.y), new Integer(rectangle.width), new Integer(rectangle.height)};
        serializer.setProperty((Object)ABVIEW, (Object)BOUNDS, (Object)integerArray);
        if (this.standalone) {
            serializer.save();
        }
        boolean bl = Serializer.getInt((Object)serializer.getProperty((Object)"DataBookOptions", (Object)"Access"), (int)0) == 0;
        String string = (String)serializer.getProperty((Object)"DataBookOptions", (Object)"Location");
        try {
            if (bl) {
                FileOutputStream fileOutputStream = string != null && string.length() > 0 ? new FileOutputStream(string) : new FileOutputStream(this.properties.getProperty(HOME, "." + File.separatorChar) + File.separatorChar + STOR_NAME);
                this.io.write(this.folders, fileOutputStream, "utf-8");
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Can't create file " + this.properties.getProperty(HOME, "./") + STOR_NAME + ' ' + fileNotFoundException);
        }
        catch (IOException iOException) {
            System.err.println("IO problem at writing back: " + iOException);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void load() {
        Serializer serializer = this.controller.getSerializer();
        if (this.standalone) {
            serializer.load();
        }
        this.view = Serializer.getInt((Object)serializer.getProperty((Object)ABVIEW, (Object)VIEW), (int)31);
        this.sortField = Serializer.getInt((Object)serializer.getProperty((Object)ABVIEW, (Object)SORTBY), (int)0);
        this.subSortField = Serializer.getInt((Object)serializer.getProperty((Object)ABVIEW, (Object)NAMESORT), (int)0);
        this.sortDir = Serializer.getInt((Object)serializer.getProperty((Object)ABVIEW, (Object)SORTORDER), (int)0) != 0;
        Object[] objectArray = (Object[])serializer.getProperty((Object)ABVIEW, (Object)BOUNDS);
        if (objectArray != null) {
            this.setBounds((Integer)objectArray[0], (Integer)objectArray[1], (Integer)objectArray[2], (Integer)objectArray[3]);
        }
        InputStream inputStream = null;
        boolean bl = Serializer.getInt((Object)serializer.getProperty((Object)"DataBookOptions", (Object)"Access"), (int)0) != 0;
        String string = (String)serializer.getProperty((Object)"DataBookOptions", (Object)"Location");
        if (string == null) {
            try {
                string = this.properties.getProperty(HOME, "." + File.separatorChar) + File.separatorChar + STOR_NAME;
                inputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            try {
                inputStream = new URL(string).openStream();
                bl = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (inputStream == null) {
                try {
                    inputStream = new FileInputStream(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (inputStream != null) {
            serializer.setProperty((Object)"DataBookOptions", (Object)"Location", (Object)string);
            serializer.setProperty((Object)"DataBookOptions", (Object)"Access", (Object)(bl ? AddressBookResources.YES_INT : AddressBookResources.NO_INT));
            try {
                this.folders = this.io.read(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.folders == null) {
            this.folders = new Vector();
            this.folders.addElement(new Folder("Persons", 1));
        }
        OptionsFrame.applyLocale(serializer);
    }

    public void setStatusText(String string) {
        if (this.statusLine != null) {
            this.statusLine.setText(string);
        }
    }

    JMenuBar createMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        this.createNewMenu(jMenu, this);
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Properties");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Delete");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu("Import");
        jMenu.add(jMenu2);
        jMenuItem = new JMenuItem("Address Book...");
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Business Card(vCard)...");
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Other Address Book...");
        jMenu2.add(jMenuItem);
        jMenu2 = new JMenu("Export");
        jMenu.add(jMenu2);
        jMenuItem = new JMenuItem("Address Book...");
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Business Card(vCard)...");
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem("Other Address Book...");
        jMenu2.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Print");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(this.standalone ? "Exit" : "Close");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu = new JMenu("Edit");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Copy");
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control C"));
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Paste");
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control V"));
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Select all");
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control A"));
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Profile...");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Find People...");
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control F"));
        jMenuItem.addActionListener(this);
        jMenu = new JMenu(VIEW);
        jMenuBar.add(jMenu);
        this.m_toolBar = new JCheckBoxMenuItem("Toolbar");
        jMenu.add(this.m_toolBar);
        this.m_toolBar.addActionListener(this);
        this.m_toolBar.setSelected((this.view & 2) != 0);
        this.m_statusBar = new JCheckBoxMenuItem("Statusbar");
        jMenu.add(this.m_statusBar);
        this.m_statusBar.addActionListener(this);
        this.m_statusBar.setSelected((this.view & 4) != 0);
        this.m_folder = new JCheckBoxMenuItem("Folders and Groups");
        jMenu.add(this.m_folder);
        this.m_folder.addActionListener(this);
        this.m_folder.setSelected((this.view & 0x10) != 0);
        jMenu.addSeparator();
        jMenu2 = new JMenu("Sort By");
        jMenu.add(jMenu2);
        ButtonGroup buttonGroup = new ButtonGroup();
        jMenuItem = new JRadioButtonMenuItemEx(new RadioAction("Name"));
        jMenu2.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem.setSelected(1 == this.sortField);
        jMenuItem = new JRadioButtonMenuItemEx(new RadioAction("E-Mail Address"));
        jMenu2.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem.setSelected(2 == this.sortField);
        jMenuItem = new JRadioButtonMenuItemEx(new RadioAction("Telephone"));
        jMenu2.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem.setSelected(3 == this.sortField);
        jMenu2.addSeparator();
        buttonGroup = new ButtonGroup();
        jMenuItem = new JRadioButtonMenuItemEx(new RadioAction("First Name"));
        jMenu2.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem.setSelected(0 == this.subSortField);
        jMenuItem = new JRadioButtonMenuItemEx(new RadioAction("Last Name"));
        jMenu2.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem.setSelected(1 == this.subSortField);
        jMenu2.addSeparator();
        buttonGroup = new ButtonGroup();
        jMenuItem = new JRadioButtonMenuItemEx(new RadioAction("Ascending"));
        jMenu2.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem.setSelected(this.sortDir);
        jMenuItem = new JRadioButtonMenuItemEx(new RadioAction("Descending"));
        jMenu2.add(jMenuItem);
        buttonGroup.add(jMenuItem);
        jMenuItem.setSelected(this.sortDir);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Refresh");
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("F5"));
        jMenuItem.addActionListener(this);
        jMenu = new JMenu("Tools");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Accounts");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Options");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenu2 = new JMenu("Action");
        jMenu.add(jMenu2);
        this.createActionMenu(jMenu2, this);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Synchronize now");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu = new JMenu("Help");
        jMenuBar.add(jMenu);
        jMenuItem = new JMenuItem("Contents");
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("F1"));
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("About...R-AddressBook");
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        return jMenuBar;
    }

    JComponent createNewMenu(JComponent jComponent, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem("New contact...");
        jComponent.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control N"));
        jMenuItem.addActionListener(actionListener);
        jMenuItem = new JMenuItem("New bookmark...");
        jComponent.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control B"));
        jMenuItem.addActionListener(actionListener);
        jMenuItem = new JMenuItem("New cookie...");
        jComponent.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control O"));
        jMenuItem.addActionListener(actionListener);
        jMenuItem = new JMenuItem("New group...");
        jComponent.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control G"));
        jMenuItem.addActionListener(actionListener);
        jMenuItem = new JMenuItem("New folder...");
        jComponent.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke("control R"));
        jMenuItem.addActionListener(actionListener);
        return jComponent;
    }

    JComponent createActionMenu(JComponent jComponent, ActionListener actionListener) {
        int n = 0;
        while (n < AddressBookResources.MENUS_ACTION.length) {
            JMenuItem jMenuItem = new JMenuItem(AddressBookResources.MENUS_ACTION[n]);
            jComponent.add(jMenuItem);
            jMenuItem.addActionListener(actionListener);
            ++n;
        }
        return jComponent;
    }

    JToolBar createToolBar(int n) {
        JToolBar jToolBar = new JToolBar(n);
        JButton jButton = jToolBar.add(new ToolAction("New", null, "Creation of a new person, a link, a cookie, etc."));
        jButton = jToolBar.add(new ToolAction("Properties", "Properties", "Edit properties of selected element."));
        jButton = jToolBar.add(new ToolAction("Delete", "Delete"));
        jButton = jToolBar.add(new ToolAction("Find", "Find People..."));
        jButton = jToolBar.add(new ToolAction("Print", "Print"));
        jButton = jToolBar.add(new ToolAction("Action"));
        return jToolBar;
    }

    JComponent createBook() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(new JLabel("Type name or select from list"));
        JTextField jTextField = new JTextField(20);
        jPanel2.add(jTextField);
        SearchPerformer searchPerformer = new SearchPerformer();
        jTextField.getDocument().addDocumentListener(searchPerformer);
        jTextField.addActionListener(searchPerformer);
        jPanel.add((Component)jPanel2, "North");
        this.table = new JTable(null);
        FocusTracer focusTracer = new FocusTracer();
        this.table.addFocusListener(focusTracer);
        ComboCellRenderer comboCellRenderer = new ComboCellRenderer();
        this.table.setDefaultRenderer(class$javax$swing$JComboBox == null ? (class$javax$swing$JComboBox = AddressBookFrame.class$("javax.swing.JComboBox")) : class$javax$swing$JComboBox, comboCellRenderer);
        this.table.setDefaultEditor(class$javax$swing$JComboBox == null ? (class$javax$swing$JComboBox = AddressBookFrame.class$("javax.swing.JComboBox")) : class$javax$swing$JComboBox, comboCellRenderer);
        this.table.addMouseListener(new MouseInputAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 4) <= 0 && mouseEvent.getClickCount() == 2) {
                    AddressBookFrame.this.actionPerformed(new ActionEvent(this, 0, "Properties"));
                }
            }
        });
        jPanel.add((Component)new JScrollPane(this.table), "Center");
        if ((this.view & 0x10) != 0) {
            this.tree = new JTree(AddressBookFrame.createTreeModel(this.folders));
            focusTracer = new FocusTracer();
            this.tree.addFocusListener(focusTracer);
            this.tree.setRootVisible(false);
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    try {
                        AddressBookFrame.this.table.setModel(new BaseAttrTableModel(((Folder)AddressBookFrame.getSelectedValueByName(AddressBookFrame.this.folders, AddressBookFrame.this.tree.getLastSelectedPathComponent().toString())).getContent()));
                    }
                    catch (NullPointerException nullPointerException) {
                        AddressBookFrame.this.table.setModel(new BaseAttrTableModel(new Vector()));
                    }
                }
            });
            return new JSplitPane(1, true, new JScrollPane(this.tree), new JScrollPane(jPanel));
        }
        return jPanel;
    }

    static Object getSelectedValueByName(Vector vector, String string) {
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n).toString().equals(string)) {
                return vector.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    static DefaultMutableTreeNode createTreeModel(Vector vector) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("databook");
        JTree.DynamicUtilTreeNode.createChildren(defaultMutableTreeNode, vector);
        return defaultMutableTreeNode;
    }

    public static JPanel createButtonPanel(ActionListener actionListener) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton("OK");
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        jButton = new JButton("<html><i>Apply");
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        jButton = new JButton("Cancel");
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        return jPanel;
    }

    JPanel createStatusBar() {
        JPanel jPanel = new JPanel();
        this.statusLine = new JLabel("Status bar", 4);
        jPanel.add(this.statusLine);
        jPanel.setBorder(new BevelBorder(1));
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (!string.equals("Find People...")) {
            if (string.equals("New contact...")) {
                if (this.table.getModel() != null && this.table.getModel() instanceof BaseAttrTableModel) {
                    new ContactFrame(this.table);
                }
            } else if (string.equals("New folder...")) {
                String string2 = JOptionPane.showInputDialog(this, "Folder name", "Enter", 3);
                if (string2 != null) {
                    if (AddressBookFrame.getSelectedValueByName(this.folders, string2) == null) {
                        this.folders.addElement(new Folder(string2, 1));
                        this.tree.setModel(new DefaultTreeModel(AddressBookFrame.createTreeModel(this.folders), false));
                    } else {
                        JOptionPane.showMessageDialog(this, "Duplicated folder name. A new folder hasn't been added.", "Warning", 2);
                    }
                }
            } else if (string.equals("Properties")) {
                if (this.table.hasFocus() || this.lastFocused == this.table) {
                    int n = this.table.getSelectedRow();
                    if (n > -1) {
                        new ContactFrame(this.table, n);
                    }
                } else if (this.tree.hasFocus() || this.lastFocused == this.tree) {
                    try {
                        Folder folder = (Folder)AddressBookFrame.getSelectedValueByName(this.folders, this.tree.getLastSelectedPathComponent().toString());
                        if (folder != null) {
                            JOptionPane.showMessageDialog(this, "Properties of folder " + folder);
                        }
                    }
                    catch (Exception exception) {}
                }
            } else if (string.equals("Delete")) {
                if (this.table.hasFocus() || this.lastFocused == this.table) {
                    int n = this.table.getSelectedRow();
                    if (n > -1 && JOptionPane.showConfirmDialog(this, "Are you sure to delete contact?", "Confirm", 0, 3) == 0) {
                        ((BaseAttrTableModel)this.table.getModel()).removeValue(n);
                        this.table.revalidate();
                    }
                } else if (this.tree.hasFocus() || this.lastFocused == this.tree) {
                    try {
                        if (JOptionPane.showConfirmDialog(this, "Are you sure to delete folder?", "Confirm", 0, 3) == 0) {
                            this.folders.remove(AddressBookFrame.getSelectedValueByName(this.folders, this.tree.getLastSelectedPathComponent().toString()));
                            this.tree.setModel(new DefaultTreeModel(AddressBookFrame.createTreeModel(this.folders), false));
                        }
                    }
                    catch (Exception exception) {}
                }
            } else if (string.equals("Options")) {
                new OptionsFrame(this.controller);
            } else if (string.equals("Exit")) {
                this.save();
                this.dispose();
                System.exit(0);
            } else if (string.equals("Send Mail")) {
                Vector vector;
                Contact contact = this.getSelectedContact();
                if (contact != null && (vector = contact.getEMails()) != null) {
                    if (vector.size() == 1) {
                        this.sendMail(((EMail)vector.elementAt(0)).getValue());
                    } else if (vector.size() > 1) {
                        Object[] objectArray = new EMail[vector.size()];
                        vector.copyInto(objectArray);
                        objectArray[0] = (EMail)JOptionPane.showInputDialog(this, "Select e-mail", "Enter", 3, null, objectArray, objectArray[0]);
                        if (objectArray[0] != null) {
                            this.sendMail(((GenericAttribute)objectArray[0]).getValue());
                        }
                    }
                }
            } else if (string.equals("Show URL")) {
                Vector vector;
                Contact contact = this.getSelectedContact();
                if (contact != null && (vector = contact.getLinks()) != null) {
                    if (vector.size() == 1) {
                        this.controller.showUrl(((Link)vector.elementAt(0)).getValue());
                    } else if (vector.size() > 1) {
                        Object[] objectArray = new Link[vector.size()];
                        vector.copyInto(objectArray);
                        objectArray[0] = (Link)JOptionPane.showInputDialog(this, "Select URL", "Enter", 3, null, objectArray, objectArray[0]);
                        if (objectArray[0] != null) {
                            this.controller.showUrl(((GenericAttribute)objectArray[0]).getValue());
                        }
                    }
                }
            } else if (!string.equals("Get directions")) {
                if (string.equals("Dial to")) {
                    Vector vector;
                    Contact contact = this.getSelectedContact();
                    if (contact != null && (vector = contact.getTelephones()) != null) {
                        if (vector.size() == 1) {
                            this.dialPhone(((EMail)vector.elementAt(0)).getValue());
                        } else if (vector.size() > 1) {
                            Object[] objectArray = new Telephone[vector.size()];
                            vector.copyInto(objectArray);
                            objectArray[0] = (Telephone)JOptionPane.showInputDialog(this, "Select telephone #", "Enter", 3, null, objectArray, objectArray[0]);
                            if (objectArray[0] != null) {
                                this.dialPhone(((GenericAttribute)objectArray[0]).getValue());
                            }
                        }
                    }
                } else if (!string.equals("Copy") && !string.equals("Paste")) {
                    if (string.equals("Select all")) {
                        this.table.setRowSelectionInterval(0, this.table.getRowCount() - 1);
                    } else if (!string.equals("Chat to")) {
                        if (string.equals("Close")) {
                            this.save();
                            this.dispose();
                        } else if (string.equals("Toolbar")) {
                            this.view = this.m_toolBar.isSelected() ? (this.view |= 2) : (this.view &= 0xFFFFFFFD);
                        } else if (string.equals("Statusbar")) {
                            this.view = this.m_statusBar.isSelected() ? (this.view |= 4) : (this.view &= 0xFFFFFFFB);
                        } else if (string.equals("Folders and Groups")) {
                            this.view = this.m_folder.isSelected() ? (this.view |= 0x10) : (this.view &= 0xFFFFFFEF);
                        } else if (string.equals("Name")) {
                            this.sortField = 1;
                            this.sortModel();
                        } else if (string.equals("E-Mail Address")) {
                            this.sortField = 2;
                            this.sortModel();
                        } else if (string.equals("Telephone")) {
                            this.sortField = 3;
                            this.sortModel();
                        } else if (string.equals("First Name")) {
                            this.subSortField = 0;
                            this.sortModel();
                        } else if (string.equals("Last Name")) {
                            this.subSortField = 1;
                            this.sortModel();
                        } else if (string.equals("Ascending")) {
                            this.sortDir = true;
                            this.sortModel();
                        } else if (string.equals("Descending")) {
                            this.sortDir = false;
                            this.sortModel();
                        } else if (string.equals("Refresh")) {
                            this.sortModel();
                        } else if (string.equals("Profile...")) {
                            new ProfileFrame();
                        } else if (string.indexOf("About...") >= 0) {
                            JOptionPane.showMessageDialog(this, "<html><i>R-AddressBook\nversion 1.0preview.3\nFor E. B.\nCopyright \u00a9 2000, 2001 Dmitriy Rogatkin\n All rights reserved.\nJava " + System.getProperty("java.version") + "JVM " + System.getProperty("java.vendor") + " OS " + System.getProperty("os.name") + ' ' + System.getProperty("os.version") + ' ' + System.getProperty("os.arch") + '\n' + Locale.getDefault().getDisplayName(), "About...", -1, BaseController.getResourceIcon((String)"AddressBook.jpg"));
                        } else if (string.equals("Contents")) {
                            this.controller.showUrl("../R-AddressBook.html");
                        }
                    }
                }
            }
        }
    }

    void sortModel() {
        BaseAttrTableModel baseAttrTableModel;
        if (this.table.getModel() instanceof BaseAttrTableModel && (baseAttrTableModel = (BaseAttrTableModel)this.table.getModel()) != null) {
            baseAttrTableModel.sort(this.sortField, this.subSortField, this.sortDir);
            this.table.revalidate();
            this.table.repaint();
        }
    }

    Contact getSelectedContact() {
        int n = this.table.getSelectedRow();
        if (n > -1) {
            return ((BaseAttrTableModel)this.table.getModel()).getValueAt(n);
        }
        return null;
    }

    void sendMail(String string) {
        ActionPerformer actionPerformer = null;
        try {
            actionPerformer = (ActionPerformer)this.controller.component((Object)COMP_ACTIONPERFORMER);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (actionPerformer != null) {
            actionPerformer.act(1, (Object)string);
            this.setState(1);
        } else {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(string), null);
        }
    }

    void dialPhone(String string) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(string), null);
    }

    public static void main(String[] stringArray) {
        new AddressBookFrame(null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class JRadioButtonMenuItemEx
    extends JRadioButtonMenuItem {
        Action action;
        PropertyChangeListener actionPropertyChangeListener;

        JRadioButtonMenuItemEx(Action action) {
            this.setAction(action);
        }

        public Action getAction() {
            return this.action;
        }

        public void setAction(Action action) {
            Action action2 = this.getAction();
            if (this.action == null || !this.action.equals(action)) {
                this.action = action;
                if (action2 != null) {
                    this.removeActionListener(action2);
                    action2.removePropertyChangeListener(this.actionPropertyChangeListener);
                    this.actionPropertyChangeListener = null;
                }
                this.configurePropertiesFromAction(this.action);
                if (this.action != null) {
                    this.addActionListener(this.action);
                    this.actionPropertyChangeListener = this.createActionPropertyChangeListener(this.action);
                    this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
                }
                this.firePropertyChange("action", action2, this.action);
                this.revalidate();
                this.repaint();
            }
        }

        protected void configurePropertiesFromAction(Action action) {
            this.setEnabled(action.isEnabled());
            this.setText((String)action.getValue("Name"));
        }

        protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
            return new PropertyChangeListener(this){
                private final /* synthetic */ JRadioButtonMenuItemEx this$1;
                {
                    this.this$1 = jRadioButtonMenuItemEx;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                }
            };
        }
    }

    class RadioAction
    extends AbstractAction {
        RadioAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AddressBookFrame.this.actionPerformed(actionEvent);
        }
    }

    class ToolAction
    extends AbstractAction {
        Icon im;

        ToolAction(String string) {
            this(string, null);
        }

        ToolAction(String string, String string2) {
            this(string, string2, null);
        }

        ToolAction(String string, String string2, String string3) {
            super(string);
            if (string2 != null) {
                this.putValue("ActionCommandKey", string2);
            }
            if (string3 != null) {
                this.putValue("ShortDescription", string3);
            }
            this.im = BaseController.getResourceIcon((String)(string + ".gif"));
        }

        public Object getValue(String string) {
            if (string == "SmallIcon") {
                return this.im;
            }
            return super.getValue(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("New".equals(this.getValue("Name"))) {
                Rectangle rectangle = ((Component)actionEvent.getSource()).getBounds();
                Point point = new Point(0, rectangle.height);
                point = SwingUtilities.convertPoint((Component)actionEvent.getSource(), point, AddressBookFrame.this);
                ((JPopupMenu)AddressBookFrame.this.createNewMenu(new JPopupMenu(), AddressBookFrame.this)).show(AddressBookFrame.this, point.x, point.y);
            } else if ("Action".equals(this.getValue("Name"))) {
                Rectangle rectangle = ((Component)actionEvent.getSource()).getBounds();
                Point point = new Point(0, rectangle.height);
                point = SwingUtilities.convertPoint((Component)actionEvent.getSource(), point, AddressBookFrame.this);
                ((JPopupMenu)AddressBookFrame.this.createActionMenu(new JPopupMenu(), AddressBookFrame.this)).show(AddressBookFrame.this, point.x, point.y);
            } else {
                AddressBookFrame.this.actionPerformed(new ActionEvent(actionEvent.getSource(), actionEvent.getID(), (String)this.getValue("ActionCommandKey")));
            }
        }
    }

    class ComboCellRenderer
    extends AbstractCellEditor
    implements TableCellRenderer,
    TableCellEditor {
        ComboCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return object != null ? new JComboBox((Vector)object) : null;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return object != null ? new JComboBox((Vector)object) : null;
        }

        public Object getCellEditorValue() {
            return null;
        }
    }

    class FocusTracer
    extends FocusAdapter {
        FocusTracer() {
        }

        public void focusGained(FocusEvent focusEvent) {
            AddressBookFrame.this.lastFocused = null;
        }

        public void focusLost(FocusEvent focusEvent) {
            AddressBookFrame.this.lastFocused = (JComponent)focusEvent.getSource();
        }
    }

    class SearchPerformer
    implements ActionListener,
    DocumentListener {
        SearchPerformer() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (this.doSearch(((JTextField)actionEvent.getSource()).getText())) {
                    AddressBookFrame.this.table.requestFocus();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            try {
                this.doSearch(documentEvent.getDocument().getText(0, documentEvent.getDocument().getLength()));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        private boolean doSearch(String string) {
            TableModel tableModel = AddressBookFrame.this.table.getModel();
            if (tableModel != null && tableModel instanceof BaseAttrTableModel) {
                BaseAttrTableModel baseAttrTableModel = (BaseAttrTableModel)tableModel;
                int n = 0;
                while (n < baseAttrTableModel.getRowCount()) {
                    Contact contact = baseAttrTableModel.getValueAt(n);
                    if (AddressBookFrame.this.sortField == 1) {
                        if (string.regionMatches(true, 0, AddressBookFrame.this.subSortField == 0 ? contact.getName().getFirst() : contact.getName().getLast(), 0, string.length())) {
                            AddressBookFrame.this.table.setRowSelectionInterval(n, n);
                            return true;
                        }
                    } else if (AddressBookFrame.this.sortField == 2 || AddressBookFrame.this.sortField == 3) {
                        Vector vector = AddressBookFrame.this.sortField == 3 ? contact.getTelephones() : contact.getEMails();
                        int n2 = 0;
                        while (n2 < vector.size()) {
                            if (string.regionMatches(true, 0, vector.elementAt(n2).toString(), 0, string.length())) {
                                AddressBookFrame.this.table.setRowSelectionInterval(n, n);
                                return true;
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
            return false;
        }
    }
}

