/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import photoorganizer.Controller;
import photoorganizer.album.Access;
import photoorganizer.renderer.AlbumPane;
import rogatkin.Serializer;

public class Upgrader {
    static final String VERSION_TAG_URI = "VersionTag";
    static final String VERSION_DNLOAD_URI = "Download";
    static final String SECNAME = "Upgrader";
    static final int CHECKING_DURATION = 1800000;
    static final String DL_EXT = ".dl";
    static final String DBUPGRADENOTICE = "upgradedb.htm";
    static final String DINARIESUPGRADENOTICE = "programupgrade.htm";
    protected Controller controller;

    Upgrader(Controller controller) {
        this.controller = controller;
        this.checkJavaVersion();
        this.checkDBVersion();
        this.checkBinariesVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void checkDBVersion() {
        block14: {
            ResultSet resultSet;
            block13: {
                resultSet = null;
                resultSet = ((AlbumPane)this.controller.component(Controller.COMP_ALBUMPANEL)).getAccess().getAvailableConnection().createStatement().executeQuery("SELECT * FROM Connection WHERE 1<>2");
                if (resultSet.getMetaData().getColumnCount() >= Access.CONNECTION_DATABASE_STRUCTURE.length) break block13;
                this.controller.showHtml(Controller.streamToString((InputStream)new FileInputStream(this.controller.getHomeDirectory() + DBUPGRADENOTICE), (String)null), "Upgrade notification");
            }
            Object var4_2 = null;
            if (resultSet == null) break block14;
            try {
                resultSet.getStatement().close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {}
            break block14;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var4_3 = null;
                    if (resultSet == null) break block14;
                    try {
                        resultSet.getStatement().close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (resultSet != null) {
                    try {
                        resultSet.getStatement().close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    protected void checkBinariesVersion() {
        Serializer serializer = this.controller.getSerializer();
        String string = (String)serializer.getProperty((Object)SECNAME, (Object)VERSION_TAG_URI);
        if (string == null) {
            string = "http://mediachest.sourceforge.net/VersionTag";
        }
        final String string2 = string;
        string = (String)serializer.getProperty((Object)SECNAME, (Object)VERSION_DNLOAD_URI);
        if (string == null) {
            string = "http://mediachest.sourceforge.net/Download";
        }
        final String string3 = string;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new URL(string2).openStream()));
                        String string = bufferedReader.readLine();
                        boolean bl = false;
                        if ("version 1.1".compareTo(string) < 0) {
                            bl = true;
                        }
                        string = bufferedReader.readLine();
                        if (!bl && String.valueOf(74).compareTo(string) < 0) {
                            bl = true;
                        }
                        if (bl) {
                            int n = JOptionPane.showConfirmDialog(Upgrader.this.controller.getMainFrame(), "A newer version of the program is available.\nWould you like to download?", "Upgrade", 1, 3);
                            if (0 == n) {
                                while ((string = bufferedReader.readLine()) != null) {
                                    StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
                                    if (!stringTokenizer.hasMoreTokens()) continue;
                                    String string22 = stringTokenizer.nextToken();
                                    String string32 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : string22;
                                    try {
                                        File file;
                                        File file2;
                                        BufferedInputStream bufferedInputStream = new BufferedInputStream(new URL(new URL(string3), string22).openStream());
                                        String string4 = null;
                                        StringTokenizer stringTokenizer2 = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
                                        while (stringTokenizer2.hasMoreTokens()) {
                                            string4 = stringTokenizer2.nextToken();
                                            if (string4.endsWith(string32)) break;
                                            string4 = null;
                                        }
                                        if (string4 != null) {
                                            file2 = new File(string4 + Upgrader.DL_EXT);
                                            file = new File(string4);
                                        } else {
                                            string4 = System.getProperty("user.dir", ".");
                                            file2 = new File(string4, string32 + Upgrader.DL_EXT);
                                            file = new File(string4, string32);
                                        }
                                        Upgrader.this.upgradeFile(bufferedInputStream, file2, file);
                                    }
                                    catch (IOException iOException) {
                                        System.err.println("File " + string22 + " can not replace " + string32 + " due io problem " + iOException);
                                    }
                                }
                            } else if (1 == n) {
                                break;
                            }
                        }
                    }
                    catch (Exception exception) {
                        System.err.println("Upgrade checking exception " + exception + " for " + string3);
                    }
                    try {
                        Thread.sleep(1800000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, "VersionChecker");
        thread.setPriority(1);
        thread.start();
    }

    protected void checkJavaVersion() {
        if (!Controller.isJdk1_4()) {
            JOptionPane.showMessageDialog(this.controller.getMainFrame(), "MediaChest requires JDK 1.4 or better.\n Please upgrade your JDK http://java.sun.com/j2se/1.4/", "Upgrade", 1);
        }
    }

    protected void upgradeFile(InputStream inputStream, File file, File file2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        Controller.copyStream((InputStream)inputStream, (OutputStream)fileOutputStream);
        fileOutputStream.flush();
        fileOutputStream.close();
        if (!file2.delete()) {
            System.err.println("Can not delete the upgradable file " + file2);
        }
        if (!file.renameTo(file2)) {
            System.err.println("Can not rename the downloaded file " + file + " to the upgradable file " + file2);
            System.err.println("Copying.." + file + " to " + file2);
            Controller.copyFile((File)file, (File)file2);
            System.err.println("Deleting.." + file);
            if (!file.delete()) {
                System.err.println("Can not delete the downloaded file " + file);
            }
        }
    }
}

