/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import photoorganizer.Controller;
import photoorganizer.Resources;
import photoorganizer.formats.FileNameFormat;
import photoorganizer.renderer.PopupCombo;
import rogatkin.GranulatedLayout;
import rogatkin.Helpable;
import rogatkin.Persistable;
import rogatkin.Serializer;

public class TransformOptionsTab
extends JPanel
implements DocumentListener,
ItemListener,
Persistable,
Helpable {
    public static final String SECNAME = "TransformOptions";
    static final String MASK = "Mask";
    static final String MOVE = "Move";
    static final String FORMAT = "Format";
    static final String KEEP = "Keep";
    public static final String TRANSFORM = "TransformCode";
    static final String TRANSFTOSEL = "TransformedToSelection";
    Controller controller;
    JTextField tf_mask;
    JTextField tf_trans;
    JComboBox mb_mask;
    JComboBox mb_format;
    JComboBox mb_trans_op;
    JCheckBox cb_move;
    JCheckBox cb_tosel;
    JRadioButton rb_en;
    JRadioButton rb_kp;
    ButtonGroup bg_format;
    Object[] transcodes;

    public TransformOptionsTab(Controller controller) {
        this.controller = controller;
        this.setLayout((LayoutManager)new GranulatedLayout(6, 7, 20, 4, 8, 8));
        this.add((Component)new JLabel("Target name generation mask"), "0,0,4,1");
        this.tf_mask = new JTextField();
        this.add((Component)this.tf_mask, "0,1,3,1");
        this.tf_mask.getDocument().addDocumentListener(this);
        this.add((Component)new PopupCombo(Resources.MASKS[1], "<", this, "3,1,1,1", this.tf_mask), "3,1,2,1");
        this.cb_move = new JCheckBox("Keep original");
        this.add((Component)this.cb_move, "0,2,2,1");
        this.cb_tosel = new JCheckBox("Add transformed to selection");
        this.add((Component)this.cb_tosel, "2,2,2");
        this.cb_tosel.setToolTipText("Check it, if you'd like to add a transformed image to selection");
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Markers"));
        jPanel.setOpaque(false);
        this.add((Component)jPanel, "0,3,4,4,4,12");
        this.bg_format = new ButtonGroup();
        this.rb_kp = new JRadioButton("Preserve APPs");
        this.add((Component)this.rb_kp, "0,4,2,1,18");
        this.bg_format.add(this.rb_kp);
        this.rb_en = new JRadioButton("Enforce format");
        this.add((Component)this.rb_en, "0,5,2,1,18");
        this.bg_format.add(this.rb_en);
        this.rb_en.setSelected(true);
        this.mb_format = new JComboBox<String>(Resources.FORMATS);
        this.add(this.mb_format, "2,5,2,1,24");
        this.mb_format.setLightWeightPopupEnabled(false);
        jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Transform code"));
        jPanel.setOpaque(false);
        this.add((Component)jPanel, "4,2,2,4,4,4");
        this.mb_trans_op = new JComboBox<String>(Resources.ROTATIONS);
        this.add(this.mb_trans_op, "4,3,2,1,24");
        this.mb_trans_op.setLightWeightPopupEnabled(false);
        this.mb_trans_op.addItemListener(this);
        this.tf_trans = new JTextField();
        this.add((Component)this.tf_trans, "4,4,2,1,24");
        this.tf_trans.getDocument().addDocumentListener(this);
    }

    public String getHelp() {
        return "<html>\n<h2>Format escape sequences for pictures and music</h2>\n<pre>\n %D - date/time stamp in current locale,\n %d - date stamp,\n %t - time stamp,\n %s - shutter speed/bitrate,\n %a - aperture value/sample rate,\n %f - flash/protected (yes, no),\n %q - quality/mode\n %c - counter, can be specified as %0..0c, if leading zeros have to be present,\n %o - original file name,\n %r - transformation code expanded to: r90, r270, r180, TrPose, TrVerse, HMirr, VMirr\n %S - file size (undocumented),\n %z - focal length (zoom)/year,\n %M - make/artist\n %m - model/title\n %x - metering mode,\n %X - exposure program\n %n - type extension\n Format escape sequences for music\n %A - album,\n %b - band,\n %C - comment,\n %L - language,\n %g - genre,\n %l - length,\n %T - track,\n %e - composer,\n %E - conductor\n </pre>";
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = itemEvent.getStateChange();
        if (n == 1) {
            this.tf_trans.setText((String)this.transcodes[this.mb_trans_op.getSelectedIndex()]);
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.tf_mask.getDocument()) {
            this.tf_mask.setToolTipText(FileNameFormat.makeValidPathName(new FileNameFormat(this.tf_mask.getText()).format(this.controller.sampleJpeg)));
        } else if (documentEvent.getDocument() == this.tf_trans.getDocument()) {
            this.transcodes[this.mb_trans_op.getSelectedIndex()] = this.tf_trans.getText();
        }
    }

    public void load() {
        String string;
        Serializer serializer = this.controller.getSerializer();
        String string2 = (String)serializer.getProperty((Object)SECNAME, (Object)MASK);
        if (string2 != null) {
            this.tf_mask.setText(string2);
        }
        this.cb_tosel.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)TRANSFTOSEL), (int)1) == 1);
        this.cb_move.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)MOVE), (int)0) == 1);
        Integer n = (Integer)serializer.getProperty((Object)SECNAME, (Object)KEEP);
        if (n != null) {
            if (n == 1) {
                this.rb_kp.setSelected(true);
            } else {
                this.rb_en.setSelected(true);
            }
        }
        if ((string = (String)serializer.getProperty((Object)SECNAME, (Object)FORMAT)) != null) {
            this.mb_format.setSelectedItem(string);
        }
        this.transcodes = FileNameFormat.transformCodes;
        this.mb_trans_op.setSelectedIndex(0);
        this.tf_trans.setText((String)this.transcodes[0]);
    }

    public void save() {
        Serializer serializer = this.controller.getSerializer();
        serializer.setProperty((Object)SECNAME, (Object)MASK, (Object)this.tf_mask.getText());
        serializer.setProperty((Object)SECNAME, (Object)MOVE, (Object)(this.cb_move.isSelected() ? Resources.I_YES : Resources.I_NO));
        serializer.setProperty((Object)SECNAME, (Object)FORMAT, this.mb_format.getSelectedItem());
        serializer.setProperty((Object)SECNAME, (Object)TRANSFTOSEL, (Object)(this.cb_tosel.isSelected() ? Resources.I_YES : Resources.I_NO));
        serializer.setProperty((Object)SECNAME, (Object)KEEP, (Object)(this.rb_kp.getModel() == this.bg_format.getSelection() ? Resources.I_YES : Resources.I_NO));
        FileNameFormat.transformCodes = this.transcodes;
        serializer.setProperty((Object)SECNAME, (Object)TRANSFORM, (Object)FileNameFormat.transformCodes);
    }
}

