/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import photoorganizer.Controller;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.BasicIo;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.Entry;
import photoorganizer.formats.FileFormatException;
import photoorganizer.formats.Rational;

public class Exif
extends AbstractImageInfo {
    public static final String FORMAT = "Exif";
    static final int FIRST_IFD_OFF = 6;
    static final int MIN_JPEG_SIZE = 100;
    public static final int NEWSUBFILETYPE = 254;
    public static final int IMAGEWIDTH = 256;
    public static final int IMAGELENGTH = 257;
    public static final int BITSPERSAMPLE = 258;
    public static final int COMPRESSION = 259;
    public static final int PHOTOMETRICINTERPRETATION = 262;
    public static final int FILLORDER = 266;
    public static final int DOCUMENTNAME = 269;
    public static final int IMAGEDESCRIPTION = 270;
    public static final int MAKE = 271;
    public static final int MODEL = 272;
    public static final int STRIPOFFSETS = 273;
    public static final int ORIENTATION = 274;
    public static final int SAMPLESPERPIXEL = 277;
    public static final int ROWSPERSTRIP = 278;
    public static final int STRIPBYTECOUNTS = 279;
    public static final int XRESOLUTION = 282;
    public static final int YRESOLUTION = 283;
    public static final int PLANARCONFIGURATION = 284;
    public static final int RESOLUTIONUNIT = 296;
    public static final int TRANSFERFUNCTION = 301;
    public static final int SOFTWARE = 305;
    public static final int DATETIME = 306;
    public static final int ARTIST = 315;
    public static final int WHITEPOINT = 318;
    public static final int PRIMARYCHROMATICITIES = 319;
    public static final int SUBIFDS = 330;
    public static final int JPEGTABLES = 347;
    public static final int TRANSFERRANGE = 342;
    public static final int JPEGPROC = 512;
    public static final int JPEGINTERCHANGEFORMAT = 513;
    public static final int JPEGINTERCHANGEFORMATLENGTH = 514;
    public static final int YCBCRCOEFFICIENTS = 529;
    public static final int YCBCRSUBSAMPLING = 530;
    public static final int YCBCRPOSITIONING = 531;
    public static final int REFERENCEBLACKWHITE = 532;
    public static final int CFAREPEATPATTERNDIM = 33421;
    public static final int CFAPATTERN = 33422;
    public static final int BATTERYLEVEL = 33423;
    public static final int COPYRIGHT = 33432;
    public static final int EXPOSURETIME = 33434;
    public static final int FNUMBER = 33437;
    public static final int IPTC_NAA = 33723;
    public static final int EXIFOFFSET = 34665;
    public static final int INTERCOLORPROFILE = 34675;
    public static final int EXPOSUREPROGRAM = 34850;
    public static final int SPECTRALSENSITIVITY = 34852;
    public static final int GPSINFO = 34853;
    public static final int ISOSPEEDRATINGS = 34855;
    public static final int OECF = 34856;
    public static final int EXIFVERSION = 36864;
    public static final int DATETIMEORIGINAL = 36867;
    public static final int DATETIMEDIGITIZED = 36868;
    public static final int COMPONENTSCONFIGURATION = 37121;
    public static final int COMPRESSEDBITSPERPIXEL = 37122;
    public static final int SHUTTERSPEEDVALUE = 37377;
    public static final int APERTUREVALUE = 37378;
    public static final int BRIGHTNESSVALUE = 37379;
    public static final int EXPOSUREBIASVALUE = 37380;
    public static final int MAXAPERTUREVALUE = 37381;
    public static final int SUBJECTDISTANCE = 37382;
    public static final int METERINGMODE = 37383;
    public static final int LIGHTSOURCE = 37384;
    public static final int FLASH = 37385;
    public static final int FOCALLENGTH = 37386;
    public static final int MAKERNOTE = 37500;
    public static final int USERCOMMENT = 37510;
    public static final int SUBSECTIME = 37520;
    public static final int SUBSECTIMEORIGINAL = 37521;
    public static final int SUBSECTIMEDIGITIZED = 37522;
    public static final int FLASHPIXVERSION = 40960;
    public static final int COLORSPACE = 40961;
    public static final int EXIFIMAGEWIDTH = 40962;
    public static final int EXIFIMAGELENGTH = 40963;
    public static final int INTEROPERABILITYOFFSET = 40965;
    public static final int FLASHENERGY = 41483;
    public static final int SPATIALFREQUENCYRESPONSE = 41484;
    public static final int FOCALPLANEXRESOLUTION = 41486;
    public static final int FOCALPLANEYRESOLUTION = 41487;
    public static final int FOCALPLANERESOLUTIONUNIT = 41488;
    public static final int SUBJECTLOCATION = 41492;
    public static final int EXPOSUREINDEX = 41493;
    public static final int SENSINGMETHOD = 41495;
    public static final int FILESOURCE = 41728;
    public static final int SCENETYPE = 41729;
    public static final int BYTE = 1;
    public static final int ASCII = 2;
    public static final int SHORT = 3;
    public static final int LONG = 4;
    public static final int RATIONAL = 5;
    public static final int SBYTE = 6;
    public static final int UNDEFINED = 7;
    public static final int SSHORT = 8;
    public static final int SLONG = 9;
    public static final int SRATIONAL = 10;
    static final int DIR_ENTRY_SIZE = 12;
    public static final int[] TYPELENGTH = new int[]{1, 1, 2, 4, 8, 1, 1, 2, 4, 8};
    int currentimage;
    int version;
    Hashtable[] imagedescr;

    public Exif(InputStream inputStream, byte[] byArray, int n, String string, String string2) throws FileFormatException {
        super(inputStream, byArray, n, string, string2);
    }

    public Exif() {
    }

    public String getFormat() {
        return FORMAT;
    }

    public static byte[] getMarkerData() {
        return new byte[]{-1, -31, 0, 40, 69, 120, 105, 102, 0, 0, 73, 73, 42, 0, 8, 0, 0, 0, 1, 0, 15, 1, 2, 0, 5, 0, 0, 0, 26, 0, 0, 0, 0, 0, 0, 0, 70, 65, 75, 69, 0, 0};
    }

    public Entry getTagValue(int n, boolean bl) {
        return this.getTagValue(new Integer(n), bl);
    }

    public Entry getTagValue(Integer n, boolean bl) {
        return (Entry)this.imagedescr[bl ? 0 : 1].get(n);
    }

    public Enumeration tags(boolean bl) {
        return this.imagedescr[bl ? 0 : 1].keys();
    }

    int getThumbnailLength() {
        Entry entry = this.getTagValue(514, false);
        if (entry == null) {
            return -1;
        }
        return (Integer)entry.getValue(0);
    }

    int getThumbnailOffset() {
        Entry entry = this.getTagValue(513, false);
        if (entry == null) {
            return -1;
        }
        return (Integer)entry.getValue(0);
    }

    public void saveThumbnailImage(BasicJpeg basicJpeg, OutputStream outputStream) throws IOException {
        if (outputStream == null || basicJpeg == null) {
            return;
        }
        boolean bl = false;
        int n = this.getThumbnailOffset();
        if (n > 0) {
            int n2 = this.getThumbnailLength();
            if (n2 > 100) {
                InputStream inputStream = basicJpeg.createInputStream();
                byte[] byArray = new byte[n2];
                BasicIo.skip(inputStream, this.offset + n + 6);
                BasicIo.read(inputStream, byArray);
                inputStream.close();
                int n3 = 0;
                while ((byArray[n3] != -1 || byArray[n3 + 1] != -40) && n3 < byArray.length - 1) {
                    ++n3;
                }
                if (byArray.length - n3 > 100) {
                    outputStream.write(byArray, n3, byArray.length - n3);
                    outputStream.flush();
                    bl = true;
                }
            }
        } else {
            Entry entry = this.getTagValue(273, false);
            if (entry != null) {
                InputStream inputStream = basicJpeg.createInputStream();
                n = (Integer)entry.getValue(0);
                if (n > 0) {
                    BasicIo.skip(inputStream, n);
                    entry = this.getTagValue(279, false);
                    if (entry != null) {
                        int n4 = (Integer)entry.getValue(0);
                        int n5 = 0;
                        int n6 = 0;
                        entry = this.getTagValue(256, false);
                        if (entry != null) {
                            n5 = (Integer)entry.getValue(0);
                        }
                        if ((entry = this.getTagValue(257, false)) != null) {
                            n6 = (Integer)entry.getValue(0);
                        }
                        int n7 = 8;
                        entry = this.getTagValue(258, false);
                        if (entry != null) {
                            n7 = (Integer)entry.getValue(0);
                        }
                        int n8 = 3;
                        entry = this.getTagValue(277, false);
                        if (entry != null) {
                            n8 = (Integer)entry.getValue(0);
                        }
                        this.data = new byte[54];
                        System.arraycopy(AbstractImageInfo.BMP_SIG, 0, this.data, 0, AbstractImageInfo.BMP_SIG.length);
                        n = 2;
                        int n9 = n5 * n8 + 3 & 0xFFFFFFFC;
                        n = this.i2bsI(n, 54 + n9 * n6, 4);
                        n = this.i2bsI(n, 0, 4);
                        n = this.i2bsI(n, 54, 4);
                        n = this.i2bsI(n, 40, 4);
                        n = this.i2bsI(n, n5, 4);
                        n = this.i2bsI(n, n6, 4);
                        n = this.i2bsI(n, 1, 2);
                        n = this.i2bsI(n, n8 * n7, 2);
                        n = this.i2bsI(n, 0, 4);
                        n = this.i2bsI(n, n9 * n6, 4);
                        n = this.i2bsI(n, 2834, 4);
                        n = this.i2bsI(n, 2834, 4);
                        n = this.i2bsI(n, 0, 4);
                        n = this.i2bsI(n, 0, 4);
                        outputStream.write(this.data);
                        this.data = new byte[n4];
                        BasicIo.read(inputStream, this.data);
                        int n10 = n9 - n5 * n8;
                        n9 = n5 * n8;
                        byte[] byArray = null;
                        if (n10 != 0) {
                            byArray = new byte[n10];
                        }
                        n = n4 - n9;
                        while (n >= 0) {
                            int n11 = 0;
                            while (n11 < n9) {
                                outputStream.write(this.data[n + n11 + 2]);
                                outputStream.write(this.data[n + n11 + 1]);
                                outputStream.write(this.data[n + n11]);
                                n11 += 3;
                            }
                            if (n10 != 0) {
                                outputStream.write(byArray);
                            }
                            n -= n9;
                        }
                    }
                }
                outputStream.flush();
                bl = true;
            }
        }
        if (bl) {
            outputStream.close();
        } else {
            super.saveThumbnailImage(basicJpeg, outputStream);
        }
    }

    public String getThumbnailExtension() {
        return this.getThumbnailOffset() > 0 ? "jpeg" : "bmp";
    }

    public Icon getThumbnailIcon(BasicJpeg basicJpeg, Dimension dimension) {
        int n = this.getThumbnailOffset();
        if (n > 0) {
            int n2 = this.getThumbnailLength();
            if (n2 > 100) {
                int n3 = 0;
                try {
                    InputStream inputStream = basicJpeg.createInputStream();
                    byte[] byArray = new byte[n2];
                    BasicIo.skip(inputStream, this.offset + n + 6);
                    inputStream.read(byArray);
                    inputStream.close();
                    while ((byArray[n3] != -1 || byArray[n3 + 1] != -40) && n3 < byArray.length - 1) {
                        ++n3;
                    }
                    if (n3 < byArray.length - 100) {
                        return new ImageIcon(Toolkit.getDefaultToolkit().createImage(byArray, n3, byArray.length - n3));
                    }
                }
                catch (IOException iOException) {
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.err.println("Bad index " + n3 + " for " + this.getName());
                }
            }
        } else {
            Entry entry = this.getTagValue(273, false);
            if (entry != null) {
                InputStream inputStream = basicJpeg.createInputStream();
                n = (Integer)entry.getValue(0);
                if (n > 0) {
                    try {
                        BasicIo.skip(inputStream, n);
                        entry = this.getTagValue(279, false);
                        if (entry != null) {
                            int n4 = (Integer)entry.getValue(0);
                            this.data = new byte[n4];
                            BasicIo.read(inputStream, this.data);
                            int n5 = 0;
                            int n6 = 0;
                            entry = this.getTagValue(256, false);
                            if (entry != null) {
                                n5 = (Integer)entry.getValue(0);
                            }
                            if ((entry = this.getTagValue(257, false)) != null) {
                                n6 = (Integer)entry.getValue(0);
                            }
                            int n7 = 8;
                            entry = this.getTagValue(258, false);
                            if (entry != null) {
                                n7 = (Integer)entry.getValue(0);
                            }
                            int n8 = 3;
                            entry = this.getTagValue(277, false);
                            if (entry != null) {
                                n8 = (Integer)entry.getValue(0);
                            }
                            int[] nArray = new int[n5 * n6];
                            int n9 = 0;
                            while (n9 < nArray.length) {
                                nArray[n9] = ((this.data[n9 * 3] & 0xFF) << 16) + ((this.data[n9 * 3 + 1] & 0xFF) << 8) + (this.data[n9 * 3 + 2] & 0xFF) + -16777216;
                                ++n9;
                            }
                            MemoryImageSource memoryImageSource = new MemoryImageSource(n5, n6, nArray, 0, n5);
                            Image image = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
                            nArray = null;
                            inputStream.close();
                            return new ImageIcon(image);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        if (Controller.getAdvancedImage() != null) {
            try {
                return Controller.getAdvancedImage().createThumbnailIcon(basicJpeg.getLocationName(), null);
            }
            catch (Throwable throwable) {
                System.err.println(throwable);
            }
        }
        return null;
    }

    public int getResolutionX() {
        Entry entry = this.getTagValue(40962, true);
        if (entry != null) {
            return (Integer)entry.getValue(0);
        }
        return -1;
    }

    public int getResolutionY() {
        Entry entry = this.getTagValue(40963, true);
        if (entry != null) {
            return (Integer)entry.getValue(0);
        }
        return -1;
    }

    public int getMetering() {
        Entry entry = this.getTagValue(37383, true);
        if (entry != null) {
            return (Integer)entry.getValue(0);
        }
        return 0;
    }

    public int getExpoProgram() {
        Entry entry = this.getTagValue(34850, true);
        if (entry != null) {
            return (Integer)entry.getValue(0);
        }
        return 0;
    }

    public String getMake() {
        Entry entry = this.getTagValue(271, true);
        if (entry != null) {
            return entry.toString();
        }
        return "n/a";
    }

    public String getModel() {
        Entry entry = this.getTagValue(272, true);
        if (entry != null) {
            return entry.toString();
        }
        return "n/a";
    }

    public String getDataTimeOriginalString() {
        String string;
        Entry entry = this.getTagValue(36867, true);
        if (entry != null && (string = entry.toString()).indexOf("0000:00:00") < 0) {
            return string;
        }
        return AbstractImageInfo.dateformat.format(new Date());
    }

    public float getFNumber() {
        Entry entry = this.getTagValue(33437, true);
        if (entry != null) {
            return ((Rational)entry.getValue(0)).floatValue();
        }
        entry = this.getTagValue(37378, true);
        if (entry != null) {
            return this.apertureToFnumber(((Rational)entry.getValue(0)).floatValue());
        }
        return -1.0f;
    }

    public Rational getShutter() {
        Entry entry = this.getTagValue(33434, true);
        if (entry != null) {
            return (Rational)entry.getValue(0);
        }
        entry = this.getTagValue(37377, true);
        try {
            return AbstractImageInfo.TV_TO_SEC[(int)((Rational)entry.getValue(0)).floatValue()];
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return new Rational(0, 1);
    }

    public boolean isFlash() {
        Entry entry = this.getTagValue(37385, true);
        if (entry != null) {
            return (Integer)entry.getValue(0) == 1;
        }
        return false;
    }

    public float getFocalLength() {
        Entry entry = this.getTagValue(37386, true);
        if (entry != null) {
            return Math.round((float)((double)(38.0f * ((Rational)entry.getValue(0)).floatValue()) / 5.8));
        }
        return 0.0f;
    }

    public String getQuality() {
        Entry entry = this.getTagValue(37122, true);
        if (entry == null) {
            return "Unknown";
        }
        switch (((Rational)entry.getValue(0)).intValue()) {
            case 1: {
                return "BASIC";
            }
            case 2: {
                return "NORMAL";
            }
            case 4: {
                return "FINE";
            }
        }
        return this.getTagValue(37122, true).toString();
    }

    public String getReport() {
        StringBuffer stringBuffer = new StringBuffer();
        Entry entry = this.getTagValue(33434, true);
        stringBuffer.append("Shutter: ");
        if (entry != null) {
            stringBuffer.append(entry.toString());
        } else {
            entry = this.getTagValue(37377, true);
            if (entry != null) {
                stringBuffer.append(entry.toString());
            } else {
                stringBuffer.append("n/a");
            }
        }
        stringBuffer.append(", Aperture: ");
        entry = this.getTagValue(33437, true);
        if (entry == null) {
            entry = this.getTagValue(37378, true);
            if (entry != null) {
                stringBuffer.append(AbstractImageInfo.fnumberformat.format((double)((Rational)entry.getValue(0)).floatValue() * 0.4 + 1.0));
            } else {
                stringBuffer.append("n/a");
            }
        } else {
            stringBuffer.append(AbstractImageInfo.fnumberformat.format(((Rational)entry.getValue(0)).floatValue()));
        }
        stringBuffer.append(", Flash: ");
        entry = this.getTagValue(37385, true);
        if (entry != null) {
            stringBuffer.append((Integer)entry.getValue(0) == 1 ? "yes" : "no");
        } else {
            stringBuffer.append("n/a");
        }
        return stringBuffer.toString();
    }

    public void readInfo() {
        this.imagedescr = new Hashtable[]{new Hashtable(), new Hashtable()};
        this.offset -= this.data.length;
        this.intel = this.data[6] == 73;
        boolean bl = this.motorola = this.data[6] == 77;
        if (!this.intel && !this.motorola) {
            return;
        }
        this.version = this.s2n(8, 2);
        this.processAllIFDs();
        this.data = null;
    }

    int firstIFD() {
        return this.s2n(10, 4) + 6;
    }

    int nextIFD(int n) {
        int n2 = this.s2n(n, 2);
        return this.s2n(n + 2 + 12 * n2, 4) + 6;
    }

    void processAllIFDs() {
        this.currentimage = 0;
        int n = this.firstIFD();
        while (n > 6 && this.currentimage < 2) {
            this.storeIFD(n);
            ++this.currentimage;
            n = this.nextIFD(n);
        }
    }

    void storeIFD(int n) {
        int n2 = this.s2n(n, 2);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n + 2 + 12 * n3;
            int n5 = this.s2n(n4, 2);
            int n6 = this.s2n(n4 + 2, 2);
            if (n6 >= 1 && n6 <= 10) {
                int n7 = TYPELENGTH[n6 - 1];
                int n8 = this.s2n(n4 + 4, 4);
                int n9 = n4 + 8;
                if (n8 * n7 > 4) {
                    n9 = this.s2n(n9, 4) + 6;
                }
                if (n6 == 2) {
                    try {
                        this.imagedescr[this.currentimage].put(new Integer(n5), new Entry(n6, new String(this.data, n9, n8 - 1, "Default")));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                } else {
                    Object[] objectArray = new Object[n8];
                    boolean bl = true;
                    int n10 = 0;
                    while (n10 < n8) {
                        objectArray[n10] = n6 % 5 != 0 ? new Integer(this.s2n(n9, n7, bl)) : new Rational(this.s2n(n9, 4, bl), this.s2n(n9 + 4, 4, bl));
                        n9 += n7;
                        this.imagedescr[this.currentimage].put(new Integer(n5), new Entry(n6, objectArray));
                        if (n5 == 34665 && n10 == 0 && (Integer)objectArray[0] > 0) {
                            this.storeIFD((Integer)objectArray[0] + 6);
                        }
                        if (n5 == 40965 && n10 == 0 && (Integer)objectArray[0] > 0) {
                            this.storeIFD((Integer)objectArray[0] + 6);
                        }
                        ++n10;
                    }
                }
            }
            ++n3;
        }
    }
}

