/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class KunststoffTabbedPaneUI
extends BasicTabbedPaneUI {
    private Color col1 = new Color(255, 255, 255, 0);
    private Color col2 = new Color(255, 255, 255, 128);
    private Color col3 = new Color(0, 0, 0, 0);
    private Color col4 = new Color(0, 0, 0, 64);
    private Color selectColor;

    public static ComponentUI createUI(JComponent c) {
        return new KunststoffTabbedPaneUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.selectColor = UIManager.getColor("TabbedPane.selected");
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        GradientPaint gradientReflectionBottom;
        super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
        Graphics2D g2D = (Graphics2D)g;
        Rectangle tabRect = rects[tabIndex];
        int selectedIndex = this.tabPane.getSelectedIndex();
        if (this.lastTabInRun(this.tabPane.getTabCount(), this.selectedRun) != selectedIndex) {
            GradientPaint gradientShadow;
            if (tabPlacement == 1 || tabPlacement == 3) {
                if (tabIndex == selectedIndex + 1) {
                    gradientShadow = new GradientPaint((float)tabRect.getX(), 0.0f, this.col4, (float)(tabRect.getX() + 7.0), 0.0f, this.col3);
                    g2D.setPaint(gradientShadow);
                    g2D.fill(tabRect);
                }
            } else if (tabIndex == selectedIndex + 1) {
                gradientShadow = new GradientPaint(0.0f, (float)tabRect.getY(), this.col4, 0.0f, (float)(tabRect.getY() + 7.0), this.col3);
                g2D.setPaint(gradientShadow);
                g2D.fill(tabRect);
            }
        }
        if (tabPlacement == 1) {
            GradientPaint gradientReflectionTop = new GradientPaint(0.0f, (float)tabRect.getHeight() / (float)2, this.col1, 0.0f, 0.0f, this.col2);
            g2D.setPaint(gradientReflectionTop);
            g2D.fill(tabRect);
        } else if (tabPlacement == 3) {
            if (tabIndex != selectedIndex) {
                gradientReflectionBottom = new GradientPaint(0.0f, (float)tabRect.getY(), this.col4, 0.0f, (float)(tabRect.getY() + 7.0), this.col3);
                g2D.setPaint(gradientReflectionBottom);
                g2D.fill(tabRect);
            }
        } else if (tabPlacement == 4 && tabIndex != selectedIndex) {
            gradientReflectionBottom = new GradientPaint((float)tabRect.getX(), 0.0f, this.col4, (float)(tabRect.getX() + 7.0), 0.0f, this.col3);
            g2D.setPaint(gradientReflectionBottom);
            g2D.fill(tabRect);
        }
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (isSelected) {
            g.setColor(this.selectColor);
        } else {
            g.setColor(this.tabPane.getBackgroundAt(tabIndex));
        }
        switch (tabPlacement) {
            case 2: {
                g.fillRect(x + 1, y + 1, w - 2, h - 3);
                break;
            }
            case 4: {
                g.fillRect(x, y + 1, w - 2, h - 3);
                break;
            }
            case 3: {
                g.fillRect(x + 1, y, w - 3, h - 1);
                break;
            }
            default: {
                g.fillRect(x + 1, y + 1, w - 3, h - 1);
            }
        }
    }
}

