/* PhotoOrganizer $RCSfile: Controller.java,v $
 * Copyright (C) 1999-2001 Dmitriy Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * $Id: Controller.java,v 1.17 2001/08/16 07:34:15 rogatkin Exp $
 */
package photoorganizer;

import java.util.Hashtable;
//import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.Locale;
import java.awt.event.*;
//import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.FlowLayout;
import java.awt.BorderLayout;
import java.awt.PrintJob;
import java.awt.Color;
import java.awt.Container;
//import java.awt.print.PrinterJob;
import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.FileOutputStream;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.filechooser.FileFilter;

import rogatkin.*;
import photoorganizer.directory.*;
import photoorganizer.renderer.*;
import photoorganizer.formats.*;
import photoorganizer.media.*;
import photoorganizer.ird.*;

import javazoom.jl.converter.*;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.*;

public class Controller extends BaseController implements ActionListener {
    // component constraint
    public final static Integer COMP_IMAGEPANEL       = new Integer(1);
    public final static Integer COMP_DIRTREE          = new Integer(2);
    public final static Integer COMP_THUMBPANEL       = new Integer(3);
    public final static Integer COMP_FORMATS          = new Integer(4);
    public final static Integer COMP_COLLECTION       = new Integer(5);
    public final static Integer COMP_THUMBCOLLCTPANEL = new Integer(6);
    public final static Integer COMP_IMAGECOLLCTPANEL = new Integer(7);
    public final static Integer COMP_ALBUMPANEL       = new Integer(8);
    public final static Integer COMP_STATUSBAR        = new Integer(9);
    public final static Integer COMP_IMAGEALBUMPANEL  = new Integer(10);
    public final static Integer COMP_ALBUMTHUMBPANEL  = new Integer(11);
    public final static Integer COMP_WEBALBUMPANEL    = new Integer(12);
	
	public final static Integer DESCR_TABLEVIEWS      = new Integer(14);
    public final static Integer COMP_REMOTERECEIVER   = new Integer(15);
	public final static Integer COMP_RIPPERPANEL      = new Integer(16);

	public static final int BTN_MSK_OK = 1;
	public static final int BTN_MSK_APLY = 2;
	public static final int BTN_MSK_CANCEL = 4;
	public static final int BTN_MSK_HELP = 8;
	public static final int BTN_MSK_CLOSE = 16;
	
	public SampleJpeg sampleJpeg;
	public MediaPlayerPanel mediaPlayer;

    public Controller(PhotoOrganizer photoorganizer) {
	super(photoorganizer);
        sampleJpeg = new SampleJpeg();
        filter     = new HTMLFilter();
        uiupdater  = new UiUpdater();
        mainicon   = getResourceIcon(Resources.IMG_PHOTOORG).getImage();
        if (java2 && System.getProperty("USE_JAI") != null) {
            try {
                advancedimage = (AdvancedImage)Class.forName("photoorganizer.jai.AdvancedImageImpl").newInstance();
            } catch(ClassNotFoundException e) {
                System.err.println(e);
            } catch(NoClassDefFoundError e) {
                System.err.println(e);
            } catch(InstantiationException e) {
                System.err.println(e);
            } catch(IllegalAccessException e) {
                System.err.println(e);
            }
        }
        serializer.load();
    }   
    
    public void actionPerformed(ActionEvent a) {
        String cmd = a.getActionCommand();
        if (cmd.equals(Resources.MENU_OPTIONS)) {
            if (options == null) {
                options = new OptionsFrame(this);
            } else 
                options.setVisible(true);
        } else if (cmd.equals(Resources.MENU_ABOUT)) {
            JOptionPane.showMessageDialog(getMainFrame(), "<html><i>"+PhotoOrganizer.PROGRAMNAME+"\n"+
                PhotoOrganizer.VERSION+'.'+PhotoOrganizer.BUILD+'\n'+
                PhotoOrganizer.COPYRIGHT+'\n'+
				"<html><b>"+PhotoOrganizer.DEDICATED+'\n'+
                "Java "+System.getProperty("java.version")+
                (java2?(" spec "+System.getProperty("java.specification.name")):"")+'\n'+
                "JVM "+System.getProperty("java.vendor")+
                " OS "+System.getProperty("os.name")+' '+System.getProperty("os.version")+' '+System.getProperty("os.arch")+'\n'+
                (java2?("Available "+(Runtime.getRuntime().totalMemory()/1024/1024)+"MB, free "+(Runtime.getRuntime().freeMemory()/1024/1024)+"MB\n"):"")+
                Locale.getDefault().getDisplayName()+
                (advancedimage!=null?"\nJava Advanced Imaging":""),
                Resources.MENU_ABOUT, JOptionPane.PLAIN_MESSAGE,
                getResourceIcon(Resources.IMG_LOGO));
        } else if (cmd.equals(Resources.MENU_CONTENTS)) {
            showUrl("doc/"+Resources.URL_HELP);
		} else if (cmd.equals(Resources.MENU_VIEW_HTML)) {
			String d = (String)serializer.getProperty(WebPublishOptionsTab.SECNAME, WebPublishOptionsTab.WEBROOT);
			if (d == null || d.length() == 0)
				d = serializer.getHomeDirectory();
			
			Object[] options = {Resources.CMD_OPEN, Resources.CMD_CANCEL, Resources.CMD_BROWSE};
			
			JOptionPane pane = new JOptionPane(Resources.LABEL_INPUT_URL, 
											   JOptionPane.QUESTION_MESSAGE,
											   JOptionPane.OK_CANCEL_OPTION,
											   null, options, options[0]);
			pane.setWantsInput(true);
			pane.setInitialSelectionValue("http://"+serializer.getProperty(WebPublishOptionsTab.SECNAME,
																		   WebPublishOptionsTab.HOSTNAME)+'/'+PhotoCollectionPanel.LastHtmlName);
			pane.selectInitialValue();
			
			JDialog dialog = pane.createDialog(getMainFrame(), Resources.TITLE_URL_SEL);
			dialog.show();
			String selectedValue = (String) pane.getValue();
			
			if (selectedValue == JOptionPane.UNINITIALIZED_VALUE ||
				options[0].equals(selectedValue)) {
				// user entered URL and selected open
				showUrl((String) pane.getInputValue());
			} else if (options[1].equals(selectedValue)) {
				// user selected cancel
			} else if (selectedValue != null) {
				// user wants to open a file
				JFileChooser fc = new JFileChooser(d);
				fc.addChoosableFileFilter(filter);
				fc.setFileFilter(filter);
				fc.setDialogTitle(Resources.TITLE_HTML_TEMPL);
				if (fc.showOpenDialog(getMainFrame()) == JFileChooser.APPROVE_OPTION)
					showUrl(fc.getSelectedFile().getAbsolutePath());
			}
		} else if (cmd.equals(Resources.MENU_EXIT)) {
            close();
            getMainFrame().dispose();
            System.exit(0);
        }
    }

    public synchronized void print(File[] files) {
        final PrintJob pj = Toolkit.getDefaultToolkit().getPrintJob(getMainFrame(),
            Resources.TITLE_PRINT, new Properties());
        final StatusBar statusbar = (StatusBar)component(COMP_STATUSBAR);
        statusbar.displayInfo(Resources.INFO_PRINTING);
        if (files != null)
            statusbar.setProgress(files.length*2);
        final Graphics g = pj.getGraphics();
        g.setColor(Color.white);
        final Dimension pd = pj.getPageDimension();
        for (int i=0; files != null && i<files.length; i++) {
            g.setClip(0,i*pd.height, pd.width, pd.height);
            g.drawRect(0,20, pd.width-10, pd.height-20-10);
            Image im = new BasicJpeg(files[i]).getImage();
            final boolean lastimage = i == (files.length-1);
            if (im == null)
                continue;
            final File file = files[i];
            if (!g.drawImage(im, 0,0,
                new ImageObserver() {
                    public boolean imageUpdate(Image img, int infoflags, int x, int y,
                        int width, int height) {
                        if (y == height/2 && height != 0)
                            statusbar.tickProgress();
                        if ((infoflags & (ImageObserver.ALLBITS | ImageObserver.ERROR)) == 0)
                            return true;
                        else {
                            g.drawImage(img, 0,15, pd.width-30, (pd.width-30)*height/width, null);
                            img.flush();
                            g.drawString(file.getAbsolutePath(), 15, (pd.width-30)*height/width+30);
                            statusbar.tickProgress();
                            if (lastimage) {
                                g.dispose();
                                pj.end();
                                statusbar.clearInfo();
                                statusbar.clearProgress();
                            }
                            return false;
                        }
                    }
                }
            )
        ) // if
        ;
        }
    }
    
    public UiUpdater getUiUpdater() {
        return uiupdater;
    }

    public Image getMainIcon() {
        return mainicon;
    }
	
	public boolean selectTab(String tabName) {
		JTabbedPane tp = (JTabbedPane)getMainFrame().getContentPane().getComponent(0);
		int ti = tp.indexOfTab(tabName);
		if (ti >= 0) {
			tp.setSelectedIndex(ti);
			return true;
		}
		return false;
	}
	
	public String getHomeDirectory() {
		String result = System.getProperty(main.getName()+Serializer.HOMEDIRSUFX, ".");
		if (!result.endsWith("/") || !result.endsWith("\\")
			|| !result.endsWith(":"))
			result += File.separatorChar;
		return result;
	}

    public void updateCaption(String str) {
        if (str == null)
            str = "";
	// TODO: check for null
        getMainFrame().setTitle(str);
    }

    public static AdvancedImage getAdvancedImage() {
        return advancedimage;
    }

    public int adjustMenuY(int y, int h) {
        if (y > screen_height-h)
            return screen_height-h;
        else
            return y; 
    }

    public FileFilter getHtmlFilter() {
        return filter;
    }

    public void close() {
        save();
        main.save();
        serializer.save();
    }

	public static JPanel createButtonPanel(ActionListener al, boolean helpButton) {
		   return createButtonPanel(al, 
									BTN_MSK_OK+BTN_MSK_APLY+BTN_MSK_CANCEL+(helpButton?BTN_MSK_HELP:0), FlowLayout.RIGHT);
	}
	
	public static JPanel createButtonPanel(ActionListener al, int buttonMask, int align) {
		JButton btn;
		JPanel result = new JPanel();
		result.setLayout(new FlowLayout(align));
		if ((buttonMask & BTN_MSK_OK) != 0) {
			result.add(btn = new JButton(Resources.CMD_OK));
			btn.setDefaultCapable(true);
			btn.addActionListener(al);
		}
		if ((buttonMask & BTN_MSK_APLY) != 0) {
			result.add(btn = new JButton(Resources.CMD_APPLY));
			btn.addActionListener(al);
		}
		if ((buttonMask & BTN_MSK_CLOSE) != 0) {
			result.add(btn = new JButton(Resources.CMD_CLOSE));
			btn.addActionListener(al);
		}
		if ((buttonMask & BTN_MSK_CANCEL) != 0) {
			result.add(btn = new JButton(Resources.CMD_CANCEL));
			btn.addActionListener(al);
		}
		if ((buttonMask & BTN_MSK_HELP) != 0) {
			result.add(btn = new JButton(Resources.CMD_HELP));
			btn.addActionListener(al);
		}			
		return result;
	}

    public static JMenu createTransformMenu(ActionListener listener) {
        JMenu result = new JMenu(Resources.MENU_TRANSFORM);
        JMenuItem item;
        result.add(item = new JMenuItem(Resources.MENU_NONE));
        item.addActionListener(listener);
        result.add(item = new JMenuItem(Resources.MENU_ROTATE90));
        item.addActionListener(listener);
        result.add(item = new JMenuItem(Resources.MENU_ROTATE180));
        item.addActionListener(listener);
        result.add(item = new JMenuItem(Resources.MENU_ROTATE270));
        item.addActionListener(listener);
        result.add(item = new JMenuItem(Resources.MENU_FLIP_H));
        item.addActionListener(listener);
        result.add(item = new JMenuItem(Resources.MENU_FLIP_V));
        item.addActionListener(listener);
        result.add(item = new JMenuItem(Resources.MENU_TRANSPOSE));
        item.addActionListener(listener);
        result.add(item = new JMenuItem(Resources.MENU_TRANSVERSE));
        item.addActionListener(listener);
		result.addSeparator();
        result.add(item = new JMenuItem(Resources.MENU_COMMENT));
        item.addActionListener(listener);
        return result;
    }
    
    public static int convertCmdToTrnasformOp(String cmd) {
        int op = -1;
        if (cmd.equals(Resources.MENU_ROTATE90)) {
            op = BasicJpeg.ROT_90;
        } else if (cmd.equals(Resources.MENU_ROTATE180)) {
            op = BasicJpeg.ROT_180;
        } else if (cmd.equals(Resources.MENU_ROTATE270)) {
            op = BasicJpeg.ROT_270;
        } else if (cmd.equals(Resources.MENU_FLIP_H)) {
            op = BasicJpeg.FLIP_H;
        } else if (cmd.equals(Resources.MENU_FLIP_V)) {
            op = BasicJpeg.FLIP_V;
        } else if (cmd.equals(Resources.MENU_TRANSPOSE)) {
            op = BasicJpeg.TRANSPOSE;
        } else if (cmd.equals(Resources.MENU_TRANSVERSE)) {
            op = BasicJpeg.TRANSVERSE;
        } else if (cmd.equals(Resources.MENU_NONE)) {
            op = BasicJpeg.NONE;
        } else if (cmd.equals(Resources.MENU_COMMENT)) {
            op = BasicJpeg.COMMENT;
        }
        return op;
    }
	
	public static boolean isJdk1_4() {
		return jdk1_4;
	}

	public void saveTableColumns(JTable table, String secName, String tableName) {
		Serializer s = getSerializer();
		Integer[] w = new Integer[table.getColumnCount()];
		for (int i = 0; i < w.length; i++) {
			try {
				w[i] = new Integer(table.getColumn(table.getColumnName(i)).getWidth());
			} catch(IllegalArgumentException iae) {
				w[i] = Resources.I_NO;
			}
		}
		s.setProperty(secName, tableName, w);
	}
    
	public void loadTableColumns(JTable table, String secName, String tableName) {
		Serializer s = getSerializer();
		Object[] w = (Object[])s.getProperty(secName, tableName);
		if (w == null)
			return;
		for (int i = 0; i < w.length; i++) {
			table.getColumn(table.getColumnName(i)).setWidth(((Integer)w[i]).intValue());
			table.getColumn(table.getColumnName(i)).setPreferredWidth(((Integer)w[i]).intValue());
		}
	}
	
    class HTMLFilter extends FileFilter  {
        final String [] extensions = new String[] {"html", "htm", "htmt"};
        
        // Accept all directories and (gif || jpg || tiff) files.
        public boolean accept(File f) {
            if(f.isDirectory()) {
                return true;
            }
            String s = f.getName();
            int i = s.lastIndexOf('.');
            if(i > 0 &&  i < s.length() - 1) {
                String extension = s.substring(i+1).toLowerCase();
                for (i=0; i<extensions.length; i++) {
                    if (extensions[i].equals(extension)) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
            return false;
        }
        
        // The desctiption of this filter
        public String getDescription() {
            return Resources.LABEL_HTML_FILES;
        }
    }
	
	public MediaPlayerPanel playMedia(AbstractFormat media, int introFrames) throws IOException {
		Serializer s = getSerializer();
		if (s.getInt(s.getProperty(MediaOptionsTab.SECNAME, MediaOptionsTab.REUSEPLAYER), 1) == 1) {
			JFrame frame = null;
			synchronized(this) {
				if (mediaPlayer == null) {
					frame = new JFrame();
					frame.setContentPane(mediaPlayer = new MediaPlayerPanel(true));
					frame.pack();
					frame.setIconImage(getMainIcon());
					frame.addWindowListener(mediaPlayer.getWindowListener());
				} else {
					frame = (JFrame)mediaPlayer.getTopLevelAncestor();
				}
			}
			frame.setVisible(true);
			mediaPlayer.replay(media, introFrames);
			if (component(COMP_REMOTERECEIVER) != null)
				((IrdReceiver)component(COMP_REMOTERECEIVER)).setOnTop(mediaPlayer);
			return mediaPlayer;
		} else {
			MediaPlayerPanel result;
			JFrame frame = new JFrame(Resources.TITLE_NOW_PLAYING+media.toString());
			frame.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
			frame.setContentPane(result = new MediaPlayerPanel(media, frame, introFrames));
			frame.pack();
			frame.setVisible(true);
			frame.setIconImage(getMainIcon());
			if (component(COMP_REMOTERECEIVER) != null)
				((IrdReceiver)component(COMP_REMOTERECEIVER)).setOnTop(result);
			return result;
		}
	}
// for version 1.1.1
	//public void playMediaList(URL[] medias) {
	//}
	
	public void playMediaList(final PlaybackRequest request) {
		new Thread(new Runnable () {
			public void run() {     				
				request.player = null;				
				playMediaList(request.playbackList, request);
			}
		}, "MediaListPlayer").start();
	}
	
	public void playMediaList(Object[] medias, PlaybackRequest request) {
		if (request.player != null && request.player.isClosed())
			return;
		for (int k=0; k<medias.length ; k++) {
			File file = null;
			AbstractFormat media = null;
			if (medias[k] instanceof File)
				file = (File)medias[k];
			else if (medias[k] instanceof AbstractFormat)
				media = (AbstractFormat)medias[k];
			else
				continue;
			if (file != null && file.isDirectory() && request.recursive) {
				playMediaList(file.listFiles(), request);				 
			} else {
				if (media == null && file != null)
					media = MediaFormatFactory. createMediaFormat(file);
				if (media == null || !media.isValid())
					continue;
				if(media instanceof MP3 && (request.matcher == null || request.matcher.match(media))) 
					try {
						//if (request.player == null)
							request.player = playMedia(media, request.introFrames);
						//else
						//	request.player.replay(media);
						
						request.player.waitForCompletion();
						System.err.println("Closed "+request.player.isClosed());
						if (request.player.isClosed())
							break;
						if (request.pauseBetween > 999)
							try {
								Thread.sleep(request.pauseBetween);
							} catch(InterruptedException ie) {
							}
					} catch(IOException ioe) {
						System.err.println("Problem "+ioe+" for "+media);
					}
			}
		}
	}

	public static void convertToWav(AbstractFormat media, String destName, StatusBar statusBar) throws JavaLayerException {
		convertToWav(media, destName, new Converter(), statusBar);
	}

	// TODO: reconsider each time creation
	public static void convertToWav(AbstractFormat media, String dest, Converter converter, StatusBar statusBar) throws JavaLayerException, IllegalArgumentException {
		if (media == null || !(media instanceof MP3) || !media.isValid())
			throw new IllegalArgumentException("Media format not specified or invalid.");
		if (statusBar != null)
			converter.convert(media.getFile().getPath(), dest, new ConvertProgressListener(statusBar));
		else
			converter.convert(media.getFile().getPath(), dest);
	}
		
	static public class ConvertProgressListener implements Converter.ProgressListener { 
		StatusBar statusBar;
		public ConvertProgressListener(StatusBar statusBar) {
			this.statusBar = statusBar;
		}		
		
		public void converterUpdate(int updateID, int param1, int param2) { 
			//System.err.println("Set progress "+param1+'/'+param2);
			if (UPDATE_FRAME_COUNT == updateID)
				statusBar.setProgress(param1);
			else if(UPDATE_CONVERT_COMPLETE == updateID) {
				statusBar.clearProgress();
				statusBar.flashInfo("Completed");
			}
		}
		
		public void parsedFrame(int frameNo, Header header) { 
			statusBar.displayInfo("P/f: "+frameNo);
			statusBar.tickProgress();
		}
		
		public void readFrame(int frameNo, Header header) { 
			statusBar.displayInfo("R/f: "+frameNo);
			statusBar.tickProgress();
		}
		
		public void decodedFrame(int frameNo, Header header, Obuffer o) { 
			statusBar.displayInfo("D/f: "+frameNo);
			statusBar.tickProgress();
		}
		
		public boolean converterException(Throwable t) { 
			statusBar.flashInfo("Exception "+t, true);
			return false;
		}
	}
	
	public void showHtml(String content, String title) {
		JDialog dialog = new JDialog(getMainFrame(), title, true);
		TwoPanesView contentPane;
		dialog.setContentPane(contentPane = TwoPanesView.createFramed(true, dialog, BTN_MSK_CLOSE, null));
		contentPane.setUpperText(content);
		dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
		dialog.pack();
		//dialog.setIconImage(getMainIcon());
		contentPane.setSize(440, 330);
		dialog.setVisible(true);
	}
	
    private Image mainicon;
    private String transformtargetdir;
    private OptionsFrame options;
    private HTMLFilter filter;
    private UiUpdater uiupdater;
    private static AdvancedImage advancedimage;
    /*
        synchronized(pj) {
            pj.notify();
        }
        synchronized(pj) {
            
            try {
                pj.wait(10*60*1000);
            } catch(InterruptedException e) {
            }
        }*/
	
   // some methods can be move in base class or a separate util class
	
	public static byte[] readStreamInBuffer(InputStream in) throws IOException {
		return readStreamInBuffer(in, 2048);
	}

	public static byte[] readStreamInBuffer(InputStream in, int bufSize) throws IOException {
		byte []buf = new byte[bufSize];
		byte []result = new byte[0];
		try {
			int cl;
			do {
				cl = in.read(buf);
				if (cl < 0)
					break;
				byte []wa = new byte[result.length+cl];
				System.arraycopy(result, 0, wa, 0, result.length);
				System.arraycopy(buf, 0, wa, result.length, cl);
				result = wa;
			} while(true);
		} finally {
			in.close();
		}
		return result;
	}
}

