/* PhotoOrganizer $RCSfile: MiscellaneousOptionsTab.java,v $
 * Copyright (C) 1999-2000 Dmitriy Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * $Id: MiscellaneousOptionsTab.java,v 1.7 2001/08/29 06:47:13 rogatkin Exp $
 */
package photoorganizer.renderer;

import java.util.Locale;
import java.awt.event.*;
import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.*;
import javax.swing.border.*;

import rogatkin.*;
import photoorganizer.*;
import photoorganizer.formats.FileNameFormat;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.directory.JDirectoryChooser;

public class MiscellaneousOptionsTab extends JPanel implements ActionListener, Persistable, Helpable {
    public final static String SECNAME = "MiscellaneousOptions";
    public final static String DATEFORMAT = "DateFormat";
    public final static String TIMEFORMAT = "TimeFormat";
    public final static String TOOLBAR   = "ToolBar";
    public final static String STATUSBAR = "StatusBar";
    public final static String MENUBAR   = "MenuBar";
    public final static String TABPOS    = "TabPosition";
    public final static String FC_FOLDER = "FlashCardDirectory";
    public final static String SHOWWARNDLG = "ShowWarnDlg";
    public final static String COUNTRY   = "Country";
    public final static String LANGUAGE  = "Language";
    public final static String SPLITVERT = "SplitVertically";
	public final static String ENCODING  = "Encoding";
	public final static String LAF       = "L&F";
    // LIST_ONTOP, LIST_ONBOTTOM, LIST_ONLEFT, LIST_ONRIGHT
    final static Integer[] TABPOSTABLE = {new Integer(SwingConstants.TOP),
	new Integer(SwingConstants.BOTTOM), new Integer(SwingConstants.LEFT), new Integer(SwingConstants.RIGHT) };

    final static String formathelp = "<html>\n"+
	"<pre>\n"+
	" Symbol   Meaning                 Presentation        Example\n"+
	" ------   -------                 ------------        -------\n"+
	" G        era designator          (Text)              AD\n"+
	" y        year                    (Number)            1996\n"+
	" M        month in year           (Text &amp; Number)     July &amp; 07\n"+
	" d        day in month            (Number)            10\n"+
	" h        hour in am/pm (1~12)    (Number)            12\n"+
	" H        hour in day (0~23)      (Number)            0\n"+
	" m        minute in hour          (Number)            30\n"+
	" s        second in minute        (Number)            55\n"+
	" S        millisecond             (Number)            978\n"+
	" E        day in week             (Text)              Tuesday\n"+
	" D        day in year             (Number)            189\n"+
	" F        day of week in month    (Number)            2 (2nd Wed in July)\n"+
	" w        week in year            (Number)            27\n"+
	" W        week in month           (Number)            2\n"+
	" a        am/pm marker            (Text)              PM\n"+
	" k        hour in day (1~24)      (Number)            24\n"+
	" K        hour in am/pm (0~11)    (Number)            0\n"+
	" z        time zone               (Text)              Pacific Standard Time  \n"+
	" '        escape for text         (Delimiter)\n"+
	" ''       single quote            (Literal)           '\n"+
	" </pre>";

	public MiscellaneousOptionsTab(Controller controller) {
		this.controller = controller;
		setLayout(new GranulatedLayout(8, Resources.CTRL_VERT_PREF_SIZE, Resources.CTRL_VERT_SIZE, Resources.CTRL_VERT_GAP, Resources.CTRL_HORIS_INSET, Resources.CTRL_HORIZ_GAP));
		JPanel canvas = new JPanel();
		canvas.setBorder(new TitledBorder(new EtchedBorder(), Resources.TITLE_SHOW));
		canvas.setOpaque(false);
		add(canvas, "0,0,8,4,16,8");
		add(cb_menu = new JCheckBox(Resources.LABEL_MENU), "1,1");
		add(cb_tool = new JCheckBox(Resources.LABEL_TOOLBAR), "2,1");
		add(cb_warn = new JCheckBox(Resources.LABEL_SHOWWARNDLG), "2,2,2");
		add(cb_status = new JCheckBox(Resources.LABEL_SATUSBAR), "1,2");
		add(new JLabel(Resources.LABEL_TABPOS, SwingConstants.LEFT), "6,1,2,1,34");
		add(mb_positions = new JComboBox(Resources.POSITIONS), "6,2,2,1,34");
		ButtonGroup bg = new ButtonGroup();
		add(rb_split_vert = new JRadioButton(Resources.LABEL_SPLIT_VERT), "4,1,2");
		bg.add(rb_split_vert);
		add(rb_split_horz = new JRadioButton(Resources.LABEL_SPLIT_HORZ), "4,2,2");
		bg.add(rb_split_horz);
		
		add(new JLabel(Resources.LABEL_LOCALES, SwingConstants.RIGHT), "0,4");
		add(cb_country = new JComboBox(Resources.COUNTRIES), "1,4");
		add(cb_lang = new JComboBox(Resources.LANGUAGES), "2,4");
		
		JButton button;
		add(new JLabel(Resources.LABEL_CF_DIR, SwingConstants.RIGHT), "0,6,2");
		add(tf_fc_folder = new JTextField(), "2,6,4");
		add(button = new JButton(Resources.CMD_BROWSE), "6,6,2");
		button.addActionListener(this);
		
		add(new JLabel(Resources.LABEL_PAGE_ENCODING, SwingConstants.RIGHT), "4,4,2");
		add(tf_encoding = new JTextField(), "6,4,2");

		add(new JLabel(Resources.LABEL_DATEFMT, SwingConstants.RIGHT), "0,5");
		add(tf_date = new JTextField(), "1,5");
		add(new JLabel(Resources.LABEL_TIMEFMT, SwingConstants.RIGHT), "2,5");
		add(tf_time = new JTextField(), "3,5");
		add(new JLabel(Resources.LABEL_LAF, SwingConstants.RIGHT), "4,5");
		add(tf_laf  = new JTextField(), "5,5,3");
	}
	
	public String getHelp() {
		return formathelp;
	}
	
	public void actionPerformed(ActionEvent a) {
		if (a.getActionCommand() == Resources.CMD_BROWSE) {
			JDirectoryChooser dc = new JDirectoryChooser(new JFrame(), tf_fc_folder.getText(), null);
			if (dc.getDirectory() != null)
				tf_fc_folder.setText(dc.getDirectory());
		}
	}

	public void load() {
		Serializer s = controller.getSerializer();
		tf_date.setText(s.arrayToString(s.getProperty(SECNAME, DATEFORMAT)));
		tf_time.setText(s.arrayToString(s.getProperty(SECNAME, TIMEFORMAT)));
		tf_fc_folder.setText(s.arrayToString(s.getProperty(SECNAME, FC_FOLDER)));
		cb_menu.setSelected(Serializer.getInt(s.getProperty(SECNAME, MENUBAR), 1) == 1);
		cb_status.setSelected(Serializer.getInt(s.getProperty(SECNAME, STATUSBAR), 1) == 1);
		cb_tool.setSelected(Serializer.getInt(s.getProperty(SECNAME, TOOLBAR), 0) == 1);
		cb_warn.setSelected(Serializer.getInt(s.getProperty(SECNAME, SHOWWARNDLG), 0) == 1);
		if (Serializer.getInt(s.getProperty(SECNAME, SPLITVERT), 1) == 1)
			rb_split_vert.setSelected(true);
		else
			rb_split_horz.setSelected(true);
		switch(Serializer.getInt(s.getProperty(SECNAME, TABPOS), SwingConstants.BOTTOM)) {
		case SwingConstants.TOP: 
			mb_positions.setSelectedIndex(0);
			break;
		case SwingConstants.BOTTOM: 
			mb_positions.setSelectedIndex(1);
			break;
		case SwingConstants.LEFT: 
			mb_positions.setSelectedIndex(2);
			break;
		case SwingConstants.RIGHT: 
			mb_positions.setSelectedIndex(3);
			break;
		}
		String a = (String)s.getProperty(SECNAME, COUNTRY);
		if (a == null)
			a = Locale.getDefault().getCountry();
		cb_country.setSelectedItem(a);
		a = (String)s.getProperty(SECNAME, LANGUAGE);
		if (a == null)
			a = Locale.getDefault().getLanguage();
		cb_lang.setSelectedItem(a);
		a = (String)s.getProperty(SECNAME, ENCODING);
		if (a != null)
			tf_encoding.setText(a);
		a = (String)s.getProperty(SECNAME, LAF);
		if (a != null)
			tf_laf.setText(a);
	}
	
	public void save() {
		Serializer s = controller.getSerializer();
		FileNameFormat.datemask = tf_date.getText().trim();
		s.setProperty(SECNAME, DATEFORMAT, FileNameFormat.datemask);
		FileNameFormat.timemask = tf_time.getText().trim();
		s.setProperty(SECNAME, TIMEFORMAT, FileNameFormat.timemask);
		s.setProperty(SECNAME, FC_FOLDER, tf_fc_folder.getText());
		s.setProperty(SECNAME, LAF, tf_laf.getText());
		s.setProperty(SECNAME, ENCODING, tf_encoding.getText());
		s.setProperty(SECNAME, MENUBAR, cb_menu.isSelected()?Resources.I_YES:Resources.I_NO);
		s.setProperty(SECNAME, STATUSBAR, cb_status.isSelected()?Resources.I_YES:Resources.I_NO);
		s.setProperty(SECNAME, TOOLBAR, cb_tool.isSelected()?Resources.I_YES:Resources.I_NO);
		s.setProperty(SECNAME, SHOWWARNDLG, cb_warn.isSelected()?Resources.I_YES:Resources.I_NO);
		s.setProperty(SECNAME, SPLITVERT, rb_split_vert.isSelected()?Resources.I_YES:Resources.I_NO);
		s.setProperty(SECNAME, TABPOS, TABPOSTABLE[mb_positions.getSelectedIndex()]);
		s.setProperty(SECNAME, COUNTRY, cb_country.getSelectedItem());
		s.setProperty(SECNAME, LANGUAGE, cb_lang.getSelectedItem());
		BasicJpeg.setEncoding(getEncoding(controller));
	}
	
	public static String getEncoding(Controller controller) {
		String result = (String)controller.getSerializer().getProperty(SECNAME, ENCODING);
		return result == null || result.trim().length()==0?null:result;
	}

	Controller controller;
	JTextField tf_date, tf_time, tf_fc_folder, tf_encoding, tf_laf;
	JCheckBox  cb_menu, cb_status, cb_tool, cb_warn;
	JComboBox mb_positions, cb_country, cb_lang;
	JRadioButton rb_split_horz, rb_split_vert;
}