/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicInputConnector;
import com.sun.media.BasicModule;
import com.sun.media.BasicOutputConnector;
import com.sun.media.Connector;
import com.sun.media.InputConnector;
import com.sun.media.MediaEngine;
import com.sun.media.OutputConnector;
import java.awt.Frame;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.control.FrameProcessingControl;

public class BasicFilterModule
extends BasicModule {
    protected Codec codec;
    protected InputConnector ic = new BasicInputConnector();
    protected OutputConnector oc;
    protected FrameProcessingControl frameControl;
    protected float curFramesBehind;
    protected float prevFramesBehind;
    protected Frame controlFrame;
    protected final boolean VERBOSE_CONTROL = false;
    protected Buffer storedInputBuffer;
    protected Buffer storedOutputBuffer;
    protected boolean readPendingFlag = false;
    protected boolean writePendingFlag = false;
    private boolean initFailed = false;
    private boolean markerSet = false;

    public BasicFilterModule(Codec c2) {
        this.registerInputConnector("input", this.ic);
        this.oc = new BasicOutputConnector();
        this.registerOutputConnector("output", this.oc);
        this.setCodec(c2);
        this.protocol = 1;
        Object control = c2.getControl("javax.media.control.FrameProcessingControl");
        if (control instanceof FrameProcessingControl) {
            this.frameControl = (FrameProcessingControl)control;
        }
    }

    public boolean doRealize() {
        if (this.codec != null) {
            try {
                this.codec.open();
            }
            catch (ResourceUnavailableException resourceUnavailableException) {
                return false;
            }
        }
        return true;
    }

    public boolean doPrefetch() {
        return super.doPrefetch();
    }

    public void doClose() {
        if (this.codec != null) {
            this.codec.close();
        }
        if (this.controlFrame != null) {
            this.controlFrame.dispose();
            this.controlFrame = null;
        }
    }

    public void setFormat(Connector c2, Format f2) {
        if (c2 == this.ic) {
            if (this.codec != null) {
                this.codec.setInputFormat(f2);
            }
        } else if (c2 == this.oc && this.codec != null) {
            this.codec.setOutputFormat(f2);
        }
    }

    public boolean setCodec(String codec) {
        return true;
    }

    public boolean setCodec(Codec codec) {
        this.codec = codec;
        return true;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public boolean isThreaded() {
        return this.getProtocol() == 3;
    }

    public Object[] getControls() {
        return this.codec.getControls();
    }

    public Object getControl(String s) {
        return this.codec.getControl(s);
    }

    protected void setFramesBehind(float framesBehind) {
        this.curFramesBehind = framesBehind;
    }

    protected boolean reinitCodec(Format input) {
        Codec c2;
        if (this.codec != null) {
            if (this.codec.setInputFormat(input) != null) {
                return true;
            }
            this.codec.close();
            this.codec = null;
        }
        if ((c2 = MediaEngine.findCodec(input, null, null, null)) == null) {
            return false;
        }
        this.setCodec(c2);
        return true;
    }

    public void process() {
        do {
            Buffer outputBuffer;
            Buffer inputBuffer;
            if (this.readPendingFlag) {
                inputBuffer = this.storedInputBuffer;
            } else {
                inputBuffer = this.ic.getValidBuffer();
                Format incomingFormat = inputBuffer.getFormat();
                if (incomingFormat != this.ic.getFormat() && incomingFormat != null && !incomingFormat.equals(this.ic.getFormat())) {
                    if (this.writePendingFlag) {
                        this.storedOutputBuffer.setDiscard(true);
                        this.oc.writeReport();
                        this.writePendingFlag = false;
                    }
                    if (!this.reinitCodec(inputBuffer.getFormat())) {
                        inputBuffer.setDiscard(true);
                        this.ic.readReport();
                        this.initFailed = true;
                        if (this.moduleListener != null) {
                            this.moduleListener.formatChangedFailure(this, this.ic.getFormat(), inputBuffer.getFormat());
                        }
                        return;
                    }
                    Format oldFormat = this.ic.getFormat();
                    this.ic.setFormat(inputBuffer.getFormat());
                    if (this.moduleListener != null) {
                        this.moduleListener.formatChanged(this, oldFormat, inputBuffer.getFormat());
                    }
                }
                if ((inputBuffer.getFlags() & 0x200) != 0) {
                    this.markerSet = true;
                }
                if (inputBuffer != null) {
                    this.jmd.moduleIn(this, 0, inputBuffer, true);
                }
            }
            if (this.writePendingFlag) {
                outputBuffer = this.storedOutputBuffer;
            } else {
                outputBuffer = this.oc.getEmptyBuffer();
                if (outputBuffer != null) {
                    this.jmd.moduleOut(this, 0, outputBuffer, true);
                    outputBuffer.setLength(0);
                    outputBuffer.setOffset(0);
                }
            }
            outputBuffer.setTimeStamp(inputBuffer.getTimeStamp());
            outputBuffer.setSequenceNumber(inputBuffer.getSequenceNumber());
            outputBuffer.setFlags(inputBuffer.getFlags());
            if (this.resetted) {
                if ((inputBuffer.getFlags() & 0x100) != 0) {
                    this.codec.reset();
                    this.resetted = false;
                }
                this.writePendingFlag = false;
                this.readPendingFlag = false;
                this.ic.readReport();
                this.oc.writeReport();
                return;
            }
            if (this.initFailed || inputBuffer.isDiscard()) {
                if (this.markerSet) {
                    outputBuffer.setFlags(outputBuffer.getFlags() & 0xFFFFFDFF);
                    this.markerSet = false;
                }
                this.curFramesBehind = 0.0f;
                this.ic.readReport();
                if (!this.writePendingFlag) {
                    this.oc.writeReport();
                }
                return;
            }
            if (this.frameControl != null && this.curFramesBehind != this.prevFramesBehind && (inputBuffer.getFlags() & 0x20) == 0) {
                this.frameControl.setFramesBehind(this.curFramesBehind);
                this.prevFramesBehind = this.curFramesBehind;
            }
            int rc = this.codec.process(inputBuffer, outputBuffer);
            if (this.curFramesBehind > 0.0f && outputBuffer.isDiscard()) {
                this.curFramesBehind -= 1.0f;
                if (this.curFramesBehind < 0.0f) {
                    this.curFramesBehind = 0.0f;
                }
                rc &= 0xFFFFFFFB;
            }
            if ((rc & 1) != 0) {
                outputBuffer.setDiscard(true);
                if (this.markerSet) {
                    outputBuffer.setFlags(outputBuffer.getFlags() & 0xFFFFFDFF);
                    this.markerSet = false;
                }
                this.jmd.moduleIn(this, 0, inputBuffer, false);
                this.ic.readReport();
                this.jmd.moduleOut(this, 0, outputBuffer, false);
                this.oc.writeReport();
                this.writePendingFlag = false;
                this.readPendingFlag = false;
                return;
            }
            if (outputBuffer.isEOM() && ((rc & 2) != 0 || (rc & 4) != 0)) {
                outputBuffer.setEOM(false);
            }
            if ((rc & 4) != 0) {
                this.writePendingFlag = true;
                this.storedOutputBuffer = outputBuffer;
            } else {
                this.jmd.moduleOut(this, 0, outputBuffer, false);
                if (this.markerSet) {
                    outputBuffer.setFlags(outputBuffer.getFlags() | 0x200);
                    this.markerSet = false;
                }
                this.oc.writeReport();
                this.writePendingFlag = false;
            }
            if ((rc & 2) != 0 || inputBuffer.isEOM() && !outputBuffer.isEOM()) {
                this.readPendingFlag = true;
                this.storedInputBuffer = inputBuffer;
                continue;
            }
            this.jmd.moduleIn(this, 0, inputBuffer, false);
            this.ic.readReport();
            this.readPendingFlag = false;
        } while (this.readPendingFlag);
    }
}

