/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer;

import com.sun.media.BasicClock;
import com.sun.media.BasicPlugIn;
import com.sun.media.MediaTimeBase;
import com.sun.media.controls.MonitorAdapter;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Clock;
import javax.media.ClockStoppedException;
import javax.media.Control;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Multiplexer;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.format.AudioFormat;
import javax.media.format.UnsupportedFormatException;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceTransferHandler;

public abstract class BasicMux
extends BasicPlugIn
implements Multiplexer,
Clock {
    protected Format[] supportedInputs;
    protected ContentDescriptor[] supportedOutputs;
    protected int numTracks;
    protected Format[] inputs;
    protected BasicMuxDataSource source;
    protected BasicMuxPushStream stream;
    protected ContentDescriptor outputCD;
    protected boolean flushing;
    protected Integer sourceLock = new Integer(0);
    protected Integer dataLock = new Integer(1);
    protected boolean eos = false;
    protected boolean firstBuffer = true;
    protected int fileSize;
    protected int filePointer;
    protected MonitorAdapter mc;
    protected int monitorTrack = -1;
    protected BasicMuxTimeBase timeBase;
    Object startup = new Integer(0);
    boolean readyToStart = false;
    long[] mediaTime;
    boolean[] ready;
    protected BasicClock clock;
    int master;
    protected byte[] buf = new byte[32768];
    protected int bufOffset;
    protected int bufLength;
    Object timeSetSync = new Object();
    boolean started = false;
    long systemStartTime = System.currentTimeMillis() * 1000000L;

    public BasicMux() {
        this.timeBase = new BasicMuxTimeBase();
        this.clock = new BasicClock();
        try {
            this.clock.setTimeBase(this.timeBase);
        }
        catch (Exception exception) {}
    }

    public void open() {
        this.firstBuffer = true;
        this.mediaTime = new long[this.inputs.length];
        int i2 = 0;
        while (i2 < this.mediaTime.length) {
            this.mediaTime[i2] = 0L;
            ++i2;
        }
        this.ready = new boolean[this.inputs.length];
        this.resetReady();
        i2 = 0;
        while (i2 < this.inputs.length) {
            if (this.inputs[i2] instanceof VideoFormat && this.mc == null) {
                try {
                    this.mc = new MonitorAdapter((VideoFormat)this.inputs[i2]);
                    this.controls = new Control[1];
                    this.controls[0] = this.mc;
                    this.monitorTrack = i2;
                    return;
                }
                catch (UnsupportedFormatException unsupportedFormatException) {}
            }
            ++i2;
        }
    }

    public void close() {
        this.writeFooter();
    }

    public void reset() {
        int i2 = 0;
        while (i2 < this.mediaTime.length) {
            this.mediaTime[i2] = 0L;
            ++i2;
        }
        this.timeBase.update();
        this.resetReady();
    }

    private void resetReady() {
        int i2 = 0;
        while (i2 < this.ready.length) {
            this.ready[i2] = false;
            ++i2;
        }
        this.readyToStart = false;
        Object object = this.startup;
        synchronized (object) {
            this.startup.notifyAll();
        }
    }

    private boolean checkReady() {
        if (this.readyToStart) {
            return true;
        }
        int i2 = 0;
        while (i2 < this.ready.length) {
            if (!this.ready[i2]) {
                return false;
            }
            ++i2;
        }
        this.readyToStart = true;
        return true;
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedInputs;
    }

    public ContentDescriptor[] getSupportedOutputContentDescriptors(Format[] inputs) {
        return this.supportedOutputs;
    }

    public int setNumTracks(int numTracks) {
        this.numTracks = numTracks;
        if (this.inputs == null) {
            this.inputs = new Format[numTracks];
        } else {
            Format[] newInputs = new Format[numTracks];
            int i2 = 0;
            while (i2 < this.inputs.length) {
                newInputs[i2] = this.inputs[i2];
                ++i2;
            }
            this.inputs = newInputs;
        }
        return numTracks;
    }

    public Format setInputFormat(Format format, int trackID) {
        this.inputs[trackID] = format;
        return format;
    }

    public int process(Buffer buffer, int trackID) {
        Object object;
        this.flushing = false;
        while (this.source == null || !this.source.isConnected() || !this.source.isStarted()) {
            object = this.sourceLock;
            synchronized (object) {
                try {
                    this.sourceLock.wait();
                }
                catch (InterruptedException interruptedException) {}
                if (this.flushing) {
                    Object var4_5 = null;
                    break;
                }
            }
        }
        if (this.flushing) {
            this.flushing = false;
            buffer.setLength(0);
            return 0;
        }
        object = this;
        synchronized (object) {
            if (this.firstBuffer) {
                this.writeHeader();
                this.firstBuffer = false;
            }
        }
        this.updateClock(buffer, trackID);
        if (trackID == this.monitorTrack && this.mc != null) {
            this.mc.process(buffer);
        }
        int processResult = this.doProcess(buffer, trackID);
        return processResult;
    }

    private void updateClock(Buffer buffer, int trackID) {
        long timestamp;
        if (!this.readyToStart && this.numTracks > 1) {
            Object object = this.startup;
            synchronized (object) {
                this.ready[trackID] = true;
                if (this.checkReady()) {
                    this.startup.notifyAll();
                } else {
                    try {
                        while (!this.readyToStart) {
                            this.startup.wait(1000L);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if ((timestamp = buffer.getTimeStamp()) <= 0L && buffer.getFormat() instanceof AudioFormat) {
            timestamp = this.mediaTime[trackID];
            int n2 = trackID;
            this.mediaTime[n2] = this.mediaTime[n2] + this.getDuration(buffer);
        } else {
            this.mediaTime[trackID] = timestamp <= 0L ? System.currentTimeMillis() * 1000000L - this.systemStartTime : timestamp;
        }
        this.timeBase.update();
    }

    public ContentDescriptor setContentDescriptor(ContentDescriptor outputCD) {
        if (BasicPlugIn.matches(outputCD, this.supportedOutputs) == null) {
            return null;
        }
        this.outputCD = outputCD;
        return outputCD;
    }

    public DataSource getDataOutput() {
        if (this.source == null) {
            this.source = new BasicMuxDataSource(this, this.outputCD);
        }
        return this.source;
    }

    protected int doProcess(Buffer buffer, int trackID) {
        byte[] data = (byte[])buffer.getData();
        int dataLen = buffer.getLength();
        if (buffer.isEOM()) {
            dataLen = -1;
        }
        this.write(data, buffer.getOffset(), dataLen);
        return 0;
    }

    protected int write(byte[] data, int offset, int length) {
        if (this.source == null || !this.source.isConnected()) {
            return length;
        }
        if (length > 0) {
            this.filePointer += length;
            if (this.filePointer > this.fileSize) {
                this.fileSize = this.filePointer;
            }
        }
        return this.stream.write(data, offset, length);
    }

    void setStream(BasicMuxPushStream ps) {
        this.stream = ps;
    }

    boolean needsSeekable() {
        return false;
    }

    protected int seek(int location) {
        if (this.source == null || !this.source.isConnected()) {
            return location;
        }
        this.filePointer = this.stream.seek(location);
        return this.filePointer;
    }

    boolean isEOS() {
        return this.eos;
    }

    protected void writeHeader() {
    }

    protected void writeFooter() {
    }

    protected void bufClear() {
        this.bufOffset = 0;
        this.bufLength = 0;
    }

    protected void bufSkip(int size) {
        this.bufOffset += size;
        this.bufLength += size;
        this.filePointer += size;
    }

    protected void bufWriteBytes(String s) {
        byte[] bytes = s.getBytes();
        this.bufWriteBytes(bytes);
    }

    protected void bufWriteBytes(byte[] bytes) {
        System.arraycopy(bytes, 0, this.buf, this.bufOffset, bytes.length);
        this.bufOffset += bytes.length;
        this.bufLength += bytes.length;
        this.filePointer += bytes.length;
    }

    protected void bufWriteInt(int value) {
        this.buf[this.bufOffset] = (byte)(value >> 24 & 0xFF);
        this.buf[this.bufOffset + 1] = (byte)(value >> 16 & 0xFF);
        this.buf[this.bufOffset + 2] = (byte)(value >> 8 & 0xFF);
        this.buf[this.bufOffset + 3] = (byte)(value & 0xFF);
        this.bufOffset += 4;
        this.bufLength += 4;
        this.filePointer += 4;
    }

    protected void bufWriteIntLittleEndian(int value) {
        this.buf[this.bufOffset + 3] = (byte)(value >>> 24 & 0xFF);
        this.buf[this.bufOffset + 2] = (byte)(value >>> 16 & 0xFF);
        this.buf[this.bufOffset + 1] = (byte)(value >>> 8 & 0xFF);
        this.buf[this.bufOffset] = (byte)(value & 0xFF);
        this.bufOffset += 4;
        this.bufLength += 4;
        this.filePointer += 4;
    }

    protected void bufWriteShort(short value) {
        this.buf[this.bufOffset] = (byte)(value >> 8 & 0xFF);
        this.buf[this.bufOffset + 1] = (byte)(value & 0xFF);
        this.bufOffset += 2;
        this.bufLength += 2;
        this.filePointer += 2;
    }

    protected void bufWriteShortLittleEndian(short value) {
        this.buf[this.bufOffset + 1] = (byte)(value >> 8 & 0xFF);
        this.buf[this.bufOffset] = (byte)(value & 0xFF);
        this.bufOffset += 2;
        this.bufLength += 2;
        this.filePointer += 2;
    }

    protected void bufWriteByte(byte value) {
        this.buf[this.bufOffset] = value;
        ++this.bufOffset;
        ++this.bufLength;
        ++this.filePointer;
    }

    protected void bufFlush() {
        this.filePointer -= this.bufLength;
        this.write(this.buf, 0, this.bufLength);
    }

    private long getDuration(Buffer buffer) {
        AudioFormat format = (AudioFormat)buffer.getFormat();
        int sampleRate = (int)format.getSampleRate();
        int sampleSize = format.getSampleSizeInBits();
        int channels = format.getChannels();
        if (sampleSize == 0) {
            return 0L;
        }
        long duration = buffer.getLength() * 1000 * 8 / (sampleSize * 8000);
        return duration * 1000000L;
    }

    public void setTimeBase(TimeBase master) throws IncompatibleTimeBaseException {
        if (master != this.timeBase) {
            throw new IncompatibleTimeBaseException();
        }
    }

    public void syncStart(Time at) {
        Object object = this.timeSetSync;
        synchronized (object) {
            if (this.started) {
                Object var3_3 = null;
                return;
            }
            this.started = true;
            this.clock.syncStart(at);
            this.timeBase.mediaStarted();
            this.systemStartTime = System.currentTimeMillis() * 1000000L;
        }
    }

    public void stop() {
        Object object = this.timeSetSync;
        synchronized (object) {
            if (!this.started) {
                Object var2_2 = null;
                return;
            }
            this.started = false;
            this.clock.stop();
            this.timeBase.mediaStopped();
        }
    }

    public void setStopTime(Time stopTime) {
        this.clock.setStopTime(stopTime);
    }

    public Time getStopTime() {
        return this.clock.getStopTime();
    }

    public void setMediaTime(Time now) {
        Object object = this.timeSetSync;
        synchronized (object) {
            this.clock.setMediaTime(now);
            int i2 = 0;
            while (i2 < this.mediaTime.length) {
                this.mediaTime[i2] = now.getNanoseconds();
                ++i2;
            }
            this.timeBase.update();
        }
    }

    public Time getMediaTime() {
        return this.clock.getMediaTime();
    }

    public long getMediaNanoseconds() {
        return this.clock.getMediaNanoseconds();
    }

    public Time getSyncTime() {
        return this.clock.getSyncTime();
    }

    public TimeBase getTimeBase() {
        return this.clock.getTimeBase();
    }

    public Time mapToTimeBase(Time t) throws ClockStoppedException {
        return this.clock.mapToTimeBase(t);
    }

    public float getRate() {
        return this.clock.getRate();
    }

    public float setRate(float factor) {
        if (factor == this.clock.getRate()) {
            return factor;
        }
        return this.clock.setRate(1.0f);
    }

    class BasicMuxTimeBase
    extends MediaTimeBase {
        long ticks;
        boolean updated = false;

        public long getMediaTime() {
            if (!this.updated) {
                return this.ticks;
            }
            if (BasicMux.this.mediaTime.length == 1) {
                this.ticks = BasicMux.this.mediaTime[0];
            } else {
                this.ticks = BasicMux.this.mediaTime[0];
                int i2 = 1;
                while (i2 < BasicMux.this.mediaTime.length) {
                    if (BasicMux.this.mediaTime[i2] < this.ticks) {
                        this.ticks = BasicMux.this.mediaTime[i2];
                    }
                    ++i2;
                }
            }
            this.updated = false;
            return this.ticks;
        }

        public void update() {
            this.updated = true;
        }

        BasicMuxTimeBase() {
            BasicMux.this = BasicMux.this;
        }
    }

    class BasicMuxDataSource
    extends PushDataSource {
        private BasicMux mux;
        private ContentDescriptor cd;
        private BasicMuxPushStream[] streams;
        private BasicMuxPushStream stream;
        private boolean connected = false;
        private boolean started = false;

        public BasicMuxDataSource(BasicMux mux, ContentDescriptor cd) {
            BasicMux.this = BasicMux.this;
            this.cd = cd;
            this.mux = mux;
        }

        public PushSourceStream[] getStreams() {
            if (this.streams == null) {
                this.streams = new BasicMuxPushStream[1];
                this.streams[0] = this.stream = new BasicMuxPushStream(this.cd);
                BasicMux.this.setStream(this.stream);
            }
            return this.streams;
        }

        public String getContentType() {
            return this.cd.toString();
        }

        public void connect() throws IOException {
            if (this.streams == null) {
                this.getStreams();
            }
            this.connected = true;
        }

        boolean isConnected() {
            return this.connected;
        }

        boolean isStarted() {
            return this.started;
        }

        public void disconnect() {
            this.connected = false;
        }

        public void start() throws IOException {
            if (this.streams == null || !this.connected) {
                throw new IOException("Source not connected yet!");
            }
            this.started = true;
        }

        public void stop() {
            this.started = false;
        }

        public Object[] getControls() {
            return new Control[0];
        }

        public Object getControl(String s) {
            return null;
        }

        public Time getDuration() {
            return Duration.DURATION_UNKNOWN;
        }
    }

    class BasicMuxPushStream
    implements PushSourceStream {
        private ContentDescriptor cd;
        private byte[] data;
        private int dataLen;
        private int dataOff;
        private SourceTransferHandler sth;
        private Integer writeLock = new Integer(0);

        public BasicMuxPushStream(ContentDescriptor cd) {
            BasicMux.this = BasicMux.this;
            this.cd = cd;
        }

        public ContentDescriptor getContentDescriptor() {
            return this.cd;
        }

        public long getContentLength() {
            return -1L;
        }

        public boolean endOfStream() {
            return BasicMux.this.isEOS();
        }

        synchronized int write(byte[] data, int offset, int length) {
            if (this.sth == null) {
                return 0;
            }
            Integer n2 = this.writeLock;
            synchronized (n2) {
                this.data = data;
                this.dataOff = offset;
                this.dataLen = length;
                this.sth.transferData(this);
                while (this.dataLen > 0) {
                    if (this.dataLen == length) {
                        try {
                            this.writeLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.dataLen <= 0 || this.dataLen == length) continue;
                    length = this.dataLen;
                    this.sth.transferData(this);
                }
            }
            return length;
        }

        synchronized int seek(int location) {
            ((Seekable)((Object)this.sth)).seek(location);
            int seekVal = (int)((Seekable)((Object)this.sth)).tell();
            return seekVal;
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            int transferred = 0;
            Integer n2 = this.writeLock;
            synchronized (n2) {
                if (this.dataLen == -1) {
                    transferred = -1;
                } else {
                    transferred = length >= this.dataLen ? this.dataLen : length;
                    System.arraycopy(this.data, this.dataOff, buffer, offset, transferred);
                    this.dataLen -= transferred;
                    this.dataOff += transferred;
                }
                this.writeLock.notifyAll();
                int n3 = transferred;
                Object var7_7 = null;
                return n3;
            }
        }

        public int getMinimumTransferSize() {
            return this.dataLen;
        }

        public void setTransferHandler(SourceTransferHandler sth) {
            this.sth = sth;
            if (BasicMux.this.needsSeekable() && !(sth instanceof Seekable)) {
                throw new Error("SourceTransferHandler needs to be seekable");
            }
        }

        public Object[] getControls() {
            return new Control[0];
        }

        public Object getControl(String s) {
            return null;
        }
    }
}

