/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio;

import com.sun.media.JMFSecurityManager;
import com.sun.media.MediaEngine;
import com.sun.media.controls.GainControlAdapter;
import com.sun.media.renderer.audio.AudioRenderer;
import com.sun.media.renderer.audio.device.AudioOutput;
import com.sun.media.renderer.audio.device.JavaSoundOutput;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class JavaSoundRenderer
extends AudioRenderer {
    static String NAME;
    Codec ulawDecoder;
    Format ulawOutputFormat;
    Format ulawFormat = new AudioFormat("ULAW");
    Format linearFormat = new AudioFormat("LINEAR");
    Buffer decodeBuffer;

    public JavaSoundRenderer() {
        this.supportedFormats = new Format[2];
        this.supportedFormats[0] = this.linearFormat;
        this.supportedFormats[1] = this.ulawFormat;
        this.gainControl = new GCA(this);
    }

    public String getName() {
        return NAME;
    }

    public void open() throws ResourceUnavailableException {
        if (this.device == null && this.inputFormat != null) {
            if (!this.initDevice(this.inputFormat)) {
                throw new ResourceUnavailableException("Cannot intialize audio device for playback");
            }
            this.device.pause();
        }
    }

    protected boolean initDevice(AudioFormat in) {
        Format newInput = in;
        if (this.ulawDecoder != null) {
            this.ulawDecoder.close();
            this.ulawDecoder = null;
        }
        Format[] outs = new Format[1];
        if (this.ulawFormat.matches(in)) {
            this.ulawDecoder = MediaEngine.findCodec(in, this.linearFormat, null, outs);
            if (this.ulawDecoder != null) {
                newInput = outs[0];
                this.ulawOutputFormat = newInput;
            } else {
                return false;
            }
        }
        this.inputFormat = in;
        return super.initDevice((AudioFormat)newInput);
    }

    protected AudioOutput createDevice(AudioFormat format) {
        return new JavaSoundOutput();
    }

    public int processData(Buffer buffer) {
        if (!this.checkInput(buffer)) {
            return 1;
        }
        if (this.ulawDecoder == null) {
            return super.doProcessData(buffer);
        }
        if (this.decodeBuffer == null) {
            this.decodeBuffer = new Buffer();
            this.decodeBuffer.setFormat(this.ulawOutputFormat);
        }
        this.decodeBuffer.setLength(0);
        this.decodeBuffer.setOffset(0);
        this.decodeBuffer.setFlags(buffer.getFlags());
        this.decodeBuffer.setTimeStamp(buffer.getTimeStamp());
        this.decodeBuffer.setSequenceNumber(buffer.getSequenceNumber());
        int rc = this.ulawDecoder.process(buffer, this.decodeBuffer);
        if (rc == 0) {
            return super.doProcessData(this.decodeBuffer);
        }
        return 1;
    }

    static {
        String javaVersion;
        NAME = "JavaSound Renderer";
        try {
            javaVersion = System.getProperty("java.version");
        }
        catch (Throwable throwable) {
            javaVersion = null;
        }
        if (javaVersion == null || !javaVersion.startsWith("1.3")) {
            JMFSecurityManager.loadLibrary("jsound");
        }
    }

    class GCA
    extends GainControlAdapter {
        AudioRenderer renderer;

        protected GCA(AudioRenderer r2) {
            super(false);
            JavaSoundRenderer.this = JavaSoundRenderer.this;
            this.renderer = r2;
        }

        public void setMute(boolean mute) {
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setMute(mute);
            }
            super.setMute(mute);
        }

        public float setLevel(float g2) {
            float level = super.setLevel(g2);
            if (this.renderer != null && this.renderer.device != null) {
                this.renderer.device.setGain(this.getDB());
            }
            return level;
        }
    }
}

