/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class LabelComponent
extends Component {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    String text;
    int alignment = 0;
    Color background;
    int margin = 2;

    public LabelComponent() {
        this("", 0);
    }

    public LabelComponent(String text) {
        this(text, 0);
    }

    public LabelComponent(String text, int alignment) {
        this.text = text;
        this.setAlignment(alignment);
        this.background = null;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public synchronized void setAlignment(int alignment) {
        switch (alignment) {
            case 0: 
            case 1: 
            case 2: {
                if (this.alignment != alignment) {
                    this.alignment = alignment;
                    this.repaint();
                }
                return;
            }
        }
        throw new IllegalArgumentException("improper alignment: " + alignment);
    }

    public String getText() {
        return this.text;
    }

    public synchronized void setText(String text) {
        if (!(text == this.text || this.text != null && this.text.equals(text))) {
            this.text = text;
            this.repaint();
        }
    }

    public void setFont(Font f2) {
        super.setFont(f2);
        this.repaint();
    }

    public void setForeground(Color c2) {
        super.setForeground(c2);
        this.repaint();
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color c2) {
        this.background = c2;
        this.repaint();
    }

    public void paint(Graphics g2) {
        int x;
        Font f2 = this.getFont();
        Dimension size = this.getSize();
        g2.setFont(f2);
        FontMetrics fm = this.getFontMetrics(f2);
        int y = size.height / 2 - fm.getHeight() / 2 + fm.getAscent();
        switch (this.alignment) {
            default: {
                x = this.margin;
                break;
            }
            case 1: {
                x = size.width / 2 - fm.stringWidth(this.text) / 2;
                break;
            }
            case 2: {
                x = size.width - fm.stringWidth(this.text) - this.margin;
            }
        }
        if (this.getBackground() != null) {
            g2.setColor(this.getBackground());
            g2.fillRect(0, 0, size.width, size.height);
        }
        g2.setColor(this.getForeground());
        g2.drawString(this.text, x, y);
    }

    public void addNotify() {
        super.addNotify();
        Dimension size = this.getSize();
        if (size.width == 0 && size.height == 0) {
            this.setSize(this.getPreferredSize());
        }
    }

    public Dimension getPreferredSize() {
        Dimension size = new Dimension();
        Font f2 = this.getFont();
        FontMetrics fm = this.getFontMetrics(f2);
        size.width = fm.stringWidth(this.text) + 2 * this.margin;
        size.height = fm.getHeight() + 2 * this.margin;
        return size;
    }

    protected String paramString() {
        String str = ",align=";
        switch (this.alignment) {
            case 0: {
                str = String.valueOf(str) + "left";
                break;
            }
            case 1: {
                str = String.valueOf(str) + "center";
                break;
            }
            case 2: {
                str = String.valueOf(str) + "right";
                break;
            }
        }
        return String.valueOf(super.paramString()) + str + ",text=" + this.text;
    }
}

