/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import com.ibm.media.protocol.CloneableCapturePullBufferDataSource;
import com.ibm.media.protocol.CloneableCapturePullDataSource;
import com.ibm.media.protocol.CloneableCapturePushBufferDataSource;
import com.ibm.media.protocol.CloneableCapturePushDataSource;
import com.ibm.media.protocol.CloneablePullBufferDataSource;
import com.ibm.media.protocol.CloneablePullDataSource;
import com.ibm.media.protocol.CloneablePushBufferDataSource;
import com.ibm.media.protocol.CloneablePushDataSource;
import com.ibm.media.protocol.MergingPullBufferDataSource;
import com.ibm.media.protocol.MergingPullDataSource;
import com.ibm.media.protocol.MergingPushBufferDataSource;
import com.ibm.media.protocol.MergingPushDataSource;
import com.sun.media.util.Registry;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.CannotRealizeException;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.DataSink;
import javax.media.DataSinkProxy;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.MCA;
import javax.media.MediaHandler;
import javax.media.MediaLocator;
import javax.media.MediaProxy;
import javax.media.NoDataSinkException;
import javax.media.NoDataSourceException;
import javax.media.NoPlayerException;
import javax.media.NoProcessorException;
import javax.media.PackageManager;
import javax.media.Player;
import javax.media.Processor;
import javax.media.ProcessorModel;
import javax.media.SystemTimeBase;
import javax.media.TimeBase;
import javax.media.control.FormatControl;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.SourceCloneable;

public final class Manager {
    private static String VERSION = "2.0beta2";
    public static final int MAX_SECURITY = 1;
    public static final int CACHING = 2;
    public static final int LIGHTWEIGHT_RENDERER = 3;
    public static final int PLUGIN_PLAYER = 4;
    private static int numberOfHints = 4;
    private static SystemTimeBase sysTimeBase = null;
    public static final String UNKNOWN_CONTENT_NAME = "unknown";
    private static boolean jdkInit;
    private static Method forName3ArgsM;
    private static Method getSystemClassLoaderM;
    private static ClassLoader systemClassLoader;
    private static Method getContextClassLoaderM;
    private static String fileSeparator;
    private static Hashtable hintTable;
    static final int DONE = 0;
    static final int SUCCESS = 1;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$java$lang$Thread;

    private Manager() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static Player createPlayer(URL sourceURL) throws IOException, NoPlayerException {
        return Manager.createPlayer(new MediaLocator(sourceURL));
    }

    public static Player createPlayer(MediaLocator sourceLocator) throws IOException, NoPlayerException {
        Player newPlayer = null;
        Hashtable sources = new Hashtable(10);
        boolean needPluginPlayer = (Boolean)Manager.getHint(4);
        try {
            newPlayer = Manager.createPlayerForContent(sourceLocator, needPluginPlayer, sources);
        }
        catch (NoPlayerException e2) {
            if (needPluginPlayer) {
                throw e2;
            }
            newPlayer = Manager.createPlayerForContent(sourceLocator, true, sources);
        }
        if (sources.size() != 0) {
            Enumeration enumeration = sources.elements();
            while (enumeration.hasMoreElements()) {
                DataSource ds = (DataSource)enumeration.nextElement();
                ds.disconnect();
            }
        }
        return newPlayer;
    }

    public static Player createPlayer(DataSource source) throws IOException, NoPlayerException {
        Player newPlayer;
        boolean needPluginPlayer = (Boolean)Manager.getHint(4);
        try {
            String contentType = needPluginPlayer ? UNKNOWN_CONTENT_NAME : source.getContentType();
            newPlayer = Manager.createPlayerForSource(source, contentType, null);
        }
        catch (NoPlayerException e2) {
            if (needPluginPlayer) {
                throw e2;
            }
            newPlayer = Manager.createPlayerForSource(source, UNKNOWN_CONTENT_NAME, null);
        }
        return newPlayer;
    }

    public static Player createRealizedPlayer(URL sourceURL) throws IOException, NoPlayerException, CannotRealizeException {
        Player p2 = Manager.createPlayer(sourceURL);
        Manager.blockingCall(p2, 300);
        return p2;
    }

    public static Player createRealizedPlayer(MediaLocator ml) throws IOException, NoPlayerException, CannotRealizeException {
        Player p2 = Manager.createPlayer(ml);
        Manager.blockingCall(p2, 300);
        return p2;
    }

    public static Player createRealizedPlayer(DataSource source) throws IOException, NoPlayerException, CannotRealizeException {
        Player p2 = Manager.createPlayer(source);
        Manager.blockingCall(p2, 300);
        return p2;
    }

    public static Processor createProcessor(URL sourceURL) throws IOException, NoProcessorException {
        return Manager.createProcessor(new MediaLocator(sourceURL));
    }

    public static Processor createProcessor(MediaLocator sourceLocator) throws IOException, NoProcessorException {
        Processor newProcessor = null;
        Hashtable sources = new Hashtable(10);
        try {
            newProcessor = Manager.createProcessorForContent(sourceLocator, false, sources);
        }
        catch (NoProcessorException noProcessorException) {
            newProcessor = Manager.createProcessorForContent(sourceLocator, true, sources);
        }
        if (sources.size() != 0) {
            Enumeration enumeration = sources.elements();
            while (enumeration.hasMoreElements()) {
                DataSource ds = (DataSource)enumeration.nextElement();
                ds.disconnect();
            }
        }
        return newProcessor;
    }

    public static Processor createProcessor(DataSource source) throws IOException, NoProcessorException {
        Processor newProcessor;
        try {
            newProcessor = Manager.createProcessorForSource(source, source.getContentType(), null);
        }
        catch (NoProcessorException noProcessorException) {
            newProcessor = Manager.createProcessorForSource(source, UNKNOWN_CONTENT_NAME, null);
        }
        return newProcessor;
    }

    public static Processor createRealizedProcessor(ProcessorModel model) throws IOException, NoProcessorException, CannotRealizeException {
        int k2;
        int i2;
        DataSource ds = null;
        MediaLocator ml = null;
        Processor processor = null;
        boolean matched = false;
        Format[] reqFormats = null;
        int reqNumTracks = -1;
        int nTracksEnabled = 0;
        if (model == null) {
            throw new NoProcessorException("null ProcessorModel");
        }
        ds = model.getInputDataSource();
        if (ds != null) {
            processor = Manager.createProcessor(ds);
        } else {
            ml = model.getInputLocator();
            if (ml != null) {
                processor = Manager.createProcessor(ml);
            } else {
                int nDevices = Manager.getNTypesOfCaptureDevices();
                Vector<DataSource> dataSourceList = new Vector<DataSource>(1);
                reqNumTracks = model.getTrackCount(nDevices);
                reqFormats = new Format[reqNumTracks];
                i2 = 0;
                while (i2 < reqNumTracks) {
                    CaptureDeviceInfo cdi;
                    reqFormats[i2] = model.getOutputTrackFormat(i2);
                    Vector deviceList = CaptureDeviceManager.getDeviceList(reqFormats[i2]);
                    if (deviceList == null || deviceList.size() == 0) {
                        if (reqFormats[i2] instanceof AudioFormat) {
                            deviceList = CaptureDeviceManager.getDeviceList(new AudioFormat(null));
                        } else if (reqFormats[i2] instanceof VideoFormat) {
                            deviceList = CaptureDeviceManager.getDeviceList(new VideoFormat(null));
                        }
                    }
                    if (deviceList.size() != 0 && (cdi = (CaptureDeviceInfo)deviceList.elementAt(0)) != null && cdi.getLocator() != null) {
                        try {
                            Format[] supported;
                            FormatControl[] fc;
                            DataSource crds = Manager.createDataSource(cdi.getLocator());
                            if (crds instanceof CaptureDevice && (fc = ((CaptureDevice)((Object)crds)).getFormatControls()).length > 0 && (supported = fc[0].getSupportedFormats()).length > 0) {
                                int f2 = 0;
                                while (f2 < supported.length) {
                                    Format intersect;
                                    if (supported[f2].matches(reqFormats[i2]) && (intersect = supported[f2].intersects(reqFormats[i2])) != null && fc[0].setFormat(intersect) != null) break;
                                    ++f2;
                                }
                            }
                            dataSourceList.addElement(crds);
                        }
                        catch (IOException iOException) {
                        }
                        catch (NoDataSourceException noDataSourceException) {}
                    }
                    ++i2;
                }
                if (dataSourceList.size() == 0) {
                    throw new NoProcessorException("No suitable capture devices found!");
                }
                if (dataSourceList.size() > 1) {
                    DataSource[] dataSourceArray = new DataSource[dataSourceList.size()];
                    k2 = 0;
                    while (k2 < dataSourceList.size()) {
                        dataSourceArray[k2] = (DataSource)dataSourceList.elementAt(k2);
                        ++k2;
                    }
                    try {
                        ds = Manager.createMergingDataSource(dataSourceArray);
                    }
                    catch (IncompatibleSourceException incompatibleSourceException) {
                        throw new NoProcessorException("Couldn't merge capture devices");
                    }
                } else {
                    ds = (DataSource)dataSourceList.elementAt(0);
                }
                processor = Manager.createProcessor(ds);
            }
        }
        if (processor == null) {
            throw new NoProcessorException("Couldn't create Processor for source");
        }
        Manager.blockingCall(processor, 180);
        ContentDescriptor rcd = model.getContentDescriptor();
        if (rcd == null) {
            processor.setContentDescriptor(null);
        } else {
            ContentDescriptor[] cds = processor.getSupportedContentDescriptors();
            if (cds == null || cds.length == 0) {
                throw new NoProcessorException("Processor doesn't support output");
            }
            i2 = 0;
            while (i2 < cds.length) {
                if (rcd.matches(cds[i2]) && processor.setContentDescriptor(cds[i2]) != null) {
                    matched = true;
                    break;
                }
                ++i2;
            }
            if (!matched) {
                throw new NoProcessorException("Processor doesn't support requested output ContentDescriptor");
            }
        }
        TrackControl[] procTracks = processor.getTrackControls();
        if (procTracks != null && procTracks.length > 0) {
            int nValidTracks = 0;
            i2 = 0;
            while (i2 < procTracks.length) {
                if (procTracks[i2].isEnabled()) {
                    ++nValidTracks;
                }
                ++i2;
            }
            if (reqNumTracks == -1) {
                reqNumTracks = model.getTrackCount(nValidTracks);
            }
            if (reqNumTracks > 0) {
                int j2;
                Format prefFormat;
                if (reqFormats == null) {
                    reqFormats = new Format[reqNumTracks];
                }
                int[] procToReqMap = new int[reqNumTracks];
                i2 = 0;
                while (i2 < reqNumTracks) {
                    if (reqFormats[i2] == null) {
                        reqFormats[i2] = model.getOutputTrackFormat(i2);
                    }
                    procToReqMap[i2] = -1;
                    ++i2;
                }
                boolean[] enabled = new boolean[procTracks.length];
                i2 = 0;
                while (i2 < procTracks.length) {
                    enabled[i2] = false;
                    if (procTracks[i2].isEnabled()) {
                        prefFormat = procTracks[i2].getFormat();
                        j2 = 0;
                        while (j2 < reqNumTracks) {
                            if (procToReqMap[j2] == -1 && (reqFormats[j2] == null || prefFormat.matches(reqFormats[j2])) && model.isFormatAcceptable(j2, prefFormat)) {
                                procToReqMap[j2] = i2;
                                enabled[i2] = true;
                                ++nTracksEnabled;
                                break;
                            }
                            ++j2;
                        }
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < procTracks.length && nTracksEnabled < reqNumTracks) {
                    boolean used = false;
                    if (procTracks[i2].isEnabled()) {
                        Format[] suppFormats;
                        j2 = 0;
                        while (j2 < reqNumTracks) {
                            if (procToReqMap[j2] == i2) {
                                used = true;
                            }
                            ++j2;
                        }
                        if (!used && (suppFormats = procTracks[i2].getSupportedFormats()) != null && suppFormats.length != 0) {
                            matched = false;
                            k2 = 0;
                            while (k2 < suppFormats.length && !matched) {
                                prefFormat = suppFormats[k2];
                                j2 = 0;
                                while (j2 < reqNumTracks && !matched) {
                                    if (procToReqMap[j2] == -1 && (reqFormats[j2] == null || prefFormat.matches(reqFormats[j2])) && model.isFormatAcceptable(j2, prefFormat) && procTracks[i2].setFormat(prefFormat) != null) {
                                        procToReqMap[j2] = i2;
                                        enabled[i2] = true;
                                        ++nTracksEnabled;
                                        matched = true;
                                        break;
                                    }
                                    ++j2;
                                }
                                ++k2;
                            }
                        }
                    }
                    ++i2;
                }
                if (nTracksEnabled < reqNumTracks) {
                    throw new CannotRealizeException("Unable to provide all requested tracks");
                }
            }
        }
        Manager.blockingCall(processor, 300);
        return processor;
    }

    public static DataSource createDataSource(URL sourceURL) throws IOException, NoDataSourceException {
        return Manager.createDataSource(new MediaLocator(sourceURL));
    }

    public static DataSource createDataSource(MediaLocator sourceLocator) throws IOException, NoDataSourceException {
        DataSource source = null;
        Enumeration protoList = Manager.getDataSourceList(sourceLocator.getProtocol()).elements();
        while (protoList.hasMoreElements()) {
            String protoClassName = (String)protoList.nextElement();
            try {
                Class protoClass = Manager.getClassForName(protoClassName);
                source = (DataSource)protoClass.newInstance();
                source.setLocator(sourceLocator);
                source.connect();
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                source = null;
            }
            catch (InstantiationException instantiationException) {
                source = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                source = null;
            }
            catch (Exception e2) {
                source = null;
                String err = "Error instantiating class: " + protoClassName + " : " + e2;
                throw new NoDataSourceException(err);
            }
        }
        if (source == null) {
            throw new NoDataSourceException();
        }
        return source;
    }

    public static DataSource createMergingDataSource(DataSource[] sources) throws IncompatibleSourceException {
        if (sources.length == 0) {
            throw new IncompatibleSourceException("No sources");
        }
        if (sources[0] instanceof PullDataSource) {
            int i2 = 1;
            while (i2 < sources.length) {
                if (!(sources[i2] instanceof PullDataSource)) {
                    throw new IncompatibleSourceException("One of the sources isn't matching the others");
                }
                ++i2;
            }
            PullDataSource[] pds = new PullDataSource[sources.length];
            int i3 = 0;
            while (i3 < pds.length) {
                pds[i3] = (PullDataSource)sources[i3];
                ++i3;
            }
            return new MergingPullDataSource(pds);
        }
        if (sources[0] instanceof PushDataSource) {
            int i4 = 1;
            while (i4 < sources.length) {
                if (!(sources[i4] instanceof PushDataSource)) {
                    throw new IncompatibleSourceException("One of the sources isn't matching the others");
                }
                ++i4;
            }
            PushDataSource[] pds = new PushDataSource[sources.length];
            int i5 = 0;
            while (i5 < pds.length) {
                pds[i5] = (PushDataSource)sources[i5];
                ++i5;
            }
            return new MergingPushDataSource(pds);
        }
        if (sources[0] instanceof PullBufferDataSource) {
            int i6 = 1;
            while (i6 < sources.length) {
                if (!(sources[i6] instanceof PullBufferDataSource)) {
                    throw new IncompatibleSourceException("One of the sources isn't matching the others");
                }
                ++i6;
            }
            PullBufferDataSource[] pds = new PullBufferDataSource[sources.length];
            int i7 = 0;
            while (i7 < pds.length) {
                pds[i7] = (PullBufferDataSource)sources[i7];
                ++i7;
            }
            return new MergingPullBufferDataSource(pds);
        }
        if (sources[0] instanceof PushBufferDataSource) {
            int i8 = 1;
            while (i8 < sources.length) {
                if (!(sources[i8] instanceof PushBufferDataSource)) {
                    throw new IncompatibleSourceException("One of the sources isn't matching the others");
                }
                ++i8;
            }
            PushBufferDataSource[] pds = new PushBufferDataSource[sources.length];
            int i9 = 0;
            while (i9 < pds.length) {
                pds[i9] = (PushBufferDataSource)sources[i9];
                ++i9;
            }
            return new MergingPushBufferDataSource(pds);
        }
        return null;
    }

    public static DataSource createCloneableDataSource(DataSource source) {
        if (source instanceof SourceCloneable) {
            return source;
        }
        if (source instanceof CaptureDevice) {
            if (source instanceof PullDataSource) {
                return new CloneableCapturePullDataSource((PullDataSource)source);
            }
            if (source instanceof PushDataSource) {
                return new CloneableCapturePushDataSource((PushDataSource)source);
            }
            if (source instanceof PullBufferDataSource) {
                return new CloneableCapturePullBufferDataSource((PullBufferDataSource)source);
            }
            if (source instanceof PushBufferDataSource) {
                return new CloneableCapturePushBufferDataSource((PushBufferDataSource)source);
            }
        }
        if (source instanceof PullDataSource) {
            return new CloneablePullDataSource((PullDataSource)source);
        }
        if (source instanceof PushDataSource) {
            return new CloneablePushDataSource((PushDataSource)source);
        }
        if (source instanceof PullBufferDataSource) {
            return new CloneablePullBufferDataSource((PullBufferDataSource)source);
        }
        if (source instanceof PushBufferDataSource) {
            return new CloneablePushBufferDataSource((PushBufferDataSource)source);
        }
        return null;
    }

    public static TimeBase getSystemTimeBase() {
        if (sysTimeBase == null) {
            sysTimeBase = new SystemTimeBase();
        }
        return sysTimeBase;
    }

    static Player createPlayerForContent(MediaLocator sourceLocator, boolean useUnknownContent, Hashtable sources) throws IOException, NoPlayerException {
        Player newPlayer = null;
        boolean[] sourceUsed = new boolean[]{false};
        Enumeration protoList = Manager.getDataSourceList(sourceLocator.getProtocol()).elements();
        while (protoList.hasMoreElements()) {
            String protoClassName = (String)protoList.nextElement();
            DataSource source = null;
            try {
                source = (DataSource)sources.get(protoClassName);
                if (source == null) {
                    Class protoClass = Manager.getClassForName(protoClassName);
                    source = (DataSource)protoClass.newInstance();
                    source.setLocator(sourceLocator);
                    source.connect();
                } else {
                    sources.remove(protoClassName);
                }
                try {
                    if (useUnknownContent) {
                        newPlayer = Manager.createPlayerForSource(source, UNKNOWN_CONTENT_NAME, sourceUsed);
                        break;
                    }
                    newPlayer = Manager.createPlayerForSource(source, source.getContentType(), sourceUsed);
                    break;
                }
                catch (NoPlayerException noPlayerException) {
                    newPlayer = null;
                    if (sourceUsed[0]) {
                        source.disconnect();
                        continue;
                    }
                    sources.put(protoClassName, source);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                source = null;
            }
            catch (InstantiationException instantiationException) {
                source = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                source = null;
            }
            catch (Exception e2) {
                source = null;
                String err = "Error instantiating class: " + protoClassName + " : " + e2;
                throw new NoPlayerException(err);
            }
        }
        if (newPlayer == null) {
            throw new NoPlayerException("");
        }
        return newPlayer;
    }

    static Player createPlayerForSource(DataSource source, String contentTypeName, boolean[] sourceUsed) throws IOException, NoPlayerException {
        Player newPlayer = null;
        if (sourceUsed != null) {
            sourceUsed[0] = true;
        }
        Enumeration playerList = Manager.getHandlerClassList(contentTypeName).elements();
        DataSource newSource = null;
        while (playerList.hasMoreElements()) {
            String handlerClassName = (String)playerList.nextElement();
            try {
                Class handlerClass = Manager.getClassForName(handlerClassName);
                MediaHandler mHandler = (MediaHandler)handlerClass.newInstance();
                mHandler.setSource(source);
                if (mHandler instanceof Player) {
                    newPlayer = (Player)mHandler;
                    break;
                }
                MediaProxy mProxy = (MediaProxy)mHandler;
                newSource = mProxy.getDataSource();
                String newContentType = newSource.getContentType();
                try {
                    newPlayer = Manager.createPlayerForSource(newSource, newContentType, null);
                }
                catch (NoPlayerException noPlayerException) {
                    newPlayer = Manager.createPlayerForSource(newSource, UNKNOWN_CONTENT_NAME, null);
                    if (newPlayer == null) continue;
                    break;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                newPlayer = null;
                if (sourceUsed == null) continue;
                sourceUsed[0] = false;
            }
            catch (InstantiationException instantiationException) {
                newPlayer = null;
                if (sourceUsed == null) continue;
                sourceUsed[0] = false;
            }
            catch (IllegalAccessException illegalAccessException) {
                newPlayer = null;
                if (sourceUsed == null) continue;
                sourceUsed[0] = false;
            }
            catch (IncompatibleSourceException incompatibleSourceException) {
                newPlayer = null;
            }
            catch (NoDataSourceException noDataSourceException) {
                newPlayer = null;
            }
            catch (Exception e2) {
                newPlayer = null;
                String err = "Error instantiating class: " + handlerClassName + " : " + e2;
                throw new NoPlayerException(err);
            }
        }
        if (newPlayer == null) {
            throw new NoPlayerException();
        }
        return newPlayer;
    }

    static Processor createProcessorForContent(MediaLocator sourceLocator, boolean useUnknownContent, Hashtable sources) throws IOException, NoProcessorException {
        Processor newProcessor = null;
        boolean[] sourceUsed = new boolean[]{false};
        Enumeration protoList = Manager.getDataSourceList(sourceLocator.getProtocol()).elements();
        while (protoList.hasMoreElements()) {
            String protoClassName = (String)protoList.nextElement();
            DataSource source = null;
            try {
                source = (DataSource)sources.get(protoClassName);
                if (source == null) {
                    Class protoClass = Manager.getClassForName(protoClassName);
                    source = (DataSource)protoClass.newInstance();
                    source.setLocator(sourceLocator);
                    source.connect();
                } else {
                    sources.remove(protoClassName);
                }
                try {
                    if (useUnknownContent) {
                        newProcessor = Manager.createProcessorForSource(source, UNKNOWN_CONTENT_NAME, sourceUsed);
                        break;
                    }
                    newProcessor = Manager.createProcessorForSource(source, source.getContentType(), sourceUsed);
                    break;
                }
                catch (NoProcessorException noProcessorException) {
                    newProcessor = null;
                    if (sourceUsed[0]) {
                        source.disconnect();
                        continue;
                    }
                    sources.put(protoClassName, source);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                source = null;
            }
            catch (InstantiationException instantiationException) {
                source = null;
            }
            catch (IllegalAccessException illegalAccessException) {
                source = null;
            }
            catch (Exception e2) {
                String err = "Error instantiating class: " + protoClassName + " : " + e2;
                throw new NoProcessorException(err);
            }
        }
        if (newProcessor == null) {
            throw new NoProcessorException("");
        }
        return newProcessor;
    }

    static Processor createProcessorForSource(DataSource source, String contentTypeName, boolean[] sourceUsed) throws IOException, NoProcessorException {
        Processor newProcessor = null;
        if (sourceUsed != null) {
            sourceUsed[0] = true;
        }
        Enumeration playerList = Manager.getProcessorClassList(contentTypeName).elements();
        DataSource newSource = null;
        while (playerList.hasMoreElements()) {
            String handlerClassName = (String)playerList.nextElement();
            try {
                Class handlerClass = Manager.getClassForName(handlerClassName);
                MediaHandler mHandler = (MediaHandler)handlerClass.newInstance();
                mHandler.setSource(source);
                if (mHandler instanceof Processor) {
                    newProcessor = (Processor)mHandler;
                    break;
                }
                MediaProxy mProxy = (MediaProxy)mHandler;
                newSource = mProxy.getDataSource();
                String newContentType = newSource.getContentType();
                try {
                    newProcessor = Manager.createProcessorForSource(newSource, newContentType, null);
                }
                catch (NoProcessorException noProcessorException) {
                    newProcessor = Manager.createProcessorForSource(newSource, UNKNOWN_CONTENT_NAME, null);
                    if (newProcessor == null) continue;
                    break;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                newProcessor = null;
                if (sourceUsed == null) continue;
                sourceUsed[0] = false;
            }
            catch (InstantiationException instantiationException) {
                newProcessor = null;
                if (sourceUsed == null) continue;
                sourceUsed[0] = false;
            }
            catch (IllegalAccessException illegalAccessException) {
                newProcessor = null;
                if (sourceUsed == null) continue;
                sourceUsed[0] = false;
            }
            catch (IncompatibleSourceException incompatibleSourceException) {
                newProcessor = null;
            }
            catch (NoDataSourceException noDataSourceException) {
                newProcessor = null;
            }
            catch (Exception e2) {
                newProcessor = null;
                String err = "Error instantiating class: " + handlerClassName + " : " + e2;
                throw new NoProcessorException(err);
            }
        }
        if (newProcessor == null) {
            throw new NoProcessorException();
        }
        return newProcessor;
    }

    public static DataSink createDataSink(DataSource datasource, MediaLocator destLocator) throws NoDataSinkException {
        String handlerName = "media.datasink." + destLocator.getProtocol() + ".Handler";
        Vector classList = Manager.buildClassList(Manager.getContentPrefixList(), handlerName);
        Enumeration handlerList = classList.elements();
        DataSink dataSink = null;
        boolean done = false;
        block4: while (!done && handlerList.hasMoreElements()) {
            String handlerClassName = (String)handlerList.nextElement();
            try {
                Class handlerClass = Manager.getClassForName(handlerClassName);
                Object object = handlerClass.newInstance();
                if (object instanceof DataSink) {
                    dataSink = (DataSink)object;
                    dataSink.setSource(datasource);
                    dataSink.setOutputLocator(destLocator);
                    done = true;
                    break;
                }
                DataSinkProxy dsProxy = (DataSinkProxy)object;
                String contentType = dsProxy.getContentType(destLocator);
                handlerName = "media.datasink." + destLocator.getProtocol() + "." + contentType + ".Handler";
                Vector dataSinkList = Manager.buildClassList(Manager.getContentPrefixList(), handlerName);
                Enumeration elements = dataSinkList.elements();
                while (elements.hasMoreElements()) {
                    String dsClassName = (String)elements.nextElement();
                    try {
                        dataSink = (DataSink)Manager.getClassForName(dsClassName).newInstance();
                        dataSink.setSource(datasource);
                        dataSink.setOutputLocator(destLocator);
                        done = true;
                        continue block4;
                    }
                    catch (Exception exception) {
                        dataSink = null;
                    }
                }
            }
            catch (Exception exception) {
                dataSink = null;
            }
        }
        if (dataSink == null) {
            throw new NoDataSinkException("");
        }
        return dataSink;
    }

    public static String getCacheDirectory() {
        Object cdir = Registry.get("secure.cacheDir");
        if (cdir != null) {
            if (!(cdir instanceof String)) {
                return null;
            }
            String cacheDir = (String)cdir;
            if (cacheDir.indexOf(fileSeparator) == -1) {
                cacheDir = fileSeparator.equals("/") ? "/tmp" : (fileSeparator.equals("\\") ? "C:" + fileSeparator + "temp" : null);
            }
            return cacheDir;
        }
        return null;
    }

    public static void setHint(int hint, Object value) {
        if (value != null && hint >= 1 && hint <= numberOfHints) {
            hintTable.put(new Integer(hint), value);
        }
    }

    public static Object getHint(int hint) {
        if (hint >= 1 && hint <= numberOfHints) {
            return hintTable.get(new Integer(hint));
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void blockingCall(Player p2, int state) throws CannotRealizeException {
        boolean[] sync = new boolean[]{false, false};
        MCA cl = new MCA(sync, state);
        p2.addControllerListener(cl);
        if (state == 300) {
            p2.realize();
        } else if (state == 180) {
            ((Processor)p2).configure();
        }
        boolean[] blArray = sync;
        synchronized (blArray) {
            while (!sync[0]) {
                try {
                    sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        p2.removeControllerListener(cl);
        if (!sync[1]) {
            throw new CannotRealizeException();
        }
    }

    public static Vector getDataSourceList(String protocolName) {
        String sourceName = "media.protocol." + protocolName + ".DataSource";
        return Manager.buildClassList(Manager.getProtocolPrefixList(), sourceName);
    }

    public static Vector getHandlerClassList(String contentName) {
        String handlerName = "media.content." + ContentDescriptor.mimeTypeToPackageName(contentName) + ".Handler";
        return Manager.buildClassList(Manager.getContentPrefixList(), handlerName);
    }

    public static Vector getProcessorClassList(String contentName) {
        String handlerName = "media.processor." + ContentDescriptor.mimeTypeToPackageName(contentName) + ".Handler";
        return Manager.buildClassList(Manager.getContentPrefixList(), handlerName);
    }

    static Vector buildClassList(Vector prefixList, String name) {
        Vector<String> classList = new Vector<String>();
        classList.addElement(name);
        Enumeration prefix = prefixList.elements();
        while (prefix.hasMoreElements()) {
            String prefixName = (String)prefix.nextElement();
            classList.addElement(String.valueOf(prefixName) + "." + name);
        }
        return classList;
    }

    static Vector getContentPrefixList() {
        return (Vector)PackageManager.getContentPrefixList().clone();
    }

    static Vector getProtocolPrefixList() {
        return (Vector)PackageManager.getProtocolPrefixList().clone();
    }

    private static int getNTypesOfCaptureDevices() {
        int nDevices = 0;
        Vector audioDevs = CaptureDeviceManager.getDeviceList(new AudioFormat(null));
        Vector videoDevs = CaptureDeviceManager.getDeviceList(new VideoFormat(null));
        if (audioDevs != null && audioDevs.size() > 0) {
            ++nDevices;
        }
        if (videoDevs != null && videoDevs.size() > 0) {
            ++nDevices;
        }
        return nDevices;
    }

    private static boolean checkIfJDK12() {
        if (jdkInit) {
            return forName3ArgsM != null;
        }
        jdkInit = true;
        try {
            forName3ArgsM = (class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = Manager.class$("java.lang.Class"))).getMethod("forName", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Manager.class$("java.lang.String")), Boolean.TYPE, class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = Manager.class$("java.lang.ClassLoader")));
            getSystemClassLoaderM = (class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = Manager.class$("java.lang.ClassLoader"))).getMethod("getSystemClassLoader", null);
            systemClassLoader = (ClassLoader)getSystemClassLoaderM.invoke((Object)(class$java$lang$ClassLoader != null ? class$java$lang$ClassLoader : (class$java$lang$ClassLoader = Manager.class$("java.lang.ClassLoader"))), null);
            getContextClassLoaderM = (class$java$lang$Thread != null ? class$java$lang$Thread : (class$java$lang$Thread = Manager.class$("java.lang.Thread"))).getMethod("getContextClassLoader", null);
            return true;
        }
        catch (Throwable throwable) {
            forName3ArgsM = null;
            return false;
        }
    }

    static Class getClassForName(String className) throws ClassNotFoundException {
        block9: {
            try {
                return Class.forName(className);
            }
            catch (Exception e2) {
                if (!Manager.checkIfJDK12()) {
                    throw new ClassNotFoundException(e2.getMessage());
                }
            }
            catch (Error e3) {
                if (Manager.checkIfJDK12()) break block9;
                throw e3;
            }
        }
        try {
            return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = Manager.class$("java.lang.Class"))), className, new Boolean(true), systemClassLoader);
        }
        catch (Throwable throwable) {
            try {
                ClassLoader contextClassLoader = (ClassLoader)getContextClassLoaderM.invoke((Object)Thread.currentThread(), null);
                return (Class)forName3ArgsM.invoke((Object)(class$java$lang$Class != null ? class$java$lang$Class : (class$java$lang$Class = Manager.class$("java.lang.Class"))), className, new Boolean(true), contextClassLoader);
            }
            catch (Exception e4) {
                throw new ClassNotFoundException(e4.getMessage());
            }
            catch (Error e5) {
                throw e5;
            }
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static {
        fileSeparator = System.getProperty("file.separator");
        hintTable = new Hashtable();
        hintTable.put(new Integer(1), new Boolean(false));
        hintTable.put(new Integer(2), new Boolean(true));
        hintTable.put(new Integer(3), new Boolean(false));
        hintTable.put(new Integer(4), new Boolean(false));
    }
}

