/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.dvi;

import com.ibm.media.codec.audio.AudioPacketizer;
import com.ibm.media.codec.audio.dvi.DVI;
import com.ibm.media.codec.audio.dvi.DVIState;
import com.ibm.media.codec.audio.dvi.PacketSizeAdapter;
import com.sun.media.controls.SilenceSuppressionAdapter;
import javax.media.Buffer;
import javax.media.Control;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class JavaEncoder
extends AudioPacketizer {
    private Buffer pcmBuffer = new Buffer();
    private DVIState dviState = new DVIState();

    public JavaEncoder() {
        this.packetSize = 240;
        this.supportedInputFormats = new AudioFormat[]{new AudioFormat("LINEAR", -1.0, 16, 1, 0, 1, -1, -1.0, Format.byteArray)};
        this.defaultOutputFormats = new AudioFormat[]{new AudioFormat("dvi/rtp", -1.0, 4, 1, -1, -1, -1, -1.0, Format.byteArray)};
        this.PLUGIN_NAME = "DVI Encoder";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        AudioFormat af = (AudioFormat)in;
        this.supportedOutputFormats = new AudioFormat[]{new AudioFormat("dvi/rtp", af.getSampleRate(), 4, 1, -1, -1, -1, -1.0, Format.byteArray)};
        return this.supportedOutputFormats;
    }

    public Format setOutputFormat(Format out) {
        Format f2 = super.setOutputFormat(out);
        AudioFormat af = (AudioFormat)f2;
        if (af.getSampleRate() == 8000.0) {
            this.packetSize = 240;
        } else if (af.getSampleRate() == 11025.0) {
            this.packetSize = 330;
        } else if (af.getSampleRate() == 22050.0) {
            this.packetSize = 660;
        } else if (af.getSampleRate() == 44100.0) {
            this.packetSize = 1320;
        }
        return f2;
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        int rc = super.process(inputBuffer, this.pcmBuffer);
        if ((rc & 4) != 0) {
            return rc;
        }
        byte[] pcmData = (byte[])this.pcmBuffer.getData();
        int inpLength = this.pcmBuffer.getLength();
        int outLength = this.pcmBuffer.getLength() / 4;
        byte[] outData = this.validateByteArraySize(outputBuffer, outLength + 4);
        outData[0] = (byte)(this.dviState.valprev >> 8);
        outData[1] = (byte)this.dviState.valprev;
        outData[2] = (byte)this.dviState.index;
        outData[3] = 0;
        DVI.encode(pcmData, 0, outData, 4, inpLength >> 1, this.dviState);
        this.pcmBuffer.setOffset(0);
        this.pcmBuffer.setLength(0);
        outputBuffer.setSequenceNumber(this.pcmBuffer.getSequenceNumber());
        outputBuffer.setTimeStamp(this.pcmBuffer.getTimeStamp());
        this.updateOutput(outputBuffer, this.outputFormat, outLength + 4, 0);
        return rc;
    }

    public void open() throws ResourceUnavailableException {
        this.dviState = new DVIState();
        this.setPacketSize(this.packetSize);
        this.reset();
    }

    public void reset() {
        super.reset();
        this.dviState.valprev = 0;
        this.dviState.index = 0;
        this.pcmBuffer.setOffset(0);
        this.pcmBuffer.setLength(0);
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[2];
            this.controls[0] = new PacketSizeAdapter(this, this.packetSize, true);
            this.controls[1] = new SilenceSuppressionAdapter(this, false, false);
        }
        return this.controls;
    }

    public synchronized void setPacketSize(int newPacketSize) {
        this.packetSize = newPacketSize * 4;
        this.sample_count = this.packetSize / 2;
        if (this.history == null) {
            this.history = new byte[this.packetSize];
            return;
        }
        if (this.packetSize > this.history.length) {
            byte[] newHistory = new byte[this.packetSize];
            System.arraycopy(this.history, 0, newHistory, 0, this.historyLength);
            this.history = newHistory;
        }
    }
}

