/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.jpeg;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.JMFSecurityManager;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.JPEGFormat;
import javax.media.format.VideoFormat;

public class Packetizer
extends BasicCodec {
    private static boolean loaded;
    private static boolean canLoad;
    private int peer;
    private VideoFormat inputFormat;
    private VideoFormat outputFormat;
    private int PACKET_SIZE;
    private int currentSeq;
    private int copyLength;
    private boolean newframe;
    private int current_offset;
    private int packet_counter;
    private long packet_inc;
    int returnVal;
    private int decimation;
    private static final int DEFAULT_FRAMERATE = 15;
    private float frame_duration;

    public Packetizer() {
        this.copyLength = this.PACKET_SIZE = 960;
        this.newframe = true;
        this.decimation = -1;
        this.frame_duration = -1.0f;
        this.inputFormats = new VideoFormat[]{new VideoFormat("jpeg")};
        this.outputFormats = new VideoFormat[]{new VideoFormat("jpeg/rtp")};
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return this.outputFormats;
        }
        if (!this.verifyInputFormat(in)) {
            return new Format[0];
        }
        Format[] out = new Format[]{((VideoFormat)in).getFrameRate() == -1.0f ? new VideoFormat("jpeg/rtp", ((VideoFormat)in).getSize(), ((VideoFormat)in).getMaxDataLength(), Format.byteArray, 15.0f) : new VideoFormat("jpeg/rtp", ((VideoFormat)in).getSize(), ((VideoFormat)in).getMaxDataLength(), Format.byteArray, ((VideoFormat)in).getFrameRate())};
        return out;
    }

    private boolean verifyInputFormat(Format input) {
        return input instanceof VideoFormat && input.getEncoding().equals("jpeg");
    }

    public Format setInputFormat(Format input) {
        if (!this.verifyInputFormat(input)) {
            return null;
        }
        this.inputFormat = (VideoFormat)input;
        Dimension size = this.inputFormat.getSize();
        if (size != null && (size.width % 8 != 0 || size.height % 8 != 0)) {
            System.err.println("JPEG packetizer does not handle non standard image size:\ntrack cannot be transcoded to JPEG/RTP");
            return null;
        }
        float rate = this.inputFormat.getFrameRate();
        if (rate != -1.0f) {
            this.frame_duration = 1000.0f / rate;
        }
        return input;
    }

    public Format setOutputFormat(Format output) {
        if (BasicPlugIn.matches(output, this.outputFormats) == null) {
            return null;
        }
        this.outputFormat = (VideoFormat)output;
        return output;
    }

    public void open() throws ResourceUnavailableException {
        if (!canLoad) {
            throw new ResourceUnavailableException("Unable to load native JPEG converter");
        }
        if (!loaded) {
            try {
                JMFSecurityManager.loadLibrary("jmjpeg");
                loaded = true;
            }
            catch (Throwable throwable) {
                canLoad = false;
                throw new ResourceUnavailableException("Unable to load native JPEG converter");
            }
        }
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Incorrect formats set on JPEG converter");
        }
        if (this.peer != 0) {
            this.close();
        }
        try {
            this.peer = this.initJPEGPacketizer();
        }
        catch (Throwable throwable) {}
        if (this.peer == 0) {
            throw new ResourceUnavailableException("Unable to initialize JPEG converter");
        }
    }

    public synchronized void close() {
        if (this.peer != 0) {
            this.freeJPEGPacketizer(this.peer);
        }
        this.peer = 0;
    }

    public void reset() {
    }

    public synchronized int process(Buffer inBuffer, Buffer outBuffer) {
        Object header = null;
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            return 0;
        }
        if (inBuffer.isDiscard()) {
            this.updateOutput(outBuffer, this.outputFormat, 0, 0);
            outBuffer.setDiscard(true);
            return 4;
        }
        Format inFormat = inBuffer.getFormat();
        Format outFormat = outBuffer.getFormat();
        byte[] inData = (byte[])inBuffer.getData();
        if (this.outputFormat.getEncoding().equals("jpeg/rtp")) {
            int qfactor;
            byte[] outData;
            int remaining_output;
            boolean inLength = false;
            if (outFormat == null) {
                outBuffer.setFormat(this.outputFormat);
            }
            if (this.peer == 0) {
                try {
                    this.open();
                }
                catch (ResourceUnavailableException resourceUnavailableException) {
                    return 1;
                }
            }
            if (this.decimation == -1) {
                int length = inBuffer.getLength();
                int[] width = new int[1];
                int[] height = new int[1];
                int[] dec = new int[1];
                this.peekJFIF(inData, length, width, height, dec);
                this.decimation = dec[0];
            }
            Dimension size = this.inputFormat.getSize();
            int keyFrame = 0;
            if (this.newframe) {
                this.returnVal = inBuffer.getLength();
                this.current_offset = 0;
                this.newframe = false;
                int numpackets = inBuffer.getLength() % this.PACKET_SIZE != 0 ? inBuffer.getLength() / this.PACKET_SIZE + 1 : inBuffer.getLength() / this.PACKET_SIZE;
                this.packet_inc = (long)(this.frame_duration / (float)numpackets);
                this.packet_counter = 0;
                keyFrame = 16;
            }
            if ((remaining_output = this.returnVal - this.current_offset) < this.PACKET_SIZE) {
                this.copyLength = remaining_output;
            }
            if ((outData = (byte[])outBuffer.getData()) == null || outData.length < this.copyLength + 8) {
                outData = new byte[this.copyLength + 8];
                outBuffer.setData(outData);
            }
            System.arraycopy(inData, this.current_offset, outData, 8, this.copyLength);
            int n2 = qfactor = this.inputFormat instanceof JPEGFormat ? ((JPEGFormat)this.inputFormat).getQFactor() : 80;
            if (this.returnVal > 0) {
                outBuffer.setLength(this.copyLength + 8);
                outBuffer.setOffset(0);
                outBuffer.setSequenceNumber(this.currentSeq++);
                outBuffer.setFormat(this.outputFormat);
                outData[0] = 0;
                outData[1] = (byte)(this.current_offset >> 16);
                outData[2] = (byte)(this.current_offset >> 8);
                outData[3] = (byte)this.current_offset;
                outData[4] = (byte)this.decimation;
                outData[5] = (byte)qfactor;
                outData[6] = (byte)(size.width / 8);
                outData[7] = (byte)(size.height / 8);
                this.current_offset += this.copyLength;
                outBuffer.setFlags(keyFrame);
                if (this.current_offset == this.returnVal) {
                    outBuffer.setFlags(outBuffer.getFlags() | 0x400);
                    this.newframe = true;
                    this.current_offset = 0;
                    this.copyLength = this.PACKET_SIZE;
                    return 0;
                }
                return 2;
            }
            outBuffer.setDiscard(true);
            return 1;
        }
        return 1;
    }

    public void finalize() {
        this.close();
    }

    public String getName() {
        return "JPEG Packetizer";
    }

    private native boolean peekJFIF(byte[] var1, int var2, int[] var3, int[] var4, int[] var5);

    private native int initJPEGPacketizer();

    private native boolean freeJPEGPacketizer(int var1);

    static {
        canLoad = true;
    }
}

