/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.PassiveSSRCInfo;
import com.sun.media.rtp.RTPSourceInfo;
import com.sun.media.rtp.RecvSSRCInfo;
import com.sun.media.rtp.SSRCCache;
import com.sun.media.rtp.SSRCInfo;
import com.sun.media.rtp.util.RTPMediaThread;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.event.ByeEvent;
import javax.media.rtp.event.InactiveReceiveStreamEvent;
import javax.media.rtp.event.TimeoutEvent;

public class SSRCCacheCleaner
implements Runnable {
    private SSRCCache cache;
    private RTPMediaThread thread;
    private static final int DEATHTIME = 1800000;
    private static final int TIMEOUT_MULTIPLIER = 5;
    boolean timeToClean = false;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    public SSRCCacheCleaner(SSRCCache cache) {
        this.cache = cache;
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable e2) {
                if (permission.endsWith("group")) {
                    jmfSecurity.permissionFailureNotification(32);
                }
                jmfSecurity.permissionFailureNotification(16);
            }
        }
        this.thread = new RTPMediaThread(this, "SSRC Cache Cleaner");
        this.thread.setDaemon(true);
        this.thread.useControlPriority();
        this.thread.start();
    }

    public void stop() {
        this.thread.stop();
    }

    public synchronized void run() {
        try {
            while (true) {
                if (!this.timeToClean) {
                    this.wait();
                    continue;
                }
                this.cleannow();
                this.timeToClean = false;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return;
        }
    }

    public synchronized void setClean() {
        this.timeToClean = true;
        this.notifyAll();
    }

    public void cleannow() {
        long time = System.currentTimeMillis();
        if (this.cache.ourssrc == null) {
            return;
        }
        double reportInterval = this.cache.calcReportInterval(this.cache.ourssrc.sender, true);
        Enumeration enumeration = this.cache.cache.elements();
        while (enumeration.hasMoreElements()) {
            SSRCInfo info = (SSRCInfo)enumeration.nextElement();
            if (info.ours) continue;
            if (info.byeReceived) {
                if (time - info.byeTime < 1000L) continue;
                info.byeTime = 0L;
                info.byeReceived = false;
                this.cache.remove(info.ssrc);
                boolean byepart = false;
                RTPSourceInfo sourceInfo = info.sourceInfo;
                if (sourceInfo != null && sourceInfo.getStreamCount() == 0) {
                    byepart = true;
                }
                ByeEvent evtbye = null;
                if (info instanceof RecvSSRCInfo) {
                    evtbye = new ByeEvent(this.cache.sm, info.sourceInfo, (ReceiveStream)((Object)info), info.byereason, byepart);
                }
                if (info instanceof PassiveSSRCInfo) {
                    evtbye = new ByeEvent(this.cache.sm, info.sourceInfo, null, info.byereason, byepart);
                }
                this.cache.eventhandler.postEvent(evtbye);
                continue;
            }
            if (!((double)info.lastHeardFrom + reportInterval <= (double)time)) continue;
            InactiveReceiveStreamEvent event = null;
            if (!info.inactivesent) {
                boolean laststream = false;
                RTPSourceInfo si = info.sourceInfo;
                if (si != null && si.getStreamCount() == 1) {
                    laststream = true;
                }
                if (info instanceof ReceiveStream) {
                    event = new InactiveReceiveStreamEvent(this.cache.sm, info.sourceInfo, (ReceiveStream)((Object)info), laststream);
                } else if ((double)info.lastHeardFrom + (reportInterval *= 5.0) <= (double)time) {
                    event = new InactiveReceiveStreamEvent(this.cache.sm, info.sourceInfo, null, laststream);
                }
                if (event == null) continue;
                this.cache.eventhandler.postEvent(event);
                info.quiet = true;
                info.inactivesent = true;
                info.setAlive(false);
                continue;
            }
            if (info.lastHeardFrom + 1800000L > time) continue;
            TimeoutEvent evt = null;
            this.cache.remove(info.ssrc);
            boolean byepart = false;
            RTPSourceInfo sourceInfo = info.sourceInfo;
            if (sourceInfo != null && sourceInfo.getStreamCount() == 0) {
                byepart = true;
            }
            evt = info instanceof ReceiveStream ? new TimeoutEvent(this.cache.sm, info.sourceInfo, (ReceiveStream)((Object)info), byepart) : new TimeoutEvent(this.cache.sm, info.sourceInfo, null, byepart);
            this.cache.eventhandler.postEvent(evt);
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }
}

