/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Caret;
import javax.swing.text.ComponentView;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.JTextComponent;
import javax.swing.text.LabelView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class StyledEditorKit
extends DefaultEditorKit {
    private static final ViewFactory defaultFactory = new StyledViewFactory();
    Element currentRun;
    Element currentParagraph;
    MutableAttributeSet inputAttributes = new SimpleAttributeSet(){

        public Object clone() {
            return new SimpleAttributeSet(this);
        }

        public AttributeSet getResolveParent() {
            return StyledEditorKit.this.currentParagraph != null ? StyledEditorKit.this.currentParagraph.getAttributes() : null;
        }
    };
    private AttributeTracker inputAttributeUpdater = new AttributeTracker();
    private static final Action[] defaultActions = new Action[]{new FontFamilyAction("font-family-SansSerif", "SansSerif"), new FontFamilyAction("font-family-Monospaced", "Monospaced"), new FontFamilyAction("font-family-Serif", "Serif"), new FontSizeAction("font-size-8", 8), new FontSizeAction("font-size-10", 10), new FontSizeAction("font-size-12", 12), new FontSizeAction("font-size-14", 14), new FontSizeAction("font-size-16", 16), new FontSizeAction("font-size-18", 18), new FontSizeAction("font-size-24", 24), new FontSizeAction("font-size-36", 36), new FontSizeAction("font-size-48", 48), new AlignmentAction("left-justify", 0), new AlignmentAction("center-justify", 1), new AlignmentAction("right-justify", 2), new BoldAction(), new ItalicAction(), new UnderlineAction()};

    public Object clone() {
        return new StyledEditorKit();
    }

    public Document createDefaultDocument() {
        return new DefaultStyledDocument();
    }

    protected void createInputAttributes(Element element, MutableAttributeSet mutableAttributeSet) {
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        mutableAttributeSet.addAttributes(element.getAttributes());
        mutableAttributeSet.removeAttribute(StyleConstants.ComponentAttribute);
        mutableAttributeSet.removeAttribute(StyleConstants.IconAttribute);
        mutableAttributeSet.removeAttribute("$ename");
        mutableAttributeSet.removeAttribute(StyleConstants.ComposedTextAttribute);
    }

    public void deinstall(JEditorPane jEditorPane) {
        jEditorPane.removeCaretListener(this.inputAttributeUpdater);
        jEditorPane.removePropertyChangeListener(this.inputAttributeUpdater);
        this.currentRun = null;
        this.currentParagraph = null;
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public Element getCharacterAttributeRun() {
        return this.currentRun;
    }

    public MutableAttributeSet getInputAttributes() {
        return this.inputAttributes;
    }

    public ViewFactory getViewFactory() {
        return defaultFactory;
    }

    public void install(JEditorPane jEditorPane) {
        jEditorPane.addCaretListener(this.inputAttributeUpdater);
        jEditorPane.addPropertyChangeListener(this.inputAttributeUpdater);
        Caret caret = jEditorPane.getCaret();
        if (caret != null) {
            this.inputAttributeUpdater.updateInputAttributes(caret.getDot(), caret.getMark(), jEditorPane);
        }
    }

    class AttributeTracker
    implements CaretListener,
    PropertyChangeListener,
    Serializable {
        AttributeTracker() {
        }

        public void caretUpdate(CaretEvent caretEvent) {
            this.updateInputAttributes(caretEvent.getDot(), caretEvent.getMark(), (JTextComponent)caretEvent.getSource());
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getSource();
            if (object2 instanceof JTextComponent && object instanceof Document) {
                this.updateInputAttributes(0, 0, (JTextComponent)object2);
            }
        }

        void updateInputAttributes(int n, int n2, JTextComponent jTextComponent) {
            Document document = jTextComponent.getDocument();
            if (!(document instanceof StyledDocument)) {
                return;
            }
            int n3 = Math.min(n, n2);
            StyledDocument styledDocument = (StyledDocument)document;
            StyledEditorKit.this.currentParagraph = styledDocument.getParagraphElement(n3);
            Element element = StyledEditorKit.this.currentParagraph.getStartOffset() == n3 ? styledDocument.getCharacterElement(n3) : styledDocument.getCharacterElement(Math.max(n3 - 1, 0));
            if (element != StyledEditorKit.this.currentRun) {
                StyledEditorKit.this.currentRun = element;
                StyledEditorKit.this.createInputAttributes(StyledEditorKit.this.currentRun, StyledEditorKit.this.getInputAttributes());
            }
        }
    }

    static class StyledViewFactory
    implements ViewFactory {
        StyledViewFactory() {
        }

        public View create(Element element) {
            String string = element.getName();
            if (string != null) {
                if (string.equals("content")) {
                    return new LabelView(element);
                }
                if (string.equals("paragraph")) {
                    return new ParagraphView(element);
                }
                if (string.equals("section")) {
                    return new BoxView(element, 1);
                }
                if (string.equals("component")) {
                    return new ComponentView(element);
                }
                if (string.equals("icon")) {
                    return new IconView(element);
                }
            }
            return new LabelView(element);
        }
    }

    public static abstract class StyledTextAction
    extends TextAction {
        public StyledTextAction(String string) {
            super(string);
        }

        protected final JEditorPane getEditor(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof JEditorPane) {
                return (JEditorPane)jTextComponent;
            }
            return null;
        }

        protected final StyledDocument getStyledDocument(JEditorPane jEditorPane) {
            Document document = jEditorPane.getDocument();
            if (document instanceof StyledDocument) {
                return (StyledDocument)document;
            }
            throw new IllegalArgumentException("document must be StyledDocument");
        }

        protected final StyledEditorKit getStyledEditorKit(JEditorPane jEditorPane) {
            EditorKit editorKit = jEditorPane.getEditorKit();
            if (editorKit instanceof StyledEditorKit) {
                return (StyledEditorKit)editorKit;
            }
            throw new IllegalArgumentException("EditorKit must be StyledEditorKit");
        }

        protected final void setCharacterAttributes(JEditorPane jEditorPane, AttributeSet attributeSet, boolean bl) {
            Object object;
            int n;
            int n2 = jEditorPane.getSelectionStart();
            if (n2 != (n = jEditorPane.getSelectionEnd())) {
                object = this.getStyledDocument(jEditorPane);
                object.setCharacterAttributes(n2, n - n2, attributeSet, bl);
            }
            object = this.getStyledEditorKit(jEditorPane);
            MutableAttributeSet mutableAttributeSet = ((StyledEditorKit)object).getInputAttributes();
            if (bl) {
                mutableAttributeSet.removeAttributes(mutableAttributeSet);
            }
            mutableAttributeSet.addAttributes(attributeSet);
        }

        protected final void setParagraphAttributes(JEditorPane jEditorPane, AttributeSet attributeSet, boolean bl) {
            int n = jEditorPane.getSelectionStart();
            int n2 = jEditorPane.getSelectionEnd();
            StyledDocument styledDocument = this.getStyledDocument(jEditorPane);
            styledDocument.setParagraphAttributes(n, n2 - n, attributeSet, bl);
        }
    }

    public static class FontFamilyAction
    extends StyledTextAction {
        private String family;

        public FontFamilyAction(String string, String string2) {
            super(string);
            this.family = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                Object object;
                Object object2 = this.family;
                if (actionEvent != null && actionEvent.getSource() == jEditorPane && (object = actionEvent.getActionCommand()) != null) {
                    object2 = object;
                }
                if (object2 != null) {
                    object = new SimpleAttributeSet();
                    StyleConstants.setFontFamily((MutableAttributeSet)object, (String)object2);
                    this.setCharacterAttributes(jEditorPane, (AttributeSet)object, false);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    public static class FontSizeAction
    extends StyledTextAction {
        private int size;

        public FontSizeAction(String string, int n) {
            super(string);
            this.size = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                Object object;
                int n = this.size;
                if (actionEvent != null && actionEvent.getSource() == jEditorPane) {
                    object = actionEvent.getActionCommand();
                    try {
                        n = Integer.parseInt((String)object, 10);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (n != 0) {
                    object = new SimpleAttributeSet();
                    StyleConstants.setFontSize((MutableAttributeSet)object, n);
                    this.setCharacterAttributes(jEditorPane, (AttributeSet)object, false);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    public static class ForegroundAction
    extends StyledTextAction {
        private Color fg;

        public ForegroundAction(String string, Color color) {
            super(string);
            this.fg = color;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                Object object;
                Color color = this.fg;
                if (actionEvent != null && actionEvent.getSource() == jEditorPane) {
                    object = actionEvent.getActionCommand();
                    try {
                        color = Color.decode((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (color != null) {
                    object = new SimpleAttributeSet();
                    StyleConstants.setForeground((MutableAttributeSet)object, color);
                    this.setCharacterAttributes(jEditorPane, (AttributeSet)object, false);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }
    }

    public static class AlignmentAction
    extends StyledTextAction {
        private int a;

        public AlignmentAction(String string, int n) {
            super(string);
            this.a = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                Object object;
                int n = this.a;
                if (actionEvent != null && actionEvent.getSource() == jEditorPane) {
                    object = actionEvent.getActionCommand();
                    try {
                        n = Integer.parseInt((String)object, 10);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                object = new SimpleAttributeSet();
                StyleConstants.setAlignment((MutableAttributeSet)object, n);
                this.setParagraphAttributes(jEditorPane, (AttributeSet)object, false);
            }
        }
    }

    public static class BoldAction
    extends StyledTextAction {
        public BoldAction() {
            super("font-bold");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                StyledEditorKit styledEditorKit = this.getStyledEditorKit(jEditorPane);
                MutableAttributeSet mutableAttributeSet = styledEditorKit.getInputAttributes();
                boolean bl = !StyleConstants.isBold(mutableAttributeSet);
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setBold(simpleAttributeSet, bl);
                this.setCharacterAttributes(jEditorPane, simpleAttributeSet, false);
            }
        }
    }

    public static class ItalicAction
    extends StyledTextAction {
        public ItalicAction() {
            super("font-italic");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                StyledEditorKit styledEditorKit = this.getStyledEditorKit(jEditorPane);
                MutableAttributeSet mutableAttributeSet = styledEditorKit.getInputAttributes();
                boolean bl = !StyleConstants.isItalic(mutableAttributeSet);
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setItalic(simpleAttributeSet, bl);
                this.setCharacterAttributes(jEditorPane, simpleAttributeSet, false);
            }
        }
    }

    public static class UnderlineAction
    extends StyledTextAction {
        public UnderlineAction() {
            super("font-underline");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                StyledEditorKit styledEditorKit = this.getStyledEditorKit(jEditorPane);
                MutableAttributeSet mutableAttributeSet = styledEditorKit.getInputAttributes();
                boolean bl = !StyleConstants.isUnderline(mutableAttributeSet);
                SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
                StyleConstants.setUnderline(simpleAttributeSet, bl);
                this.setCharacterAttributes(jEditorPane, simpleAttributeSet, false);
            }
        }
    }
}

