/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt.multiList;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import symantec.itools.awt.MultiList;
import symantec.itools.awt.multiList.Cell;

public class TextAndImageCell
extends Cell
implements ImageObserver,
Serializable {
    protected MultiList list;
    protected String text = "";
    protected transient Image im;

    public TextAndImageCell(MultiList l) {
        this.list = l;
    }

    public TextAndImageCell(MultiList l, String s) {
        this.list = l;
        this.text = s;
    }

    public TextAndImageCell(MultiList l, Image i) {
        this.list = l;
        this.im = i;
    }

    public TextAndImageCell(MultiList l, String s, Image i) {
        this.list = l;
        this.text = s;
        this.im = i;
    }

    public void drawCell(Graphics g, int align, int x, int y, int w, int h, int asc) {
        FontMetrics fm = g.getFontMetrics();
        int sw = fm.stringWidth(this.text);
        int offset = 0;
        switch (align) {
            case 0: {
                if (this.im != null) {
                    g.drawImage(this.im, x, y, this);
                    offset = this.im.getWidth(this) + 2;
                }
                g.drawString(this.text, x + offset, y + asc);
                break;
            }
            case 1: {
                if (sw > w) {
                    g.drawString(this.text, x, y + asc);
                    break;
                }
                g.drawString(this.text, x + (w - sw) / 2, y + asc);
                break;
            }
            case 2: {
                if (sw > w) {
                    g.drawString(this.text, x, y + asc);
                    break;
                }
                g.drawString(this.text, x + w - sw - 6, y + asc);
                break;
            }
        }
    }

    public String getText() {
        return this.text;
    }

    public Image getImage() {
        return this.im;
    }

    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        if ((flags & 0xA0) != 0) {
            this.list.redraw();
            this.list.repaint();
            return false;
        }
        return true;
    }

    public String toString() {
        return this.text;
    }
}

