//////////////////////////////////////////////////////////////////////
//
//   DBF.H
//
//  Alchemy DBF Access core header file (v.1.2)
//  Copyright (C) Alchemy Lab, 2000
//     http://www.alchemy-lab.com
//
//////////////////////////////////////////////////////////////////////

#ifndef _DBF_H_
#define _DBF_H_

// Error code
typedef	int	DBF_Error_Code;

#define	DBF_E_ERROR					-1		// Error found
#define	DBF_E_NO_ERROR				0		// Error not found


// constants and global variables
#define DBF_F_DATE_FORMAT "%m/%d/%Y"           // Date format (for date->string and string->date conversions)

// Field types
#define	DBF_FIELD_TYPE_CHARACTER	'C'		// Character
#define	DBF_FIELD_TYPE_NUMERIC		'N'		// Float or integer
#define	DBF_FIELD_TYPE_LOGICAL		'L'		// Logical
#define	DBF_FIELD_TYPE_DATE			'D'		// Date
#define	DBF_FIELD_TYPE_MEMO			'M'		// Memo


typedef struct {
	int year;
	int month;
	int day;
} DBFDate;


typedef struct
{
    char			FieldName[11];		//	Field name
    char			FieldType;			//	Field type
    char			FieldTypeEx[15];	//	Field full type
    int				FieldLen;			//	Field len
    int				FieldDec;			//	Field decimal

}	DBFField;

typedef struct
{
	int		LastError;	//	Last Error code
	void*	pData;		//	For internal purposes

}	DBFTable;


#ifdef __cplusplus
extern "C"{
#endif

DBF_Error_Code	DBFOpen			(const char* fName, DBFTable* pDBFTable);
DBF_Error_Code	DBFClose		(DBFTable* pDBFTable);
DBF_Error_Code	DBFCreate		(const char* fName, int fieldCount, const DBFField* pDBFField);
DBF_Error_Code	DBFGetLastError	(DBFTable* pDBFTable, char* errMsg, int maxlen);
DBF_Error_Code	DBFPack			(DBFTable* pDBFTable);
int				DBFIsOpen		(DBFTable* pDBFTable);


const DBFField*	DBFGetFields	(DBFTable* pDBFTable);
long			DBFGetFieldCount(DBFTable* pDBFTable);
long			DBFGetRecCount	(DBFTable* pDBFTable);
long			DBFGetRecLen	(DBFTable* pDBFTable);
long			DBFGetRecNo		(DBFTable* pDBFTable);
long			DBFGetNonDeletedRecNo(DBFTable* pDBFTable);
const char*		DBFGetVersion	(DBFTable* pDBFTable);
const char*		DBFGetFileName	(DBFTable* pDBFTable);
int				DBFIsRecordDeleted(DBFTable* pDBFTable);
int				DBFGetShowDeleted(DBFTable* pDBFTable);
DBF_Error_Code	DBFSetShowDeleted(DBFTable* pDBFTable, int show);
DBF_Error_Code	DBFGetFieldNumber(DBFTable* pDBFTable, const char* pszFieldName, int *fNumber);

int				DBFIsEOF(DBFTable* pDBFTable);
int				DBFIsBOF(DBFTable* pDBFTable);
DBF_Error_Code	DBFTop(DBFTable* pDBFTable);
DBF_Error_Code	DBFBottom(DBFTable* pDBFTable);
DBF_Error_Code	DBFSkip(DBFTable* pDBFTable, long count);
DBF_Error_Code	DBFGoTo(DBFTable* pDBFTable, long recno);
DBF_Error_Code	DBFGoToNonDeleted(DBFTable* pDBFTable, long recno);

DBF_Error_Code	DBFDelete	(DBFTable* pDBFTable);
DBF_Error_Code	DBFRecall	(DBFTable* pDBFTable);
DBF_Error_Code	DBFAppend	(DBFTable* pDBFTable);
DBF_Error_Code	DBFEdit		(DBFTable* pDBFTable);
DBF_Error_Code	DBFPost		(DBFTable* pDBFTable);
DBF_Error_Code	DBFCancel	(DBFTable* pDBFTable);


// Get/Set Field Value
// fieldNumber - from 0 to (FieldCount - 1)
DBF_Error_Code DBFGetCharacterByName(DBFTable* pDBFTable, const char* pszFieldName,
														char* fieldValue, int maxlen);
DBF_Error_Code DBFGetCharacterByNumber(DBFTable* pDBFTable, int fieldNumber,
														char* fieldValue, int maxlen);
DBF_Error_Code DBFGetIntByName(DBFTable* pDBFTable, const char* pszFieldName,
																	int *fieldValue);
DBF_Error_Code DBFGetIntByNumber(DBFTable* pDBFTable, int fieldNumber,
																	int *fieldValue);
DBF_Error_Code DBFGetLongByName(DBFTable* pDBFTable, const char* pszFieldName,
																	long *fieldValue);
DBF_Error_Code DBFGetLongByNumber(DBFTable* pDBFTable, int fieldNumber,
																	long *fieldValue);
DBF_Error_Code DBFGetDoubleByName(DBFTable* pDBFTable, const char* pszFieldName,
																	double *fieldValue);
DBF_Error_Code DBFGetDoubleByNumber(DBFTable* pDBFTable, int fieldNumber,
																	double *fieldValue);
DBF_Error_Code DBFGetLogicalByName(DBFTable* pDBFTable, const char* pszFieldName,
																	int *fieldValue);
DBF_Error_Code DBFGetLogicalByNumber(DBFTable* pDBFTable, int fieldNumber,
																	int *fieldValue);
DBF_Error_Code DBFGetDateByName(DBFTable* pDBFTable, const char* pszFieldName,
																	DBFDate *fieldValue);
DBF_Error_Code DBFGetDateByNumber(DBFTable* pDBFTable, int fieldNumber,
																	DBFDate *fieldValue);


DBF_Error_Code DBFPutCharacterByName(DBFTable* pDBFTable, const char* pszFieldName,
																const char* fieldValue);
DBF_Error_Code DBFPutCharacterByNumber(DBFTable* pDBFTable, int fieldNumber,
																const char* fieldValue);
DBF_Error_Code DBFPutIntByName(DBFTable* pDBFTable, const char* pszFieldName,
																	int fieldValue);
DBF_Error_Code DBFPutIntByNumber(DBFTable* pDBFTable, int fieldNumber,
																	int fieldValue);
DBF_Error_Code DBFPutLongByName(DBFTable* pDBFTable, const char* pszFieldName,
																	long fieldValue);
DBF_Error_Code DBFPutLongByNumber(DBFTable* pDBFTable, int fieldNumber,
																	long fieldValue);
DBF_Error_Code DBFPutDoubleByName(DBFTable* pDBFTable, const char* pszFieldName,
																	double fieldValue);
DBF_Error_Code DBFPutDoubleByNumber(DBFTable* pDBFTable, int fieldNumber,
																	double fieldValue);
DBF_Error_Code DBFPutLogicalByName(DBFTable* pDBFTable, const char* pszFieldName,
																	int fieldValue);
DBF_Error_Code DBFPutLogicalByNumber(DBFTable* pDBFTable, int fieldNumber,
																	int fieldValue);
DBF_Error_Code DBFPutDateByName(DBFTable* pDBFTable, const char* pszFieldName,
																const DBFDate *fieldValue);
DBF_Error_Code DBFPutDateByNumber(DBFTable* pDBFTable, int fieldNumber,
																const DBFDate *fieldValue);


#ifdef __cplusplus
}
#endif

#endif