// View.cpp : implementation of the CAddCliView class
//

#include "stdafx.h"
#include "AddCli.h"

#include "Doc.h"
#include "View.h"

#include "..\AddSrv\AddSrv_i.c"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// works fine but has this namespace gotcha
/*
#import "..\AddSrv\AddSrv.tlb" 
using namespace ADDSRVLib;
ADDSRVLib::IAddIntfPtr pAdder; 
*/
// works fine but no namespace gotcha
/*
#import "..\AddSrv\AddSrv.tlb" 
using namespace ADDSRVLib;
IAddIntfPtr pAdder; 
*/

/////////////////////////////////////////////////////////////////////////////
// CAddCliView

IMPLEMENT_DYNCREATE(CAddCliView, CFormView)

BEGIN_MESSAGE_MAP(CAddCliView, CFormView)
	//{{AFX_MSG_MAP(CAddCliView)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CFormView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAddCliView construction/destruction

CAddCliView::CAddCliView()
	: CFormView(CAddCliView::IDD)
{
	//{{AFX_DATA_INIT(CAddCliView)
	m_nEdit1 = 0;
	m_nEdit2 = 0;
	m_sAnswer = _T("");
	//}}AFX_DATA_INIT
	// TODO: add construction code here

}

CAddCliView::~CAddCliView()
{
}

void CAddCliView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAddCliView)
	DDX_Text(pDX, IDC_EDIT1, m_nEdit1);
	DDX_Text(pDX, IDC_EDIT2, m_nEdit2);
	DDX_Text(pDX, IDC_ANSWER, m_sAnswer);
	//}}AFX_DATA_MAP
}

BOOL CAddCliView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

void CAddCliView::OnInitialUpdate()
{
	CFormView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

	HRESULT hr;

/*  
	//works fine using the CComPtr pointer
	hr = CoCreateInstance(CLSID_AddIntf, NULL, CLSCTX_INPROC_SERVER, 
                                IID_IAddIntf, reinterpret_cast<void **>(&pAdder)); 
	if(FAILED(hr))
	{
		AfxMessageBox(_T("failed"));
	}
*/

/*
	//alternate using the CComPtr pointer
	hr = pAdder.CoCreateInstance(CLSID_AddIntf, NULL, CLSCTX_INPROC_SERVER); 
	if(FAILED(hr))
	{
		AfxMessageBox(_T("failed"));
	}
*/
	
/*
	//alternate using the CComPtr pointer
	CComBSTR str("AddSrv.AddIntf.1");
	hr = pAdder.CoCreateInstance(str, NULL, CLSCTX_INPROC_SERVER); 
	if(FAILED(hr))
	{
		AfxMessageBox(_T("failed"));
	}
*/

/*
	//alternate using the CComPtr pointer
	hr = pAdder.CoCreateInstance(L"AddSrv.AddIntf.1", NULL, CLSCTX_INPROC_SERVER); 
	if(FAILED(hr))
	{
		AfxMessageBox(_T("failed"));
	}
*/

	//alternate using the CComPtr pointer
	hr = pAdder.CoCreateInstance(L"AddSrv.AddIntf.1"); 
	if(FAILED(hr))
	{
		AfxMessageBox(_T("failed"));
	}
	
/*
	//alternate using the CComPtr pointer
	CLSID clsid;
	hr = CLSIDFromProgID(L"AddSrv.AddIntf.1", &clsid);
	if(FAILED(hr))
	{
		AfxMessageBox(_T("failed"));
	}
	hr = pAdder.CoCreateInstance(clsid); 
	if(FAILED(hr))
	{
		AfxMessageBox(_T("failed"));
	}
*/

	
/* 
	//using the smart ppinter from the type lib
	hr = pAdder.CreateInstance(_uuidof(ADDSRVLib::AddIntf)); 
	if(FAILED(hr))
	{
		AfxMessageBox(_T("failed"));
	}
*/
}

/////////////////////////////////////////////////////////////////////////////
// CAddCliView printing

BOOL CAddCliView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CAddCliView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CAddCliView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

void CAddCliView::OnPrint(CDC* pDC, CPrintInfo* /*pInfo*/)
{
	// TODO: add customized printing code here
}

/////////////////////////////////////////////////////////////////////////////
// CAddCliView diagnostics

#ifdef _DEBUG
void CAddCliView::AssertValid() const
{
	CFormView::AssertValid();
}

void CAddCliView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CAddCliDoc* CAddCliView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CAddCliDoc)));
	return (CAddCliDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CAddCliView message handlers

void CAddCliView::OnButton1() 
{
	UpdateData(TRUE);
	long lAnswer = 0;

	// use if NOT #import typelib
	//		or if using the typoelib but want the "raw" HRESULT return version
	//	the func takes 3 params
	pAdder->raw_AddVal(m_nEdit1, m_nEdit2, &lAnswer); 

	// use if #import typelib
	//	tlh converts [out,retval] to the return val i.e. func takes only 2 args
	//lAnswer = pAdder->AddVal(m_nEdit1, m_nEdit2);

	m_sAnswer.Format("%d", lAnswer);
	UpdateData(FALSE);	
}
