// AdoWindow.h: interface for the AdoWindow class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ADOWINDOW_H__8DA15773_75B9_11D2_9172_8E5E24000000__INCLUDED_)
#define AFX_ADOWINDOW_H__8DA15773_75B9_11D2_9172_8E5E24000000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "AdoLib.h"

//This is the base class for dialog and property sheet objects. They must
//inherit from this in addition to their MFC hierarchy.
//It manages recordset mapping of the user interface object.

class AdoWindow : public AdoRecordset  
{
	static BOOL CALLBACK EnumChildProc(HWND hwnd, LPARAM lParam);
protected:
	bool alta;
		//Attribute that determines if we are editing or adding a record.
	void EnableControls(HWND hwnd, bool enable);
		//Control enabling function
public:
	virtual bool Execute() = 0;
		//Mandatory execution method.
	virtual LPCSTR TableName() = 0;
		//ADO doesn't store the table name
	virtual bool Exec(char* sql, bool a = false);
		//This method launches a dialog object from an external user interface.
	virtual bool Baja(char* sql);
		//Method for managing record deletion
	AdoWindow(LPCSTR s, bool a = false);
		//Regular constructor. It takes a SQL string and an editing/adding condition.
	AdoWindow(AdoRecordset& r, bool a = false);
		//Constructor for child objects, taking an existing recordset.
	virtual ~AdoWindow() {};
	AdoWindow* operator&() {return this;}
	friend class CAdoPropPage;
		//Objects of this class must access protected attributes.
};

#endif // !defined(AFX_ADOWINDOW_H__8DA15773_75B9_11D2_9172_8E5E24000000__INCLUDED_)
