# Subroutine parameter demo
:start
echo "Subroutine parameter demo."
echo
echo "The PUSH and POP verbs allow you to place copies of data onto a"
echo "'stack' structure.  The stack can either be used to preserve the"
echo "value of a given variable so that it may be used locally in a"
echo "subroutine, or it can be used to deliver information to a subroutine."
echo
echo "This demo will use two subroutines; CENTER and SPACES.  Each "
echo "subroutine will accept one parameter on the stack.  SPACES will "
echo "use that parameter to determine how many spaces to output.  CENTER"
echo "will display its parameter in a centered position on the screen."
echo
echo "....|....1....|....2....|....3....|....4....|....5....|....6....|....7....|...."

push  "Upon one day"
gosub CENTER

push "the Thunder God was riding his favorite filly."
gosub CENTER

echo
push "'I am Thor', he cried"
gosub CENTER

push "but his horse replied,"
gosub CENTER

push "'You forgot your thaddle, thilly!'"
gosub CENTER
echo
echo

pause
extreturn

:CENTER
pop line
length len $line
sub x 80 $len
dec x
div x $x 2
push $x
gosub SPACES
echo $line
return


:SPACES
pop numspaces
:SPACELOOP
echonr " "
dec numspaces
if $numspaces gt 0 goto SPACELOOP
return
