/*
 * Copyright (C) 2001 Advanced Software Engineering Limited.
 *
 * This file is part of the ChartDirector software. Usage of this file is
 * subjected to the ChartDirector license agreement. See the LICENSE.TXT
 * file that comes with the ChartDirector software release, or visit
 * Advanced Software Engineering's web site at www.advsofteng.com or 
 * email to support@advsofteng.com for information.
 *
 */
 
#ifndef BASECHART_HDR
#define BASECHART_HDR


#include "drawobj.h"


class LegendBox : virtual public TextBox
{
public :
	virtual ~LegendBox() {}
	virtual void addKey(const char *text, int color) = 0;
};


class BaseChart
{
public :
	enum ImgFormat {PNG, GIF, JPG, WMP};
	
	virtual ~BaseChart() {}
	virtual void destroy() = 0;

	//////////////////////////////////////////////////////////////////////////////////////
	//	set overall chart
	//////////////////////////////////////////////////////////////////////////////////////
	virtual void setSize(int width, int height) = 0;
	virtual void setBorder(int color) = 0;
	virtual void setWallpaper(const char *img) = 0;
	virtual void setBgImage(const char *img, Alignment align = Center) = 0;

	virtual TextBox *addTitle(Alignment alignment, const char *text, const char *font = 0, double fontSize = 12,
		int fontColor = TextColor, int bgColor = Transparent, int edgeColor = Transparent) = 0;
	virtual TextBox *addTitle(const char *text, const char *font = 0, double fontSize = 12,
		int fontColor = TextColor, int bgColor = Transparent, int edgeColor = Transparent) = 0;

	virtual LegendBox *addLegend(int x, int y, bool vertical = true, const char *font = 0, 
		double fontHeight = 10) = 0;
	virtual LegendBox *getLegend() = 0;

	//////////////////////////////////////////////////////////////////////////////////////
	//	drawing primitives
	//////////////////////////////////////////////////////////////////////////////////////
	virtual DrawArea *getDrawArea() = 0;
	virtual DrawObj *addDrawObj(DrawObj *obj) = 0;
	virtual TextBox *addText(int x, int y, const char *text, const char *font = 0, double fontSize = 8, 
		int fontColor = TextColor, Alignment alignment = TopLeft, double angle = 0, bool vertical = false) = 0;
	virtual Line *addLine(int x1, int y1, int x2, int y2, int color = LineColor, int lineWidth = 1) = 0;
	
	//////////////////////////////////////////////////////////////////////////////////////
	//	color management methods
	//////////////////////////////////////////////////////////////////////////////////////
	virtual void setColor(int paletteEntry, int color) = 0;
	virtual void setColors(int paletteEntry, const int *colors) = 0;
	virtual void setColors(const int *colors) = 0;
	virtual int getColor(int paletteEntry) = 0;

	//////////////////////////////////////////////////////////////////////////////////////
	//	chart creation methods
	//////////////////////////////////////////////////////////////////////////////////////
	virtual void layout() = 0;
	virtual bool makeChart(const char *filename) = 0;
	virtual bool makeChart(ImgFormat format, const char **data, int *len) = 0;
	virtual MemBlock makeChart(ImgFormat format) = 0;
};


static int defaultPalette[] = 
{
	0xffffff, 0x000000, 0x000000, 0x808080, 
	0x808080, 0x808080, 0x808080, 0x808080,
	0xff0000, 0x00ff00, 0x0000ff, 0xffff00, 
	0xff00ff, 0x66ffff,	0xffcc33, 0xcccccc, 
	0x9966ff, 0x339966, 0x999900, 0xcc3300,	
	0x99cccc, 0x006600, 0x660066, 0xcc9999,
	-1
};

static int whiteOnBlackPalette[] =
{
	0x000000, 0xffffff, 0xffffff, 0x808080, 
	0x808080, 0x808080, 0x808080, 0x808080,
	0xff0000, 0x00ff00, 0x0000ff, 0xffff00, 
	0xff00ff, 0x66ffff,	0xffcc33, 0xcccccc, 
	0x9966ff, 0x339966, 0x999900, 0xcc3300,	
	0x99cccc, 0x006600, 0x660066, 0xcc9999,
	-1
};

static int transparentPalette[] = 
{
	0xffffff, 0x000000, 0x000000, 0x808080, 
	0x808080, 0x808080, 0x808080, 0x808080,
	0x80ff0000, 0x8000ff00, 0x800000ff, 0x80ffff00, 
	0x80ff00ff, 0x8066ffff,	0x80ffcc33, 0x80cccccc, 
	0x809966ff, 0x80339966, 0x80999900, 0x80cc3300,
	0x8099cccc, 0x80006600, 0x80660066, 0x80cc9999,
	-1
};

#endif
