#include "chartdir.h"

void legendpos(int legendPos, const char *filename)
{
	//The data for the chart
	double data0[] = {100, 125, 245.78, 147, 67};
	double data1[] = {85, 156, 179.5, 211, 123};
	double data2[] = {97, 187, 156, 237, 157};
	const char *labels[] = {"Mon", "Tue", "Wed", "Thu", "Fri"};

	//Create a XYChart object of size 300 x 300
	XYChart *c = XYChart::create(300, 300);

	//Set the plot area at (50, 40) and of size 240 x 200
	c->setPlotArea(50, 40, 240, 200);

	switch (legendPos)
	{
	case 0 :
		//add legends on the top of the chart (60, 10) using horizontal layout.
		//set the font to 8 points, and hide the legend box boundary (Transparent)
		c->addLegend(60, 10, false, 0, 8)->setBackground(Transparent, Transparent);
		break;
	case 1 :
		//add legends on the top of the plot area (60, 28) using horizontal layout.
		//set the font to 8 points, and hide the legend box boundary (Transparent)
		c->addLegend(60, 28, false, 0, 8)->setBackground(Transparent, Transparent);
		
		//reserve 20 pixels at the top of the plot area to ensure the legend keys
		//will not overlap with the charts
		c->yAxis()->setTopMargin(20);
		break;
	default :
		//add legends on the bottom of the chart (60, 260) using horizontal layout.
		//set the font to 8 points, and hide the legend box boundary (Transparent)
		c->addLegend(60, 260, false, 0, 8)->setBackground(Transparent, Transparent);
	}
	
	//Add a title to the y-axis
	c->yAxis()->setTitle("Throughput (MBytes Per Hour)");

	//Set the labels on the x axis
	c->xAxis()->setLabels(sizeof(labels) / sizeof(labels[0]), labels);

	//Use non-indented x-axis layout
	c->xAxis()->setIndent(false);

	//Add 3 differnet layers using the given data sets
	c->addLineLayer(sizeof(data0) / sizeof(data0[0]), data0, 0x4040ff, "Server 1")->setLineWidth(3);
	c->addBarLayer(sizeof(data1) / sizeof(data1[0]), data1, 0xff8080, "Server 2")->set3D();
	c->addAreaLayer(sizeof(data2) / sizeof(data2[0]), data2, 0x80ff80, "Server 3")->set3D();

	//output the chart
	c->makeChart(filename);
	
	//destroy the chart to free up resources
	c->destroy();
}

int main(int argc, char *argv[])
{
	legendpos(0, "legendpos0.png");
	legendpos(1, "legendpos1.png");
	legendpos(2, "legendpos2.png");
	return 0;
}