/*
 * Copyright (C) 2001 Advanced Software Engineering Limited.
 *
 * This file is part of the ChartDirector software. Usage of this file is
 * subjected to the ChartDirector license agreement. See the LICENSE.TXT
 * file that comes with the ChartDirector software release, or visit
 * Advanced Software Engineering's web site at www.advsofteng.com or 
 * email to support@advsofteng.com for information.
 *
 */

#ifndef PIECHART_HDR
#define PIECHART_HDR


#include "basechart.h"


class Sector
{
public :
	virtual void setExplode(int distance = -1) = 0;
	virtual void setLabelFormat(const char *formatString) = 0;
	virtual TextBox *setLabelStyle(const char *font = 0, double fontSize = 8,
		int fontColor = TextColor) = 0;
	virtual void setLabelPos(int pos, int joinLineColor = Transparent) = 0;
};


class PieChart : virtual public BaseChart
{
public :
	__declspec(dllexport) static PieChart *create(int width, int height, int bgColor = BackgroundColor, 
		int edgeColor = Transparent);

	virtual void setPieSize(int x, int y, int r) = 0;
	virtual void set3D(int depth = -1, double angle = -1, bool shadowMode = false) = 0;

	virtual void setStartAngle(double startAngle, bool clockWise = true) = 0;
	virtual void setLabelFormat(const char *formatString) = 0;
	virtual TextBox *setLabelStyle(const char *font, double fontSize = 8, 
		int fontColor = TextColor) = 0;
	virtual void setLabelPos(int pos, int joinLineColor = Transparent) = 0;

	virtual void setData(int noOfPoints, const double *data, const char* const* labels = 0) = 0;
	virtual Sector *sector(int sectorNo) = 0;
};


#endif