<?php
include("phpchartdir.php");

#The data for the pie chart
$data = array( 25, 18, 15, 12, 30, 35 );

#The labels for the pie chart
$labels = array( "Labor", "Licenses", "Taxes", "Legal", 
	"Facilities", "Production" );

#First, create a PieChart of size 300 pixels x 300 pixels
$c = new PieChart(300, 300);

if ($HTTP_GET_VARS["img"] == "0") {

###################
#	Draw a pie chart where the label is on top of the pie
###################

	#the center of the pie at (150, 150) and the radius to 120 pixels
	$c->setPieSize(150, 150, 120);

	#the label position to -40 pixels from the perimeter of the pie.
	#A negative number means the label is inside the pie.
	$c->setLabelPos(-40);
	
} else {

###################
#	Draw a pie chart where the label is outside the pie
###################

	#the center of the pie at (150, 150) and the radius to 80 pixels
	$c->setPieSize(150, 150, 80);

	#the label position to be 25 pixels from the pie. A positive value
	#indicates the label is outside the pie. Furthermore, include a join line
	#to link the sector label with the pie.
	$c->setLabelPos(25, LineColor);
}


#Modify the label format to contain three lines showing the sector name,
#sector value, and the sector percentage. The sector value 99 is shown 
#as US$99K.
$c->setLabelFormat("&label&\nUS\$&value&K\n(&percent&%)");

#the pie data and the pie labels
$c->setData($data, $labels);
	
#Explode the 1st sector
$sectorObj = $c->sector(0);
$sectorObj->setExplode();

#output the chart
header("Content-type: image/png");
print($c->makeChart2(PNG));
?>
