// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"
#ifdef __BORLANDC__
    #pragma hdrstop
#endif

// for all others, include the necessary headers
 #ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif

#include "wx/stattext.h"
#include "wx/button.h"
#include "wx/bitmap.h"
#include "wx/statbox.h"
#include "wx/brush.h"
#include "wx/frame.h"
#include "wx/slider.h"
#include "wx/textctrl.h"
#include "colorchoose.h"
#include "wx/clipbrd.h"
#include "wx/colordlg.h"
#include "wx/defs.h"

//Stole a few needed macros from various headers within wxWindows
#define RGB(r,g,b) ((WXDWORD)((unsigned char)(b) | ((unsigned char)(g) << 8)) | ((unsigned char)(r) << 16))
#define MAX(a,b)    ((a) > (b) ? (a) : (b))
#define MIN(a,b)    ((a) < (b) ? (a) : (b))
// ----------------------------------------------------------------------------
// resources
// ----------------------------------------------------------------------------


// ----------------------------------------------------------------------------
// private classes
// ----------------------------------------------------------------------------
class MyText : public wxTextCtrl
{
public:
    MyText(wxWindow* parent, wxWindowID id, const wxString& value , const wxPoint& pos, const wxSize& size );
    void validate();
    void OnSetFocus(wxFocusEvent& event);
private:
    DECLARE_EVENT_TABLE()
};

BEGIN_EVENT_TABLE(MyText, wxTextCtrl)
    EVT_SET_FOCUS(MyText::OnSetFocus)
    EVT_KILL_FOCUS(MyText::validate)
END_EVENT_TABLE()

MyText::MyText(wxWindow* parent, wxWindowID id, const wxString& value , const wxPoint& pos, const wxSize& size )
: wxTextCtrl(parent, id, value , pos, size )
{
}

void MyText::validate()
{
    int n;
    wxString s;
    if(GetValue().IsNumber())
    {
        n=MIN(atoi(GetValue().c_str()),255);
    }
    else
        n=0;
    s.Printf("%d",n);
    SetValue(s);
}

void MyText::OnSetFocus(wxFocusEvent& event)
{

    SetSelection(0, GetLineLength( 0));
}

// Define a new application type, each program should derive a class from wxApp
class MyApp : public wxApp
{
public:
    // override base class virtuals
    // ----------------------------

    // this one is called on application startup and is a good place for the app
    // initialization (doing it here and not in the ctor allows to have an error
    // return: if OnInit() returns false, the application terminates)
    virtual bool OnInit();
};

// Define a new frame type: this is going to be our main frame
class MyFrame : public wxFrame
{
public:
    // ctor(s)
    MyFrame(const wxString& title, const wxPoint& pos, const wxSize& size);

    wxPanel * MyPanel;
   wxPanel* colorwindow;
   wxSlider* RedSlider;
   wxSlider* GreenSlider;
   wxSlider* BlueSlider;
   MyText* txtRed;
   MyText* txtGreen;
   MyText* txtBlue;
   wxButton* cmdEditColor;
   wxButton* cmdRGB;
   wxButton* cmdHTML;
   wxButton* cmdWxWin;
   wxTextCtrl* txtHexValue;
   wxStaticText* statictext14;
   wxStaticText* statictext1;
   wxStaticText* statictext2;
   wxStaticText* statictext3;
private:

    void txtchange();
    void colorwin();
    void Init();
    void clpbdhtml();
    void clpbdrgb();
    void clpbdwxcolor();
    void editcolor();
    DECLARE_EVENT_TABLE()

};

// ----------------------------------------------------------------------------
// constants
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// event tables and other macros for wxWindows
// ----------------------------------------------------------------------------

BEGIN_EVENT_TABLE(MyFrame, wxFrame)
    EVT_SLIDER(ID_GREENSLIDER, MyFrame::colorwin)
    EVT_SLIDER(ID_REDSLIDER, MyFrame::colorwin)
    EVT_SLIDER(ID_BLUESLIDER, MyFrame::colorwin)
    EVT_TEXT(ID_TXTRED, MyFrame::txtchange)
    EVT_TEXT(ID_TXTGREEN, MyFrame::txtchange)
    EVT_TEXT(ID_TXTBLUE, MyFrame::txtchange)
    EVT_BUTTON(ID_CMDHTML, MyFrame::clpbdhtml)
    EVT_BUTTON(ID_CMDRGB, MyFrame::clpbdrgb)
    EVT_BUTTON(ID_CMDWXWIN, MyFrame::clpbdwxcolor)
    EVT_BUTTON(ID_EDITCOLBUTTON, MyFrame::editcolor)
END_EVENT_TABLE()

IMPLEMENT_APP(MyApp)

// ----------------------------------------------------------------------------
// the application class
// ----------------------------------------------------------------------------

// 'Main program' equivalent: the program execution starts here
bool MyApp::OnInit()
{
    MyFrame* w= new MyFrame("Color Picker", wxPoint(0,0), wxSize( 469, 320) );
    w->Center();
    w->Show(TRUE);
    return TRUE;
}


MyFrame::MyFrame(const wxString& title, const wxPoint& pos, const wxSize& size)
       : wxFrame((wxFrame *)NULL, -1, title, pos, size,wxRAISED_BORDER | wxCAPTION | wxSYSTEM_MENU)
{
    MyPanel=new wxPanel(this, -1,wxPoint(0,0));
    colorwindow=new wxPanel(MyPanel, ID_COLORWINDOW, wxPoint(22,19), wxSize(153,149));

    RedSlider=new wxSlider(MyPanel,   ID_REDSLIDER,   0, 0, 255, wxPoint(22,190), wxSize(207,20), wxSL_HORIZONTAL);
    GreenSlider=new wxSlider(MyPanel, ID_GREENSLIDER, 0, 0, 255, wxPoint(22,224), wxSize(207,20), wxSL_HORIZONTAL);
    BlueSlider=new wxSlider(MyPanel,  ID_BLUESLIDER,  0, 0, 255, wxPoint(22,258), wxSize(207,20), wxSL_HORIZONTAL);

    txtRed=new MyText(MyPanel, ID_TXTRED, "", wxPoint(300,188), wxSize(42,24));
    txtGreen=new MyText(MyPanel, ID_TXTGREEN, "", wxPoint(300,222), wxSize(42,24));
    txtBlue=new MyText(MyPanel, ID_TXTBLUE, "", wxPoint(300,256), wxSize(42,24));

    cmdEditColor=new wxButton(MyPanel, ID_EDITCOLBUTTON, "Edit Color", wxPoint(182, 62), wxSize(80, 29));
    cmdRGB=new wxButton(MyPanel, ID_CMDRGB, "RGB Macro", wxPoint(300,23), wxSize(118,28));
    cmdHTML=new wxButton(MyPanel, ID_CMDHTML, "HTML Text", wxPoint(300,62), wxSize(118,28));
    cmdWxWin=new wxButton(MyPanel, ID_CMDWXWIN, "wxColor Macro", wxPoint(300,101), wxSize(118,28));
    txtHexValue=new wxTextCtrl(MyPanel, ID_TXTHEXVALUE, "", wxPoint(300,140), wxSize(120,24));
    statictext14=new wxStaticText(MyPanel, -1, "Hex Value", wxPoint(215,143), wxSize(62,16));
    statictext1=new wxStaticText(MyPanel, -1, "Red", wxPoint(245, 190), wxSize(26, 16));
    statictext2=new wxStaticText(MyPanel, -1, "Green", wxPoint(245, 224), wxSize(37, 16));
    statictext3=new wxStaticText(MyPanel, -1, "Blue", wxPoint(245, 258), wxSize(27, 16));
    Init();
}

void MyFrame::Init()
{
    colorwin();
}

void MyFrame::colorwin()
{
    int r,g,b;
    wxString s;
    r=RedSlider->GetValue();
    g=GreenSlider->GetValue();
    b=BlueSlider->GetValue();
    s.Printf("%d",r);
    txtRed->SetValue(s);
    s.Clear();
    s.Printf("%d",g);
    txtGreen->SetValue(s);
    s.Clear();
    s.Printf("%d",b);
    txtBlue->SetValue(s);
    colorwindow->SetBackgroundColour( wxColour(r,g,b));
    colorwindow->Refresh();
    s.Clear();
    s.Printf("%08X",RGB(r,g,b));

    txtHexValue->SetValue(s);
}

void MyFrame::txtchange()
{
    int r,g,b;
    wxString s;
    if(txtBlue->GetValue().IsNumber())
        b=MIN(atoi(txtBlue->GetValue().c_str()),255);
    if(txtRed->GetValue().IsNumber())
        r=MIN(atoi(txtRed->GetValue().c_str()),255);
    if(txtGreen->GetValue().IsNumber())
        g=MIN(atoi(txtGreen->GetValue().c_str()),255);
    RedSlider->SetValue(r);
    GreenSlider->SetValue(g);
    BlueSlider->SetValue(b);
    colorwindow->SetBackgroundColour( wxColour(r,g,b));
    colorwindow->Refresh();
    s.Clear();
    s.Printf("%08X",RGB(r,g,b));
    txtHexValue->SetValue(s);
}

void MyFrame::clpbdhtml()
{
    wxString s;

    s.Printf("\x22#%02X%02X%02X\x22",RedSlider->GetValue(),GreenSlider->GetValue(),BlueSlider->GetValue());
    if (wxOpenClipboard())
    {
        wxEmptyClipboard();
        wxSetClipboardData(wxDF_TEXT,s.c_str(),0,0);
        wxCloseClipboard();
    }
}

void MyFrame::clpbdrgb()
{
    wxString s;

    s.Printf("RGB(%d,%d,%d)",RedSlider->GetValue(),GreenSlider->GetValue(),BlueSlider->GetValue());
    if (wxOpenClipboard())
    {
        wxEmptyClipboard();
        wxSetClipboardData(wxDF_TEXT,s.c_str(),0,0);
        wxCloseClipboard();
    }
}

void MyFrame::clpbdwxcolor()
{
    wxString s;

    s.Printf("wxColor(%d,%d,%d)",RedSlider->GetValue(),GreenSlider->GetValue(),BlueSlider->GetValue());
    if (wxOpenClipboard())
    {
        wxEmptyClipboard();
        wxSetClipboardData(wxDF_TEXT,s.c_str(),0,0);
        wxCloseClipboard();
    }
}

void MyFrame::editcolor()
{
    wxColour c;
    c=wxGetColourFromUser(this, colorwindow->GetBackgroundColour());
    if(c.Ok())
    {
        RedSlider->SetValue(c.Red());
        GreenSlider->SetValue((int)c.Green());
        BlueSlider->SetValue((int)c.Blue());
        colorwin();
    }
}