#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <libp.h>

int fgetpos(FILE *stream, fpos_t *curpos)
{
	if (stream->token == FILTOK) {
		*curpos = _ll_getpos(stream->fd);
		if (*curpos < 0) {
			stream->flags |= _F_ERR;
			errno = EIO;
			return EOF;
		}
		if (stream->level > 0 && stream->buffer)
			*curpos -= stream->level;
		else			
			if (stream->level < 0 && stream->buffer)
				*curpos += stream->bsize + stream->level;
		return 0;
	}
	_dos_errno = errno = ENOENT;
	return EOF;
}