#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <libp.h>

size_t fread(void *buf, size_t size, size_t count, FILE *stream)
{
	int rv;
	int len = count * size,i;
	char *lbuf = buf;
	if (stream->token != FILTOK) {
		errno = _dos_errno = ENOENT;
		return 0;
	}
	if (!(stream->flags & _F_READ)) {
		stream->flags |= _F_ERR;
		errno = ENOENT;
		return 0;
	}
	for (i=0; i < len; i++) {
		rv = getc(stream);
		if (rv == EOF)
			return i / size;
		*lbuf++ = (char) rv;
	}
	return count;
}