/*
 * defines for memory addresses
 */

BOTTOMOFRAM = $4000
BOTTOMOFROM = $18000000

/*
 * Pull out the virtual tags if you build for absolute addresses
 */
partition {
	overlay {
		DATASTART = $;
		region {} data;
		DATAEND = $
	} RAM;
} p2 [addr = BOTTOMOFRAM, virtual];

partition {
	overlay {
		BSSSTART = $;
		region {} bss;
		BSSEND = $;
		region {} stack[size = 4096,align = 4];
		STACKTOP = $;
	} BSS;
} p1 [virtual = BOTTOMOFRAM];
partition {
	overlay {
		CODESTART = $;
		region {} boot;
		STARTUP = $;
		region {} cstartup;
		ENDSTARTUP = $;
		RUNDOWN = $;
		region {} crundown;
		ENDRUNDOWN = $;
		STARTCODEFIX = $;
		region {} codefix;
		ENDCODEFIX = $;
		STARTDATAFIX = $;       
		region {} datafix;
		ENDDATAFIX = $;
		CPPSTART = $;
		region {} cppinit;
		CPPEND = $;
		region {} code;
		CODEND = $;
	} ROM;
	IMAGELEN = CODEND-CODESTART+DATAEND - DATASTART;
} p [addr=BOTTOMOFROM];