/* 
   UnicodeFunctions.h

   Declarations for all the Windows32 API Unicode Functions

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Date: 1996
   
   This file is part of the Windows32 API Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   If you are interested in a warranty or support for this source code,
   contact Scott Christley <scottc@net-community.com> for more information.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation, 
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef _GNU_H_WINDOWS32_UNICODEFUNCTIONS
#define _GNU_H_WINDOWS32_UNICODEFUNCTIONS


#ifndef	RC_INVOKED

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

extern WINBOOL
 PASCAL GetBinaryTypeW(
    LPCWSTR lpApplicationName,
    LPDWORD lpBinaryType
    );

extern DWORD
 PASCAL GetShortPathNameW(
    LPCWSTR lpszLongPath,
    LPWSTR  lpszShortPath,
    DWORD    cchBuffer
    );

extern LPWSTR
 PASCAL GetEnvironmentStringsW(
    VOID
    );

extern WINBOOL
 PASCAL FreeEnvironmentStringsW(
    LPWSTR
    );

extern DWORD
 PASCAL FormatMessageW(
    DWORD dwFlags,
    LPCVOID lpSource,
    DWORD dwMessageId,
    DWORD dwLanguageId,
    LPWSTR lpBuffer,
    DWORD nSize,
    va_list *Arguments
    );

extern HANDLE
 PASCAL CreateMailslotW(
    LPCWSTR lpName,
    DWORD nMaxMessageSize,
    DWORD lReadTimeout,
    LPSECURITY_ATTRIBUTES lpSecurityAttributes
    );

extern int
 PASCAL lstrcmpW(
    LPCWSTR lpString1,
    LPCWSTR lpString2
    );

extern int
 PASCAL lstrcmpiW(
    LPCWSTR lpString1,
    LPCWSTR lpString2
    );

extern LPWSTR
 PASCAL lstrcpynW(
    LPWSTR lpString1,
    LPCWSTR lpString2,
    int iMaxLength
    );

extern LPWSTR
 PASCAL lstrcpyW(
    LPWSTR lpString1,
    LPCWSTR lpString2
    );

extern LPWSTR
 PASCAL lstrcatW(
    LPWSTR lpString1,
    LPCWSTR lpString2
    );

extern int
 PASCAL lstrlenW(
    LPCWSTR lpString
    );

extern HANDLE
 PASCAL CreateMutexW(
    LPSECURITY_ATTRIBUTES lpMutexAttributes,
    WINBOOL bInitialOwner,
    LPCWSTR lpName
    );

extern HANDLE
 PASCAL OpenMutexW(
    DWORD dwDesiredAccess,
    WINBOOL bInheritHandle,
    LPCWSTR lpName
    );

extern HANDLE
 PASCAL CreateEventW(
    LPSECURITY_ATTRIBUTES lpEventAttributes,
    WINBOOL bManualReset,
    WINBOOL bInitialState,
    LPCWSTR lpName
    );

extern HANDLE
 PASCAL OpenEventW(
    DWORD dwDesiredAccess,
    WINBOOL bInheritHandle,
    LPCWSTR lpName
    );

extern HANDLE
 PASCAL CreateSemaphoreW(
		 LPSECURITY_ATTRIBUTES lpSemaphoreAttributes,
		 LONG lInitialCount,
		 LONG lMaximumCount,
		 LPCWSTR lpName
		 );

extern HANDLE
 PASCAL OpenSemaphoreW(
    DWORD dwDesiredAccess,
    WINBOOL bInheritHandle,
    LPCWSTR lpName
    );

extern HANDLE
 PASCAL CreateFileMappingW(
    HANDLE hFile,
    LPSECURITY_ATTRIBUTES lpFileMappingAttributes,
    DWORD flProtect,
    DWORD dwMaximumSizeHigh,
    DWORD dwMaximumSizeLow,
    LPCWSTR lpName
    );

extern HANDLE
 PASCAL OpenFileMappingW(
    DWORD dwDesiredAccess,
    WINBOOL bInheritHandle,
    LPCWSTR lpName
    );

extern DWORD
 PASCAL GetLogicalDriveStringsW(
    DWORD nBufferLength,
    LPWSTR lpBuffer
    );

extern HINSTANCE
 PASCAL LoadLibraryW(
    LPCWSTR lpLibFileName
    );

extern HINSTANCE
 PASCAL LoadLibraryExW(
    LPCWSTR lpLibFileName,
    HANDLE hFile,
    DWORD dwFlags
    );

extern DWORD
 PASCAL GetModuleFileNameW(
    HINSTANCE hModule,
    LPWSTR lpFilename,
    DWORD nSize
    );

extern HMODULE
 PASCAL GetModuleHandleW(
    LPCWSTR lpModuleName
    );

extern VOID
 PASCAL FatalAppExitW(
    UINT uAction,
    LPCWSTR lpMessageText
    );

extern LPWSTR
 PASCAL GetCommandLineW(
    VOID
    );

extern DWORD
 PASCAL GetEnvironmentVariableW(
    LPCWSTR lpName,
    LPWSTR lpBuffer,
    DWORD nSize
    );

extern WINBOOL
 PASCAL SetEnvironmentVariableW(
    LPCWSTR lpName,
    LPCWSTR lpValue
    );

extern DWORD
 PASCAL ExpandEnvironmentStringsW(
    LPCWSTR lpSrc,
    LPWSTR lpDst,
    DWORD nSize
    );

extern VOID
 PASCAL OutputDebugStringW(
    LPCWSTR lpOutputString
    );

extern HRSRC
 PASCAL FindResourceW(
    HINSTANCE hModule,
    LPCWSTR lpName,
    LPCWSTR lpType
    );

extern HRSRC
 PASCAL FindResourceExW(
    HINSTANCE hModule,
    LPCWSTR lpType,
    LPCWSTR lpName,
    WORD    wLanguage
    );

extern WINBOOL
 PASCAL EnumResourceTypesW(
    HINSTANCE hModule,
    ENUMRESTYPEPROC lpEnumFunc,
    LONG lParam
    );

extern WINBOOL
 PASCAL EnumResourceNamesW(
    HINSTANCE hModule,
    LPCWSTR lpType,
    ENUMRESNAMEPROC lpEnumFunc,
    LONG lParam
    );

extern WINBOOL
 PASCAL EnumResourceLanguagesW(
    HINSTANCE hModule,
    LPCWSTR lpType,
    LPCWSTR lpName,
    ENUMRESLANGPROC lpEnumFunc,
    LONG lParam
    );

extern HANDLE
 PASCAL BeginUpdateResourceW(
    LPCWSTR pFileName,
    WINBOOL bDeleteExistingResources
    );

extern WINBOOL
 PASCAL UpdateResourceW(
    HANDLE      hUpdate,
    LPCWSTR     lpType,
    LPCWSTR     lpName,
    WORD        wLanguage,
    LPVOID      lpData,
    DWORD       cbData
    );

extern WINBOOL
 PASCAL EndUpdateResourceW(
    HANDLE      hUpdate,
    WINBOOL        fDiscard
    );

extern ATOM
 PASCAL GlobalAddAtomW(
    LPCWSTR lpString
    );

extern ATOM
 PASCAL GlobalFindAtomW(
    LPCWSTR lpString
    );

extern UINT
 PASCAL GlobalGetAtomNameW(
    ATOM nAtom,
    LPWSTR lpBuffer,
    int nSize
    );

extern ATOM
 PASCAL AddAtomW(
    LPCWSTR lpString
    );

extern ATOM
 PASCAL FindAtomW(
    LPCWSTR lpString
    );

extern UINT
 PASCAL GetAtomNameW(
    ATOM nAtom,
    LPWSTR lpBuffer,
    int nSize
    );

extern UINT
 PASCAL GetProfileIntW(
    LPCWSTR lpAppName,
    LPCWSTR lpKeyName,
    INT nDefault
    );

extern DWORD
 PASCAL GetProfileStringW(
    LPCWSTR lpAppName,
    LPCWSTR lpKeyName,
    LPCWSTR lpDefault,
    LPWSTR lpReturnedString,
    DWORD nSize
    );

extern WINBOOL
 PASCAL WriteProfileStringW(
    LPCWSTR lpAppName,
    LPCWSTR lpKeyName,
    LPCWSTR lpString
    );

extern DWORD
 PASCAL GetProfileSectionW(
    LPCWSTR lpAppName,
    LPWSTR lpReturnedString,
    DWORD nSize
    );

extern WINBOOL
 PASCAL WriteProfileSectionW(
    LPCWSTR lpAppName,
    LPCWSTR lpString
    );

extern UINT
 PASCAL GetPrivateProfileIntW(
    LPCWSTR lpAppName,
    LPCWSTR lpKeyName,
    INT nDefault,
    LPCWSTR lpFileName
    );

extern DWORD
 PASCAL GetPrivateProfileStringW(
    LPCWSTR lpAppName,
    LPCWSTR lpKeyName,
    LPCWSTR lpDefault,
    LPWSTR lpReturnedString,
    DWORD nSize,
    LPCWSTR lpFileName
    );

extern WINBOOL
 PASCAL WritePrivateProfileStringW(
    LPCWSTR lpAppName,
    LPCWSTR lpKeyName,
    LPCWSTR lpString,
    LPCWSTR lpFileName
    );

extern DWORD
 PASCAL GetPrivateProfileSectionW(
    LPCWSTR lpAppName,
    LPWSTR lpReturnedString,
    DWORD nSize,
    LPCWSTR lpFileName
    );

extern WINBOOL
 PASCAL WritePrivateProfileSectionW(
    LPCWSTR lpAppName,
    LPCWSTR lpString,
    LPCWSTR lpFileName
    );

extern UINT
 PASCAL GetDriveTypeW(
    LPCWSTR lpRootPathName
    );

extern UINT
 PASCAL GetSystemDirectoryW(
    LPWSTR lpBuffer,
    UINT uSize
    );

extern DWORD
 PASCAL GetTempPathW(
    DWORD nBufferLength,
    LPWSTR lpBuffer
    );

extern UINT
 PASCAL GetTempFileNameW(
    LPCWSTR lpPathName,
    LPCWSTR lpPrefixString,
    UINT uUnique,
    LPWSTR lpTempFileName
    );

extern UINT
 PASCAL GetWindowsDirectoryW(
    LPWSTR lpBuffer,
    UINT uSize
    );

extern WINBOOL
 PASCAL SetCurrentDirectoryW(
    LPCWSTR lpPathName
    );

extern DWORD
 PASCAL GetCurrentDirectoryW(
    DWORD nBufferLength,
    LPWSTR lpBuffer
    );

extern WINBOOL
 PASCAL GetDiskFreeSpaceW(
    LPCWSTR lpRootPathName,
    LPDWORD lpSectorsPerCluster,
    LPDWORD lpBytesPerSector,
    LPDWORD lpNumberOfFreeClusters,
    LPDWORD lpTotalNumberOfClusters
    );

extern WINBOOL
 PASCAL CreateDirectoryW(
    LPCWSTR lpPathName,
    LPSECURITY_ATTRIBUTES lpSecurityAttributes
    );

extern WINBOOL
 PASCAL CreateDirectoryExW(
    LPCWSTR lpTemplateDirectory,
    LPCWSTR lpNewDirectory,
    LPSECURITY_ATTRIBUTES lpSecurityAttributes
    );

extern WINBOOL
 PASCAL RemoveDirectoryW(
    LPCWSTR lpPathName
    );

extern DWORD
 PASCAL GetFullPathNameW(
    LPCWSTR lpFileName,
    DWORD nBufferLength,
    LPWSTR lpBuffer,
    LPWSTR *lpFilePart
    );

extern WINBOOL
 PASCAL DefineDosDeviceW(
    DWORD dwFlags,
    LPCWSTR lpDeviceName,
    LPCWSTR lpTargetPath
    );

extern DWORD
 PASCAL QueryDosDeviceW(
    LPCWSTR lpDeviceName,
    LPWSTR lpTargetPath,
    DWORD ucchMax
    );

extern HANDLE
 PASCAL CreateFileW(
    LPCWSTR lpFileName,
    DWORD dwDesiredAccess,
    DWORD dwShareMode,
    LPSECURITY_ATTRIBUTES lpSecurityAttributes,
    DWORD dwCreationDisposition,
    DWORD dwFlagsAndAttributes,
    HANDLE hTemplateFile
    );

extern WINBOOL
 PASCAL SetFileAttributesW(
    LPCWSTR lpFileName,
    DWORD dwFileAttributes
    );

extern DWORD
 PASCAL GetFileAttributesW(
    LPCWSTR lpFileName
    );

extern DWORD
 PASCAL GetCompressedFileSizeW(
    LPCWSTR lpFileName,
    LPDWORD lpFileSizeHigh
    );

extern WINBOOL
 PASCAL DeleteFileW(
    LPCWSTR lpFileName
    );

extern DWORD
 PASCAL SearchPathW(
    LPCWSTR lpPath,
    LPCWSTR lpFileName,
    LPCWSTR lpExtension,
    DWORD nBufferLength,
    LPWSTR lpBuffer,
    LPWSTR *lpFilePart
    );

extern WINBOOL
 PASCAL CopyFileW(
    LPCWSTR lpExistingFileName,
    LPCWSTR lpNewFileName,
    WINBOOL bFailIfExists
    );

extern WINBOOL
 PASCAL MoveFileW(
    LPCWSTR lpExistingFileName,
    LPCWSTR lpNewFileName
    );

extern WINBOOL
 PASCAL MoveFileExW(
    LPCWSTR lpExistingFileName,
    LPCWSTR lpNewFileName,
    DWORD dwFlags
    );

extern HANDLE
 PASCAL CreateNamedPipeW(
    LPCWSTR lpName,
    DWORD dwOpenMode,
    DWORD dwPipeMode,
    DWORD nMaxInstances,
    DWORD nOutBufferSize,
    DWORD nInBufferSize,
    DWORD nDefaultTimeOut,
    LPSECURITY_ATTRIBUTES lpSecurityAttributes
    );

extern WINBOOL
 PASCAL GetNamedPipeHandleStateW(
    HANDLE hNamedPipe,
    LPDWORD lpState,
    LPDWORD lpCurInstances,
    LPDWORD lpMaxCollectionCount,
    LPDWORD lpCollectDataTimeout,
    LPWSTR lpUserName,
    DWORD nMaxUserNameSize
    );

extern WINBOOL
 PASCAL CallNamedPipeW(
    LPCWSTR lpNamedPipeName,
    LPVOID lpInBuffer,
    DWORD nInBufferSize,
    LPVOID lpOutBuffer,
    DWORD nOutBufferSize,
    LPDWORD lpBytesRead,
    DWORD nTimeOut
    );

extern WINBOOL
 PASCAL WaitNamedPipeW(
    LPCWSTR lpNamedPipeName,
    DWORD nTimeOut
    );

extern WINBOOL
 PASCAL SetVolumeLabelW(
    LPCWSTR lpRootPathName,
    LPCWSTR lpVolumeName
    );

extern WINBOOL
 PASCAL GetVolumeInformationW(
    LPCWSTR lpRootPathName,
    LPWSTR lpVolumeNameBuffer,
    DWORD nVolumeNameSize,
    LPDWORD lpVolumeSerialNumber,
    LPDWORD lpMaximumComponentLength,
    LPDWORD lpFileSystemFlags,
    LPWSTR lpFileSystemNameBuffer,
    DWORD nFileSystemNameSize
    );

extern WINBOOL
 PASCAL ClearEventLogW(
    HANDLE hEventLog,
    LPCWSTR lpBackupFileName
    );

extern WINBOOL
 PASCAL BackupEventLogW(
    HANDLE hEventLog,
    LPCWSTR lpBackupFileName
    );

extern HANDLE
 PASCAL OpenEventLogW(
    LPCWSTR lpUNCServerName,
    LPCWSTR lpSourceName
    );

extern HANDLE
 PASCAL RegisterEventSourceW(
    LPCWSTR lpUNCServerName,
    LPCWSTR lpSourceName
    );

extern HANDLE
 PASCAL OpenBackupEventLogW(
    LPCWSTR lpUNCServerName,
    LPCWSTR lpFileName
    );

extern WINBOOL
 PASCAL ReadEventLogW(
     HANDLE     hEventLog,
     DWORD      dwReadFlags,
     DWORD      dwRecordOffset,
     LPVOID     lpBuffer,
     DWORD      nNumberOfBytesToRead,
     DWORD      *pnBytesRead,
     DWORD      *pnMinNumberOfBytesNeeded
    );

extern WINBOOL
 PASCAL ReportEventW(
     HANDLE     hEventLog,
     WORD       wType,
     WORD       wCategory,
     DWORD      dwEventID,
     PSID       lpUserSid,
     WORD       wNumStrings,
     DWORD      dwDataSize,
     LPCWSTR   *lpStrings,
     LPVOID     lpRawData
    );

extern WINBOOL
 PASCAL AccessCheckAndAuditAlarmW(
    LPCWSTR SubsystemName,
    LPVOID HandleId,
    LPWSTR ObjectTypeName,
    LPWSTR ObjectName,
    PSECURITY_DESCRIPTOR SecurityDescriptor,
    DWORD DesiredAccess,
    PGENERIC_MAPPING GenericMapping,
    WINBOOL ObjectCreation,
    LPDWORD GrantedAccess,
    LPBOOL AccessStatus,
    LPBOOL pfGenerateOnClose
    );

extern WINBOOL
 PASCAL ObjectOpenAuditAlarmW(
    LPCWSTR SubsystemName,
    LPVOID HandleId,
    LPWSTR ObjectTypeName,
    LPWSTR ObjectName,
    PSECURITY_DESCRIPTOR pSecurityDescriptor,
    HANDLE ClientToken,
    DWORD DesiredAccess,
    DWORD GrantedAccess,
    PPRIVILEGE_SET Privileges,
    WINBOOL ObjectCreation,
    WINBOOL AccessGranted,
    LPBOOL GenerateOnClose
    );

extern WINBOOL
 PASCAL ObjectPrivilegeAuditAlarmW(
    LPCWSTR SubsystemName,
    LPVOID HandleId,
    HANDLE ClientToken,
    DWORD DesiredAccess,
    PPRIVILEGE_SET Privileges,
    WINBOOL AccessGranted
    );

extern WINBOOL
 PASCAL ObjectCloseAuditAlarmW(
    LPCWSTR SubsystemName,
    LPVOID HandleId,
    WINBOOL GenerateOnClose
    );

extern WINBOOL
 PASCAL PrivilegedServiceAuditAlarmW(
    LPCWSTR SubsystemName,
    LPCWSTR ServiceName,
    HANDLE ClientToken,
    PPRIVILEGE_SET Privileges,
    WINBOOL AccessGranted
    );

extern WINBOOL
 PASCAL SetFileSecurityW(
    LPCWSTR lpFileName,
    SECURITY_INFORMATION SecurityInformation,
    PSECURITY_DESCRIPTOR pSecurityDescriptor
    );

extern WINBOOL
 PASCAL GetFileSecurityW(
    LPCWSTR lpFileName,
    SECURITY_INFORMATION RequestedInformation,
    PSECURITY_DESCRIPTOR pSecurityDescriptor,
    DWORD nLength,
    LPDWORD lpnLengthNeeded
    );

extern HANDLE
 PASCAL FindFirstChangeNotificationW(
    LPCWSTR lpPathName,
    WINBOOL bWatchSubtree,
    DWORD dwNotifyFilter
    );

extern WINBOOL
 PASCAL IsBadStringPtrW(
    LPCWSTR lpsz,
    UINT ucchMax
    );

extern WINBOOL
 PASCAL LookupAccountSidW(
    LPCWSTR lpSystemName,
    PSID Sid,
    LPWSTR Name,
    LPDWORD cbName,
    LPWSTR ReferencedDomainName,
    LPDWORD cbReferencedDomainName,
    PSID_NAME_USE peUse
    );

extern WINBOOL
 PASCAL LookupAccountNameW(
    LPCWSTR lpSystemName,
    LPCWSTR lpAccountName,
    PSID Sid,
    LPDWORD cbSid,
    LPWSTR ReferencedDomainName,
    LPDWORD cbReferencedDomainName,
    PSID_NAME_USE peUse
    );

extern WINBOOL
 PASCAL LookupPrivilegeValueW(
    LPCWSTR lpSystemName,
    LPCWSTR lpName,
    PLUID   lpLuid
    );

extern WINBOOL
 PASCAL LookupPrivilegeNameW(
    LPCWSTR lpSystemName,
    PLUID   lpLuid,
    LPWSTR lpName,
    LPDWORD cbName
    );

extern WINBOOL
 PASCAL LookupPrivilegeDisplayNameW(
    LPCWSTR lpSystemName,
    LPCWSTR lpName,
    LPWSTR lpDisplayName,
    LPDWORD cbDisplayName,
    LPDWORD lpLanguageId
    );

extern WINBOOL
 PASCAL BuildCommDCBW(
    LPCWSTR lpDef,
    LPDCB lpDCB
    );

extern WINBOOL
 PASCAL BuildCommDCBAndTimeoutsW(
    LPCWSTR lpDef,
    LPDCB lpDCB,
    LPCOMMTIMEOUTS lpCommTimeouts
    );

extern WINBOOL
 PASCAL CommConfigDialogW(
    LPCWSTR lpszName,
    HWND hWnd,
    LPCOMMCONFIG lpCC
    );

extern WINBOOL
 PASCAL GetDefaultCommConfigW(
    LPCWSTR lpszName,
    LPCOMMCONFIG lpCC,
    LPDWORD lpdwSize
    );

extern WINBOOL
 PASCAL SetDefaultCommConfigW(
    LPCWSTR lpszName,
    LPCOMMCONFIG lpCC,
    DWORD dwSize
    );

extern WINBOOL
 PASCAL GetComputerNameW(
    LPWSTR lpBuffer,
    LPDWORD nSize
    );

extern WINBOOL
 PASCAL SetComputerNameW(
    LPCWSTR lpComputerName
    );

extern WINBOOL
 PASCAL GetUserNameW(
    LPWSTR lpBuffer,
    LPDWORD nSize
    );

extern int
 PASCAL wvsprintfW(
    LPWSTR,
    LPCWSTR,
    va_list arglist);

extern int
wsprintfW(LPWSTR, LPCWSTR, ...);

extern HKL
 PASCAL LoadKeyboardLayoutW(
    LPCWSTR pwszKLID,
    UINT Flags);

extern WINBOOL
 PASCAL GetKeyboardLayoutNameW(
    LPWSTR pwszKLID);

extern HDESK
 PASCAL CreateDesktopW(
    LPWSTR lpszDesktop,
    LPWSTR lpszDevice,
    LPDEVMODE pDevmode,
    DWORD dwFlags,
    DWORD dwDesiredAccess,
    LPSECURITY_ATTRIBUTES lpsa);

extern HDESK
 PASCAL OpenDesktopW(
    LPWSTR lpszDesktop,
    DWORD dwFlags,
    WINBOOL fInherit,
    DWORD dwDesiredAccess);

extern WINBOOL
 PASCAL EnumDesktopsW(
    HWINSTA hwinsta,
    DESKTOPENUMPROC lpEnumFunc,
    LPARAM lParam);

extern HWINSTA
 PASCAL CreateWindowStationW(
    LPWSTR lpwinsta,
    DWORD dwReserved,
    DWORD dwDesiredAccess,
    LPSECURITY_ATTRIBUTES lpsa);

extern HWINSTA
 PASCAL OpenWindowStationW(
    LPWSTR lpszWinSta,
    WINBOOL fInherit,
    DWORD dwDesiredAccess);

extern WINBOOL
 PASCAL EnumWindowStationsW(
    ENUMWINDOWSTATIONPROC lpEnumFunc,
    LPARAM lParam);

extern WINBOOL
 PASCAL GetUserObjectInformationW(
    HANDLE hObj,
    int nIndex,
    PVOID pvInfo,
    DWORD nLength,
    LPDWORD lpnLengthNeeded);

extern WINBOOL
 PASCAL SetUserObjectInformationW(
    HANDLE hObj,
    int nIndex,
    PVOID pvInfo,
    DWORD nLength);

extern UINT
 PASCAL RegisterWindowMessageW(
    LPCWSTR lpString);

extern WINBOOL
 PASCAL GetMessageW(
    LPMSG lpMsg,
    HWND hWnd ,
    UINT wMsgFilterMin,
    UINT wMsgFilterMax);

extern LONG
 PASCAL DispatchMessageW(
    CONST MSG *lpMsg);

extern WINBOOL
 PASCAL PeekMessageW(
    LPMSG lpMsg,
    HWND hWnd ,
    UINT wMsgFilterMin,
    UINT wMsgFilterMax,
    UINT wRemoveMsg);

extern LRESULT
 PASCAL SendMessageW(
    HWND hWnd,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam);

extern LRESULT
 PASCAL SendMessageTimeoutW(
    HWND hWnd,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam,
    UINT fuFlags,
    UINT uTimeout,
    LPDWORD lpdwResult);

extern WINBOOL
 PASCAL SendNotifyMessageW(
    HWND hWnd,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam);

extern WINBOOL
 PASCAL SendMessageCallbackW(
    HWND hWnd,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam,
    SENDASYNCPROC lpResultCallBack,
    DWORD dwData);

extern WINBOOL
 PASCAL PostMessageW(
    HWND hWnd,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam);

extern WINBOOL
 PASCAL PostThreadMessageW(
    DWORD idThread,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam);

extern LRESULT
 PASCAL DefWindowProcW(
    HWND hWnd,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam);

extern LRESULT
 PASCAL CallWindowProcW(
    WNDPROC lpPrevWndFunc,
    HWND hWnd,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam);

extern ATOM
 PASCAL RegisterClassW(
    CONST WNDCLASS *lpWndClass);

extern WINBOOL
 PASCAL UnregisterClassW(
    LPCWSTR lpClassName,
    HINSTANCE hInstance);

extern WINBOOL
 PASCAL GetClassInfoW(
    HINSTANCE hInstance ,
    LPCWSTR lpClassName,
    LPWNDCLASS lpWndClass);

extern ATOM
 PASCAL RegisterClassExW(CONST WNDCLASSEX *);

extern WINBOOL
 PASCAL GetClassInfoExW(HINSTANCE, LPCWSTR, LPWNDCLASSEX);

extern HWND
 PASCAL CreateWindowExW(
    DWORD dwExStyle,
    LPCWSTR lpClassName,
    LPCWSTR lpWindowName,
    DWORD dwStyle,
    int X,
    int Y,
    int nWidth,
    int nHeight,
    HWND hWndParent ,
    HMENU hMenu,
    HINSTANCE hInstance,
    LPVOID lpParam);

extern HWND
 PASCAL CreateDialogParamW(
    HINSTANCE hInstance,
    LPCWSTR lpTemplateName,
    HWND hWndParent ,
    DLGPROC lpDialogFunc,
    LPARAM dwInitParam);

extern HWND
 PASCAL CreateDialogIndirectParamW(
    HINSTANCE hInstance,
    LPCDLGTEMPLATE lpTemplate,
    HWND hWndParent,
    DLGPROC lpDialogFunc,
    LPARAM dwInitParam);

extern int
 PASCAL DialogBoxParamW(
    HINSTANCE hInstance,
    LPCWSTR lpTemplateName,
    HWND hWndParent ,
    DLGPROC lpDialogFunc,
    LPARAM dwInitParam);

extern int
 PASCAL DialogBoxIndirectParamW(
    HINSTANCE hInstance,
    LPCDLGTEMPLATE hDialogTemplate,
    HWND hWndParent ,
    DLGPROC lpDialogFunc,
    LPARAM dwInitParam);

extern WINBOOL
 PASCAL SetDlgItemTextW(
    HWND hDlg,
    int nIDDlgItem,
    LPCWSTR lpString);

extern UINT
 PASCAL GetDlgItemTextW(
    HWND hDlg,
    int nIDDlgItem,
    LPWSTR lpString,
    int nMaxCount);

extern LONG
 PASCAL SendDlgItemMessageW(
    HWND hDlg,
    int nIDDlgItem,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam);

extern LRESULT
 PASCAL DefDlgProcW(
    HWND hDlg,
    UINT Msg,
    WPARAM wParam,
    LPARAM lParam);

extern WINBOOL
 PASCAL CallMsgFilterW(
    LPMSG lpMsg,
    int nCode);

extern UINT
 PASCAL RegisterClipboardFormatW(
    LPCWSTR lpszFormat);

extern int
 PASCAL GetClipboardFormatNameW(
    UINT format,
    LPWSTR lpszFormatName,
    int cchMaxCount);

extern WINBOOL
 PASCAL CharToOemW(
    LPCWSTR lpszSrc,
    LPSTR lpszDst);

extern WINBOOL
 PASCAL OemToCharW(
    LPCSTR lpszSrc,
    LPWSTR lpszDst);

extern WINBOOL
 PASCAL CharToOemBuffW(
    LPCWSTR lpszSrc,
    LPSTR lpszDst,
    DWORD cchDstLength);

extern WINBOOL
 PASCAL OemToCharBuffW(
    LPCSTR lpszSrc,
    LPWSTR lpszDst,
    DWORD cchDstLength);

extern LPWSTR
 PASCAL CharUpperW(
    LPWSTR lpsz);

extern DWORD
 PASCAL CharUpperBuffW(
    LPWSTR lpsz,
    DWORD cchLength);

extern LPWSTR
 PASCAL CharLowerW(
    LPWSTR lpsz);

extern DWORD
 PASCAL CharLowerBuffW(
    LPWSTR lpsz,
    DWORD cchLength);

extern LPWSTR
 PASCAL CharNextW(
    LPCWSTR lpsz);

extern LPWSTR
 PASCAL CharPrevW(
    LPCWSTR lpszStart,
    LPCWSTR lpszCurrent);

extern WINBOOL
 PASCAL IsCharAlphaW(
    WCHAR ch);

extern WINBOOL
 PASCAL IsCharAlphaNumericW(
    WCHAR ch);

extern WINBOOL
 PASCAL IsCharUpperW(
    WCHAR ch);

extern WINBOOL
 PASCAL IsCharLowerW(
    WCHAR ch);

extern int
 PASCAL GetKeyNameTextW(
    LONG lParam,
    LPWSTR lpString,
    int nSize
    );

extern SHORT
 PASCAL VkKeyScanW(
    WCHAR ch);

extern SHORT
 PASCAL VkKeyScanExW(
    WCHAR  ch,
    HKL   dwhkl);

extern UINT
 PASCAL MapVirtualKeyW(
    UINT uCode,
    UINT uMapType);

extern UINT
 PASCAL MapVirtualKeyExW(
    UINT uCode,
    UINT uMapType,
    HKL dwhkl);

extern HACCEL
 PASCAL LoadAcceleratorsW(
    HINSTANCE hInstance,
    LPCWSTR lpTableName);

extern HACCEL
 PASCAL CreateAcceleratorTableW(
    LPACCEL, int);

extern int
 PASCAL CopyAcceleratorTableW(
    HACCEL hAccelSrc,
    LPACCEL lpAccelDst,
    int cAccelEntries);

extern int
 PASCAL TranslateAcceleratorW(
    HWND hWnd,
    HACCEL hAccTable,
    LPMSG lpMsg);

extern HMENU
 PASCAL LoadMenuW(
    HINSTANCE hInstance,
    LPCWSTR lpMenuName);

extern HMENU
 PASCAL LoadMenuIndirectW(
    CONST MENUTEMPLATE *lpMenuTemplate);

extern WINBOOL
 PASCAL ChangeMenuW(
    HMENU hMenu,
    UINT cmd,
    LPCWSTR lpszNewItem,
    UINT cmdInsert,
    UINT flags);

extern int
 PASCAL GetMenuStringW(
    HMENU hMenu,
    UINT uIDItem,
    LPWSTR lpString,
    int nMaxCount,
    UINT uFlag);

extern WINBOOL
 PASCAL InsertMenuW(
    HMENU hMenu,
    UINT uPosition,
    UINT uFlags,
    UINT uIDNewItem,
    LPCWSTR lpNewItem
    );

extern WINBOOL
 PASCAL AppendMenuW(
    HMENU hMenu,
    UINT uFlags,
    UINT uIDNewItem,
    LPCWSTR lpNewItem
    );

extern WINBOOL
 PASCAL ModifyMenuW(
    HMENU hMnu,
    UINT uPosition,
    UINT uFlags,
    UINT uIDNewItem,
    LPCWSTR lpNewItem
    );

extern WINBOOL
 PASCAL InsertMenuItemW(
    HMENU,
    UINT,
    WINBOOL,
    LPCMENUITEMINFO
    );

extern WINBOOL
 PASCAL GetMenuItemInfoW(
    HMENU,
    UINT,
    WINBOOL,
    LPMENUITEMINFO
    );

extern WINBOOL
 PASCAL SetMenuItemInfoW(
    HMENU,
    UINT,
    WINBOOL,
    LPCMENUITEMINFO
    );

extern int
 PASCAL DrawTextW(
    HDC hDC,
    LPCWSTR lpString,
    int nCount,
    LPRECT lpRect,
    UINT uFormat);

extern int
 PASCAL DrawTextExW(HDC, LPWSTR, int, LPRECT, UINT, LPDRAWTEXTPARAMS);

extern WINBOOL
 PASCAL GrayStringW(
    HDC hDC,
    HBRUSH hBrush,
    GRAYSTRINGPROC lpOutputFunc,
    LPARAM lpData,
    int nCount,
    int X,
    int Y,
    int nWidth,
    int nHeight);

extern WINBOOL  PASCAL DrawStateW(HDC, HBRUSH, DRAWSTATEPROC, LPARAM, WPARAM, int, int, int, int, UINT);

extern LONG
 PASCAL TabbedTextOutW(
    HDC hDC,
    int X,
    int Y,
    LPCWSTR lpString,
    int nCount,
    int nTabPositions,
    LPINT lpnTabStopPositions,
    int nTabOrigin);

extern DWORD
 PASCAL GetTabbedTextExtentW(
    HDC hDC,
    LPCWSTR lpString,
    int nCount,
    int nTabPositions,
    LPINT lpnTabStopPositions);

extern WINBOOL
 PASCAL SetPropW(
    HWND hWnd,
    LPCWSTR lpString,
    HANDLE hData);

extern HANDLE
 PASCAL GetPropW(
    HWND hWnd,
    LPCWSTR lpString);

extern HANDLE
 PASCAL RemovePropW(
    HWND hWnd,
    LPCWSTR lpString);

extern int
 PASCAL EnumPropsExW(
    HWND hWnd,
    PROPENUMPROCEX lpEnumFunc,
    LPARAM lParam);

extern int
 PASCAL EnumPropsW(
    HWND hWnd,
    PROPENUMPROC lpEnumFunc);

extern WINBOOL
 PASCAL SetWindowTextW(
    HWND hWnd,
    LPCWSTR lpString);

extern int
 PASCAL GetWindowTextW(
    HWND hWnd,
    LPWSTR lpString,
    int nMaxCount);

extern int
 PASCAL GetWindowTextLengthW(
    HWND hWnd);

extern int
 PASCAL MessageBoxW(
    HWND hWnd ,
    LPCWSTR lpText,
    LPCWSTR lpCaption,
    UINT uType);

extern int
 PASCAL MessageBoxExW(
    HWND hWnd ,
    LPCWSTR lpText,
    LPCWSTR lpCaption,
    UINT uType,
    WORD wLanguageId);

extern int
 PASCAL MessageBoxIndirectW(LPMSGBOXPARAMS);

extern LONG
 PASCAL GetWindowLongW(
    HWND hWnd,
    int nIndex);

extern LONG
 PASCAL SetWindowLongW(
    HWND hWnd,
    int nIndex,
    LONG dwNewLong);

extern DWORD
 PASCAL GetClassLongW(
    HWND hWnd,
    int nIndex);

extern DWORD
 PASCAL SetClassLongW(
    HWND hWnd,
    int nIndex,
    LONG dwNewLong);

extern HWND
 PASCAL FindWindowW(
    LPCWSTR lpClassName ,
    LPCWSTR lpWindowName);

extern HWND
 PASCAL FindWindowExW(HWND, HWND, LPCWSTR, LPCWSTR);

extern int
 PASCAL GetClassNameW(
    HWND hWnd,
    LPWSTR lpClassName,
    int nMaxCount);

extern HHOOK
 PASCAL SetWindowsHookExW(
    int idHook,
    HOOKPROC lpfn,
    HINSTANCE hmod,
    DWORD dwThreadId);

extern HBITMAP
 PASCAL LoadBitmapW(
    HINSTANCE hInstance,
    LPCWSTR lpBitmapName);

extern HCURSOR
 PASCAL LoadCursorW(
    HINSTANCE hInstance,
    LPCWSTR lpCursorName);

extern HCURSOR
 PASCAL LoadCursorFromFileW(
    LPCWSTR    lpFileName);

extern HICON
 PASCAL LoadIconW(
    HINSTANCE hInstance,
    LPCWSTR lpIconName);

extern HANDLE
 PASCAL LoadImageW(
    HINSTANCE,
    LPCWSTR,
    UINT,
    int,
    int,
    UINT);

extern int
 PASCAL LoadStringW(
    HINSTANCE hInstance,
    UINT uID,
    LPWSTR lpBuffer,
    int nBufferMax);

extern WINBOOL
 PASCAL IsDialogMessageW(
    HWND hDlg,
    LPMSG lpMsg);

extern int
 PASCAL DlgDirListW(
    HWND hDlg,
    LPWSTR lpPathSpec,
    int nIDListBox,
    int nIDStaticPath,
    UINT uFileType);

extern WINBOOL
 PASCAL DlgDirSelectExW(
    HWND hDlg,
    LPWSTR lpString,
    int nCount,
    int nIDListBox);

extern int
 PASCAL DlgDirListComboBoxW(
    HWND hDlg,
    LPWSTR lpPathSpec,
    int nIDComboBox,
    int nIDStaticPath,
    UINT uFiletype);

extern WINBOOL
 PASCAL DlgDirSelectComboBoxExW(
    HWND hDlg,
    LPWSTR lpString,
    int nCount,
    int nIDComboBox);

extern LRESULT
 PASCAL DefFrameProcW(
    HWND hWnd,
    HWND hWndMDIClient ,
    UINT uMsg,
    WPARAM wParam,
    LPARAM lParam);

extern LRESULT
 PASCAL DefMDIChildProcW(
    HWND hWnd,
    UINT uMsg,
    WPARAM wParam,
    LPARAM lParam);

extern HWND
 PASCAL CreateMDIWindowW(
    LPWSTR lpClassName,
    LPWSTR lpWindowName,
    DWORD dwStyle,
    int X,
    int Y,
    int nWidth,
    int nHeight,
    HWND hWndParent,
    HINSTANCE hInstance,
    LPARAM lParam
    );

extern WINBOOL
 PASCAL WinHelpW(
    HWND hWndMain,
    LPCWSTR lpszHelp,
    UINT uCommand,
    DWORD dwData
    );

extern LONG
 PASCAL ChangeDisplaySettingsW(
    LPDEVMODE lpDevMode,
    DWORD dwFlags);

extern WINBOOL
 PASCAL EnumDisplaySettingsW(
    LPCWSTR lpszDeviceName,
    DWORD iModeNum,
    LPDEVMODE lpDevMode);

extern WINBOOL
 PASCAL SystemParametersInfoW(
    UINT uiAction,
    UINT uiParam,
    PVOID pvParam,
    UINT fWinIni);

extern int
 PASCAL AddFontResourceW(LPCWSTR);

extern HMETAFILE
 PASCAL CopyMetaFileW(HMETAFILE, LPCWSTR);

extern HFONT
 PASCAL CreateFontIndirectW(CONST LOGFONT *);

extern HFONT
 PASCAL CreateFontW(int, int, int, int, int, DWORD,
                             DWORD, DWORD, DWORD, DWORD, DWORD,
                             DWORD, DWORD, LPCWSTR);

extern HDC
 PASCAL CreateICW(LPCWSTR, LPCWSTR , LPCWSTR , CONST DEVMODE *);

extern HDC
 PASCAL CreateMetaFileW(LPCWSTR);

extern WINBOOL
 PASCAL CreateScalableFontResourceW(DWORD, LPCWSTR, LPCWSTR, LPCWSTR);

extern int
 PASCAL DeviceCapabilitiesW(LPCWSTR, LPCWSTR, WORD,
                                LPWSTR, CONST DEVMODE *);

extern int
 PASCAL EnumFontFamiliesExW(HDC, LPLOGFONT, FONTENUMEXPROC, LPARAM, DWORD);

extern int
 PASCAL EnumFontFamiliesW(HDC, LPCWSTR, FONTENUMPROC, LPARAM);

extern int
 PASCAL EnumFontsW(HDC, LPCWSTR,  ENUMFONTSPROC, LPARAM);

extern WINBOOL
 PASCAL GetCharWidthW(HDC, UINT, UINT, LPINT);

extern WINBOOL
  PASCAL GetCharWidth32W(HDC, UINT, UINT, LPINT);

extern WINBOOL
 PASCAL GetCharWidthFloatW(HDC, UINT, UINT, PFLOAT);

extern WINBOOL
 PASCAL GetCharABCWidthsW(HDC, UINT, UINT, LPABC);

extern WINBOOL
 PASCAL GetCharABCWidthsFloatW(HDC, UINT, UINT, LPABCFLOAT);

extern DWORD
 PASCAL GetGlyphOutlineW(HDC, UINT, UINT, LPGLYPHMETRICS, DWORD, LPVOID, CONST MAT2 *);

extern HMETAFILE
 PASCAL GetMetaFileW(LPCWSTR);

extern UINT
 PASCAL GetOutlineTextMetricsW(HDC, UINT, LPOUTLINETEXTMETRIC);

extern WINBOOL
 PASCAL GetTextExtentPointW(
                    HDC,
                    LPCWSTR,
                    int,
                    LPSIZE
                    );

extern WINBOOL
 PASCAL GetTextExtentPoint32W(
                    HDC,
                    LPCWSTR,
                    int,
                    LPSIZE
                    );

extern WINBOOL
 PASCAL GetTextExtentExPointW(
                    HDC,
                    LPCWSTR,
                    int,
                    int,
                    LPINT,
                    LPINT,
                    LPSIZE
                    );

extern DWORD
 PASCAL GetCharacterPlacementW(HDC, LPCWSTR, int, int, LPGCP_RESULTS, DWORD);

extern HDC
 PASCAL ResetDCW(HDC, CONST DEVMODE *);

extern WINBOOL
 PASCAL RemoveFontResourceW(LPCWSTR);

extern HENHMETAFILE
 PASCAL CopyEnhMetaFileW(HENHMETAFILE, LPCWSTR);

extern HDC
 PASCAL CreateEnhMetaFileW(HDC, LPCWSTR, CONST RECT *, LPCWSTR);

extern HENHMETAFILE
 PASCAL GetEnhMetaFileW(LPCWSTR);

extern UINT
 PASCAL GetEnhMetaFileDescriptionW(HENHMETAFILE, UINT, LPWSTR );

extern WINBOOL
 PASCAL GetTextMetricsW(HDC, LPTEXTMETRIC);

extern int
 PASCAL StartDocW(HDC, CONST DOCINFO *);

extern int
 PASCAL GetObjectW(HGDIOBJ, int, LPVOID);

extern WINBOOL
 PASCAL TextOutW(HDC, int, int, LPCWSTR, int);

extern WINBOOL
 PASCAL ExtTextOutW(HDC, int, int, UINT, CONST RECT *,LPCWSTR, UINT, CONST INT *);

extern WINBOOL
 PASCAL PolyTextOutW(HDC, CONST POLYTEXT *, int);

extern int
 PASCAL GetTextFaceW(HDC, int, LPWSTR);

extern DWORD
 PASCAL GetKerningPairsW(HDC, DWORD, LPKERNINGPAIR);

extern WINBOOL
 PASCAL GetLogColorSpaceW(HCOLORSPACE,LPLOGCOLORSPACE,DWORD);

extern HCOLORSPACE
 PASCAL CreateColorSpaceW(LPLOGCOLORSPACE);

extern WINBOOL
 PASCAL GetICMProfileW(HDC,DWORD,LPWSTR);

extern WINBOOL
 PASCAL SetICMProfileW(HDC,LPWSTR);

extern WINBOOL
 PASCAL UpdateICMRegKeyW(DWORD, DWORD, LPWSTR, UINT);

extern int
 PASCAL EnumICMProfilesW(HDC,ICMENUMPROC,LPARAM);

extern HPROPSHEETPAGE
 PASCAL CreatePropertySheetPageW(LPCPROPSHEETPAGE lppsp);

extern int
 PASCAL PropertySheetW(LPCPROPSHEETHEADER lppsph);

extern HIMAGELIST
 PASCAL ImageList_LoadImageW(HINSTANCE hi, 
LPCWSTR lpbmp, 
int cx, 
int cGrow, 
COLORREF crMask, 
UINT uType, 
UINT uFlags);

extern HWND
 PASCAL CreateStatusWindowW(LONG style, LPCWSTR lpszText, HWND hwndParent, UINT wID);

extern void
 PASCAL DrawStatusTextW(HDC hDC, LPRECT lprc, LPCWSTR pszText, UINT uFlags);

extern WINBOOL
 PASCAL GetOpenFileNameW(LPOPENFILENAME);

extern WINBOOL
 PASCAL GetSaveFileNameW(LPOPENFILENAME);

extern short
 PASCAL GetFileTitleW(LPCWSTR, LPWSTR, WORD);

extern WINBOOL
 PASCAL ChooseColorW(LPCHOOSECOLOR);

extern HWND
 PASCAL ReplaceTextW(LPFINDREPLACE);

extern WINBOOL
 PASCAL ChooseFontW(LPCHOOSEFONT);

extern HWND
 PASCAL FindTextW(LPFINDREPLACE);

extern WINBOOL
 PASCAL PrintDlgW(LPPRINTDLG);

extern WINBOOL
 PASCAL PageSetupDlgW(LPPAGESETUPDLG);

extern WINBOOL
 PASCAL CreateProcessW(
    LPCWSTR lpApplicationName,
    LPWSTR lpCommandLine,
    LPSECURITY_ATTRIBUTES lpProcessAttributes,
    LPSECURITY_ATTRIBUTES lpThreadAttributes,
    WINBOOL bInheritHandles,
    DWORD dwCreationFlags,
    LPVOID lpEnvironment,
    LPCWSTR lpCurrentDirectory,
    LPSTARTUPINFO lpStartupInfo,
    LPPROCESS_INFORMATION lpProcessInformation
    );

extern VOID
 PASCAL GetStartupInfoW(
    LPSTARTUPINFO lpStartupInfo
    );

extern HANDLE
 PASCAL FindFirstFileW(
    LPCWSTR lpFileName,
    LPWIN32_FIND_DATA lpFindFileData
    );

extern WINBOOL
 PASCAL FindNextFileW(
    HANDLE hFindFile,
    LPWIN32_FIND_DATA lpFindFileData
    );

extern WINBOOL
 PASCAL GetVersionExW(
    LPOSVERSIONINFO lpVersionInformation
    );

#define CreateWindowW(lpClassName, lpWindowName, dwStyle, x, y,\
nWidth, nHeight, hWndParent, hMenu, hInstance, lpParam)\
CreateWindowExW(0L, lpClassName, lpWindowName, dwStyle, x, y,\
nWidth, nHeight, hWndParent, hMenu, hInstance, lpParam)

#define CreateDialogW(hInstance, lpName, hWndParent, lpDialogFunc) \
CreateDialogParamW(hInstance, lpName, hWndParent, lpDialogFunc, 0L)

#define CreateDialogIndirectW(hInstance, lpTemplate, hWndParent, lpDialogFunc) \
CreateDialogIndirectParamW(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0L)

#define DialogBoxW(hInstance, lpTemplate, hWndParent, lpDialogFunc) \
DialogBoxParamW(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0L)

#define DialogBoxIndirectW(hInstance, lpTemplate, hWndParent, lpDialogFunc) \
DialogBoxIndirectParamW(hInstance, lpTemplate, hWndParent, lpDialogFunc, 0L)

extern HDC
 PASCAL CreateDCW(LPCWSTR, LPCWSTR , LPCWSTR , CONST DEVMODE *);

extern HFONT
 PASCAL CreateFontA(int, int, int, int, int, DWORD,
                             DWORD, DWORD, DWORD, DWORD, DWORD,
                             DWORD, DWORD, LPCSTR);

extern DWORD
 PASCAL VerInstallFileW(
        DWORD uFlags,
        LPWSTR szSrcFileName,
        LPWSTR szDestFileName,
        LPWSTR szSrcDir,
        LPWSTR szDestDir,
        LPWSTR szCurDir,
        LPWSTR szTmpFile,
        PUINT lpuTmpFileLen
        );

extern DWORD
 PASCAL GetFileVersionInfoSizeW(
        LPWSTR lptstrFilename,
        LPDWORD lpdwHandle
        );

extern WINBOOL
 PASCAL GetFileVersionInfoW(
        LPWSTR lptstrFilename,
        DWORD dwHandle,
        DWORD dwLen,
        LPVOID lpData
        );

extern DWORD
 PASCAL VerLanguageNameW(
        DWORD wLang,
        LPWSTR szLang,
        DWORD nSize
        );

extern WINBOOL
 PASCAL VerQueryValueW(
        const LPVOID pBlock,
        LPWSTR lpSubBlock,
        LPVOID * lplpBuffer,
        PUINT puLen
        );

extern DWORD
 PASCAL VerFindFileW(
        DWORD uFlags,
        LPWSTR szFileName,
        LPWSTR szWinDir,
        LPWSTR szAppDir,
        LPWSTR szCurDir,
        PUINT lpuCurDirLen,
        LPWSTR szDestDir,
        PUINT lpuDestDirLen
        );

extern LONG
 PASCAL RegSetValueExW(
    HKEY hKey,
    LPCWSTR lpValueName,
    DWORD Reserved,
    DWORD dwType,
    CONST BYTE* lpData,
    DWORD cbData
    );

extern LONG
 PASCAL RegUnLoadKeyW(
    HKEY    hKey,
    LPCWSTR lpSubKey
    );

extern WINBOOL
 PASCAL InitiateSystemShutdownW(
    LPWSTR lpMachineName,
    LPWSTR lpMessage,
    DWORD dwTimeout,
    WINBOOL bForceAppsClosed,
    WINBOOL bRebootAfterShutdown
    );

extern WINBOOL
 PASCAL AbortSystemShutdownW(
    LPWSTR lpMachineName
    );

extern LONG
 PASCAL RegRestoreKeyW(
    HKEY hKey,
    LPCWSTR lpFile,
    DWORD   dwFlags
    );

extern LONG
 PASCAL RegSaveKeyW(
    HKEY hKey,
    LPCWSTR lpFile,
    LPSECURITY_ATTRIBUTES lpSecurityAttributes
    );

extern LONG
 PASCAL RegSetValueW(
    HKEY hKey,
    LPCWSTR lpSubKey,
    DWORD dwType,
    LPCWSTR lpData,
    DWORD cbData
    );

extern LONG
 PASCAL RegQueryValueW(
    HKEY hKey,
    LPCWSTR lpSubKey,
    LPWSTR lpValue,
    PLONG   lpcbValue
    );

extern LONG
 PASCAL RegQueryMultipleValuesW(
    HKEY hKey,
    PVALENT val_list,
    DWORD num_vals,
    LPWSTR lpValueBuf,
    LPDWORD ldwTotsize
    );

extern LONG
 PASCAL RegQueryValueExW(
    HKEY hKey,
    LPCWSTR lpValueName,
    LPDWORD lpReserved,
    LPDWORD lpType,
    LPBYTE lpData,
    LPDWORD lpcbData
    );

extern LONG
 PASCAL RegReplaceKeyW(
    HKEY     hKey,
    LPCWSTR  lpSubKey,
    LPCWSTR  lpNewFile,
    LPCWSTR  lpOldFile
    );

extern LONG
 PASCAL RegConnectRegistryW(
    LPWSTR lpMachineName,
    HKEY hKey,
    PHKEY phkResult
    );

extern LONG
 PASCAL RegCreateKeyW(
    HKEY hKey,
    LPCWSTR lpSubKey,
    PHKEY phkResult
    );

extern LONG
 PASCAL RegCreateKeyExW(
    HKEY hKey,
    LPCWSTR lpSubKey,
    DWORD Reserved,
    LPWSTR lpClass,
    DWORD dwOptions,
    REGSAM samDesired,
    LPSECURITY_ATTRIBUTES lpSecurityAttributes,
    PHKEY phkResult,
    LPDWORD lpdwDisposition
    );

extern LONG
 PASCAL RegDeleteKeyW(
    HKEY hKey,
    LPCWSTR lpSubKey
    );

extern LONG
 PASCAL RegDeleteValueW(
    HKEY hKey,
    LPCWSTR lpValueName
    );

extern LONG
 PASCAL RegEnumKeyW(
    HKEY hKey,
    DWORD dwIndex,
    LPWSTR lpName,
    DWORD cbName
    );

extern LONG
 PASCAL RegEnumKeyExW(
    HKEY hKey,
    DWORD dwIndex,
    LPWSTR lpName,
    LPDWORD lpcbName,
    LPDWORD lpReserved,
    LPWSTR lpClass,
    LPDWORD lpcbClass,
    PFILETIME lpftLastWriteTime
    );

extern LONG
 PASCAL RegEnumValueW(
    HKEY hKey,
    DWORD dwIndex,
    LPWSTR lpValueName,
    LPDWORD lpcbValueName,
    LPDWORD lpReserved,
    LPDWORD lpType,
    LPBYTE lpData,
    LPDWORD lpcbData
    );

extern LONG
 PASCAL RegLoadKeyW(
    HKEY    hKey,
    LPCWSTR  lpSubKey,
    LPCWSTR  lpFile
    );

extern LONG
 PASCAL RegOpenKeyW(
    HKEY hKey,
    LPCWSTR lpSubKey,
    PHKEY phkResult
    );

extern LONG
 PASCAL RegOpenKeyExW(
    HKEY hKey,
    LPCWSTR lpSubKey,
    DWORD ulOptions,
    REGSAM samDesired,
    PHKEY phkResult
    );

extern LONG
 PASCAL RegQueryInfoKeyW(
    HKEY hKey,
    LPWSTR lpClass,
    LPDWORD lpcbClass,
    LPDWORD lpReserved,
    LPDWORD lpcSubKeys,
    LPDWORD lpcbMaxSubKeyLen,
    LPDWORD lpcbMaxClassLen,
    LPDWORD lpcValues,
    LPDWORD lpcbMaxValueNameLen,
    LPDWORD lpcbMaxValueLen,
    LPDWORD lpcbSecurityDescriptor,
    PFILETIME lpftLastWriteTime
    );

extern int
 PASCAL CompareStringW(
    LCID     Locale,
    DWORD    dwCmpFlags,
    LPCWSTR lpString1,
    int      cchCount1,
    LPCWSTR lpString2,
    int      cchCount2);

extern int
 PASCAL LCMapStringW(
    LCID     Locale,
    DWORD    dwMapFlags,
    LPCWSTR lpSrcStr,
    int      cchSrc,
    LPWSTR  lpDestStr,
    int      cchDest);


extern int
 PASCAL GetLocaleInfoW(
    LCID     Locale,
    LCTYPE   LCType,
    LPWSTR  lpLCData,
    int      cchData);

extern WINBOOL
 PASCAL SetLocaleInfoW(
    LCID     Locale,
    LCTYPE   LCType,
    LPCWSTR lpLCData);

extern int
 PASCAL GetTimeFormatW(
    LCID     Locale,
    DWORD    dwFlags,
    CONST SYSTEMTIME *lpTime,
    LPCWSTR lpFormat,
    LPWSTR  lpTimeStr,
    int      cchTime);

extern int
 PASCAL GetDateFormatW(
    LCID     Locale,
    DWORD    dwFlags,
    CONST SYSTEMTIME *lpDate,
    LPCWSTR lpFormat,
    LPWSTR  lpDateStr,
    int      cchDate);

extern int
 PASCAL GetNumberFormatW(
    LCID     Locale,
    DWORD    dwFlags,
    LPCWSTR lpValue,
    CONST NUMBERFMT *lpFormat,
    LPWSTR  lpNumberStr,
    int      cchNumber);

extern int
 PASCAL GetCurrencyFormatW(
    LCID     Locale,
    DWORD    dwFlags,
    LPCWSTR lpValue,
    CONST CURRENCYFMT *lpFormat,
    LPWSTR  lpCurrencyStr,
    int      cchCurrency);

extern WINBOOL
 PASCAL EnumCalendarInfoW(
    CALINFO_ENUMPROC lpCalInfoEnumProc,
    LCID              Locale,
    CALID             Calendar,
    CALTYPE           CalType);

extern WINBOOL
 PASCAL EnumTimeFormatsW(
    TIMEFMT_ENUMPROC lpTimeFmtEnumProc,
    LCID              Locale,
    DWORD             dwFlags);

extern WINBOOL
 PASCAL EnumDateFormatsW(
    DATEFMT_ENUMPROC lpDateFmtEnumProc,
    LCID              Locale,
    DWORD             dwFlags);

extern WINBOOL
 PASCAL GetStringTypeExW(
    LCID     Locale,
    DWORD    dwInfoType,
    LPCWSTR lpSrcStr,
    int      cchSrc,
    LPWORD   lpCharType);

extern WINBOOL
 PASCAL GetStringTypeW(
    DWORD    dwInfoType,
    LPCWSTR  lpSrcStr,
    int      cchSrc,
    LPWORD   lpCharType);

extern int
 PASCAL FoldStringW(
    DWORD    dwMapFlags,
    LPCWSTR lpSrcStr,
    int      cchSrc,
    LPWSTR  lpDestStr,
    int      cchDest);

extern WINBOOL
 PASCAL EnumSystemLocalesW(
    LOCALE_ENUMPROC lpLocaleEnumProc,
    DWORD            dwFlags);

extern WINBOOL
 PASCAL EnumSystemCodePagesW(
    CODEPAGE_ENUMPROC lpCodePageEnumProc,
    DWORD              dwFlags);

extern WINBOOL
 PASCAL PeekConsoleInputW(
    HANDLE hConsoleInput,
    PINPUT_RECORD lpBuffer,
    DWORD nLength,
    LPDWORD lpNumberOfEventsRead
    );

extern WINBOOL
 PASCAL ReadConsoleInputW(
    HANDLE hConsoleInput,
    PINPUT_RECORD lpBuffer,
    DWORD nLength,
    LPDWORD lpNumberOfEventsRead
    );

extern WINBOOL
 PASCAL WriteConsoleInputW(
    HANDLE hConsoleInput,
    CONST INPUT_RECORD *lpBuffer,
    DWORD nLength,
    LPDWORD lpNumberOfEventsWritten
    );

extern WINBOOL
 PASCAL ReadConsoleOutputW(
    HANDLE hConsoleOutput,
    PCHAR_INFO lpBuffer,
    COORD dwBufferSize,
    COORD dwBufferCoord,
    PSMALL_RECT lpReadRegion
    );

extern WINBOOL
 PASCAL WriteConsoleOutputW(
    HANDLE hConsoleOutput,
    CONST CHAR_INFO *lpBuffer,
    COORD dwBufferSize,
    COORD dwBufferCoord,
    PSMALL_RECT lpWriteRegion
    );

extern WINBOOL
 PASCAL ReadConsoleOutputCharacterW(
    HANDLE hConsoleOutput,
    LPWSTR lpCharacter,
    DWORD nLength,
    COORD dwReadCoord,
    LPDWORD lpNumberOfCharsRead
    );

extern WINBOOL
 PASCAL WriteConsoleOutputCharacterW(
    HANDLE hConsoleOutput,
    LPCWSTR lpCharacter,
    DWORD nLength,
    COORD dwWriteCoord,
    LPDWORD lpNumberOfCharsWritten
    );

extern WINBOOL
 PASCAL FillConsoleOutputCharacterW(
    HANDLE hConsoleOutput,
    WCHAR  cCharacter,
    DWORD  nLength,
    COORD  dwWriteCoord,
    LPDWORD lpNumberOfCharsWritten
    );

extern WINBOOL
 PASCAL ScrollConsoleScreenBufferW(
    HANDLE hConsoleOutput,
    CONST SMALL_RECT *lpScrollRectangle,
    CONST SMALL_RECT *lpClipRectangle,
    COORD dwDestinationOrigin,
    CONST CHAR_INFO *lpFill
    );

extern DWORD
 PASCAL GetConsoleTitleW(
    LPWSTR lpConsoleTitle,
    DWORD nSize
    );

extern WINBOOL
 PASCAL SetConsoleTitleW(
    LPCWSTR lpConsoleTitle
    );

extern WINBOOL
 PASCAL ReadConsoleW(
    HANDLE hConsoleInput,
    LPVOID lpBuffer,
    DWORD nNumberOfCharsToRead,
    LPDWORD lpNumberOfCharsRead,
    LPVOID lpReserved
    );

extern WINBOOL
 PASCAL WriteConsoleW(
    HANDLE hConsoleOutput,
    CONST VOID *lpBuffer,
    DWORD nNumberOfCharsToWrite,
    LPDWORD lpNumberOfCharsWritten,
    LPVOID lpReserved
    );

extern DWORD  PASCAL WNetAddConnectionW(
     LPCWSTR   lpRemoteName,
     LPCWSTR   lpPassword,
     LPCWSTR   lpLocalName
    );

extern DWORD  PASCAL WNetAddConnection2W(
     LPNETRESOURCE lpNetResource,
     LPCWSTR       lpPassword,
     LPCWSTR       lpUserName,
     DWORD          dwFlags
    );

extern DWORD  PASCAL WNetAddConnection3W(
     HWND           hwndOwner,
     LPNETRESOURCE lpNetResource,
     LPCWSTR       lpPassword,
     LPCWSTR       lpUserName,
     DWORD          dwFlags
    );

extern DWORD  PASCAL WNetCancelConnectionW(
     LPCWSTR lpName,
     WINBOOL     fForce
    );

extern DWORD  PASCAL WNetCancelConnection2W(
     LPCWSTR lpName,
     DWORD    dwFlags,
     WINBOOL     fForce
    );

extern DWORD  PASCAL WNetGetConnectionW(
     LPCWSTR lpLocalName,
     LPWSTR  lpRemoteName,
     LPDWORD  lpnLength
    );

extern DWORD  PASCAL WNetUseConnectionW(
    HWND            hwndOwner,
    LPNETRESOURCE  lpNetResource,
    LPCWSTR        lpUserID,
    LPCWSTR        lpPassword,
    DWORD           dwFlags,
    LPWSTR         lpAccessName,
    LPDWORD         lpBufferSize,
    LPDWORD         lpResult
    );

extern DWORD  PASCAL WNetSetConnectionW(
    LPCWSTR    lpName,
    DWORD       dwProperties,
    LPVOID      pvValues
    );

extern DWORD  PASCAL WNetConnectionDialog1W(
    LPCONNECTDLGSTRUCT lpConnDlgStruct
    );

extern DWORD  PASCAL WNetDisconnectDialog1W(
    LPDISCDLGSTRUCT lpConnDlgStruct
    );

extern DWORD  PASCAL WNetOpenEnumW(
     DWORD          dwScope,
     DWORD          dwType,
     DWORD          dwUsage,
     LPNETRESOURCE lpNetResource,
     LPHANDLE       lphEnum
    );

extern DWORD  PASCAL WNetEnumResourceW(
     HANDLE  hEnum,
     LPDWORD lpcCount,
     LPVOID  lpBuffer,
     LPDWORD lpBufferSize
    );

extern DWORD  PASCAL WNetGetUniversalNameW(
     LPCWSTR lpLocalPath,
     DWORD    dwInfoLevel,
     LPVOID   lpBuffer,
     LPDWORD  lpBufferSize
     );

extern DWORD  PASCAL WNetGetUserW(
     LPCWSTR  lpName,
     LPWSTR   lpUserName,
     LPDWORD   lpnLength
    );

extern DWORD  PASCAL WNetGetProviderNameW(
    DWORD   dwNetType,
    LPWSTR lpProviderName,
    LPDWORD lpBufferSize
    );

extern DWORD  PASCAL WNetGetNetworkInformationW(
    LPCWSTR          lpProvider,
    LPNETINFOSTRUCT   lpNetInfoStruct
    );

extern DWORD  PASCAL WNetGetLastErrorW(
     LPDWORD    lpError,
     LPWSTR    lpErrorBuf,
     DWORD      nErrorBufSize,
     LPWSTR    lpNameBuf,
     DWORD      nNameBufSize
    );

extern DWORD  PASCAL MultinetGetConnectionPerformanceW(
        LPNETRESOURCE lpNetResource,
        LPNETCONNECTINFOSTRUCT lpNetConnectInfoStruct
        );

extern WINBOOL
 PASCAL ChangeServiceConfigW(
    SC_HANDLE    hService,
    DWORD        dwServiceType,
    DWORD        dwStartType,
    DWORD        dwErrorControl,
    LPCWSTR     lpBinaryPathName,
    LPCWSTR     lpLoadOrderGroup,
    LPDWORD      lpdwTagId,
    LPCWSTR     lpDependencies,
    LPCWSTR     lpServiceStartName,
    LPCWSTR     lpPassword,
    LPCWSTR     lpDisplayName
    );

extern SC_HANDLE
 PASCAL CreateServiceW(
    SC_HANDLE    hSCManager,
    LPCWSTR     lpServiceName,
    LPCWSTR     lpDisplayName,
    DWORD        dwDesiredAccess,
    DWORD        dwServiceType,
    DWORD        dwStartType,
    DWORD        dwErrorControl,
    LPCWSTR     lpBinaryPathName,
    LPCWSTR     lpLoadOrderGroup,
    LPDWORD      lpdwTagId,
    LPCWSTR     lpDependencies,
    LPCWSTR     lpServiceStartName,
    LPCWSTR     lpPassword
    );

extern WINBOOL
 PASCAL EnumDependentServicesW(
    SC_HANDLE               hService,
    DWORD                   dwServiceState,
    LPENUM_SERVICE_STATUS  lpServices,
    DWORD                   cbBufSize,
    LPDWORD                 pcbBytesNeeded,
    LPDWORD                 lpServicesReturned
    );

extern WINBOOL
 PASCAL EnumServicesStatusW(
    SC_HANDLE               hSCManager,
    DWORD                   dwServiceType,
    DWORD                   dwServiceState,
    LPENUM_SERVICE_STATUS  lpServices,
    DWORD                   cbBufSize,
    LPDWORD                 pcbBytesNeeded,
    LPDWORD                 lpServicesReturned,
    LPDWORD                 lpResumeHandle
    );

extern WINBOOL
 PASCAL GetServiceKeyNameW(
    SC_HANDLE               hSCManager,
    LPCWSTR                lpDisplayName,
    LPWSTR                 lpServiceName,
    LPDWORD                 lpcchBuffer
    );

extern WINBOOL
 PASCAL GetServiceDisplayNameW(
    SC_HANDLE               hSCManager,
    LPCWSTR                lpServiceName,
    LPWSTR                 lpDisplayName,
    LPDWORD                 lpcchBuffer
    );

extern SC_HANDLE
 PASCAL OpenSCManagerW(
    LPCWSTR lpMachineName,
    LPCWSTR lpDatabaseName,
    DWORD   dwDesiredAccess
    );

extern SC_HANDLE
 PASCAL OpenServiceW(
    SC_HANDLE   hSCManager,
    LPCWSTR    lpServiceName,
    DWORD       dwDesiredAccess
    );

extern WINBOOL
 PASCAL QueryServiceConfigW(
    SC_HANDLE               hService,
    LPQUERY_SERVICE_CONFIG lpServiceConfig,
    DWORD                   cbBufSize,
    LPDWORD                 pcbBytesNeeded
    );

extern WINBOOL
 PASCAL QueryServiceLockStatusW(
    SC_HANDLE                       hSCManager,
    LPQUERY_SERVICE_LOCK_STATUS    lpLockStatus,
    DWORD                           cbBufSize,
    LPDWORD                         pcbBytesNeeded
    );

extern SERVICE_STATUS_HANDLE
 PASCAL RegisterServiceCtrlHandlerW(
    LPCWSTR             lpServiceName,
    LPHANDLER_FUNCTION   lpHandlerProc
    );

extern WINBOOL
 PASCAL StartServiceCtrlDispatcherW(
    LPSERVICE_TABLE_ENTRY    lpServiceStartTable
    );

extern WINBOOL
 PASCAL StartServiceW(
    SC_HANDLE            hService,
    DWORD                dwNumServiceArgs,
    LPCWSTR             *lpServiceArgVectors
    );

/* Extensions to OpenGL */

extern WINBOOL  PASCAL wglUseFontBitmapsW(HDC, DWORD, DWORD, DWORD);

extern WINBOOL  PASCAL wglUseFontOutlinesW(HDC, DWORD, DWORD, DWORD, FLOAT,
		    FLOAT, int, LPGLYPHMETRICSFLOAT);

/* ------------------------------------- */
/* From shellapi.h in old Cygnus headers */

extern unsigned int  PASCAL DragQueryFileW(HDROP, unsigned int, LPCWSTR, unsigned int);

extern HICON  PASCAL ExtractAssociatedIconW(HINSTANCE, LPCWSTR, WORD *);

extern HICON  PASCAL ExtractIconW(HINSTANCE, const LPCWSTR, unsigned int);

extern HINSTANCE  PASCAL FindExecutableW(const LPCWSTR, const LPCWSTR, LPCWSTR);

extern int  PASCAL ShellAboutW(HWND, const LPCWSTR, const LPCWSTR, HICON);

extern HINSTANCE  PASCAL ShellExecuteW(HWND, const LPCWSTR, const LPCWSTR, LPCWSTR, const LPCWSTR, int);

/* end of stuff from shellapi.h in old Cygnus headers */
/* -------------------------------------------------- */
/* From ddeml.h in old Cygnus headers */

extern HSZ  PASCAL DdeCreateStringHandleW(DWORD, LPCWSTR, int);

extern UINT  PASCAL DdeInitializeW(DWORD *, CALLB, DWORD, DWORD);

extern DWORD  PASCAL DdeQueryStringW(DWORD, HSZ, LPCWSTR, DWORD, int);

/* end of stuff from ddeml.h in old Cygnus headers */
/* ----------------------------------------------- */

extern WINBOOL  PASCAL LogonUserW(LPWSTR, LPWSTR, LPWSTR, DWORD, DWORD, HANDLE *);
extern WINBOOL  PASCAL CreateProcessAsUserW(HANDLE, LPCWSTR, LPWSTR,
			SECURITY_ATTRIBUTES*, SECURITY_ATTRIBUTES*, WINBOOL,
			DWORD, LPVOID, LPCWSTR, STARTUPINFO*,
			PROCESS_INFORMATION*);

extern WINBOOL  PASCAL PlaySoundW(LPCWSTR pszSound, HMODULE hmod, DWORD fdwSound);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* RC_INVOKED */

#endif /* _GNU_H_WINDOWS32_UNICODEFUNCTIONS */
