#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include "header.h"
#include "dir.h"
#ifdef PROFILE
static char szProfileName[] = "ccide.ini" ;
static char szProfileClass[] = "Defaults" ;
#else
static char RegistryKey[] = "Software\\LadSoft\\CC386\\CCIDE" ;
#endif


void StringToProfile(char *name, char *string) 
{
#ifdef PROFILE
	WritePrivateProfileString(szProfileClass,key,string,szProfileName) ;
#else
   HKEY key ;
   DWORD disp ;
   if (RegCreateKeyEx(HKEY_LOCAL_MACHINE,RegistryKey,0,0,
         0,KEY_ALL_ACCESS,0,&key,&disp) == ERROR_SUCCESS) {
      RegSetValueEx(key,name,0,REG_SZ,string,strlen(string)) ;
      RegCloseKey(key) ;
   }
#endif
}
char * ProfileToString(char *name,char *def)
{
	static char buf[256] ;
#ifdef PROFILE
	GetPrivateProfileString(szProfileClass, key,def,buf,256, szProfileName) ;
#else
   HKEY key ;
   int disp ;
   int type, datalen=256 ;
   if (RegCreateKeyEx(HKEY_LOCAL_MACHINE,RegistryKey,0,0,
         0,KEY_ALL_ACCESS,0,&key,&disp) == ERROR_SUCCESS) {
      if (RegQueryValueEx(key,name,NULL,&type,buf,&datalen)  != ERROR_SUCCESS) 
         strcpy(buf,def) ;
      RegCloseKey(key) ;
   }
#endif
	return buf ;

}
void IntToProfile(char *key, int value)
{
	char buf[256] ;
	sprintf(buf,"%d",value);
	StringToProfile(key,buf) ;
}
int ProfileToInt(char *key, int def)
{
   int val ;
   char vvv[256] ;
   char *buf ;
   sprintf(vvv,"%d",def) ;
   buf = ProfileToString(key,vvv) ;
   sscanf(buf,"%d",&val) ;
   return val ;
}