// ChildView.cpp : implementation of the CChildView class
//

#include "stdafx.h"
#include "DaoSample.h"
#include "ChildView.h"
#include "DaoDialog.h"
#include "DaoEdit.h"
#include "ListDialog.h"
#include "ModemDialog.h"
#include "DaoCheck.h"
#include "DaoCombo.h"
#include "DaoPropPage.h"
#include "Cust1Page.h"
#include "Cust2Page.h"
#include "DaoPropSheet.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define IN_INT		-4
#define IN_LONG     -5
int InputBox(HWND HWindow, LPSTR ATitle, LPSTR AStatic, void* ABuffer,
	short tipo);

/////////////////////////////////////////////////////////////////////////////
// CChildView

CChildView::CChildView()
{
}

CChildView::~CChildView()
{
}


BEGIN_MESSAGE_MAP(CChildView,CWnd )
	//{{AFX_MSG_MAP(CChildView)
	ON_WM_PAINT()
	ON_COMMAND(ID_FILE_MODEM, OnFileModem)
	ON_COMMAND(ID_FILE_CUSTOMER, OnFileCustomer)
	ON_COMMAND(ID_FILE_CUSTOMER_OPEN, OnFileCustomerOpen)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CChildView message handlers

BOOL CChildView::PreCreateWindow(CREATESTRUCT& cs) 
{
	if (!CWnd::PreCreateWindow(cs))
		return FALSE;

	cs.dwExStyle |= WS_EX_CLIENTEDGE;
	cs.style &= ~WS_BORDER;
	cs.lpszClass = AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS, 
		::LoadCursor(NULL, IDC_ARROW), HBRUSH(COLOR_WINDOW+1), NULL);

	return TRUE;
}

void CChildView::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	
	// Do not call CWnd::OnPaint() for painting messages
}


void CChildView::OnFileModem() 
{
	DaoRecordset rs;
	try {
		rs = "select * from Modem";
	}
	catch(_com_error& e) {
		Show(e, *this);
		return;
	}
	CModemDialog Mod;
	CListDialog Lis(rs, &Mod);
	Lis.SetCaption("Modem Listing");
	Lis.DoModal();
}

void CChildView::OnFileCustomer() 
{
	try {
		CDaoPropSheet Prop("Customer Data", "Customer", true);
		Prop.AddPage(new CCust1Page);
		Prop.AddPage(new CCust2Page);
		Prop.DoModal();
	}
	catch(_com_error& e) {
		Show(e, *this);
	}
}

void CChildView::OnFileCustomerOpen() 
{
	int customer = 0;

	if(InputBox(m_hWnd, "Customer", "Enter Customer ID: ", &customer,
		IN_LONG) == IDCANCEL) return;

	CString sql;
	sql.Format("select * from Customer where CustomerID = %d", customer);

	try {
		CDaoPropSheet Prop("Customer Data", sql);
		Prop.AddPage(new CCust1Page);
		Prop.AddPage(new CCust2Page);
		Prop.DoModal();
	}
	catch(_com_error& e) {
		Show(e, *this);
	}
}
