// tntechoDlg.cpp : implementation file
//

#include "stdafx.h"
#include "tntecho.h"
#include "tntechoDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
//Create dll instance
	HINSTANCE subsdll = NULL;
	HINSTANCE civerbsdll = NULL;
//Define the type definition
	typedef void (*DTSPATH)(char *);
	typedef void (*FATAL)(char *, int);
	typedef void (*PARSE)(char *, char *, int *);
	typedef void (*CAT)(char *, char*);
	typedef void (*TRIM)(char *);
	typedef void (*SCOPY)(char *, char *, int);
	typedef int (*LU62)(void);
	typedef void (*CONVA)(char *, int);
	typedef void (*CONVE)(char *, int);
	typedef int (*CISTART)(int *, char *, char *, struct descriptor *);
	typedef int (*CIOPEN)(int *, char *, int *,
		struct descriptor *, struct descriptor *,
		struct descriptor *, struct descriptor *);
	typedef int (*CITALK)(int *, char *, int *, char *, int*, char *);
	typedef int (*CILISTEN)(int *, char *, int *, char *,int *,
		char *, int *, char *);
	typedef int (*CICLOSE)(int *, char *, int *, char *);
//declare external subroutines
	DTSPATH	dtspath;
	FATAL	fatal;
	PARSE	parse;
	CAT		cat;
	TRIM	trim;
	SCOPY	scopy;
	LU62	LU62DETCH;
	CONVA	convert_string_ASCII;
	CONVE	convert_string_EBCDIC;
	CISTART	cistart;
	CIOPEN	ciopen;
	CITALK	citalk;
	CILISTEN cilisten;
	CICLOSE	ciclose;
//Create an instance of CFile
	CFile	tntecholog;
//Some variables
	char	*port;

   struct descriptor	PROD;
   struct descriptor	REQUESTER;
   struct descriptor	TPNAME;
   struct descriptor	USER;
   struct descriptor	PASSW;

   int	cmn, 				// Common area pointer	
		cid, 				// Conversation ID
		length, 			// Transmission/receipt data length
		type, 				// Conversation type
		i,
		majcode;			// CI return status code
   char	retcode[7], 		// CI return status buffer
		role[2],			// Role (<T>arget or <S>ource
		flag[9]="NNNNNNNN",	// Option flag (Initialized)
		buf[256], 			// Listen buffer
		tranbuf[256],		// Talk buffer
		logout[80],			// Write to log
		osdepend[10],		// Not used
		text[256],
		path1[256];

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTntechoDlg dialog

CTntechoDlg::CTntechoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTntechoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTntechoDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTntechoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTntechoDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTntechoDlg, CDialog)
	//{{AFX_MSG_MAP(CTntechoDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_EXIT_BUTTON, OnExitButton)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTntechoDlg message handlers

BOOL CTntechoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
//Load the library
	subsdll = LoadLibrary("ci_subs.dll");
	if(subsdll == NULL)
	{
		AfxMessageBox("Subs DLL load failure.", NULL, MB_ICONERROR);
		return(FALSE);
	}
	civerbsdll = LoadLibrary("ci_verbs.dll");
	if(civerbsdll == NULL)
	{
		AfxMessageBox("Ci_verbs DLL load failure.", NULL, MB_ICONERROR);
		return(FALSE);
	}
//Get address of subroutine
	dtspath = (DTSPATH)GetProcAddress(subsdll, "dtspath");
	fatal = (FATAL)GetProcAddress(subsdll, "fatal");
	parse = (PARSE)GetProcAddress(subsdll, "parse");
	cat   = (CAT)GetProcAddress(subsdll, "cat");
	trim  = (TRIM)GetProcAddress(subsdll, "trim");
	scopy = (SCOPY)GetProcAddress(subsdll, "scopy");
	LU62DETCH = (LU62)GetProcAddress(subsdll, "LU62DETCH");
	convert_string_ASCII =
		(CONVA)GetProcAddress(subsdll, "convert_string_ASCII");
	convert_string_EBCDIC =
		(CONVE)GetProcAddress(subsdll, "convert_string_EBCDIC");
	cistart = (CISTART)GetProcAddress(civerbsdll, "cistart");
	ciopen = (CIOPEN)GetProcAddress(civerbsdll, "ciopen");
	citalk = (CITALK)GetProcAddress(civerbsdll, "citalk");
	cilisten = (CILISTEN)GetProcAddress(civerbsdll, "cilisten");
	ciclose = (CICLOSE)GetProcAddress(civerbsdll, "ciclose");
	//Open the log
	dtspath(path1);
	port = getenv("PORT_STRING");
	i = atoi(port);
	i = i - ((i/1000)*1000);
	sprintf(logout, "%s\\log\\tntecho%03d.log\0", path1, i);
	tntecholog.Open(logout, CFile::modeCreate | CFile::modeWrite);
	sprintf(logout, "Log file opened\n");
	tntecholog.Write(logout, strlen(logout));
	sprintf(logout, "PORT_STRING = %s\n", port);
	tntecholog.Write(logout, strlen(logout));
//Fill in some data
	strcpy(PROD.a_pointer, "PROD");
	PROD.w_length = strlen("prod");
	PROD.w_length = (short)strlen(strcpy(PROD.a_pointer, "PROD"));
	REQUESTER.w_length = (short)strlen(strcpy(REQUESTER.a_pointer, "REQUESTER"));
	TPNAME.w_length = (short)strlen(strcpy(TPNAME.a_pointer, "          "));
	USER.w_length = (short)strlen(strcpy(USER.a_pointer, "          "));
	PASSW.w_length = (short)strlen(strcpy(PASSW.a_pointer, "         "));
	sprintf(logout, "Starting calls\n");
	tntecholog.Write(logout, strlen(logout));
/* 
 * Attach to the CI resource
 */
    if (majcode=cistart(&cmn, retcode, role, &PROD) != TRUE)
    {
        sprintf(logout, "CISTART error %s\n", retcode);
		tntecholog.Write(logout, strlen(logout));
		return(FALSE);
    }
    sprintf(logout, "\nProgram tvaxecho started.\n");
	tntecholog.Write(logout, strlen(logout));
/*
 * Open a hailing frequency to the caller
 */
    if (majcode=ciopen(&cmn, retcode, &cid, &REQUESTER, &TPNAME,
       &USER, &PASSW) != TRUE) 
    {
        sprintf(logout, "CIOPEN error %s\n", retcode);
		tntecholog.Write(logout, strlen(logout));
		return(FALSE);
    }
    sprintf(logout, "Opened as REQUESTER.\n");
	tntecholog.Write(logout, strlen(logout));
/*
 * Listen for the data, then for the OVER. If you get an OVER, send the last
 * data received back to the sender. If you receive a deallocation message,
 * exit gracefully.
 */    

loop:
    strncpy(flag, "NNNNNNNN", 8);
    memset (buf, 0, sizeof(buf));
    type = TYPE_SPCID;
    length = sizeof(buf);	
    sprintf(logout, "CILISTEN.\n");
	tntecholog.Write(logout, strlen(logout));
    if ( (majcode=cilisten(&cmn, retcode, &cid, buf, &length, 
			       flag, &type, osdepend) != TRUE))
    {
        sprintf(logout, "CILISTEN error %s\n", retcode);
		tntecholog.Write(logout, strlen(logout));
        strncpy(flag, "NNNNNNNN", 8);
        if (majcode=ciclose(&cmn, retcode, &cid, flag) != TRUE) 
        {
            sprintf(logout, "CICLOSE error %s\n", retcode);
			tntecholog.Write(logout, strlen(logout));
        }
		return(FALSE);
	}
	    if(length > 0)
    {
        /* Save the data for later retransmission */
        buf[length] = 0; /* Terminate the buffer */
        strcpy(tranbuf, buf);
        convert_string_ASCII(buf, length);
        sprintf(logout, "Received   : [%s]\n", buf);
		tntecholog.Write(logout, strlen(logout));
    }
    if (flag[OVERPOS] != 'Y')
        goto loop;
    sprintf(logout, "Received over flag.\n");
	tntecholog.Write(logout, strlen(logout));
/*
 * Send the buffer back
 */
    strncpy(flag, "NYNNNNNN", 8);
    length = strlen(tranbuf);	
    sprintf(logout, "CITALK.\n");
	tntecholog.Write(logout, strlen(logout));
    if (majcode=citalk(&cmn, retcode, &cid, tranbuf, &length,
       flag) != TRUE) 
    {
        sprintf(logout, "CITALK error %s\n", retcode);
	   	tntecholog.Write(logout, strlen(logout));
        strncpy(flag, "NNNNNNNN", 8);
        if (majcode=ciclose(&cmn, retcode, &cid, flag) != TRUE) 
        {
            sprintf(logout, "CICLOSE error %s\n", retcode);
			tntecholog.Write(logout, strlen(logout));
        }
		return(FALSE);
    }
    convert_string_ASCII(tranbuf, length);
    sprintf(logout, "Transmitted: [%s]\n", tranbuf);
	tntecholog.Write(logout, strlen(logout));
/*
 * close gracefully
 */
    memset (buf, 0, sizeof(buf));
    type = TYPE_SPCID;
    length = sizeof(buf);	
    sprintf(logout, "CILISTEN.\n");
	tntecholog.Write(logout, strlen(logout));
    if ( (majcode=cilisten(&cmn, retcode, &cid, buf, &length, 
			       flag, &type, osdepend) != TRUE))
    {
        sprintf(logout, "CILISTEN error %s\n", retcode);
		tntecholog.Write(logout, strlen(logout));
		return(FALSE);
	}
	sprintf(logout, "Got the close, retcode = %s\n", retcode);
	tntecholog.Write(logout, strlen(logout));
    strncpy(flag, "NNNNNNNN", 8);
	if(flag[OVERPOS] != 'Y')
	{
		sprintf(logout, "CICLOSE.\n");
		tntecholog.Write(logout, strlen(logout));
	    if (majcode=ciclose(&cmn, retcode, &cid, flag) != TRUE) 
	    {
			sprintf(logout, "CICLOSE error %s\n", retcode);
			tntecholog.Write(logout, strlen(logout));
	    }
	}
    sprintf(logout, "Exiting program.\n");
	tntecholog.Write(logout, strlen(logout));
	tntecholog.Close();
	exit(TRUE);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTntechoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTntechoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CTntechoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CTntechoDlg::OnExitButton() 
{
	// TODO: Add your control notification handler code here
	tntecholog.Close();
	OnOK();
	
}
